/*
 * TableColumModel.java
 *
 * Created on 18. M?rz 2003, 15:03
 */
package com.sun.star.wizards.tutorial.creator.frame.objectFinder;

import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;

/**
 * Table model class. Defines a table model's properties.
 *
 * @author $author$
 * @version $Revision: 1.2 $
 */
public class TableColumModel extends javax.swing.table.DefaultTableColumnModel {
	private int m_largeColumIndex;

	/**
	 * Creates a new TableColumModel object.
	 *
	 * @param largeColumIndex index
	 */
	public TableColumModel(int largeColumIndex) {
		super();
		m_largeColumIndex = largeColumIndex;
		addColumnModelListener(new TableColumnModelListener() {
			public void columnAdded(TableColumnModelEvent e) {
				if (e.getToIndex() == m_largeColumIndex) {
					getColumn(m_largeColumIndex).setPreferredWidth(350);
				}
			}

			public void columnMoved(TableColumnModelEvent e) {
			}

			public void columnRemoved(TableColumnModelEvent e) {
			}

			public void columnSelectionChanged(ListSelectionEvent e) {
			}

			public void columnMarginChanged(ChangeEvent e) {
			}
		});
	}

	/**
	 * Is not implemented. Owerwrite the super methode.
	 *
	 * @param columnIndex index
	 * @param newIndex index
	 */
	public void moveColumn(int columnIndex, int newIndex) {
	}
}
