/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: object.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 14:28:42 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef UDM_OBJECT_HXX
#define UDM_OBJECT_HXX



// USED SERVICES
	// BASE CLASSES
	// COMPONENTS
#include <udm/data.hxx>
	// PARAMETERS
#include <udm/stdstr.hxx>
#include <udm/integer.hxx>
#include <udm/uinteger.hxx>
#include <udm/real.hxx>
#include <udm/boolean.hxx>

namespace csv
{
 	class bostream;
 	class bistream;
}


namespace udm
{

class Creator;


/** @resp
    This is the user interface to all objects which represent
    data of udm-type.

    @collab     Data
    @invariant  pData != 0;

*/
class Object
{
  public:
    // LIFECYCLE
                        Object();
                        Object(
                            Data &              i_pData );
                        Object(
                            const Object &      i_rObj );
                        ~Object();
    // OPERATORS
    /// @return false, if Data_Null are assigned.
                        operator bool() const;

    Object &            operator=(
                            Data &              i_rData );
    Object &            operator=(
                            const Object &      i_rObj );

    Data &              operator*() const;
    Data *              operator->();

    // OPERATIONS
    csv::bostream &     bin_write(
                            csv::bostream &     o_out ) const;
    csv::bistream &     bin_read(
                            csv::bistream &     io_in,
                            Creator &           io_rCreationInfo );

    // INQUIRY
    bool                is_type(
                            Data::accessor_type i_type ) const;
    Data::accessor_type type() const;
    Data::description   type_description() const;

    Stdstr &            r_str() const;
    Integer &           r_int() const;
    UInteger &          r_uint() const;
    Real &              r_real() const;
    Boolean &           r_bool() const;

    BinaryStream &      r_bstream() const;
    Enum &              r_enum() const;
    Ptr &               r_ptr() const;
    Dynamic &           r_dyn() const;
    Array &             r_array() const;
    Map &               r_map() const;
    Struct &            r_struct() const;

    ::csv::String       v_str() const;
    intt                v_int() const;
    uintt               v_uint() const;
    real                v_real() const;
    bool                v_bool() const;

    Object              get(
                            int                 i_nKey ) const;
  private:
    // Locals
    inline void         ExchangeData(
                            Data &              io_rNewData );
    inline void         ReleaseData();
    static Data *       Acquire(
                            Data &              io_rNewData );

    // DATA
    Data *              pData;      /// Is administrated by refcounting.
};


// IMPLEMENTATION

inline Data &
Object::operator*() const
    { csv_assert(pData != 0);
      return *pData; }
inline Data *
Object::operator->()
    { return pData; }

inline Stdstr &
Object::r_str() const
    { return pData->as_str(); }
inline Integer &
Object::r_int() const
    { return pData->as_int(); }
inline UInteger &
Object::r_uint() const
    { return pData->as_uint(); }
inline Real &
Object::r_real() const
    { return pData->as_real(); }
inline Boolean &
Object::r_bool() const
    { return pData->as_bool(); }

inline BinaryStream &
Object::r_bstream() const
    { return pData->as_bstream(); }
inline Enum &
Object::r_enum() const
    { return pData->as_enum(); }
inline Ptr &
Object::r_ptr() const
    { return pData->as_ptr(); }
inline Dynamic &
Object::r_dyn() const
    { return pData->as_dyn(); }
inline Array &
Object::r_array() const
    { return pData->as_array(); }
inline Map &
Object::r_map() const
    { return pData->as_map(); }
inline Struct &
Object::r_struct() const
    { return pData->as_struct(); }

inline ::csv::String
Object::v_str() const
    { return r_str().value(); }
inline intt
Object::v_int() const
    { return r_int().value(); }
inline uintt
Object::v_uint() const
    { return r_uint().value(); }
inline real
Object::v_real() const
    { return r_real().value(); }
inline bool
Object::v_bool() const
    { return r_bool().value(); }

}   // namespace udm




#endif

