/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: break.hxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 09:01:48 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef _BREAK_HXX
#define _BREAK_HXX

#ifndef _SVX_STDDLG_HXX //autogen
#include <svx/stddlg.hxx>
#endif

#ifndef _BUTTON_HXX //autogen
#include <vcl/button.hxx>
#endif

#ifndef _FIXED_HXX //autogen
#include <vcl/fixed.hxx>
#endif

#ifndef _LSTBOX_HXX //autogen
#include <vcl/lstbox.hxx>
#endif

#ifndef _FIELD_HXX //autogen
#include <vcl/field.hxx>
#endif

class SwWrtShell;

class SwBreakDlg: public SvxStandardDialog
{
	SwWrtShell	   &rSh;
	RadioButton		aLineBtn;
	RadioButton		aColumnBtn;
	RadioButton		aPageBtn;
	FixedText		aPageCollText;
	ListBox			aPageCollBox;
	CheckBox		aPageNumBox;
	NumericField	aPageNumEdit;
    FixedLine       aBreakFL;

	OKButton		aOkBtn;
	CancelButton	aCancelBtn;
	HelpButton		aHelpBtn;

    String          aTemplate;
    USHORT          nKind;
    USHORT          nPgNum;

	BOOL 			bHtmlMode;

	DECL_LINK( ClickHdl, void * );
	DECL_LINK( PageNumHdl, CheckBox * );
	DECL_LINK( PageNumModifyHdl, Edit * );
	DECL_LINK( OkHdl, Button * );

	void CheckEnable();

protected:
	virtual void Apply();

public:
	SwBreakDlg( Window *pParent, SwWrtShell &rSh );
	~SwBreakDlg();

    String  GetTemplateName() { return aTemplate; }
    USHORT  GetKind() { return nKind; }
    USHORT  GetPageNumber() { return nPgNum; }
};

#endif

