/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: dpage.hxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 01:42:44 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef _DPAGE_HXX
#define _DPAGE_HXX

#ifndef _FM_FMPAGE_HXX
#include <svx/fmpage.hxx>
#endif

#ifndef _SVDOBJ_HXX
#include <svx/svdobj.hxx>
#endif

class SdrPageGridFrameList;
class SwDrawDocument;
class SwDoc;

class SwDPage : public FmFormPage, public SdrObjUserCall
{
	SdrPageGridFrameList*	pGridLst;
	SwDoc& 					rDoc;

public:
	SwDPage(SwDrawDocument& rNewModel, BOOL bMasterPage=FALSE);
	~SwDPage();

	// #i3694#
	// This GetOffset() method is not needed anymore, it even leads to errors.
	// virtual Point GetOffset() const;
	virtual SdrObject* ReplaceObject( SdrObject* pNewObj, ULONG nObjNum );

	virtual void	RequestBasic();

	virtual const SdrPageGridFrameList* GetGridFrameList(const SdrPageView* pPV,
									const Rectangle *pRect) const;

	virtual String GetLinkData( const String& rLinkName );
	virtual	void SetLinkData( const String& rLinkName, const String& rLinkData );

	BOOL RequestHelp( Window* pWindow, SdrView* pView, const HelpEvent& rEvt );

	virtual ::com::sun::star::uno::Reference< ::com::sun::star::uno::XInterface > createUnoPage();
};

#endif	   // _DPAGE_HXX



