/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: srchitem.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 23:39:36 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// include ---------------------------------------------------------------

#ifndef __SBX_SBXVARIABLE_HXX
#include <basic/sbxvar.hxx>
#endif
#pragma hdrstop

#define _SVX_SRCHITEM_CXX

#include "svxitems.hrc"

#define ITEMID_SEARCH	0
#include "srchitem.hxx"
#include "itemtype.hxx"
#include "dialmgr.hxx"
#include <svtools/memberid.hrc>
#include "svxids.hrc"

// STATIC DATA -----------------------------------------------------------

TYPEINIT1_AUTOFACTORY(SvxSearchItem, SfxPoolItem);

// -----------------------------------------------------------------------

SvxSearchItem::SvxSearchItem( const sal_uInt16 nId ) :

	SfxPoolItem( nId ),

	nCommand		( 0 ),
	aSearchString	() ,
	aReplaceString	(),
	bWordOnly		( sal_False ),
	bExact			( sal_False ),
	bBackward		( sal_False ),
	bSelection		( sal_False ),
	bRegExp			( sal_False ),
	bPattern		( sal_False ),
	bContent		( sal_False ),
	eFamily			( SFX_STYLE_FAMILY_PARA ),
	bRowDirection	( sal_True ),
	bAllTables		( sal_False ),
	nCellType		( SVX_SEARCHIN_FORMULA ),
	nAppFlag		( SVX_SEARCHAPP_WRITER ),
	bLevenshtein	( sal_False ),
	bLEVRelaxed		( sal_True ),
	nLEVOther		( 2 ),
	nLEVShorter   	( 2 ),
	nLEVLonger    	( 2 )
{
}

// -----------------------------------------------------------------------

SvxSearchItem::SvxSearchItem( const SvxSearchItem& rItem ) :

	SfxPoolItem	( rItem ),

	nCommand		( rItem.nCommand ),
	aSearchString	( rItem.aSearchString ),
	aReplaceString	( rItem.aReplaceString ),
	bWordOnly		( rItem.bWordOnly ),
	bExact			( rItem.bExact ),
	bBackward		( rItem.bBackward ),
	bSelection		( rItem.bSelection ),
	bRegExp			( rItem.bRegExp ),
	bPattern		( rItem.bPattern ),
	bContent		( rItem.bContent ),
	eFamily			( rItem.eFamily ),
	bRowDirection	( rItem.bRowDirection ),
	bAllTables		( rItem.bAllTables ),
	nCellType		( rItem.nCellType ),
	nAppFlag		( rItem.nAppFlag ),
	bLevenshtein	( rItem.bLevenshtein  ),
	bLEVRelaxed		( rItem.bLEVRelaxed  ),
	nLEVOther		( rItem.nLEVOther	  ),
	nLEVShorter   	( rItem.nLEVShorter ),
	nLEVLonger    	( rItem.nLEVLonger )
{
}

// -----------------------------------------------------------------------

int SvxSearchItem::operator==( const SfxPoolItem& rItem ) const
{
	DBG_ASSERT( SfxPoolItem::operator==( rItem ), "unequal which or type" );

	return ( nCommand 		== ( (SvxSearchItem&)rItem ).nCommand ) 	  &&
		   ( aSearchString  == ( (SvxSearchItem&)rItem ).aSearchString )  &&
		   ( aReplaceString == ( (SvxSearchItem&)rItem ).aReplaceString ) &&
		   ( bWordOnly 		== ( (SvxSearchItem&)rItem ).bWordOnly ) 	  &&
		   ( bExact 		== ( (SvxSearchItem&)rItem ).bExact )  		  &&
		   ( bBackward 		== ( (SvxSearchItem&)rItem ).bBackward ) 	  &&
		   ( bSelection 	== ( (SvxSearchItem&)rItem ).bSelection ) 	  &&
		   ( bRegExp 		== ( (SvxSearchItem&)rItem ).bRegExp ) 		  &&
		   ( bPattern 		== ( (SvxSearchItem&)rItem ).bPattern ) 	  &&
		   ( bContent 		== ( (SvxSearchItem&)rItem ).bContent ) 	  &&
		   ( eFamily 		== ( (SvxSearchItem&)rItem ).eFamily ) 		  &&
		   ( bRowDirection 	== ( (SvxSearchItem&)rItem ).bRowDirection )  &&
		   ( bAllTables 	== ( (SvxSearchItem&)rItem ).bAllTables )	  &&
		   ( nCellType 		== ( (SvxSearchItem&)rItem ).nCellType ) 	  &&
		   ( nAppFlag 		== ( (SvxSearchItem&)rItem ).nAppFlag )		  &&
		   ( bLevenshtein	== ( (SvxSearchItem&)rItem ).bLevenshtein  )  &&
		   ( bLEVRelaxed	== ( (SvxSearchItem&)rItem ).bLEVRelaxed  )   &&
		   ( nLEVOther		== ( (SvxSearchItem&)rItem ).nLEVOther   )    &&
		   ( nLEVShorter 	== ( (SvxSearchItem&)rItem ).nLEVShorter )    &&
		   ( nLEVLonger   	== ( (SvxSearchItem&)rItem ).nLEVLonger  );
}

//------------------------------------------------------------------------

SfxItemPresentation SvxSearchItem::GetPresentation
(
	SfxItemPresentation ePres,
	SfxMapUnit			eCoreUnit,
	SfxMapUnit			ePresUnit,
    XubString&          rText, const IntlWrapper *
)	const
{
	switch ( ePres )
	{
		case SFX_ITEM_PRESENTATION_NONE:
			rText.Erase();
			return SFX_ITEM_PRESENTATION_NONE;
		case SFX_ITEM_PRESENTATION_NAMELESS:
		case SFX_ITEM_PRESENTATION_COMPLETE:
		{
			rText = SVX_RESSTR(RID_SVXITEMS_SEARCHCMD_BEGIN + nCommand);
			rText += cpDelim;
			rText += aSearchString;
			rText += cpDelim;
			rText += aReplaceString;
			rText += cpDelim;
			rText += ::GetBoolString( bWordOnly );
			rText += cpDelim;
			rText += ::GetBoolString( bExact );
			rText += cpDelim;
			rText += ::GetBoolString( bBackward );
			rText += cpDelim;
			rText += ::GetBoolString( bSelection );
			rText += cpDelim;
			rText += ::GetBoolString( bRegExp );
			rText += cpDelim;
			rText += ::GetBoolString( bPattern );
			rText += cpDelim;
			rText += ::GetBoolString( bContent );
			rText += cpDelim;
			rText += SVX_RESSTR(RID_SVXITEMS_SEARCHSTYLE_BEGIN + (sal_uInt16)eFamily );
			rText += cpDelim;
			rText += ::GetBoolString( bRowDirection );
			rText += cpDelim;
			rText += ::GetBoolString( bAllTables );
			rText += cpDelim;
			rText += SVX_RESSTR(RID_SVXITEMS_SEARCHIN_BEGIN + nCellType);
			rText += cpDelim;
			rText += SVX_RESSTR(RID_SVXITEMS_SEARCHAPP_BEGIN + nAppFlag);
			return ePres;
		}
	}
	return SFX_ITEM_PRESENTATION_NONE;

}


