/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: itemdel.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 15:58:51 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#include "itemdel.hxx"

#ifndef _SV_SVAPP_HXX //autogen
#include <vcl/svapp.hxx>
#endif
#ifndef _ERRCODE_HXX //autogen
#include <tools/errcode.hxx>
#endif
#include <limits.h>

#include "svtdata.hxx"
#include "svarray.hxx"
#include "itempool.hxx"

// STATIC DATA -----------------------------------------------------------

DBG_NAME(SfxItemDesruptor_Impl);

// -----------------------------------------------------------------------

class SfxItemDesruptor_Impl
{
	SfxPoolItem *pItem;
	Link		 aLink;

private:
				 DECL_LINK( Delete, void * );
				 SfxItemDesruptor_Impl( const SfxItemDesruptor_Impl& ); // n.i.

public:
				 SfxItemDesruptor_Impl( SfxPoolItem *pItemToDesrupt );
				 ~SfxItemDesruptor_Impl();
};

SV_DECL_PTRARR( SfxItemDesruptorList_Impl, SfxItemDesruptor_Impl*, 4, 4 );

// ------------------------------------------------------------------------
SfxItemDesruptor_Impl::SfxItemDesruptor_Impl( SfxPoolItem *pItemToDesrupt ):
	pItem(pItemToDesrupt),
	aLink( LINK(this, SfxItemDesruptor_Impl, Delete) )
{
	DBG_CTOR(SfxItemDesruptor_Impl, 0);

	DBG_ASSERT( 0 == pItem->GetRefCount(), "desrupting pooled item" );
	pItem->SetKind( SFX_ITEMS_DELETEONIDLE );

	// im Idle abarbeiten
	GetpApp()->InsertIdleHdl( aLink, 1 );

	// und in Liste eintragen (damit geflusht werden kann)
	SfxItemDesruptorList_Impl* &rpList = ImpSvtData::GetSvtData().pItemDesruptList;
	if ( !rpList )
		rpList = new SfxItemDesruptorList_Impl;
	const SfxItemDesruptor_Impl *pThis = this;
	rpList->Insert( pThis, rpList->Count() );
}

// ------------------------------------------------------------------------
SfxItemDesruptor_Impl::~SfxItemDesruptor_Impl()
{
	DBG_DTOR(SfxItemDesruptor_Impl, 0);

	// aus Idle-Handler austragen
	GetpApp()->RemoveIdleHdl( aLink );

	// und aus Liste austragen
	SfxItemDesruptorList_Impl* &rpList = ImpSvtData::GetSvtData().pItemDesruptList;
	DBG_ASSERT( rpList, "no DesruptorList" );
	const SfxItemDesruptor_Impl *pThis = this;
	if ( rpList ) HACK(warum?)
		rpList->Remove( rpList->GetPos(pThis) );

	// reset RefCount (was set to SFX_ITEMS_SPECIAL before!)
	pItem->SetRefCount( 0 );
    //DBG_CHKOBJ( pItem, SfxPoolItem, 0 );
	delete pItem;
}

// ------------------------------------------------------------------------
IMPL_LINK( SfxItemDesruptor_Impl, Delete, void *, pvoid )
{
	{DBG_CHKTHIS(SfxItemDesruptor_Impl, 0);}
	delete this;
	return 0;
}

// ------------------------------------------------------------------------
SfxPoolItem* DeleteItemOnIdle( SfxPoolItem* pItem )
{
	DBG_ASSERT( 0 == pItem->GetRefCount(), "deleting item in use" );
	new SfxItemDesruptor_Impl( pItem );
	return pItem;
}

// ------------------------------------------------------------------------
void DeleteOnIdleItems()
{
	SfxItemDesruptorList_Impl* &rpList
	 = ImpSvtData::GetSvtData().pItemDesruptList;
	if ( rpList )
	{
		USHORT n;
		while ( 0 != ( n = rpList->Count() ) )
			// Remove ist implizit im Dtor
			delete rpList->GetObject( n-1 );
		DELETEZ(rpList);
	}
}


