/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: accessibletabbarpagelist.cxx,v $
 *
 *  $Revision: 1.14 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 14:27:02 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _SVTOOLS_ACCESSIBLETABBARPAGELIST_HXX_
#include <accessibletabbarpagelist.hxx>
#endif

#ifndef _TABBAR_HXX
#include <tabbar.hxx>
#endif
#ifndef _SVTOOLS_ACCESSIBLETABBARPAGE_HXX_
#include <accessibletabbarpage.hxx>
#endif

#ifndef _COM_SUN_STAR_ACCESSIBILITY_ACCESSIBLEEVENTID_HPP_
#include <com/sun/star/accessibility/AccessibleEventId.hpp>
#endif
#ifndef _COM_SUN_STAR_ACCESSIBILITY_ACCESSIBLEROLE_HPP_
#include <com/sun/star/accessibility/AccessibleRole.hpp>
#endif
#ifndef _COM_SUN_STAR_ACCESSIBILITY_ACCESSIBLESTATETYPE_HPP_
#include <com/sun/star/accessibility/AccessibleStateType.hpp>
#endif

#ifndef _UTL_ACCESSIBLESTATESETHELPER_HXX_
#include <unotools/accessiblestatesethelper.hxx>
#endif
#ifndef _UTL_ACCESSIBLERELATIONSETHELPER_HXX_
#include <unotools/accessiblerelationsethelper.hxx>
#endif
#ifndef _TOOLS_DEBUG_HXX
#include <tools/debug.hxx>
#endif
#ifndef _SV_SVAPP_HXX
#include <vcl/svapp.hxx>
#endif
#ifndef _TOOLKIT_HELPER_EXTERNALLOCK_HXX_
#include <toolkit/helper/externallock.hxx>
#endif
#ifndef _TOOLKIT_HELPER_CONVERT_HXX_
#include <toolkit/helper/convert.hxx>
#endif


//.........................................................................
namespace svt
{
//.........................................................................

	using namespace ::com::sun::star::accessibility;
	using namespace ::com::sun::star::uno;
	using namespace ::com::sun::star::lang;
	using namespace ::com::sun::star;
	using namespace ::comphelper;

	DBG_NAME( AccessibleTabBarPageList )

	// -----------------------------------------------------------------------------
	// class AccessibleTabBarPageList
	// -----------------------------------------------------------------------------

	AccessibleTabBarPageList::AccessibleTabBarPageList( TabBar* pTabBar, sal_Int32 nIndexInParent )
		:AccessibleExtendedComponentHelper_BASE( new VCLExternalSolarLock() )
		,m_pTabBar( pTabBar )
		,m_nIndexInParent( nIndexInParent )
	{
	    DBG_CTOR( AccessibleTabBarPageList, NULL );

		m_pExternalLock = static_cast< VCLExternalSolarLock* >( getExternalLock() );

		if ( m_pTabBar )
		{
			m_aAccessibleChildren.assign( m_pTabBar->GetPageCount(), Reference< XAccessible >() );
			m_pTabBar->AddEventListener( LINK( this, AccessibleTabBarPageList, WindowEventListener ) );
		}
	}

	// -----------------------------------------------------------------------------

	AccessibleTabBarPageList::~AccessibleTabBarPageList()
	{
	    DBG_DTOR( AccessibleTabBarPageList, NULL );

		if ( m_pTabBar )
			m_pTabBar->RemoveEventListener( LINK( this, AccessibleTabBarPageList, WindowEventListener ) );

		delete m_pExternalLock;
		m_pExternalLock = NULL;
	}

	// -----------------------------------------------------------------------------

	void AccessibleTabBarPageList::UpdateEnabled( sal_Int32 i, sal_Bool bEnabled )
	{
		if ( i >= 0 && i < (sal_Int32)m_aAccessibleChildren.size() )
		{
			Reference< XAccessible > xChild( m_aAccessibleChildren[i] );
			if ( xChild.is() )
			{
				AccessibleTabBarPage* pAccessibleTabBarPage = static_cast< AccessibleTabBarPage* >( xChild.get() );
				if ( pAccessibleTabBarPage )
					pAccessibleTabBarPage->SetEnabled( bEnabled );
			}
		}
	}

	// -----------------------------------------------------------------------------

	void AccessibleTabBarPageList::UpdateShowing( sal_Bool bShowing )
	{
		for ( sal_uInt32 i = 0; i < m_aAccessibleChildren.size(); ++i )
		{
			Reference< XAccessible > xChild( m_aAccessibleChildren[i] );
			if ( xChild.is() )
			{
				AccessibleTabBarPage* pAccessibleTabBarPage = static_cast< AccessibleTabBarPage* >( xChild.get() );
				if ( pAccessibleTabBarPage )
					pAccessibleTabBarPage->SetShowing( bShowing );
			}
		}
	}

	// -----------------------------------------------------------------------------

	void AccessibleTabBarPageList::UpdateSelected( sal_Int32 i, sal_Bool bSelected )
	{
		NotifyAccessibleEvent( AccessibleEventId::SELECTION_CHANGED, Any(), Any() );

		if ( i >= 0 && i < (sal_Int32)m_aAccessibleChildren.size() )
		{
			Reference< XAccessible > xChild( m_aAccessibleChildren[i] );
			if ( xChild.is() )
			{
				AccessibleTabBarPage* pAccessibleTabBarPage = static_cast< AccessibleTabBarPage* >( xChild.get() );
				if ( pAccessibleTabBarPage )
					pAccessibleTabBarPage->SetSelected( bSelected );
			}
		}
	}

	// -----------------------------------------------------------------------------

	void AccessibleTabBarPageList::UpdatePageText( sal_Int32 i )
	{
		if ( i >= 0 && i < (sal_Int32)m_aAccessibleChildren.size() )
		{
			Reference< XAccessible > xChild( m_aAccessibleChildren[i] );
			if ( xChild.is() )
			{
				AccessibleTabBarPage* pAccessibleTabBarPage = static_cast< AccessibleTabBarPage* >( xChild.get() );
				if ( pAccessibleTabBarPage )
				{
					if ( m_pTabBar )
					{
						::rtl::OUString sPageText = m_pTabBar->GetPageText( m_pTabBar->GetPageId( (sal_uInt16)i ) );
						pAccessibleTabBarPage->SetPageText( sPageText );
					}
				}
			}
		}
	}

	// -----------------------------------------------------------------------------

	void AccessibleTabBarPageList::InsertChild( sal_Int32 i )
	{
		if ( i >= 0 && i <= (sal_Int32)m_aAccessibleChildren.size() )
		{
			// insert entry in child list
			m_aAccessibleChildren.insert( m_aAccessibleChildren.begin() + i, Reference< XAccessible >() );

			// send accessible child event
			Reference< XAccessible > xChild( getAccessibleChild( i ) );
			if ( xChild.is() )
			{
				Any aOldValue, aNewValue;
				aNewValue <<= xChild;
				NotifyAccessibleEvent( AccessibleEventId::CHILD, aOldValue, aNewValue );
			}
		}
	}

	// -----------------------------------------------------------------------------

	void AccessibleTabBarPageList::RemoveChild( sal_Int32 i )
	{
		if ( i >= 0 && i < (sal_Int32)m_aAccessibleChildren.size() )
		{
			// get the accessible of the removed page
			Reference< XAccessible > xChild( m_aAccessibleChildren[i] );

			// remove entry in child list
			m_aAccessibleChildren.erase( m_aAccessibleChildren.begin() + i );

			// send accessible child event
			if ( xChild.is() )
			{
				Any aOldValue, aNewValue;
				aOldValue <<= xChild;
				NotifyAccessibleEvent( AccessibleEventId::CHILD, aOldValue, aNewValue );

				Reference< XComponent > xComponent( xChild, UNO_QUERY );
				if ( xComponent.is() )
					xComponent->dispose();
			}
		}
	}

	// -----------------------------------------------------------------------------

	void AccessibleTabBarPageList::MoveChild( sal_Int32 i, sal_Int32 j )
	{
		if ( i >= 0 && i < (sal_Int32)m_aAccessibleChildren.size() &&
			 j >= 0 && j <= (sal_Int32)m_aAccessibleChildren.size() )
		{
			if ( i < j )
				--j;

			// get the accessible of the moved page
			Reference< XAccessible > xChild( m_aAccessibleChildren[i] );

			// remove entry in child list at old position
			m_aAccessibleChildren.erase( m_aAccessibleChildren.begin() + i );

			// insert entry in child list at new position
			m_aAccessibleChildren.insert( m_aAccessibleChildren.begin() + j, xChild );
		}
	}

	// -----------------------------------------------------------------------------

	IMPL_LINK( AccessibleTabBarPageList, WindowEventListener, VclSimpleEvent*, pEvent )
	{
		DBG_CHKTHIS( AccessibleTabBarPageList, 0 );
		DBG_ASSERT( pEvent && pEvent->ISA( VclWindowEvent ), "AccessibleTabBarPageList::WindowEventListener: unknown window event!" );

		if ( pEvent && pEvent->ISA( VclWindowEvent ) )
		{
			DBG_ASSERT( ((VclWindowEvent*)pEvent)->GetWindow(), "AccessibleTabBar::WindowEventListener: no window!" );
			if ( !((VclWindowEvent*)pEvent)->GetWindow()->IsAccessibilityEventsSuppressed() || ( pEvent->GetId() == VCLEVENT_OBJECT_DYING ) )
			{
				ProcessWindowEvent( *(VclWindowEvent*)pEvent );
			}
		}

		return 0;
	}

	// -----------------------------------------------------------------------------

	void AccessibleTabBarPageList::ProcessWindowEvent( const VclWindowEvent& rVclWindowEvent )
	{
		Any aOldValue, aNewValue;

		switch ( rVclWindowEvent.GetId() )
		{
			case VCLEVENT_WINDOW_ENABLED:
			{
				Any aOldValue, aNewValue;
				aNewValue <<= AccessibleStateType::ENABLED;
				NotifyAccessibleEvent( AccessibleEventId::STATE_CHANGED, aOldValue, aNewValue );				
			}
			break;
			case VCLEVENT_WINDOW_DISABLED:
			{
				Any aOldValue, aNewValue;
				aOldValue <<= AccessibleStateType::ENABLED;
				NotifyAccessibleEvent( AccessibleEventId::STATE_CHANGED, aOldValue, aNewValue );
			}
			break;
			case VCLEVENT_WINDOW_SHOW:
			{
				Any aOldValue, aNewValue;
				aNewValue <<= AccessibleStateType::SHOWING;
				NotifyAccessibleEvent( AccessibleEventId::STATE_CHANGED, aOldValue, aNewValue );
				UpdateShowing( sal_True );
			}
			break;
			case VCLEVENT_WINDOW_HIDE:
			{
				Any aOldValue, aNewValue;
				aOldValue <<= AccessibleStateType::SHOWING;
				NotifyAccessibleEvent( AccessibleEventId::STATE_CHANGED, aOldValue, aNewValue );
				UpdateShowing( sal_False );
			}
			break;
			case VCLEVENT_TABBAR_PAGEENABLED:
			{
				if ( m_pTabBar )
				{				
					sal_uInt16 nPageId = (sal_uInt16)(int) rVclWindowEvent.GetData();
					sal_uInt16 nPagePos = m_pTabBar->GetPagePos( nPageId );
					UpdateEnabled( nPagePos, sal_True );
				}
			}
			break;
			case VCLEVENT_TABBAR_PAGEDISABLED:
			{
				if ( m_pTabBar )
				{				
					sal_uInt16 nPageId = (sal_uInt16)(int) rVclWindowEvent.GetData();
					sal_uInt16 nPagePos = m_pTabBar->GetPagePos( nPageId );
					UpdateEnabled( nPagePos, sal_False );
				}
			}
			break;
			case VCLEVENT_TABBAR_PAGESELECTED:
			{
				// do nothing
			}
			break;
			case VCLEVENT_TABBAR_PAGEACTIVATED:
			{
				if ( m_pTabBar )
				{				
					sal_uInt16 nPageId = (sal_uInt16)(int) rVclWindowEvent.GetData();
					sal_uInt16 nPagePos = m_pTabBar->GetPagePos( nPageId );
					UpdateSelected( nPagePos, sal_True );
				}
			}
			break;
			case VCLEVENT_TABBAR_PAGEDEACTIVATED:
			{
				if ( m_pTabBar )
				{				
					sal_uInt16 nPageId = (sal_uInt16)(int) rVclWindowEvent.GetData();
					sal_uInt16 nPagePos = m_pTabBar->GetPagePos( nPageId );
					UpdateSelected( nPagePos, sal_False );
				}
			}
			break;
			case VCLEVENT_TABBAR_PAGEINSERTED:
			{
				if ( m_pTabBar )
				{
					sal_uInt16 nPageId = (sal_uInt16)(int) rVclWindowEvent.GetData();
					sal_uInt16 nPagePos = m_pTabBar->GetPagePos( nPageId );
					InsertChild( nPagePos );
				}
			}
			break;
			case VCLEVENT_TABBAR_PAGEREMOVED:
			{
				if ( m_pTabBar )
				{
					sal_uInt16 nPageId = (sal_uInt16)(int) rVclWindowEvent.GetData();

					if ( nPageId == TAB_PAGE_NOTFOUND )
					{
						for ( sal_Int32 i = m_aAccessibleChildren.size() - 1; i >= 0; --i )
							RemoveChild( i );
					}
					else
					{
						for ( sal_Int32 i = 0, nCount = getAccessibleChildCount(); i < nCount; ++i )
						{
							Reference< XAccessible > xChild( getAccessibleChild( i ) );
							if ( xChild.is() )
							{
								AccessibleTabBarPage* pAccessibleTabBarPage = static_cast< AccessibleTabBarPage* >( xChild.get() );
								if ( pAccessibleTabBarPage && pAccessibleTabBarPage->GetPageId() == nPageId )
								{
									RemoveChild( i );
									break;
								}
							}
						}
					}
				}
			}
			break;
			case VCLEVENT_TABBAR_PAGEMOVED:
			{
			    Pair* pPair = (Pair*) rVclWindowEvent.GetData();
				if ( pPair )
					MoveChild( pPair->A(), pPair->B() );
			}
			break;
			case VCLEVENT_TABBAR_PAGETEXTCHANGED:
			{
			    sal_uInt16 nPageId = (sal_uInt16)(int) rVclWindowEvent.GetData();
				sal_uInt16 nPagePos = m_pTabBar->GetPagePos( nPageId );
				UpdatePageText( nPagePos );
			}
			break;
			case VCLEVENT_OBJECT_DYING:
			{
				if ( m_pTabBar )
				{
					m_pTabBar->RemoveEventListener( LINK( this, AccessibleTabBarPageList, WindowEventListener ) );

					m_pTabBar = NULL;

					// dispose all children
					for ( sal_uInt32 i = 0; i < m_aAccessibleChildren.size(); ++i )
					{
						Reference< XComponent > xComponent( m_aAccessibleChildren[i], UNO_QUERY );
						if ( xComponent.is() )
							xComponent->dispose();
					}
					m_aAccessibleChildren.clear();
				}
			}
			break;
			default:
			{
			}
			break;
		}
	}

	// -----------------------------------------------------------------------------

	void AccessibleTabBarPageList::FillAccessibleStateSet( utl::AccessibleStateSetHelper& rStateSet )
	{
		if ( m_pTabBar )
		{
			if ( m_pTabBar->IsEnabled() )
				rStateSet.AddState( AccessibleStateType::ENABLED );

			rStateSet.AddState( AccessibleStateType::VISIBLE );

			if ( m_pTabBar->IsVisible() )
				rStateSet.AddState( AccessibleStateType::SHOWING );
		}
	}

	// -----------------------------------------------------------------------------
	// OCommonAccessibleComponent 
	// -----------------------------------------------------------------------------

	awt::Rectangle AccessibleTabBarPageList::implGetBounds() throw (RuntimeException)
	{
		awt::Rectangle aBounds;
		if ( m_pTabBar )
			aBounds = AWTRectangle( m_pTabBar->GetPageArea() );

		return aBounds;
	}

	// -----------------------------------------------------------------------------
	// XInterface
	// -----------------------------------------------------------------------------

	IMPLEMENT_FORWARD_XINTERFACE2( AccessibleTabBarPageList, AccessibleExtendedComponentHelper_BASE, AccessibleTabBarPageList_BASE )

	// -----------------------------------------------------------------------------
	// XTypeProvider
	// -----------------------------------------------------------------------------

	IMPLEMENT_FORWARD_XTYPEPROVIDER2( AccessibleTabBarPageList, AccessibleExtendedComponentHelper_BASE, AccessibleTabBarPageList_BASE )

	// -----------------------------------------------------------------------------
	// XComponent
	// -----------------------------------------------------------------------------

	void AccessibleTabBarPageList::disposing()
	{
		AccessibleExtendedComponentHelper_BASE::disposing();

		if ( m_pTabBar )
		{
			m_pTabBar->RemoveEventListener( LINK( this, AccessibleTabBarPageList, WindowEventListener ) );

			m_pTabBar = NULL;

			// dispose all children
			for ( sal_uInt32 i = 0; i < m_aAccessibleChildren.size(); ++i )
			{
				Reference< XComponent > xComponent( m_aAccessibleChildren[i], UNO_QUERY );
				if ( xComponent.is() )
					xComponent->dispose();
			}
			m_aAccessibleChildren.clear();
		}
	}

	// -----------------------------------------------------------------------------
	// XServiceInfo
	// -----------------------------------------------------------------------------

	::rtl::OUString AccessibleTabBarPageList::getImplementationName() throw (RuntimeException)
	{
		return ::rtl::OUString::createFromAscii( "com.sun.star.comp.svtools.AccessibleTabBarPageList" );
	}

	// -----------------------------------------------------------------------------

	sal_Bool AccessibleTabBarPageList::supportsService( const ::rtl::OUString& rServiceName ) throw (RuntimeException)
	{
		Sequence< ::rtl::OUString > aNames( getSupportedServiceNames() );
		const ::rtl::OUString* pNames = aNames.getConstArray();
		const ::rtl::OUString* pEnd = pNames + aNames.getLength();
		for ( ; pNames != pEnd && !pNames->equals( rServiceName ); ++pNames )
			;

		return pNames != pEnd;
	}

	// -----------------------------------------------------------------------------

	Sequence< ::rtl::OUString > AccessibleTabBarPageList::getSupportedServiceNames() throw (RuntimeException)
	{
		Sequence< ::rtl::OUString > aNames(1);
		aNames[0] = ::rtl::OUString::createFromAscii( "com.sun.star.awt.AccessibleTabBarPageList" );
		return aNames;
	}

	// -----------------------------------------------------------------------------
	// XAccessible
	// -----------------------------------------------------------------------------

	Reference< XAccessibleContext > AccessibleTabBarPageList::getAccessibleContext(  ) throw (RuntimeException)
	{
		OExternalLockGuard aGuard( this );

		return this;
	}

	// -----------------------------------------------------------------------------
	// XAccessibleContext
	// -----------------------------------------------------------------------------

	sal_Int32 AccessibleTabBarPageList::getAccessibleChildCount() throw (RuntimeException)
	{
		OExternalLockGuard aGuard( this );

		return m_aAccessibleChildren.size();
	}

	// -----------------------------------------------------------------------------

	Reference< XAccessible > AccessibleTabBarPageList::getAccessibleChild( sal_Int32 i ) throw (IndexOutOfBoundsException, RuntimeException)
	{
		OExternalLockGuard aGuard( this );

		if ( i < 0 || i >= getAccessibleChildCount() )
			throw IndexOutOfBoundsException();

		Reference< XAccessible > xChild = m_aAccessibleChildren[i];
		if ( !xChild.is() )
		{
			if ( m_pTabBar )
			{
				sal_uInt16 nPageId = m_pTabBar->GetPageId( (USHORT)i );

				xChild = new AccessibleTabBarPage( m_pTabBar, nPageId, this );

				// insert into child list
				m_aAccessibleChildren[i] = xChild;
			}
		}

		return xChild;
	}

	// -----------------------------------------------------------------------------

	Reference< XAccessible > AccessibleTabBarPageList::getAccessibleParent(  ) throw (RuntimeException)
	{
		OExternalLockGuard aGuard( this );

		Reference< XAccessible > xParent;
		if ( m_pTabBar )
			xParent = m_pTabBar->GetAccessible();

		return xParent;
	}

	// -----------------------------------------------------------------------------

	sal_Int32 AccessibleTabBarPageList::getAccessibleIndexInParent(  ) throw (RuntimeException)
	{
		OExternalLockGuard aGuard( this );

		return m_nIndexInParent;
	}

	// -----------------------------------------------------------------------------

	sal_Int16 AccessibleTabBarPageList::getAccessibleRole(  ) throw (RuntimeException)
	{
		OExternalLockGuard aGuard( this );

		return AccessibleRole::PAGE_TAB_LIST;
	}

	// -----------------------------------------------------------------------------

	::rtl::OUString AccessibleTabBarPageList::getAccessibleDescription(	) throw (RuntimeException)
	{
		OExternalLockGuard aGuard( this );

		return ::rtl::OUString();
	}

	// -----------------------------------------------------------------------------

	::rtl::OUString AccessibleTabBarPageList::getAccessibleName(  ) throw (RuntimeException)
	{
		OExternalLockGuard aGuard( this );

		return ::rtl::OUString();
	}

	// -----------------------------------------------------------------------------

	Reference< XAccessibleRelationSet > AccessibleTabBarPageList::getAccessibleRelationSet(  ) throw (RuntimeException)
	{
		OExternalLockGuard aGuard( this );

		utl::AccessibleRelationSetHelper* pRelationSetHelper = new utl::AccessibleRelationSetHelper;
		Reference< XAccessibleRelationSet > xSet = pRelationSetHelper;
		return xSet;
	}

	// -----------------------------------------------------------------------------

	Reference< XAccessibleStateSet > AccessibleTabBarPageList::getAccessibleStateSet(  ) throw (RuntimeException)
	{
		OExternalLockGuard aGuard( this );

		utl::AccessibleStateSetHelper* pStateSetHelper = new utl::AccessibleStateSetHelper;
		Reference< XAccessibleStateSet > xSet = pStateSetHelper;

		if ( !rBHelper.bDisposed && !rBHelper.bInDispose )
		{
			FillAccessibleStateSet( *pStateSetHelper );
		}
		else
		{
			pStateSetHelper->AddState( AccessibleStateType::DEFUNC );
		}

		return xSet;
	}

	// -----------------------------------------------------------------------------

	Locale AccessibleTabBarPageList::getLocale(  ) throw (IllegalAccessibleComponentStateException, RuntimeException)
	{
		OExternalLockGuard aGuard( this );

		return Application::GetSettings().GetLocale();
	}

	// -----------------------------------------------------------------------------
	// XAccessibleComponent
	// -----------------------------------------------------------------------------

	Reference< XAccessible > AccessibleTabBarPageList::getAccessibleAtPoint( const awt::Point& rPoint ) throw (RuntimeException)
	{
		OExternalLockGuard aGuard( this );

		Reference< XAccessible > xChild;
		for ( sal_uInt32 i = 0; i < m_aAccessibleChildren.size(); ++i )
		{
			Reference< XAccessible > xAcc = getAccessibleChild( i );
			if ( xAcc.is() )
			{			
				Reference< XAccessibleComponent > xComp( xAcc->getAccessibleContext(), UNO_QUERY );				
				if ( xComp.is() )
				{
					Rectangle aRect = VCLRectangle( xComp->getBounds() );
					Point aPos = VCLPoint( rPoint );
					if ( aRect.IsInside( aPos ) )
					{
						xChild = xAcc;
						break;
					}
				}
			}
		}

		return xChild;
	}

	// -----------------------------------------------------------------------------

	void AccessibleTabBarPageList::grabFocus(  ) throw (RuntimeException)
	{
		// no focus
	}

	// -----------------------------------------------------------------------------

	sal_Int32 AccessibleTabBarPageList::getForeground(	) throw (RuntimeException)
	{
		OExternalLockGuard aGuard( this );

		sal_Int32 nColor = 0;
		Reference< XAccessible > xParent = getAccessibleParent();
		if ( xParent.is() )
		{
			Reference< XAccessibleComponent > xParentComp( xParent->getAccessibleContext(), UNO_QUERY );
			if ( xParentComp.is() )
				nColor = xParentComp->getForeground();	
		}

		return nColor;
	}

	// -----------------------------------------------------------------------------

	sal_Int32 AccessibleTabBarPageList::getBackground(  ) throw (RuntimeException)
	{
		OExternalLockGuard aGuard( this );

		sal_Int32 nColor = 0;
		Reference< XAccessible > xParent = getAccessibleParent();
		if ( xParent.is() )
		{
			Reference< XAccessibleComponent > xParentComp( xParent->getAccessibleContext(), UNO_QUERY );
			if ( xParentComp.is() )
				nColor = xParentComp->getBackground();	
		}

		return nColor;
	}

	// -----------------------------------------------------------------------------
	// XAccessibleExtendedComponent
	// -----------------------------------------------------------------------------

	Reference< awt::XFont > AccessibleTabBarPageList::getFont(  ) throw (RuntimeException)
	{
		OExternalLockGuard aGuard( this );

		Reference< awt::XFont > xFont;
		sal_Int32 nColor = 0;
		Reference< XAccessible > xParent = getAccessibleParent();
		if ( xParent.is() )
		{
			Reference< XAccessibleExtendedComponent > xParentComp( xParent->getAccessibleContext(), UNO_QUERY );
			if ( xParentComp.is() )
				xFont = xParentComp->getFont();	
		}

		return xFont;
	}

	// -----------------------------------------------------------------------------

	::rtl::OUString AccessibleTabBarPageList::getTitledBorderText(  ) throw (RuntimeException)
	{
		OExternalLockGuard aGuard( this );

		return ::rtl::OUString();
	}

	// -----------------------------------------------------------------------------

	::rtl::OUString AccessibleTabBarPageList::getToolTipText(  ) throw (RuntimeException)
	{
		OExternalLockGuard aGuard( this );

		return ::rtl::OUString();
	}

	// -----------------------------------------------------------------------------
	// XAccessibleSelection
	// -----------------------------------------------------------------------------

	void AccessibleTabBarPageList::selectAccessibleChild( sal_Int32 nChildIndex ) throw (IndexOutOfBoundsException, RuntimeException)
	{
		OExternalLockGuard aGuard( this );

		if ( nChildIndex < 0 || nChildIndex >= getAccessibleChildCount() )
			throw IndexOutOfBoundsException();

		if ( m_pTabBar )
		{
			m_pTabBar->SetCurPageId( m_pTabBar->GetPageId( (USHORT)nChildIndex ) );
			m_pTabBar->Update();
			m_pTabBar->ActivatePage();
			m_pTabBar->Select();
		}
	}

	// -----------------------------------------------------------------------------

	sal_Bool AccessibleTabBarPageList::isAccessibleChildSelected( sal_Int32 nChildIndex ) throw (IndexOutOfBoundsException, RuntimeException)
	{
		OExternalLockGuard aGuard( this );

		if ( nChildIndex < 0 || nChildIndex >= getAccessibleChildCount() )
			throw IndexOutOfBoundsException();

		sal_Bool bSelected = sal_False;
		if ( m_pTabBar && m_pTabBar->GetCurPageId() == m_pTabBar->GetPageId( (USHORT)nChildIndex ) )
			bSelected = sal_True;

		return bSelected;
	}

	// -----------------------------------------------------------------------------

	void AccessibleTabBarPageList::clearAccessibleSelection(  ) throw (RuntimeException)
	{
		// This method makes no sense in a TabBar, and so does nothing.
	}

	// -----------------------------------------------------------------------------

	void AccessibleTabBarPageList::selectAllAccessibleChildren(  ) throw (RuntimeException)
	{
		OExternalLockGuard aGuard( this );

		selectAccessibleChild( 0 );
	}

	// -----------------------------------------------------------------------------

	sal_Int32 AccessibleTabBarPageList::getSelectedAccessibleChildCount(  ) throw (RuntimeException)
	{
		OExternalLockGuard aGuard( this );

		return 1;
	}

	// -----------------------------------------------------------------------------

	Reference< XAccessible > AccessibleTabBarPageList::getSelectedAccessibleChild( sal_Int32 nSelectedChildIndex ) throw (IndexOutOfBoundsException, RuntimeException)
	{
		OExternalLockGuard aGuard( this );

		if ( nSelectedChildIndex < 0 || nSelectedChildIndex >= getSelectedAccessibleChildCount() )
			throw IndexOutOfBoundsException();

		Reference< XAccessible > xChild;

		for ( sal_Int32 i = 0, j = 0, nCount = getAccessibleChildCount(); i < nCount; i++ )
		{		
			if ( isAccessibleChildSelected( i ) && ( j++ == nSelectedChildIndex ) )
			{
				xChild = getAccessibleChild( i );
				break;
			}
		}

		return xChild;
	}

	// -----------------------------------------------------------------------------

	void AccessibleTabBarPageList::deselectAccessibleChild( sal_Int32 nChildIndex ) throw (IndexOutOfBoundsException, RuntimeException)
	{
		OExternalLockGuard aGuard( this );

		if ( nChildIndex < 0 || nChildIndex >= getAccessibleChildCount() )
			throw IndexOutOfBoundsException();

		// This method makes no sense in a TabBar, and so does nothing.
	}

	// -----------------------------------------------------------------------------

//.........................................................................
}	// namespace svt
//.........................................................................
