/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: accessibletabbar.cxx,v $
 *
 *  $Revision: 1.10 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 14:26:29 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _SVTOOLS_ACCESSIBLETABBAR_HXX_
#include <accessibletabbar.hxx>
#endif

#ifndef _TABBAR_HXX
#include <tabbar.hxx>
#endif
#ifndef _SVTOOLS_ACCESSIBLETABBARPAGELIST_HXX_
#include <accessibletabbarpagelist.hxx>
#endif

#ifndef _COM_SUN_STAR_ACCESSIBILITY_ACCESSIBLEEVENTID_HPP_
#include <com/sun/star/accessibility/AccessibleEventId.hpp>
#endif
#ifndef _COM_SUN_STAR_ACCESSIBILITY_ACCESSIBLEROLE_HPP_
#include <com/sun/star/accessibility/AccessibleRole.hpp>
#endif
#ifndef _COM_SUN_STAR_ACCESSIBILITY_ACCESSIBLESTATETYPE_HPP_
#include <com/sun/star/accessibility/AccessibleStateType.hpp>
#endif

#ifndef _UTL_ACCESSIBLESTATESETHELPER_HXX_
#include <unotools/accessiblestatesethelper.hxx>
#endif
#ifndef _UTL_ACCESSIBLERELATIONSETHELPER_HXX_
#include <unotools/accessiblerelationsethelper.hxx>
#endif
#ifndef _SV_SVAPP_HXX
#include <vcl/svapp.hxx>
#endif
#ifndef _TOOLKIT_AWT_VCLXFONT_HXX_
#include <toolkit/awt/vclxfont.hxx>
#endif
#ifndef _TOOLKIT_HELPER_EXTERNALLOCK_HXX_
#include <toolkit/helper/externallock.hxx>
#endif
#ifndef _TOOLKIT_HELPER_CONVERT_HXX_
#include <toolkit/helper/convert.hxx>
#endif

#include <vector>


//.........................................................................
namespace svt
{
//.........................................................................

	using namespace ::com::sun::star;
	using namespace ::com::sun::star::uno;
	using namespace ::com::sun::star::lang;
	using namespace ::com::sun::star::accessibility;
	using namespace ::comphelper;

	DBG_NAME( AccessibleTabBar )

	//	----------------------------------------------------
	//	class AccessibleTabBar
	//	----------------------------------------------------

	AccessibleTabBar::AccessibleTabBar( TabBar* pTabBar )
		:AccessibleExtendedComponentHelper_BASE( new VCLExternalSolarLock() )
		,m_pTabBar( pTabBar )
	{
	    DBG_CTOR( AccessibleTabBar, NULL );
		m_pExternalLock = static_cast< VCLExternalSolarLock* >( getExternalLock() );

		if ( m_pTabBar )
		{
			m_aAccessibleChildren.assign( m_pTabBar->GetAccessibleChildWindowCount() + 1, Reference< XAccessible >() );
			m_pTabBar->AddEventListener( LINK( this, AccessibleTabBar, WindowEventListener ) );
		}
	}

	// -----------------------------------------------------------------------------

	AccessibleTabBar::~AccessibleTabBar()
	{
	    DBG_DTOR( AccessibleTabBar, NULL );
		if ( m_pTabBar )
			m_pTabBar->RemoveEventListener( LINK( this, AccessibleTabBar, WindowEventListener ) );

		delete m_pExternalLock;
		m_pExternalLock = NULL;
	}

	// -----------------------------------------------------------------------------

	IMPL_LINK( AccessibleTabBar, WindowEventListener, VclSimpleEvent*, pEvent )
	{
		DBG_CHKTHIS( AccessibleTabBar, 0 );
		DBG_ASSERT( pEvent && pEvent->ISA( VclWindowEvent ), "AccessibleTabBar::WindowEventListener: unknown window event!" );

		if ( pEvent && pEvent->ISA( VclWindowEvent ) )
		{
			DBG_ASSERT( ((VclWindowEvent*)pEvent)->GetWindow(), "AccessibleTabBar::WindowEventListener: no window!" );
			if ( !((VclWindowEvent*)pEvent)->GetWindow()->IsAccessibilityEventsSuppressed() || ( pEvent->GetId() == VCLEVENT_OBJECT_DYING ) )
			{
				ProcessWindowEvent( *(VclWindowEvent*)pEvent );
			}
		}

		return 0;
	}

	// -----------------------------------------------------------------------------

	void AccessibleTabBar::ProcessWindowEvent( const VclWindowEvent& rVclWindowEvent )
	{
		Any aOldValue, aNewValue;

		switch ( rVclWindowEvent.GetId() )
		{
			case VCLEVENT_WINDOW_ENABLED:
			{
				aNewValue <<= AccessibleStateType::ENABLED;
				NotifyAccessibleEvent( AccessibleEventId::STATE_CHANGED, aOldValue, aNewValue );
			}
			break;
			case VCLEVENT_WINDOW_DISABLED:
			{
				aOldValue <<= AccessibleStateType::ENABLED;
				NotifyAccessibleEvent( AccessibleEventId::STATE_CHANGED, aOldValue, aNewValue );
			}
			break;
			case VCLEVENT_WINDOW_GETFOCUS:
			{
				aNewValue <<= AccessibleStateType::FOCUSED;
				NotifyAccessibleEvent( AccessibleEventId::STATE_CHANGED, aOldValue, aNewValue );
			}
			break;
			case VCLEVENT_WINDOW_LOSEFOCUS:
			{
				aOldValue <<= AccessibleStateType::FOCUSED;
				NotifyAccessibleEvent( AccessibleEventId::STATE_CHANGED, aOldValue, aNewValue );
			}
			break;
			case VCLEVENT_WINDOW_SHOW:
			{
				aNewValue <<= AccessibleStateType::SHOWING;
				NotifyAccessibleEvent( AccessibleEventId::STATE_CHANGED, aOldValue, aNewValue );							
			}
			break;
			case VCLEVENT_WINDOW_HIDE:
			{
				aOldValue <<= AccessibleStateType::SHOWING;
				NotifyAccessibleEvent( AccessibleEventId::STATE_CHANGED, aOldValue, aNewValue );				
			}
			break;
			case VCLEVENT_OBJECT_DYING:
			{
				if ( m_pTabBar )
				{
					m_pTabBar->RemoveEventListener( LINK( this, AccessibleTabBar, WindowEventListener ) );

					m_pTabBar = NULL;

					// dispose all children
					for ( sal_uInt32 i = 0; i < m_aAccessibleChildren.size(); ++i )
					{
						Reference< XComponent > xComponent( m_aAccessibleChildren[i], UNO_QUERY );
						if ( xComponent.is() )
							xComponent->dispose();
					}
					m_aAccessibleChildren.clear();
				}
			}
			break;
			default:
			{
			}
			break;
		}
	}

	// -----------------------------------------------------------------------------

	void AccessibleTabBar::FillAccessibleStateSet( utl::AccessibleStateSetHelper& rStateSet )
	{
		if ( m_pTabBar )
		{
			if ( m_pTabBar->IsEnabled() )
				rStateSet.AddState( AccessibleStateType::ENABLED );

			rStateSet.AddState( AccessibleStateType::FOCUSABLE );

			if ( m_pTabBar->HasFocus() )
				rStateSet.AddState( AccessibleStateType::FOCUSED );

			rStateSet.AddState( AccessibleStateType::VISIBLE );

			if ( m_pTabBar->IsVisible() )
				rStateSet.AddState( AccessibleStateType::SHOWING );

			if ( m_pTabBar->GetStyle() & WB_SIZEABLE )
				rStateSet.AddState( AccessibleStateType::RESIZABLE );
		}
	}

	// -----------------------------------------------------------------------------
	// OCommonAccessibleComponent 
	// -----------------------------------------------------------------------------

	awt::Rectangle AccessibleTabBar::implGetBounds() throw (RuntimeException)
	{
		awt::Rectangle aBounds;
		if ( m_pTabBar )
			aBounds = AWTRectangle( Rectangle( m_pTabBar->GetPosPixel(), m_pTabBar->GetSizePixel() ) );

		return aBounds;
	}

	// -----------------------------------------------------------------------------
	// XInterface
	// -----------------------------------------------------------------------------

	IMPLEMENT_FORWARD_XINTERFACE2( AccessibleTabBar, AccessibleExtendedComponentHelper_BASE, AccessibleTabBar_BASE )

	// -----------------------------------------------------------------------------
	// XTypeProvider
	// -----------------------------------------------------------------------------

	IMPLEMENT_FORWARD_XTYPEPROVIDER2( AccessibleTabBar, AccessibleExtendedComponentHelper_BASE, AccessibleTabBar_BASE )

	// -----------------------------------------------------------------------------
	// XComponent
	// -----------------------------------------------------------------------------

	void AccessibleTabBar::disposing()
	{
		AccessibleExtendedComponentHelper_BASE::disposing();

		if ( m_pTabBar )
		{
			m_pTabBar->RemoveEventListener( LINK( this, AccessibleTabBar, WindowEventListener ) );

			m_pTabBar = NULL;

			// dispose all children
			for ( sal_uInt32 i = 0; i < m_aAccessibleChildren.size(); ++i )
			{
				Reference< XComponent > xComponent( m_aAccessibleChildren[i], UNO_QUERY );
				if ( xComponent.is() )
					xComponent->dispose();
			}
			m_aAccessibleChildren.clear();
		}
	}

	// -----------------------------------------------------------------------------
	// XServiceInfo
	// -----------------------------------------------------------------------------

	::rtl::OUString AccessibleTabBar::getImplementationName() throw (RuntimeException)
	{
		return ::rtl::OUString::createFromAscii( "com.sun.star.comp.svtools.AccessibleTabBar" );
	}

	// -----------------------------------------------------------------------------

	sal_Bool AccessibleTabBar::supportsService( const ::rtl::OUString& rServiceName ) throw (RuntimeException)
	{
		Sequence< ::rtl::OUString > aNames( getSupportedServiceNames() );
		const ::rtl::OUString* pNames = aNames.getConstArray();
		const ::rtl::OUString* pEnd = pNames + aNames.getLength();
		for ( ; pNames != pEnd && !pNames->equals( rServiceName ); ++pNames )
			;

		return pNames != pEnd;
	}

	// -----------------------------------------------------------------------------

	Sequence< ::rtl::OUString > AccessibleTabBar::getSupportedServiceNames() throw (RuntimeException)
	{
		Sequence< ::rtl::OUString > aNames(1);
		aNames[0] = ::rtl::OUString::createFromAscii( "com.sun.star.awt.AccessibleTabBar" );
		return aNames;
	}

	// -----------------------------------------------------------------------------
	// XAccessible
	// -----------------------------------------------------------------------------

	Reference< XAccessibleContext > AccessibleTabBar::getAccessibleContext(  ) throw (RuntimeException)
	{
		OExternalLockGuard aGuard( this );

		return this;
	}

	// -----------------------------------------------------------------------------
	// XAccessibleContext
	// -----------------------------------------------------------------------------

	sal_Int32 AccessibleTabBar::getAccessibleChildCount() throw (RuntimeException)
	{
		OExternalLockGuard aGuard( this );

		return m_aAccessibleChildren.size();
	}

	// -----------------------------------------------------------------------------

	Reference< XAccessible > AccessibleTabBar::getAccessibleChild( sal_Int32 i ) throw (IndexOutOfBoundsException, RuntimeException)
	{
		OExternalLockGuard aGuard( this );

		if ( i < 0 || i >= getAccessibleChildCount() )
			throw IndexOutOfBoundsException();

		Reference< XAccessible > xChild = m_aAccessibleChildren[i];
		if ( !xChild.is() )
		{
			if ( m_pTabBar )
			{
				sal_Int32 nCount = m_pTabBar->GetAccessibleChildWindowCount();

				if ( i < nCount )
				{
					Window* pChild = m_pTabBar->GetAccessibleChildWindow( (USHORT)i );
					if ( pChild )
						xChild = pChild->GetAccessible();
				}
				else if ( i == nCount )
				{
					xChild = new AccessibleTabBarPageList( m_pTabBar, i );
				}

				// insert into child list
				m_aAccessibleChildren[i] = xChild;
			}
		}

		return xChild;
	}

	// -----------------------------------------------------------------------------

	Reference< XAccessible > AccessibleTabBar::getAccessibleParent(  ) throw (RuntimeException)
	{
		OExternalLockGuard aGuard( this );

		Reference< XAccessible > xParent;
		if ( m_pTabBar )
		{
			Window* pParent = m_pTabBar->GetAccessibleParentWindow();
			if ( pParent )
				xParent = pParent->GetAccessible();
		}

		return xParent;
	}

	// -----------------------------------------------------------------------------

	sal_Int32 AccessibleTabBar::getAccessibleIndexInParent(  ) throw (RuntimeException)
	{
		OExternalLockGuard aGuard( this );

		sal_Int32 nIndexInParent = -1;
		if ( m_pTabBar )
		{
			Window* pParent = m_pTabBar->GetAccessibleParentWindow();
			if ( pParent )
			{
				for ( USHORT i = 0, nCount = pParent->GetAccessibleChildWindowCount(); i < nCount; ++i )
				{
					Window* pChild = pParent->GetAccessibleChildWindow( i );
					if ( pChild == static_cast< Window* >( m_pTabBar ) )
					{
						nIndexInParent = i;
						break;
					}
				}
			}
		}

		return nIndexInParent;
	}

	// -----------------------------------------------------------------------------

	sal_Int16 AccessibleTabBar::getAccessibleRole(  ) throw (RuntimeException)
	{
		OExternalLockGuard aGuard( this );

		return AccessibleRole::PANEL;
	}

	// -----------------------------------------------------------------------------

	::rtl::OUString AccessibleTabBar::getAccessibleDescription(	) throw (RuntimeException)
	{
		OExternalLockGuard aGuard( this );

		::rtl::OUString sDescription;
		if ( m_pTabBar )
			sDescription = m_pTabBar->GetAccessibleDescription();

		return sDescription;
	}

	// -----------------------------------------------------------------------------

	::rtl::OUString AccessibleTabBar::getAccessibleName(  ) throw (RuntimeException)
	{
		OExternalLockGuard aGuard( this );

		::rtl::OUString sName;
		if ( m_pTabBar )
			sName = m_pTabBar->GetAccessibleName();

		return sName;
	}

	// -----------------------------------------------------------------------------

	Reference< XAccessibleRelationSet > AccessibleTabBar::getAccessibleRelationSet(  ) throw (RuntimeException)
	{
		OExternalLockGuard aGuard( this );

		utl::AccessibleRelationSetHelper* pRelationSetHelper = new utl::AccessibleRelationSetHelper;
		Reference< XAccessibleRelationSet > xSet = pRelationSetHelper;
		return xSet;
	}

	// -----------------------------------------------------------------------------

	Reference< XAccessibleStateSet > AccessibleTabBar::getAccessibleStateSet(  ) throw (RuntimeException)
	{
		OExternalLockGuard aGuard( this );

		utl::AccessibleStateSetHelper* pStateSetHelper = new utl::AccessibleStateSetHelper;
		Reference< XAccessibleStateSet > xSet = pStateSetHelper;

		if ( !rBHelper.bDisposed && !rBHelper.bInDispose )
		{
			FillAccessibleStateSet( *pStateSetHelper );
		}
		else
		{
			pStateSetHelper->AddState( AccessibleStateType::DEFUNC );
		}

		return xSet;
	}

	// -----------------------------------------------------------------------------

	Locale AccessibleTabBar::getLocale(  ) throw (IllegalAccessibleComponentStateException, RuntimeException)
	{
		OExternalLockGuard aGuard( this );

		return Application::GetSettings().GetLocale();
	}

	// -----------------------------------------------------------------------------
	// XAccessibleComponent
	// -----------------------------------------------------------------------------

	Reference< XAccessible > AccessibleTabBar::getAccessibleAtPoint( const awt::Point& rPoint ) throw (RuntimeException)
	{
		OExternalLockGuard aGuard( this );

		Reference< XAccessible > xChild;
		for ( sal_uInt32 i = 0; i < m_aAccessibleChildren.size(); ++i )
		{
			Reference< XAccessible > xAcc = getAccessibleChild( i );
			if ( xAcc.is() )
			{			
				Reference< XAccessibleComponent > xComp( xAcc->getAccessibleContext(), UNO_QUERY );				
				if ( xComp.is() )
				{
					Rectangle aRect = VCLRectangle( xComp->getBounds() );
					Point aPos = VCLPoint( rPoint );
					if ( aRect.IsInside( aPos ) )
					{
						xChild = xAcc;
						break;
					}
				}
			}
		}

		return xChild;
	}

	// -----------------------------------------------------------------------------

	void AccessibleTabBar::grabFocus(  ) throw (RuntimeException)
	{
		OExternalLockGuard aGuard( this );

		if ( m_pTabBar )
			m_pTabBar->GrabFocus();
	}

	// -----------------------------------------------------------------------------

	sal_Int32 AccessibleTabBar::getForeground(	) throw (RuntimeException)
	{
		OExternalLockGuard aGuard( this );

		sal_Int32 nColor = 0;
		if ( m_pTabBar )
		{
			if ( m_pTabBar->IsControlForeground() )
				nColor = m_pTabBar->GetControlForeground().GetColor();
			else
			{
				Font aFont;
				if ( m_pTabBar->IsControlFont() )
					aFont = m_pTabBar->GetControlFont();
				else
					aFont = m_pTabBar->GetFont();
				nColor = aFont.GetColor().GetColor();
			}
		}

		return nColor;
	}

	// -----------------------------------------------------------------------------

	sal_Int32 AccessibleTabBar::getBackground(  ) throw (RuntimeException)
	{
		OExternalLockGuard aGuard( this );

		sal_Int32 nColor = 0;
		if ( m_pTabBar )
		{
			if ( m_pTabBar->IsControlBackground() )
				nColor = m_pTabBar->GetControlBackground().GetColor();
			else
				nColor = m_pTabBar->GetBackground().GetColor().GetColor();
		}

		return nColor;
	}

	// -----------------------------------------------------------------------------
	// XAccessibleExtendedComponent
	// -----------------------------------------------------------------------------

	Reference< awt::XFont > AccessibleTabBar::getFont(  ) throw (RuntimeException)
	{
		OExternalLockGuard aGuard( this );

		Reference< awt::XFont > xFont;
		if ( m_pTabBar )
		{
			Reference< awt::XDevice > xDev( m_pTabBar->GetComponentInterface(), UNO_QUERY );
			if ( xDev.is() )
			{
				Font aFont;
				if ( m_pTabBar->IsControlFont() )
					aFont = m_pTabBar->GetControlFont();
				else
					aFont = m_pTabBar->GetFont();
				VCLXFont* pVCLXFont = new VCLXFont;
				pVCLXFont->Init( *xDev.get(), aFont );
				xFont = pVCLXFont;
			}
		}

		return xFont;
	}

	// -----------------------------------------------------------------------------

	::rtl::OUString AccessibleTabBar::getTitledBorderText(  ) throw (RuntimeException)
	{
		OExternalLockGuard aGuard( this );

		::rtl::OUString sText;
		if ( m_pTabBar )
			sText = m_pTabBar->GetText();

		return sText;
	}

	// -----------------------------------------------------------------------------

	::rtl::OUString AccessibleTabBar::getToolTipText(  ) throw (RuntimeException)
	{
		OExternalLockGuard aGuard( this );

		::rtl::OUString sText;
		if ( m_pTabBar )
			sText = m_pTabBar->GetQuickHelpText();

		return sText;
	}

	// -----------------------------------------------------------------------------

//.........................................................................
}	// namespace svt
//.........................................................................
