/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: gdimtftools.hxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 21:12:45 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _SLIDESHOW_GDIMTFTOOLS_HXX
#define _SLIDESHOW_GDIMTFTOOLS_HXX

#ifndef _COM_SUN_STAR_UNO_REFERENCE_HXX_
#include <com/sun/star/uno/Reference.hxx>
#endif

#ifndef BOOST_SHARED_PTR_HPP_INCLUDED
#include <boost/shared_ptr.hpp>
#endif

#include <vector>


class GDIMetaFile;
class Graphic;

namespace com { namespace sun { namespace star { namespace drawing 
{
    class XShape;
    class XDrawPage;
} } } }


// -----------------------------------------------------------------------------

namespace presentation
{
    namespace internal
    {
        typedef ::boost::shared_ptr< GDIMetaFile > GDIMetaFileSharedPtr;


        /** Retrieve a meta file for the given shape

			@param xShape
            XShape to retrieve a metafile for.
        
            @param xContainingPage
            The page that contains this shape. Needed for proper
            import (currently, the UnoGraphicExporter needs this
            information).

            @param o_rMtf
            Metafile to extract shape content into

            @param bVerboseComments
            When true, annotate text actions with verbose comments,
            denoting logical and physical text entities.

            @param bForeignSource
            When true, the source of the metafile might be a foreign
            application. The metafile is checked against unsupported
            content, and, if necessary, returned as a pre-rendererd
            bitmap.
         */
        bool getMetaFile( const ::com::sun::star::uno::Reference< ::com::sun::star::drawing::XShape >& 		xShape, 
                          const ::com::sun::star::uno::Reference< ::com::sun::star::drawing::XDrawPage >&	xContainingPage,
                          GDIMetaFile& 							                                    		o_rMtf,
                          bool									                                    		bVerboseComments,
                          bool																				bForeignSource );

        /** Retrieve a meta file for the page background

        	@param xPage
            XDrawPage to retrieve a metafile for.

            @param xContainingPage
            The containing page of the content - if xPage is a
            masterpage, xContainingPage must be the draw page that
            uses the master page as its background.

            @param o_rMtf
            Metafile to extract shape content into

            @param bVerboseComments
            When true, annotate text actions with verbose comments,
            denoting logical and physical text entities.

            @param bForeignSource
            When true, the source of the metafile might be a foreign
            application. The metafile is checked against unsupported
            content, and, if necessary, returned as a pre-rendererd
            bitmap.
         */
        bool getBackgroundMetaFile( const ::com::sun::star::uno::Reference< ::com::sun::star::drawing::XDrawPage >& 	xPage, 
                                    const ::com::sun::star::uno::Reference< ::com::sun::star::drawing::XDrawPage >& 	xContainingPage, 
                                    GDIMetaFile& 							                                			o_rMtf,
                                    bool									                                			bVerboseComments,
                                    bool																				bForeignSource );

        /** Remove all text actions from the given metafile.
         */
        void removeTextActions( GDIMetaFile& io_rMtf );

        struct MtfAnimationFrame
        {
            MtfAnimationFrame( const GDIMetaFileSharedPtr& rMtf,
                               double					   nDuration ) :
                mpMtf( rMtf ),
                mnDuration( nDuration )
            {
            }

            /// Enables STL algos to be used for duration extraction
            double getDuration() const
            {
                return mnDuration;
            }

            GDIMetaFileSharedPtr	mpMtf;
            double					mnDuration;
        };
        
        typedef ::std::vector< MtfAnimationFrame > VectorOfMtfAnimationFrames;

        /** Extract a vector of animation frames from given Graphic.

        	@param o_rFrames
            Resulting vector of animated metafiles

            @param rGraphic
            Input graphic object, to extract animations from
         */
        bool getAnimationFromGraphic( VectorOfMtfAnimationFrames& o_rFrames,
                                      const Graphic&			  rGraphic );
    }
}

#endif
