/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: ipenv.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 19:05:00 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef _SFX_IPENV_HXX
#define _SFX_IPENV_HXX

#ifndef _IPENV_HXX //autogen
#include <so3/ipenv.hxx>
#endif
#include <sfx.hrc>
#include "childwin.hxx"
#include "workwin.hxx"

//=========================================================================

class SvInPlaceMenuBar;
class SfxToolBoxManager;
class SfxMenuBarManager;
class SfxAcceleratorManager;
class SfxConfigManager;
class SfxInPlaceObject;
class SfxInPlaceFrame;

//=========================================================================

class SfxInPlaceEnv_Impl: public SvInPlaceEnvironment

/*	[Beschreibung]

	Eine Instanz dieser (SFx-internen) Klasse wird auf der Seite des Servers
	vom <SfxInPlaceFrame> erzeugt, wenn ein Objekt (genauer ein
	<SfxInPlaceObject>) In-Place aktiviert wird. Dar"uber wird die Kommnikation
	bez"uglich der Tools (Menu etc.) abgewickelt.
*/

{
	SfxInPlaceFrame*		pFrame;
	SvInPlaceMenuBar*		pMenuBar;
	SfxWorkWindow*			pWorkWin;

protected:
	virtual MenuBar*	QueryMenu( USHORT * nCount1, USHORT * nCount2,
									USHORT * nCount3 );
	virtual void		ShowUITools( BOOL bShow );
	virtual void		TopWinResize();
	virtual BOOL		DispatchAccel( const KeyCode & );
	virtual void		RectsChangedPixel( const Rectangle & rObjRect,
										   const Rectangle & rClipRect );

public:
						SfxInPlaceEnv_Impl( SfxInPlaceObject *pObj,
											SfxInPlaceFrame *pIPFrame );
						~SfxInPlaceEnv_Impl();

	void				TopWinActivate( BOOL bActivate );
	void				DocWinActivate( BOOL bActivate );
	void				UIActivate( BOOL bActivate );
	SfxWorkWindow*		GetWorkWindow()
						{ return pWorkWin; }
	virtual void		QueryObjAreaPixel( Rectangle& rRect ) const;
	DECL_LINK(			DummyMenuHdl, Menu*);
	BOOL				IsInternalInPlace() const;
};

#endif

