/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: infodlgs.hxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 19:04:10 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _INFODLGS_HXX
#define _INFODLGS_HXX

// includes ******************************************************************


#ifndef _SV_BUTTON_HXX //autogen
#include <vcl/button.hxx>
#endif
#ifndef _SV_FIXED_HXX //autogen
#include <vcl/fixed.hxx>
#endif
#ifndef _SV_DIALOG_HXX //autogen
#include <vcl/dialog.hxx>
#endif
#ifndef _SV_EDIT_HXX //autogen
#include <vcl/edit.hxx>
#endif
#ifndef _SV_MSGBOX_HXX
#include <vcl/msgbox.hxx>
#endif

//****************************************************************************
// SfxShortFixedText_Impl
//****************************************************************************

/*
  [Beschreibung]
  Instanzen dieser Klasse pruefen, ob der ueber den Ctor spezifizierte Text in
  das Textfeld passt. Ist dies nicht der Fall, so wird selbiger gekuerzt und
  eine Hilfe wird angezeigt, wenn der Benutzer mit der Maus ueber dem Feld
  steht.
  */

class SfxShortFixedText_Impl : public FixedText
{

	String       _aQuickHelpText;

protected:

	virtual void RequestHelp( const HelpEvent& rEvt );

public:

				 SfxShortFixedText_Impl( Window* pParent, USHORT,
										 const String& rText );
				 SfxShortFixedText_Impl( Window* pParent,
										 const ResId& rResId );

	void         SetText( const String& rText );

};

//****************************************************************************
// SfxQueryDeleteDlg_Impl
//****************************************************************************

enum SfxQueryDeleteResult_Impl
{
	SFX_QUERYDELETE_YES = 0,
	SFX_QUERYDELETE_NO,
	SFX_QUERYDELETE_ALL,
	SFX_QUERYDELETE_CANCEL
};

class SfxQueryDeleteDlg_Impl : public ModalDialog
{
	FixedText                 _aEntryLabel;
	SfxShortFixedText_Impl    _aEntry;

	FixedText                 _aQueryMsg;

	PushButton                _aYesButton;
	PushButton                _aAllButton;
	PushButton                _aNoButton;
	CancelButton              _aCancelButton;

	SfxQueryDeleteResult_Impl _eResult;

private:

	DECL_STATIC_LINK( SfxQueryDeleteDlg_Impl, ClickLink, PushButton* );

public:

							  SfxQueryDeleteDlg_Impl( Window* pParent,
													  const String& rLabel,
													  const String& rName,
													  const String& rMsg,
													  BOOL bWithAll = FALSE );

	SfxQueryDeleteResult_Impl GetResult() const
							  {
								  return _eResult;
							  }
};

//****************************************************************************
// SfxQueryOverwriteDlg_Impl
//****************************************************************************

#ifndef RET_ALL
#define RET_ALL (RET_RETRY)
#endif

#endif

