/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: msgdescr.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 18:05:49 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#pragma hdrstop

#include "msgdescr.hxx"
#include "sfxtypes.hxx"
#include "sfx.hrc"

//==================================================================

SfxMessageDescription::SfxMessageDescription( USHORT nId,
		const Bitmap &rLargeBmp, const Bitmap &rSmallBmp ):
	Resource( ResId( nId ) ),
	aLargeBmp(rLargeBmp),
	aSmallBmp(rSmallBmp)
{
	if ( IsAvailableRes( ResId(SFX_MSG_NAME).SetRT(RSC_STRING) ) )
		aFunctionName = String( ResId(SFX_MSG_NAME) );
	else
		aFunctionName = String( "unknown message #" ) + String(nId);

	if ( IsAvailableRes( ResId(SFX_MSG_HELPTEXT).SetRT(RSC_STRING) ) )
		aHelpText = String( ResId(SFX_MSG_HELPTEXT) );

	if ( IsAvailableRes( ResId(SFX_MSG_BASICNAME).SetRT(RSC_STRING) ) )
		aBasicName = String( ResId(SFX_MSG_BASICNAME) );

	FreeResource();
}

//--------------------------------------------------------------------

SfxMessageDescription::SfxMessageDescription( USHORT nId ):
	Resource( ResId( nId ) )
{
	if ( IsAvailableRes( ResId(SFX_MSG_NAME).SetRT(RSC_STRING) ) )
		aFunctionName = String( ResId(SFX_MSG_NAME) );
	else
		aFunctionName = String( "unknown message #" ) + String(nId);

	if ( IsAvailableRes( ResId(SFX_MSG_HELPTEXT).SetRT(RSC_STRING) ) )
		aHelpText = String( ResId(SFX_MSG_HELPTEXT) );

	if ( IsAvailableRes( ResId(SFX_MSG_BASICNAME).SetRT(RSC_STRING) ) )
		aBasicName = String( ResId(SFX_MSG_BASICNAME) );

	FreeResource();
}


