/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: fltdlg.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 17:51:42 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// INCLUDE ---------------------------------------------------------------

#ifndef _LIST_HXX //autogen
#include <tools/list.hxx>
#endif
#ifndef _URLOBJ_HXX //autogen
#include <tools/urlobj.hxx>
#endif
#ifndef _SV_MSGBOX_HXX //autogen
#include <vcl/msgbox.hxx>
#endif
#ifndef _SV_BUTTON_HXX //autogen
#include <vcl/button.hxx>
#endif
#ifndef _SFXPOOLITEM_HXX //autogen
#include <svtools/poolitem.hxx>
#endif
#ifndef GCC
#pragma hdrstop
#endif

#include "fltfnc.hxx"
#include "nfltdlg.hxx"
#include "docfilt.hxx"
#include "sfxresid.hxx"
#include "app.hxx"
#include "docfile.hxx"

#include "bastyp.hrc"
#include "fltdlg.hrc"

// -----------------------------------------------------------------------

SfxFilterDialog::SfxFilterDialog
(
	Window* pParent,
	SfxMedium* pMed,
	const SfxFilterMatcher& rMatcherP,
	const String* pDefFilter,
	BOOL bShowConvert
) :

	ModalDialog( pParent, SfxResId( DLG_FILTER_SELECT ) ),

	aMimeTypeFL	( this, ResId( FL_MIMETYPE ) ),
	aMIMEType	( this, ResId( FT_DLG_MIMETYPE ) ),
	aExtension	( this, ResId( FT_DLG_EXTENSTION ) ),
	aFilterFL	( this, ResId( FL_FILTER ) ),
	aListbox	( this, ResId( LB_DLG_LISTBOX ) ),
	aOkBtn		( this, ResId( LB_DLG_OKBTN ) ),
	aCancelBtn	( this, ResId( LB_DLG_CANCELBTN ) ),
	aHelpBtn	( this, ResId( BTN_HELP ) ),
    rMatcher    ( rMatcherP )
{
	GetClassRes(); // -Wall  - needed???
	IncrementRes(sizeof(short));
	FreeResource();

	String aMimeText( aMIMEType.GetText() );
	String aMime;
	pMed->GetMIMEAndRedirect( aMime );
	aMimeText += aMime;
	aMIMEType.SetText( aMimeText );
	rtl::OUString aExtensionText( aExtension.GetText() );
	aExtensionText += pMed->GetURLObject().GetExtension();
	aExtension.SetText( aExtensionText );

	aListbox.SetDoubleClickHdl(LINK(this, SfxFilterDialog, OkHdl));
	SfxFilterMatcherIter aIter(
		&rMatcher, SFX_FILTER_IMPORT,
		SFX_FILTER_INTERNAL|SFX_FILTER_NOTINCHOOSER );
	for( const SfxFilter* pFilter = aIter.First(); pFilter;
		 pFilter = aIter.Next() )
		aListbox.InsertEntry( pFilter->GetUIName() );
	if ( pDefFilter )
		aListbox.SelectEntry(*pDefFilter);
	else
		aListbox.SelectEntryPos( aListbox.GetEntryCount()-1 );
}

//-------------------------------------------------------------------------

String SfxFilterDialog::GetSelectEntry()  const
{
	return aListbox.GetSelectEntry();
}

//-------------------------------------------------------------------------

IMPL_LINK_INLINE_START( SfxFilterDialog, OkHdl, Control *, pControl )
{
	EndDialog(RET_OK);
	return 0;
}
IMPL_LINK_INLINE_END( SfxFilterDialog, OkHdl, Control *, pControl )

