/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sfxhelp2.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 17:47:39 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#include <sfxhelp.hxx>
#include <sfxhelp2.hxx>
#include <sfxsids.hrc>

#ifndef _SV_TOOLBOX_HXX //autogen
#include <vcl/toolbox.hxx>
#endif
#ifndef _SV_WRKWIN_HXX //autogen
#include <vcl/wrkwin.hxx>
#endif

#include <dispatch.hxx>


SFX_IMPL_TOOLBOX_CONTROL( HelpFileBoxControl, SfxStringItem );

HelpFileBoxControl::HelpFileBoxControl( USHORT nId, ToolBox& rTbx, SfxBindings& rBind )
	: SfxToolBoxControl( nId, rTbx, rBind )
{
}

HelpFileBoxControl::~HelpFileBoxControl()
{
}

void HelpFileBoxControl::StateChanged( USHORT nSID, SfxItemState eState, const SfxPoolItem* pState )
{
	HelpFileBox* pBox = (HelpFileBox*) GetToolBox().GetItemWindow( GetId() );

	DBG_ASSERT( pBox, "Box not found" );
	if ( !pBox )
		return;

	if ( eState != SFX_ITEM_AVAILABLE )
		pBox->Disable();
	else
	{
		pBox->Enable();

		if ( pState->ISA(SfxStringItem) )
			pBox->Update( (const SfxStringItem*)pState );
		else
			pBox->Update( NULL );
	}
}

Window* HelpFileBoxControl::CreateItemWindow( Window *pParent )
{
	return new HelpFileBox( pParent );
}



HelpFileBox::HelpFileBox( Window* pParent ) :

	ListBox( pParent, WinBits( WB_BORDER | WB_DROPDOWN | WB_SORT ) )

{
	FillBox();
	bIgnoreSelect = TRUE;	// Select von 0 noch nicht weiterleiten
	SelectEntryPos( 0 );
	aCurText = GetEntry( 0 );
	SetSizePixel( Size( 165, 200 ) );
	bIgnoreSelect = FALSE;
}


HelpFileBox::~HelpFileBox()
{
}

void HelpFileBox::Update( const SfxStringItem* pItem )
{
	if ( !pItem  || !pItem->GetValue().Len() )
		FillBox();

	if ( pItem )
		aCurText = pItem->GetValue();

	if ( GetSelectEntry() != aCurText )
		SelectEntry( aCurText );
}

void HelpFileBox::ReleaseFocus()
{
	SfxViewShell* pCurSh = SfxViewShell::Current();
	DBG_ASSERT( pCurSh, "Current ViewShell not found!" );

	if ( pCurSh )
	{
		Window* pShellWin = pCurSh->GetWindow();
        if ( pShellWin )       // sonst werde ich ihn nicht los
            pShellWin->GrabFocus();
	}
}

void HelpFileBox::FillBox( BOOL bSelect )
{
	SetUpdateMode( FALSE );
	bIgnoreSelect = TRUE;

	aCurText = GetSelectEntry();
	USHORT nCurPos = GetSelectEntryPos();

	SelectEntryPos( 0 );
	Clear();

	USHORT nFiles = SfxHelp::GetHelpFileInfoCount();
	for ( USHORT n = 0; n < nFiles; n++ )
	{
		HelpFileInfo* pInf = SfxHelp::GetHelpFileInfo( n );
		String aFileName( pInf->aFileName );
		aFileName.ToLowerAscii();
		if ( aFileName.SearchAscii( "tips.svh" ) == STRING_NOTFOUND )
			InsertEntry( pInf->aTitle, LISTBOX_APPEND );
	}

	SetUpdateMode( TRUE );

	if ( bSelect )
	{
		SelectEntry( aCurText );
		if ( !GetSelectEntryCount() )
		{
			SelectEntryPos( GetEntryCount() );	// gibst es nicht => leer?
			aCurText = GetSelectEntry();
		}
	}
	bIgnoreSelect = FALSE;
}

long HelpFileBox::PreNotify( NotifyEvent& rNEvt )
{
	long nDone = 0;
	if( rNEvt.GetType() == EVENT_KEYINPUT )
	{
		KeyEvent aKeyEvt = *rNEvt.GetKeyEvent();
		USHORT nKeyCode = aKeyEvt.GetKeyCode().GetCode();
		switch( nKeyCode )
		{
			case KEY_RETURN:
			{
				NotifyHelpShell();
				nDone = 1;
			}
			break;

			case KEY_ESCAPE:
			{
				SelectEntry( aCurText );
				ReleaseFocus();
				nDone = 1;
			}
			break;
		}
	}

	return nDone ? nDone : ListBox::PreNotify( rNEvt );
}

void HelpFileBox::Select()
{
	if ( !IsTravelSelect() )
	{
		if ( !bIgnoreSelect )
			NotifyHelpShell();
		else
			SelectEntry( aCurText );
	}
}

void HelpFileBox::NotifyHelpShell()
{
	SfxStringItem aTitle( SID_HELP_HELPFILEBOX_SELECTED, GetSelectEntry() );
    SFX_APP()->GetDispatcher_Impl()->Execute( SID_HELP_HELPFILEBOX, SFX_CALLMODE_ASYNCHRON, &aTitle, 0L );
	ReleaseFocus();
}


