/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: tbxchild.hxx,v $
 *
 *  $Revision: 1.13 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 17:21:42 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _TIMER_HXX //autogen
#include <vcl/timer.hxx>
#endif
#ifndef _TOOLBOX_HXX //autogen
#include <vcl/toolbox.hxx>
#endif

#ifndef SVTOOLS_ASYNCLINK_HXX
#include <svtools/asynclink.hxx>
#endif

#define _SVSTDARR_USHORTS
#include <svtools/svstdarr.hxx>		// SvUShorts

#include "chalign.hxx"
#include "sfxtypes.hxx"
//#include "generictoolbarcontroller.hxx"

#ifndef _COM_SUN_STAR_CONTAINER_XINDEXACCESS_HPP_
#include <com/sun/star/container/XIndexAccess.hpp>
#endif

#ifndef _COM_SUN_STAR_FRAME_XFRAME_HPP_
#include <com/sun/star/frame/XFrame.hpp>
#endif
#ifndef _COM_SUN_STAR_FRAME_XSTATUSLISTENER_HPP_
#include <com/sun/star/frame/XStatusListener.hpp>
#endif

class SfxToolBoxControl;
class SfxToolBox_Impl;

struct SfxChildWinInfo;

class SfxToolbox: public ToolBox
{
	SvUShorts			aItems;
	BOOL                bConstructed;
	BOOL                bEmpty;
	BOOL				bHelpInitialized;
	BOOL				bWaitSuppressed;
	Timer				aTimer;
	Timer				aAsyncStoreCfgTimer;
	SfxChildAlignment   eAlignment;
	WindowAlign			eAlign;
	Point               aFloatPos;
	USHORT              nLines;
	USHORT              nFloatLines;
	BOOL				bCopyCtor;
	BOOL				bActivated;
	BOOL				bDeleteToolBox;
	BOOL				bReconfigure;
	BOOL				bMod1;
	BOOL				bMod2;
	BOOL				bShift;
	USHORT 				nPos;
    svtools::AsynchronLink	aLink;
	SfxToolBox_Impl*	pImp;
	Link				aChangedListener;
	int					nActivated;
    com::sun::star::uno::Reference< com::sun::star::frame::XFrame > m_xFrame;
    std::vector< ::com::sun::star::uno::Reference< ::com::sun::star::frame::XStatusListener > > m_aController;

protected:
    virtual void    Move();
	virtual void	MouseButtonDown( const MouseEvent& rMEvt );
	virtual void	MouseMove( const MouseEvent& rMEvt );
	virtual void	MouseButtonUp( const MouseEvent& rMEvt );
	virtual void	DoubleClick();
	virtual void	Click();
	virtual void    Deactivate();
	virtual void	Highlight();
	virtual void	Command ( const CommandEvent& rCEvt );
	virtual void    StartDocking();
	virtual BOOL    Docking(const Point&, Rectangle&);
	virtual void    EndDocking(const Rectangle& rRect, BOOL bFloatMode);
	virtual BOOL    PrepareToggleFloatingMode();
	virtual void    ToggleFloatingMode();
	virtual void    RequestHelp( const HelpEvent& rHEvt );
	virtual void    Customize( const ToolBoxCustomizeEvent& rCEvt );
	virtual void    Resize();
	virtual BOOL    Close();
	virtual long	Notify( NotifyEvent& rNEvt );
	virtual void 	NextToolBox();
    virtual void	StateChanged( StateChangedType nType );
	virtual void	DataChanged( const DataChangedEvent& rDCEvt );
	DECL_LINK( 		Delete, void * );

	void			Construct();
	void			CheckAndUpdateImages();
	DECL_LINK( 		TimeHdl, Timer * );
	DECL_LINK( 		AsyncStoreCfgHdl, Timer * );
	ULONG			nEventId;


public:
                    SfxToolbox( const com::sun::star::uno::Reference< com::sun::star::frame::XFrame >& rFrame, Window *pParent, WinBits nBits );
					~SfxToolbox();

	void 			SetConstructed(BOOL bCon) {bConstructed = bCon; }
	void 			SetEmpty(BOOL bOn) {bEmpty = bOn; }
	BOOL 			IsEmpty() {return bEmpty; }
	BOOL 			IsConstructed() {return bConstructed; }
	USHORT 			GetItemAt( const CommandEvent &rMEvt);
	virtual void    FillInfo(SfxChildWinInfo&) const;
	SfxChildAlignment	GetAlignment() const	{ return eAlignment; }
	void			SetToolBoxAlignment_Impl( SfxChildAlignment );
	void			SetChildAlignment_Impl( WindowAlign eAlign );
	USHORT 			GetPosition_Impl() const	{ return nPos; }
	void			ClearItemText_Impl();
	void			SetItemText_Impl( USHORT, BOOL );
	BOOL			HasItemText_Impl( USHORT );
	void			SetChangedListener( const Link& aLink ) { aChangedListener = aLink; }
	const Link&		GetChangedListener() const { return aChangedListener; }
	BOOL			IsHiContrastMode();
    void            SetFloatingPosition( const Point& rPos );
    Point           GetFloatingPosition() const;

    void            FillToolBox( const ::com::sun::star::uno::Reference< com::sun::star::container::XIndexAccess >& rToolBarDefinition );
};
