/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: propset.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 17:12:27 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef _SFX_PROPSET_HXX
#define _SFX_PROPSET_HXX

#ifndef _COM_SUN_STAR_BEANS_PROPERTYVALUES_HPP_
#include <com/sun/star/beans/PropertyValues.hpp>
#endif
#ifndef _COM_SUN_STAR_BEANS_XPROPERTYSET_HPP_
#include <com/sun/star/beans/XPropertySet.hpp>
#endif
#ifndef _COM_SUN_STAR_BEANS_PROPERTYVALUE_HPP_
#include <com/sun/star/beans/PropertyValue.hpp>
#endif
#ifndef _COM_SUN_STAR_BEANS_PROPERTYSTATE_HPP_
#include <com/sun/star/beans/PropertyState.hpp>
#endif
#ifndef _COM_SUN_STAR_BEANS_XPROPERTYSETINFO_HPP_
#include <com/sun/star/beans/XPropertySetInfo.hpp>
#endif
#ifndef _COM_SUN_STAR_BEANS_XMULTIPROPERTYSET_HPP_
#include <com/sun/star/beans/XMultiPropertySet.hpp>
#endif
#ifndef _COM_SUN_STAR_BEANS_XFASTPROPERTYSET_HPP_
#include <com/sun/star/beans/XFastPropertySet.hpp>
#endif
#ifndef _COM_SUN_STAR_BEANS_XVETOABLECHANGELISTENER_HPP_
#include <com/sun/star/beans/XVetoableChangeListener.hpp>
#endif
#ifndef _COM_SUN_STAR_BEANS_XPROPERTYSTATE_HPP_
#include <com/sun/star/beans/XPropertyState.hpp>
#endif
#ifndef _COM_SUN_STAR_BEANS_XPROPERTYSTATECHANGELISTENER_HPP_
#include <com/sun/star/beans/XPropertyStateChangeListener.hpp>
#endif
#ifndef _COM_SUN_STAR_BEANS_PROPERTYATTRIBUTE_HPP_
#include <com/sun/star/beans/PropertyAttribute.hpp>
#endif
#ifndef _COM_SUN_STAR_BEANS_XPROPERTIESCHANGELISTENER_HPP_
#include <com/sun/star/beans/XPropertiesChangeListener.hpp>
#endif
#ifndef _COM_SUN_STAR_BEANS_XPROPERTYCHANGELISTENER_HPP_
#include <com/sun/star/beans/XPropertyChangeListener.hpp>
#endif
#ifndef _COM_SUN_STAR_BEANS_XPROPERTYACCESS_HPP_
#include <com/sun/star/beans/XPropertyAccess.hpp>
#endif
#ifndef _COM_SUN_STAR_BEANS_XPROPERTYCONTAINER_HPP_
#include <com/sun/star/beans/XPropertyContainer.hpp>
#endif
#ifndef _COM_SUN_STAR_BEANS_PROPERTYSTATECHANGEEVENT_HPP_
#include <com/sun/star/beans/PropertyStateChangeEvent.hpp>
#endif
#ifndef _COM_SUN_STAR_BEANS_PROPERTYCHANGEEVENT_HPP_
#include <com/sun/star/beans/PropertyChangeEvent.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_XTYPEPROVIDER_HPP_
#include <com/sun/star/lang/XTypeProvider.hpp>
#endif
#ifndef _CPPUHELPER_WEAK_HXX_
#include <cppuhelper/weak.hxx>
#endif
#include "sfxuno.hxx"

//=========================================================================

#define SFX_PROPERTYSETINFO_BEGIN(Name,Count) \
	const SfxPropertySetInfo* Name() \
	{ \
		static SfxPropertyDescriptor aProps_Impl[Count] = {

#define SFX_PROPERTYSETINFO_END() \
			}; \
		static SfxPropertySetInfo *pPropInfo_Impl; \
		\
		if ( !pPropInfo_Impl ) \
		{ \
			pPropInfo_Impl = new SfxPropertySetInfo( aProps_Impl, \
					sizeof(aProps_Impl)/sizeof(SfxPropertyDescriptor) ); \
			pPropInfo_Impl->acquire(); \
		} \
		return pPropInfo_Impl; \
	}

//=========================================================================

struct SfxPropertyDescriptor
{
	const ::rtl::OUString					aName;
	sal_Int32							nHandle;
//ASDBG	Usr_GetReflectionFunctionType	pReflection;
	::com::sun::star::uno::Type			aType;
	sal_Int16							nAttributes;

	SfxPropertyDescriptor(const sal_Char* pName, sal_Int32 n, ::com::sun::star::uno::Type t, sal_Int16 nAtt)
		: aName(::rtl::OUString::createFromAscii(pName)), nHandle(n), aType(t), nAttributes(nAtt)
	{}
};

//=========================================================================

class SfxPropertySetInfo	:	public ::cppu::OWeakObject							,
								public ::com::sun::star::beans::XPropertySetInfo	,
								public ::com::sun::star::lang::XTypeProvider
{
	const SfxPropertyDescriptor*	_pPropDescriptors;
	sal_uInt16							_nPropCount;
	::com::sun::star::uno::Sequence< ::com::sun::star::beans::Property >				_aProps;

public:
							SfxPropertySetInfo(
								const SfxPropertyDescriptor* pDescriptors,
								sal_uInt16 nCount );
//ASDBG	friend Reflection *		::getCppuType((const SfxPropertySetInfo*)0);

	sal_Int32					GetHandle( const ::rtl::OUString &rPropName ) const;

	// XInterface, XTypeProvider
	SFX_DECL_XINTERFACE_XTYPEPROVIDER

	// XPropertySetInfo
	virtual ::com::sun::star::uno::Sequence< ::com::sun::star::beans::Property > SAL_CALL getProperties(void) throw ( ::com::sun::star::uno::RuntimeException );
	virtual ::com::sun::star::beans::Property SAL_CALL getPropertyByName(const ::rtl::OUString& aPropertyName) throw ( ::com::sun::star::uno::RuntimeException );
	virtual sal_Bool SAL_CALL hasPropertyByName(const ::rtl::OUString& aPropertyName) throw ( ::com::sun::star::uno::RuntimeException );
};

//=========================================================================

class SfxPropertySet: public ::com::sun::star::beans::XPropertySet, public ::com::sun::star::beans::XFastPropertySet
{
	const SfxPropertySetInfo*	_pInfo;

public:
							SfxPropertySet( const SfxPropertySetInfo *pInfo )
							:	_pInfo(pInfo)
							{}

	// XPropertySet
	virtual ::com::sun::star::uno::Reference< ::com::sun::star::beans::XPropertySetInfo > SAL_CALL getPropertySetInfo(void) throw ( ::com::sun::star::uno::RuntimeException );
	virtual void SAL_CALL setPropertyValue(const ::rtl::OUString& aPropertyName, const ::com::sun::star::uno::Any& aValue) throw ( ::com::sun::star::uno::RuntimeException );
	virtual ::com::sun::star::uno::Any SAL_CALL getPropertyValue(const ::rtl::OUString& aPropertyName) throw ( ::com::sun::star::uno::RuntimeException );
	virtual void SAL_CALL addPropertyChangeListener(const ::rtl::OUString& aPropertyName, const ::com::sun::star::uno::Reference< ::com::sun::star::beans::XPropertyChangeListener > & aListener) throw ( ::com::sun::star::uno::RuntimeException );
	virtual void SAL_CALL removePropertyChangeListener(const ::rtl::OUString& aPropertyName, const ::com::sun::star::uno::Reference< ::com::sun::star::beans::XPropertyChangeListener > & aListener) throw ( ::com::sun::star::uno::RuntimeException );
	virtual void SAL_CALL addVetoableChangeListener(const ::rtl::OUString& aPropertyName, const ::com::sun::star::uno::Reference< ::com::sun::star::beans::XVetoableChangeListener > & aListener) throw ( ::com::sun::star::uno::RuntimeException );
	virtual void SAL_CALL removeVetoableChangeListener(const ::rtl::OUString& aPropertyName, const ::com::sun::star::uno::Reference< ::com::sun::star::beans::XVetoableChangeListener > & aListener) throw ( ::com::sun::star::uno::RuntimeException );

	// XFastPropertySet
	virtual void SAL_CALL setFastPropertyValue(sal_Int32 nHandle, const ::com::sun::star::uno::Any& aValue) throw ( ::com::sun::star::uno::RuntimeException ) = 0;
	virtual ::com::sun::star::uno::Any SAL_CALL getFastPropertyValue(sal_Int32 nHandle) throw ( ::com::sun::star::uno::RuntimeException ) = 0;
};


#endif
