/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: MasterPagesSelectorListener.cxx,v $
 *
 *  $Revision: 1.7 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 06:41:38 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#include "MasterPagesSelectorListener.hxx"

#include "ViewShellBase.hxx"
#include "MasterPagesSelector.hxx"
#include "drawdoc.hxx"

#ifndef _COM_SUN_STAR_LANG_XCOMPONENT_HPP_
#include <com/sun/star/lang/XComponent.hpp>
#endif
#ifndef _COM_SUN_STAR_BEANS_PROPERTYCHANGEEVENT_HPP_
#include <com/sun/star/beans/PropertyChangeEvent.hpp>
#endif

#include <sfx2/viewfrm.hxx>

using namespace ::com::sun::star::uno;
using namespace ::com::sun::star;

namespace sd { namespace toolpanel { namespace controls {


MasterPagesSelectorListener::MasterPagesSelectorListener (
    ViewShellBase& rBase,
    MasterPagesSelector& rSelector)
    : ListenerInterfaceBase(maMutex),
      mrBase (rBase),
      mrSelector (rSelector),
      mbListeningToController (false),
      mbListeningToFrame (false),
      mxControllerPropertySetWeak(NULL),
      mxFrameWeak(NULL)
{
    // Connect to the frame to listen for controllers being exchanged.
    // Listen to changes of certain properties.
    Reference<frame::XFrame> xFrame (
        mrBase.GetFrame()->GetTopFrame()->GetFrameInterface(),
        uno::UNO_QUERY);
    mxFrameWeak = xFrame;
    if (xFrame.is())
    {
        xFrame->addFrameActionListener (
            Reference<frame::XFrameActionListener>(
               static_cast<XWeak*>(this), UNO_QUERY));
        mbListeningToFrame = true;
    }

    // Connect to the current controller.
    ConnectToController ();

    StartListening (*mrBase.GetDocument());
}




MasterPagesSelectorListener::~MasterPagesSelectorListener (void)
{
    ReleaseListeners();
}




void MasterPagesSelectorListener::ReleaseListeners (void)
{
    if (mbListeningToFrame)
    {
        // Listen to changes of certain properties.
        Reference<frame::XFrame> xFrame (mxFrameWeak);
        if (xFrame.is())
        {
            xFrame->removeFrameActionListener (
                Reference<frame::XFrameActionListener>(
                    static_cast<XWeak*>(this), UNO_QUERY));
            mbListeningToFrame = false;
        }
    }

    DisconnectFromController ();

    EndListening (*mrBase.GetDocument());
}




void MasterPagesSelectorListener::ConnectToController (void)
{
    // Register at the controller of the main view shell.

    mxControllerPropertySetWeak = Reference<beans::XPropertySet> (
        mrBase.GetController(),
        UNO_QUERY);

    // Listen to changes of certain properties. 
    Reference<beans::XPropertySet> xSet (mxControllerPropertySetWeak);
    try
    {
        if (xSet.is())
        {
            xSet->addPropertyChangeListener (
                String::CreateFromAscii("CurrentPage"), 
                this);
            xSet->addPropertyChangeListener (
                String::CreateFromAscii("IsMasterPageMode"), 
                this);
            mbListeningToController = true;
        }
    }
    catch (beans::UnknownPropertyException aEvent)
    {
        OSL_TRACE ("caught exception in SlideSorterController::SetupListeners: %s",
            ::rtl::OUStringToOString(aEvent.Message,
                RTL_TEXTENCODING_UTF8).getStr());
    }
    
    // Listen for disposing events.
    Reference<lang::XComponent> xComponent (xSet, UNO_QUERY);
    if (xComponent.is())
        xComponent->addEventListener (
            Reference<lang::XEventListener>(
                static_cast<XWeak*>(this), UNO_QUERY));
}




void MasterPagesSelectorListener::DisconnectFromController (void)
{
    if (mbListeningToController)
    {
        Reference<beans::XPropertySet> xSet (mxControllerPropertySetWeak);
        try
        {
            // Remove the property listener.
            if (xSet.is())
            {
                xSet->removePropertyChangeListener (
                    String::CreateFromAscii("CurrentPage"), 
                    this);
                xSet->removePropertyChangeListener (
                    String::CreateFromAscii("IsMasterPageMode"), 
                    this);
            }

            // Remove the dispose listener.
            Reference<XComponent> xComponent (xSet, UNO_QUERY);
            if (xComponent.is())
                xComponent->removeEventListener (
                    Reference<lang::XEventListener>(
                        static_cast<XWeak*>(this), UNO_QUERY));
        }
        catch (beans::UnknownPropertyException aEvent)
        {
            OSL_TRACE ("caught exception in destructor of SlideSorterController: %s",
                ::rtl::OUStringToOString(aEvent.Message,
                    RTL_TEXTENCODING_UTF8).getStr());
        }

        mbListeningToController = false;
    }
}




//=====  lang::XEventListener  ================================================

void SAL_CALL MasterPagesSelectorListener::disposing (
    const lang::EventObject& rEventObject)
    throw (RuntimeException)
{
    if (mbListeningToController)
    {
        Reference<view::XSelectionSupplier> xSelectionSupplier (
            mrBase.GetController(),
            uno::UNO_QUERY);
        if (rEventObject.Source == xSelectionSupplier)
        {
            mbListeningToController = false;
        }
    }
}




//=====  beans::XPropertySetListener  =========================================

void SAL_CALL MasterPagesSelectorListener::propertyChange (
    const beans::PropertyChangeEvent& rEvent)
    throw (RuntimeException)
{
    ThrowIfDisposed();

    static const ::rtl::OUString sCurrentPagePropertyName (
		RTL_CONSTASCII_USTRINGPARAM("CurrentPage"));
    static const ::rtl::OUString sEditModePropertyName (
		RTL_CONSTASCII_USTRINGPARAM("IsMasterPageMode"));

    if (rEvent.PropertyName.equals (sCurrentPagePropertyName)
        || (rEvent.PropertyName.equals (sEditModePropertyName)))
    {
        mrSelector.UpdateSelection();
    }
}




//===== frame::XFrameActionListener  ==========================================

void SAL_CALL MasterPagesSelectorListener::frameAction (
    const frame::FrameActionEvent& rEvent)
    throw (::com::sun::star::uno::RuntimeException)
{
    switch (rEvent.Action)
    {
        case frame::FrameAction_COMPONENT_DETACHING:
            DisconnectFromController();
            break;

        case frame::FrameAction_COMPONENT_REATTACHED:
            ConnectToController();
            break;

        default:
            break;
    }
}




void SAL_CALL MasterPagesSelectorListener::disposing (void)
{
    ReleaseListeners();
}




void MasterPagesSelectorListener::ThrowIfDisposed (void)
    throw (::com::sun::star::lang::DisposedException)
{
	if (rBHelper.bDisposed || rBHelper.bInDispose)
	{
        throw lang::DisposedException (
            ::rtl::OUString(RTL_CONSTASCII_USTRINGPARAM(
                "SlideSorterController object has already been disposed")),
            static_cast<uno::XWeak*>(this));
    }
}




void MasterPagesSelectorListener::Notify (
    SfxBroadcaster& rBroadcaster,
    const SfxHint& rHint)
{
    if (rHint.ISA(SdrHint))
    {
        SdrHint& rSdrHint (*PTR_CAST(SdrHint,&rHint));
        switch (rSdrHint.GetKind())
        {
            case HINT_PAGEORDERCHG:
				// This is tricky.  If a master page is removed, moved, or
				// added we have to wait until both the notes master page
				// and the standard master page have been removed, moved,
				// or added.  We do this by looking at the number of master
				// pages which has to be odd in the consistent state (the
				// handout master page is always present).  If the number is
				// even we ignore the hint.
                if (mrBase.GetDocument()->GetMasterPageCount()%2 == 1)
                    mrSelector.Fill ();
                break;

            case HINT_MODELCLEARED:
                mrSelector.Fill ();
                break;

            case HINT_SWITCHTOPAGE:
                mrSelector.UpdateSelection();
                break;

            case HINT_OBJCHG:
            case HINT_OBJINSERTED:
            case HINT_OBJREMOVED:
                mrSelector.InvalidatePreview(static_cast<const SdPage*>(rSdrHint.GetPage()));
                break;
        }
    }
}




} } } // end of namespace ::sd::slidesorter::controller
