/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: fuinsdes.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 00:23:44 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _CTRLTOOL_HXX //autogen
#include <svtools/ctrltool.hxx>
#endif
#ifndef _SV_MSGBOX_HXX //autogen
#include <vcl/msgbox.hxx>
#endif
#ifndef _SFXDISPATCH_HXX //autogen
#include <sfx2/dispatch.hxx>
#endif
#ifndef _SFXVIEWFRM_HXX //autogen
#include <sfx2/viewfrm.hxx>
#endif
#include <svx/flstitem.hxx>
#ifndef _SFXREQUEST_HXX //autogen
#include <sfx2/request.hxx>
#endif
#ifndef _SFX_OBJSH_HXX //autogen
#include <sfx2/objsh.hxx>
#endif

#pragma hdrstop


#include "schattr.hxx"
#define ITEMID_CHARTDATADESCR	SCHATTR_DATADESCR_DESCR
#include <svx/chrtitem.hxx>

#include "app.hrc"
#include "schresid.hxx"
#include "strings.hrc"
#include "viewshel.hxx"
#include "datdescr.hxx"
#include "uninsdes.hxx"
#include "fuinsdes.hxx"
#ifndef _CHTMODEL_HXX
#include "chtmodel.hxx"
#endif

TYPEINIT1(SchFuInsertDataDescr, SchFuPoor);


/*************************************************************************
|*
|* Konstruktor
|*
\************************************************************************/

SchFuInsertDataDescr::SchFuInsertDataDescr(SchViewShell* pViewSh,
										   SchWindow* pWin, SchView* pView,
										   ChartModel* pDoc,
										   SfxRequest& rReq) :
	SchFuPoor(pViewSh, pWin, pView, pDoc, rReq)
{
	nMarkedID           = 0;

	SvxChartDataDescr eOldDescr = pDoc->DataDescr();
	BOOL bOldSym = pDoc->ShowSym();

	const SfxItemSet* pArgs = rReq.GetArgs();

	if (!pArgs)
	{
		SfxItemSet aNewAttr(pViewSh->GetPool(), SCHATTR_DATADESCR_START,
												SCHATTR_DATADESCR_END);
		aNewAttr.Put(SvxChartDataDescrItem(eOldDescr));
		aNewAttr.Put(SfxBoolItem(SCHATTR_DATADESCR_SHOW_SYM, bOldSym));

//      FG: Mit dieser Zeile erhaelt man keinen modalen Dialog => Absturz falls ein Resize im Chart
//      stattfindet waehrend dieser Dialog geoeffnet ist.
//		SchDataDescrDlg* pDlg =	new SchDataDescrDlg(&pViewSh->GetViewFrame()->GetWindow(),
//				  			                    	aNewAttr);
		SchDataDescrDlg* pDlg =	new SchDataDescrDlg(NULL, aNewAttr);

		if(pDlg->Execute() == RET_OK)
		{
			pDlg->GetAttr(aNewAttr);
			rReq.Done(aNewAttr);
			pArgs = rReq.GetArgs();
			delete pDlg;
		}
		else
		{
			delete pDlg;
			return;
		}

		pChDoc->CanRebuild (TRUE);
	}
	else pChDoc->CanRebuild (FALSE);

	pViewSh->GetViewFrame()->GetDispatcher()->Execute(SID_TOOL_SELECT, SFX_CALLMODE_SYNCHRON);

	SvxChartDataDescr eNewDescr = ((const SvxChartDataDescrItem&)pArgs->Get(SCHATTR_DATADESCR_DESCR)).GetValue();
	BOOL bNewSym = ((const SfxBoolItem&)pArgs->Get(SCHATTR_DATADESCR_SHOW_SYM)).GetValue();

	pDoc->ChangeDataDescr(eNewDescr, bNewSym);
	SchUndoInsertDataDescr* pUndo =	new SchUndoInsertDataDescr(*pDoc, eOldDescr, bOldSym,
															   eNewDescr, bNewSym);
	pUndo->SetComment(String(SchResId(STR_UNDO_INSERT_DESCR)));
	pViewSh->GetViewFrame()->GetObjectShell()->GetUndoManager()->AddUndoAction(pUndo);
	RemarkObject ();
}

/*************************************************************************
|*
|*
|*
\************************************************************************/

void SchFuInsertDataDescr::Activate()
{
}

/*************************************************************************
|*
|*
|*
\************************************************************************/

void SchFuInsertDataDescr::Deactivate()
{
}



