
package org.netbeans.modules.openoffice.wizard.panels.idl;

import java.awt.*;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.*;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
//import org.netbeans.modules.openoffice.wizard.nodes.utils.IdlUtilities;



public class ValueFactoryPanel extends BasePanel
    implements DocumentListener
{

    public ValueFactoryPanel()
    {
        initComponents();
        name.getDocument().addDocumentListener(this);
        params.getDocument().addDocumentListener(this);
    }

    public String getName()
    {
        return name.getText().trim();
    }

    public void setName(String s)
    {
        name.setText(s);
    }

    public String getParams()
    {
        return params.getText().trim();
    }

    public void setParams(String s)
    {
        params.setText(s);
    }

    private void initComponents()
    {
        jLabel1 = new JLabel();
        name = new JTextField();
        jLabel2 = new JLabel();
        params = new JTextField();
        setLayout(new GridBagLayout());
        setPreferredSize(new Dimension(250, 60));
        jLabel1.setText(bundle.getString("TXT_ValueFactoryName"));
        jLabel1.setLabelFor(name);
        GridBagConstraints gridbagconstraints = new GridBagConstraints();
        gridbagconstraints.insets = new Insets(8, 8, 4, 4);
        gridbagconstraints.anchor = 18;
        add(jLabel1, gridbagconstraints);
        name.setToolTipText(bundle.getString("TIP_ValueFactoryName"));
        gridbagconstraints = new GridBagConstraints();
        gridbagconstraints.gridwidth = 0;
        gridbagconstraints.fill = 2;
        gridbagconstraints.insets = new Insets(8, 4, 4, 8);
        gridbagconstraints.anchor = 18;
        add(name, gridbagconstraints);
        jLabel2.setText(bundle.getString("TXT_ValueParams"));
        jLabel2.setLabelFor(params);
        gridbagconstraints = new GridBagConstraints();
        gridbagconstraints.gridx = 0;
        gridbagconstraints.gridy = 1;
        gridbagconstraints.insets = new Insets(4, 8, 8, 4);
        gridbagconstraints.anchor = 18;
        add(jLabel2, gridbagconstraints);
        params.setToolTipText(bundle.getString("TIP_ValueFactoryParam"));
        gridbagconstraints = new GridBagConstraints();
        gridbagconstraints.gridx = 1;
        gridbagconstraints.gridy = 1;
        gridbagconstraints.gridwidth = 0;
        gridbagconstraints.fill = 2;
        gridbagconstraints.insets = new Insets(4, 4, 8, 8);
        gridbagconstraints.anchor = 18;
        gridbagconstraints.weightx = 1.0D;
        gridbagconstraints.weighty = 1.0D;
        add(params, gridbagconstraints);
    }

    public void changedUpdate(DocumentEvent documentevent)
    {
        checkState();
    }

    public void removeUpdate(DocumentEvent documentevent)
    {
        checkState();
    }

    public void insertUpdate(DocumentEvent documentevent)
    {
        checkState();
    }

    private void checkState()
    {
//        if(IdlUtilities.isValidIDLIdentifier(name.getText()) && isArgValid())
//            enableOk();
//        else
//            disableOk();
    }

    private boolean isArgValid()
    {
        String s = params.getText();
        if(s.length() == 0)
            return true;
        if(s.endsWith(","))
            return false;
        for(StringTokenizer stringtokenizer = new StringTokenizer(s, ","); stringtokenizer.hasMoreTokens();)
        {
            String s1 = stringtokenizer.nextToken().trim();
            int i = 0;
            int j = 0;
            String s2 = null;
            Object obj = null;
            String s4 = null;
            int k;
            for(k = 0; k < s1.length(); k++)
                switch(i)
                {
                default:
                    break;

                case 0: /* '\0' */
                    if(s1.charAt(k) == ' ' || s1.charAt(k) == '\t')
                    {
                        s2 = s1.substring(j, k);
                        i++;
                    }
                    break;

                case 1: /* '\001' */
                    if(s1.charAt(k) != ' ' && s1.charAt(k) != '\t')
                    {
                        j = k;
                        i++;
                    }
                    break;

                case 2: /* '\002' */
                    if(s1.charAt(k) == ' ' || s1.charAt(k) == '\t')
                    {
                        String s3 = s1.substring(j, k);
                        i++;
                    }
                    break;

                case 3: /* '\003' */
                    if(s1.charAt(k) != ' ' && s1.charAt(k) != '\t')
                    {
                        j = k;
                        i++;
                    }
                    break;

                case 4: /* '\004' */
                    if(s1.charAt(k) == ' ' || s1.charAt(k) == '\t')
                        return false;
                    break;

                }

            if(i != 4)
                return false;
            s4 = s1.substring(j, k);
            if(!s2.equals("in"))
                return false;
        }

        return true;
    }

    private JLabel jLabel1;
    private JTextField name;
    private JLabel jLabel2;
    private JTextField params;
    private static final ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/openoffice/wizard/nodes/gui/Bundle");

}
