/*
 * CreateIDLaPanel.java
 *
 * Created on 30. Januar 2002
 */

package org.netbeans.modules.openoffice.wizard.panels.idl;

import javax.swing.border.EtchedBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ResourceBundle;
import java.util.Set;
import org.netbeans.modules.openoffice.wizard.*;
import org.netbeans.modules.openoffice.wizard.actions.idl.*;
import org.netbeans.modules.openoffice.wizard.keys.NameKey;
import org.netbeans.modules.openoffice.wizard.nodes.*;
import org.netbeans.modules.openoffice.wizard.util.*;
import org.openide.explorer.ExplorerPanel;
import org.openide.explorer.view.BeanTreeView;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard;
import org.openide.nodes.Node;
import org.openide.NotifyDescriptor;
import org.openide.TopManager;
import org.openide.util.actions.NodeAction;
import org.openide.util.actions.SystemAction;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.WizardDescriptor;

/** A single panel for a wizard.
 * You probably want to make a wizard iterator to hold it.
 *
 * @author  Bertram Nolte
 */

public class CreateIDLPanel extends javax.swing.JPanel implements WizardDescriptor.Panel, PropertyChangeListener, VetoableChangeListener {
    
    private static final boolean DEBUG = false;
    private BeanTreeView bv;
    private IdlFileNode root;
    private SystemAction removeAction;
    private SystemAction editAction;
    private OOIDLData IDLdata;
    private ExplorerPanel tree;
    private JComboBox jcomboboxTypes;
    private JButton create;
    private JButton edit;
    private JButton up;
    private JButton down;
    private JButton remove;
    private JPanel jPanel2;
    private boolean initialized = false;
    private static final ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/openoffice/wizard/panels/idl/Bundle");
    
    
    /** Create the wizard panel and set up some basic properties. */
    public CreateIDLPanel() {
    }
    
    public CreateIDLPanel(OOIDLData aOOIDLData) {
        IDLdata = aOOIDLData;
        initComponents();
        postInitComponents();
        setName(bundle.getString("TXT_CreateIDL"));
        putClientProperty("WizardPanel_contentSelectedIndex", new Integer(2));
    }
    
    public void postInitComponents() {
        bv = new BeanTreeView();
        bv.setPopupAllowed(false);
        bv.setDefaultActionAllowed(false);
        tree.add(bv);
        root = new IdlFileNode();
        
        tree.getExplorerManager().setRootContext(root);
        tree.getExplorerManager().addPropertyChangeListener(this);
        tree.getExplorerManager().addVetoableChangeListener(this);
        try {
            tree.getExplorerManager().setSelectedNodes(new Node[] {
                root
            });
            createCommandPanel(new Node[] {
                root
            });
        }
        catch(PropertyVetoException propertyvetoexception) {}
        
        
        // Get the package name.
        String stringPackage = IDLdata.getPackage();
        
        // Get the root node.
        Node nodeFather = root;
        
        while ( !stringPackage.equals( "" ) ) {
            // Get the index of the first dot.
            int intIndexDot = stringPackage.indexOf( '.' );
            
            // Declare directory.
            String stringDirectory = null;
            
            // If the dot exists.
            if ( intIndexDot != -1 ) {
                // Get the directory.
                stringDirectory = stringPackage.substring( 0, intIndexDot );
                
                // Get the package without the first directory.
                stringPackage = stringPackage.substring( intIndexDot + 1 );
            }
            // If the dot is missing.
            else {
                // There is only a directory.
                stringDirectory = stringPackage;
                
                // Everything is done for the package.
                stringPackage = "";
            }
            
            // Create a module node.
            Node node[] = new Node[] { new ModuleNode( new NameKey(
            4, stringDirectory ) ) };
            
            // Add node to tree.
            nodeFather.getChildren().add( node );
            
            // The inserted node will be the next father.
            nodeFather = node[ 0 ];
        }
        
        try {
            // Select the last node.
            tree.getExplorerManager().setSelectedNodes(
            new Node[] { nodeFather } );
        }
        catch( PropertyVetoException propertyvetoexception ) {
            // Show message.
            TopManager.getDefault().notify(
            new NotifyDescriptor.Message(
            propertyvetoexception.toString() ) );
        }
        
    }
    // --- VISUAL DESIGN OF PANEL ---
    
    
    private void initComponents() {
        tree = new ExplorerPanel();
        jcomboboxTypes = new JComboBox();
        create = new JButton();
        edit = new JButton();
        up = new JButton();
        down = new JButton();
        remove = new JButton();
        jPanel2 = new JPanel();
        setLayout(new GridBagLayout());
        setPreferredSize(new Dimension(500, 300));
        setMinimumSize(new Dimension(100, 100));
        tree.setBorder(new EtchedBorder());
        GridBagConstraints gridbagconstraints = new GridBagConstraints();
        gridbagconstraints.gridx = 0;
        gridbagconstraints.gridy = 0;
        gridbagconstraints.gridheight = 0;
        gridbagconstraints.fill = 1;
        gridbagconstraints.insets = new Insets(12, 12, 12, 12);
        gridbagconstraints.anchor = 17;
        gridbagconstraints.weightx = 1.0D;
        gridbagconstraints.weighty = 1.0D;
        
        add(tree, gridbagconstraints);
        jcomboboxTypes.setPreferredSize(new Dimension(120, 23));
        jcomboboxTypes.setMinimumSize(new Dimension(120, 23));
        jcomboboxTypes.addActionListener(new ActionListener() {
            
            public void actionPerformed(ActionEvent actionevent) {
                typesActionPerformed(actionevent);
            }
            
        });
        gridbagconstraints = new GridBagConstraints();
        gridbagconstraints.gridx = 1;
        gridbagconstraints.gridy = 0;
        gridbagconstraints.fill = 2;
        gridbagconstraints.insets = new Insets(12, 0, 6, 12);
        add(jcomboboxTypes, gridbagconstraints);
        create.setText(bundle.getString("TXT_CreateButton"));
        create.addActionListener(new ActionListener() {
            
            public void actionPerformed(ActionEvent actionevent) {
                createActionPerformed(actionevent);
            }
            
        });
        gridbagconstraints = new GridBagConstraints();
        gridbagconstraints.gridx = 1;
        gridbagconstraints.gridy = 1;
        gridbagconstraints.fill = 2;
        gridbagconstraints.insets = new Insets(0, 0, 6, 12);
        add(create, gridbagconstraints);
        edit.setText(bundle.getString("TXT_EditButton"));
        edit.addActionListener(new ActionListener() {
            
            public void actionPerformed(ActionEvent actionevent) {
                editActionPerformed(actionevent);
            }
            
        });
        gridbagconstraints = new GridBagConstraints();
        gridbagconstraints.gridx = 1;
        gridbagconstraints.gridy = 3;
        gridbagconstraints.fill = 2;
        gridbagconstraints.insets = new Insets(6, 0, 6, 12);
        add(edit, gridbagconstraints);
        up.setText(bundle.getString("TXT_UpButton"));
        up.addActionListener(new ActionListener() {
            
            public void actionPerformed(ActionEvent actionevent) {
                upActionPerformed(actionevent);
            }
            
        });
        gridbagconstraints = new GridBagConstraints();
        gridbagconstraints.gridx = 1;
        gridbagconstraints.gridy = 4;
        gridbagconstraints.fill = 2;
        gridbagconstraints.insets = new Insets(6, 0, 6, 12);
        add(up, gridbagconstraints);
        down.setText(bundle.getString("TXT_DownButton"));
        down.addActionListener(new ActionListener() {
            
            public void actionPerformed(ActionEvent actionevent) {
                downActionPerformed(actionevent);
            }
            
        });
        gridbagconstraints = new GridBagConstraints();
        gridbagconstraints.gridx = 1;
        gridbagconstraints.gridy = 5;
        gridbagconstraints.fill = 2;
        gridbagconstraints.insets = new Insets(6, 0, 6, 12);
        add(down, gridbagconstraints);
        remove.setText(bundle.getString("TXT_RemoveButton"));
        remove.addActionListener(new ActionListener() {
            
            public void actionPerformed(ActionEvent actionevent) {
                removeActionPerformed(actionevent);
            }
            
        });
        gridbagconstraints = new GridBagConstraints();
        gridbagconstraints.gridx = 1;
        gridbagconstraints.gridy = 2;
        gridbagconstraints.fill = 2;
        gridbagconstraints.insets = new Insets(6, 0, 6, 12);
        add(remove, gridbagconstraints);
        gridbagconstraints = new GridBagConstraints();
        gridbagconstraints.gridx = 1;
        gridbagconstraints.gridy = 6;
        gridbagconstraints.gridheight = 0;
        gridbagconstraints.fill = 3;
        gridbagconstraints.insets = new Insets(6, 0, 12, 12);
        gridbagconstraints.weighty = 1.0D;
        add(jPanel2, gridbagconstraints);
        
        
        
    }
    
    private void typesActionPerformed(ActionEvent actionevent) {
    }
    
    private void downActionPerformed(ActionEvent actionevent) {
        Node node[] = tree.getExplorerManager().getSelectedNodes();
        ((BaseNode)node[0]).moveDown();
        try {
            tree.getExplorerManager().setSelectedNodes(node);
        }
        catch(PropertyVetoException propertyvetoexception) {}
    }
    
    private void upActionPerformed(ActionEvent actionevent) {
        Node node[] = tree.getExplorerManager().getSelectedNodes();
        ((BaseNode)node[0]).moveUp();
        try {
            tree.getExplorerManager().setSelectedNodes(node);
        }
        catch(PropertyVetoException propertyvetoexception) {}
    }
    
    private void editActionPerformed(ActionEvent actionevent) {
        Node node[] = tree.getExplorerManager().getSelectedNodes();
        editAction.actionPerformed(new ActionEvent(node, 0, ""));
    }
    
    private void removeActionPerformed(ActionEvent actionevent) {
        Node node[] = tree.getExplorerManager().getSelectedNodes();
        removeAction.actionPerformed(new ActionEvent(node, 0, ""));
    }
    
    private void createActionPerformed(ActionEvent actionevent) {
        Object obj = jcomboboxTypes.getSelectedItem();
        if(obj == null || !(obj instanceof NodeAction)) {
            return;
        }
        else {
            NodeAction nodeaction = (NodeAction)obj;
            Node node[] = tree.getExplorerManager().getSelectedNodes();
            nodeaction.actionPerformed(new ActionEvent(node, 0, ""));
            
            // Get nodes count.
            int intNodesCount = node[ 0 ].getChildren().getNodesCount();
            
            // Test if nodes count greater than zero.
            if ( intNodesCount > 0 ) {
                try {
                    // Select the last node.
                    tree.getExplorerManager().setSelectedNodes(
                    new Node[] {
                        node[ 0 ].getChildren().getNodes()[
                        intNodesCount - 1 ] } );
                }
                catch( PropertyVetoException propertyvetoexception ) {
                    // Show message.
                    TopManager.getDefault().notify(
                    new NotifyDescriptor.Message(
                    propertyvetoexception.toString() ) );
                }
            }
            
            return;
        }
    }
    
    public void propertyChange(PropertyChangeEvent propertychangeevent) {
        
        Object obj = propertychangeevent.getNewValue();
        if(obj != null && (obj instanceof Node[])) {
            Node node[] = (Node[])obj;
            if(node.length == 1) {
                tree.setActivatedNodes(node);
                createCommandPanel(node);
            }
        }
    }
    
    public void vetoableChange(PropertyChangeEvent propertychangeevent)
    throws PropertyVetoException {
        
        
        Object obj = propertychangeevent.getNewValue();
        if(obj != null && (obj instanceof Node[])) {
            Node node[] = (Node[])obj;
            if(node.length != 1)
                throw new PropertyVetoException("", propertychangeevent);
        }
    }
    private void createCommandPanel( Node node[] ) {
        jcomboboxTypes.removeAllItems();
        SystemAction systemaction[] = node[ 0 ].getActions();
        
        remove.setEnabled(false);
        
        edit.setEnabled(false);
        
        up.setEnabled(false);
        
        down.setEnabled(false);
        
        for( int i = 0; i < systemaction.length; i++ ) {
            if ( systemaction[ i ] != null )
                if( systemaction[ i ] instanceof Create ) {
                    if ( ( ( Create ) systemaction[ i ] ).isEnabled( node ) ) {
                        jcomboboxTypes.addItem( systemaction[ i ] );
                        
                        if ( ( systemaction[ i ] 
                        instanceof CreateOperationAction ) 
                        || ( systemaction[ i ] 
                        instanceof CreateInterfaceAction ) ) {
                            jcomboboxTypes.setSelectedItem( systemaction[ i ] );
                        }
                    }
                }
                else
                    if ( systemaction[ i ] instanceof DestroyAction ) {
                        removeAction = systemaction[ i ];
                        remove.setEnabled( true );
                    }
                    else
                        if ( systemaction[ i ] instanceof EditAction ) {
                            editAction = systemaction[ i ];
                            edit.setEnabled( true );
                        }
        }
        
        if ( jcomboboxTypes.getItemCount() == 0 )
            create.setEnabled( false );
        else
            create.setEnabled( true );
        
        if( node[ 0 ] instanceof BaseNode ) {
            up.setEnabled( ( ( BaseNode )node[ 0 ] ).canMoveUp() );
            down.setEnabled( ( ( BaseNode )node[ 0 ] ).canMoveDown() );
        }
    }
    
    
    
    public Component getComponent() {
        return this;
    }
    
    public HelpCtx getHelp() {
        return new HelpCtx( 
        "org.netbeans.modules.openoffice.help.UNOIDL.Description" );
    }
    
    public boolean isValid() {
        return true;
    }
    
    public final void addChangeListener(ChangeListener l) {}
    public final void removeChangeListener(ChangeListener l) {}
    
    public void readSettings( Object obj ) {
        if( obj instanceof TemplateWizard ) {
            // Get the template wizard.
            TemplateWizard templatewizard = ( TemplateWizard ) obj;
            
            // Declare data folder.
            DataFolder datafolder = null;
            
            try {
                // Get the data folder from the mount point.
                datafolder = templatewizard.getTargetFolder();
                
                // Set the package name.
                IDLdata.setTargetFolder( datafolder );
            }
            catch( IOException ioexception ) {
                // Show message.
                TopManager.getDefault().notify(
                new NotifyDescriptor.Message(
                ioexception.toString() ) );
            }
            
            if ( datafolder == null ) {
                throw new IllegalStateException( "Expected target folder, got null." );
            }
        }
    }
    
    public void storeSettings(Object settings) {
        
        IDLdata.setIdlSource(root.generate());
    }
    
}
