/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: IMessage.java,v $
 *
 *  $Revision: 1.7 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 18:59:12 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

package com.sun.star.lib.uno.environments.remote;


import com.sun.star.uno.ITypeDescription;


/**
 * The purpose of this class is to be an abstraction
 * for messages for remote communication.
 * <p>
 * @version 	$Revision: 1.7 $ $ $Date: 2005/09/07 18:59:12 $
 * @author 	    Kay Ramme
 * @since       UDK1.0
 */
public interface IMessage {
	/**
	 * Gets the operation name of this message.
	 *<p>
	 * @return  the name of the operation or null if it is a reply
	 */
	String getOperation();

	/**
	 * Gets the thread id of the message.
	 *<p>
	 * @return  the thread id
	 */
	ThreadId getThreadId();

	/**
	 * Gets the interface of the target object.
	 *<p>
	 * @return  the interface
	 */
	ITypeDescription getInterface();

	/**
	 * Determines if the message is synchron or asynchron
	 *<p>
	 * @return  <code>true</code>, if synchron else <code>false</code>
	 */
	boolean isSynchron();

	/**
	 * Determines if a reply has to be send for the message
	 *<p>
	 * @return  <code>true</code>, if a reply has to be send else <code>false</code>
	 */
	boolean mustReply();

	/**
	 * Determines if the message an exceptions
	 *<p>
	 * @return  <code>true</code>, if exceptions else <code>false</code>
	 */
	boolean isException();

	/**
	 * Gets the oid of the target object
	 *<p>
	 * @return  the oid
	 */
	String getOid();

	/**
	 * Gets the data of the request or reply
	 *<p>
	 * @return  the result, if it is a reply
	 * @param   params    the in parameters if it is a request otherwiese the out parameters
	 */
	Object getData(Object params[][]);
}


