/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: pluginframe.cxx,v $
 *
 *  $Revision: 1.29 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 01:45:45 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

//_________________________________________________________________________________________________________________
//	my own includes
//_________________________________________________________________________________________________________________

#ifndef __FRAMEWORK_HELPER_OPLUGINFRAMEDISPATCHER_HXX_
#include <helper/opluginframedispatcher.hxx>
#endif

#ifndef __FRAMEWORK_SERVICES_PLUGINFRAME_HXX_
#include <services/pluginframe.hxx>
#endif

#ifndef __FRAMEWORK_SERVICES_H_
#include <services.h>
#endif

#ifndef __FRAMEWORK_ARGUMENTS_H_
#include <arguments.h>
#endif

#ifndef __FRAMEWORK_GENERAL_H_
#include <general.h>
#endif

#include <services/documentlist.hxx>
#include <comphelper/processfactory.hxx>

//_________________________________________________________________________________________________________________
//	interface includes
//_________________________________________________________________________________________________________________

#ifndef _COM_SUN_STAR_REGISTRY_XSIMPLEREGISTRY_HPP_
#include <com/sun/star/registry/XSimpleRegistry.hpp>
#endif

#ifndef _COM_SUN_STAR_REGISTRY_XREGISTRYKEY_HPP_
#include <com/sun/star/registry/XRegistryKey.hpp>
#endif

#ifndef _COM_SUN_STAR_FRAME_FRAMESEARCHFLAG_HPP_
#include <com/sun/star/frame/FrameSearchFlag.hpp>
#endif

#ifndef _COM_SUN_STAR_UTIL_XURLTRANSFORMER_HPP_
#include <com/sun/star/util/XURLTransformer.hpp>
#endif

#ifndef _COM_SUN_STAR_UTIL_XMODIFIABLE_HPP_
#include <com/sun/star/util/XModifiable.hpp>
#endif

#ifndef _COM_SUN_STAR_FRAME_XFRAMESSUPPLIER_HPP_
#include <com/sun/star/frame/XFramesSupplier.hpp>
#endif

#ifndef _COM_SUN_STAR_CONTAINER_XENUMERATIONACCESS_HPP_
#include <com/sun/star/container/XEnumerationAccess.hpp>
#endif

#ifndef _COM_SUN_STAR_CONTAINER_XCONTENTENUMERATIONACCESS_HPP_
#include <com/sun/star/container/XContentEnumerationAccess.hpp>
#endif

#ifndef _COM_SUN_STAR_CONTAINER_XSET_HPP_
#include <com/sun/star/container/XSet.hpp>
#endif

#ifndef _COM_SUN_STAR_FRAME_XNOTIFYINGDISPATCH_HPP_
#include <com/sun/star/frame/XNotifyingDispatch.hpp>
#endif

#ifndef _COM_SUN_STAR_FRAME_DISPATCHRESULTSTATE_HPP_
#include <com/sun/star/frame/DispatchResultState.hpp>
#endif

//_________________________________________________________________________________________________________________
//	includes of other projects
//_________________________________________________________________________________________________________________

#ifndef _TOOLKIT_HELPER_VCLUNOHELPER_HXX_
#include <toolkit/helper/vclunohelper.hxx>
#endif

#ifndef _LINK_HXX
#include <tools/link.hxx>
#endif

/* HACK for translateToInternal */
#ifndef _URLOBJ_HXX
#include <tools/urlobj.hxx>
#endif
/* HACK for translateToInternal */

#ifndef _SV_SVAPP_HXX
#include <vcl/svapp.hxx>
#endif

#ifndef _SV_WRKWIN_HXX
#include <vcl/wrkwin.hxx>
#endif

#ifndef _CPPUHELPER_INTERFACECONTAINER_HXX_
#include <cppuhelper/interfacecontainer.hxx>
#endif

//_________________________________________________________________________________________________________________
//	namespace
//_________________________________________________________________________________________________________________

namespace framework{

using namespace ::com::sun::star::awt		;
using namespace ::com::sun::star::beans		;
using namespace ::com::sun::star::frame		;
using namespace ::com::sun::star::io		;
using namespace ::com::sun::star::lang		;
using namespace ::com::sun::star::mozilla	;
using namespace ::com::sun::star::registry	;
using namespace ::com::sun::star::uno		;
using namespace ::com::sun::star::util		;
using namespace ::com::sun::star::container	;
using namespace ::cppu						;
using namespace ::osl						;
using namespace ::rtl						;

//_________________________________________________________________________________________________________________
//	non exported const
//_________________________________________________________________________________________________________________

#define	DEFAULT_XPLUGININSTANCEPEER			Reference< XPluginInstancePeer >()
#define	DEFAULT_XPLUGINWINDOWPEER			Reference< XPluginWindowPeer >()
#define	DEFAULT_SEQPROPERTIES				Sequence< PropertyValue >()
#define	DEFAULT_AURL						URL()
#define	DEFAULT_BILOAD						sal_False
#define	DEFAULT_BIHAVEDOCUMENT				sal_False
#define	REFERRERVALUE						DECLARE_ASCII( "private:user"				)
#define	PACKAGENAME_PORTAL					DECLARE_ASCII( "org.openoffice.Portal"		)
#define	KEYNAME_HTTPLOADBALANCING_HOST		DECLARE_ASCII( "HTTPLoadbalancing/Host"		)
#define	KEYNAME_HTTPLOADBALANCING_PORT		DECLARE_ASCII( "HTTPLoadbalancing/Port"		)
#define	KEYNAME_WEBAPPS_PORTAL_PREFIXPATH	DECLARE_ASCII( "WebApps/Portal/PrefixPath"	)

//_________________________________________________________________________________________________________________
//	non exported definitions
//_________________________________________________________________________________________________________________

//_________________________________________________________________________________________________________________
//	declarations
//_________________________________________________________________________________________________________________

//*****************************************************************************************************************
//	constructor
//*****************************************************************************************************************

void cIMPL_MainThreadExecutor::execute( cIMPL_MainThreadExecutorRequest* pMainThreadExecutorRequest )
{
	Application::PostUserEvent( STATIC_LINK( NULL, cIMPL_MainThreadExecutor, worker ), pMainThreadExecutorRequest );
}

IMPL_STATIC_LINK( cIMPL_MainThreadExecutor, worker, cIMPL_MainThreadExecutorRequest*, pThreadExecutorRequest )
{
	// execute request
	long nReturn = pThreadExecutorRequest->doIt();

	// delete request after execution
	delete pThreadExecutorRequest;
	return nReturn;
}

//*****************************************************************************************************************
//	constructor
//*****************************************************************************************************************

cIMPL_MainThreadExecutorRequest::cIMPL_MainThreadExecutorRequest(	eIMPL_PluginCommand			eCommand		,
																	PlugInFrame*				pPluginInstance		)
	:	m_eCommand				( eCommand											)
	,	m_pPluginInstance		( pPluginInstance									)
	,	m_xPluginInstance		( SAL_STATIC_CAST( OWeakObject*, pPluginInstance )	)
	,	m_aPlatformWindowHandle	( Any()												)
	,	m_bEmbedded				( sal_False											)
{
}

//*****************************************************************************************************************
//	constructor
//*****************************************************************************************************************
cIMPL_MainThreadExecutorRequest::cIMPL_MainThreadExecutorRequest(	eIMPL_PluginCommand			eCommand				,
																	PlugInFrame*				pPluginInstance			,
																	const	Any&				aPlatformWindowHandle	,
																	sal_Bool					bEmbedded				)
	:	m_eCommand				( eCommand											)
	,	m_pPluginInstance		( pPluginInstance									)
	,	m_xPluginInstance		( SAL_STATIC_CAST( OWeakObject*, pPluginInstance )	)
	,	m_aPlatformWindowHandle	( aPlatformWindowHandle								)
	,	m_bEmbedded				( bEmbedded											)
{
}

//*****************************************************************************************************************
//	constructor
//*****************************************************************************************************************
cIMPL_MainThreadExecutorRequest::cIMPL_MainThreadExecutorRequest(	eIMPL_PluginCommand			eCommand		,
																	PlugInFrame*				pPluginInstance	,
															const   OUString&					sMIMEDescription,
															const	OUString&					sURL		    ,
															const	OUString&					sFilter		    ,
															const	Reference< XInputStream >&	xStream     	,
															const	Any&						aSessionId		)
	:	m_eCommand				( eCommand											)
	,   m_pPluginInstance       ( pPluginInstance 									)
	,	m_xPluginInstance		( SAL_STATIC_CAST( OWeakObject*, pPluginInstance )	)
	,	m_sMIMEDescription		( sMIMEDescription									)
	,	m_sURL	                ( sURL												)
	,	m_sFilter				( sFilter											)
	,	m_xStream				( xStream											)
	,   m_aSessionId            ( aSessionId										)
{
}

sal_Int32 cIMPL_MainThreadExecutorRequest::doIt()
{
	// Look for given command and forward call to right impl method of given instance!
	// We don't need any mutex here. Calledmethods must protected by himself.
	try
	{
		switch ( m_eCommand )
		{
			//-----------------------------------------------------------------------------------------------------
			case START			:	{
										if( m_pPluginInstance != NULL )
										{
											m_pPluginInstance->implcb_start();
										}
										break;
									}
			//-----------------------------------------------------------------------------------------------------
			case STOP			:	{
										if( m_pPluginInstance != NULL )
										{
											m_pPluginInstance->implcb_stop();
										}
										break;
									}
			//-----------------------------------------------------------------------------------------------------
			case CREATEWINDOW	:	{
										if( m_pPluginInstance != NULL )
										{
											m_pPluginInstance->implcb_createWindow( m_aPlatformWindowHandle, m_bEmbedded );
										}
										break;
									}
			//-----------------------------------------------------------------------------------------------------
			case DESTROY		:	{
										if( m_pPluginInstance != NULL )
										{
											m_pPluginInstance->implcb_destroy();
										}
										break;
			                        }
			//-----------------------------------------------------------------------------------------------------
 		   case NEWSTREAM       :   {
	 		                           if( m_pPluginInstance != NULL )
		                          	   {
                           				   m_pPluginInstance->implcb_newStream( m_sMIMEDescription, m_sURL, m_sFilter, m_xStream, m_aSessionId );
                         			   }
									   break;
		                            }
			//-----------------------------------------------------------------------------------------------------
		   case NEWURL          :   {
			                           if( m_pPluginInstance != NULL )
									   {
										   m_pPluginInstance->implcb_newURL( m_sMIMEDescription, m_sURL, m_sFilter, m_aSessionId );
									   }
									   break;
		                            }
			//-----------------------------------------------------------------------------------------------------
			default				:	{
										LOG_ASSERT( sal_False, "cIMPL_MainThreadExecutor::doIt()\nCommand multiplexer of PlugInFrame has unknown command detected!\n" )
										break;
									}
		}
	}
	catch( RuntimeException& )
	{
		// We have detected a runtime exception ... all interface methods of XPluginInstance can throw this ... but
		// I don't know how I can do it from here!
		LOG_ASSERT( sal_False, "cIMPL_MainThreadExecutorRequest::doIt()\nCommand multiplexer of PlugInFrame has RuntimeException catched ! ...\n" )
	}

	return 0;
}

//*****************************************************************************************************************
//	constructor
//*****************************************************************************************************************
PlugInFrame::PlugInFrame( const Reference< XMultiServiceFactory >& xFactory )
		//	Init baseclasses first
        :   Frame                   ( xFactory                          )
		// Init member
		,	m_xPlugInInstancePeer	( DEFAULT_XPLUGININSTANCEPEER		)
		,	m_xPlugInWindowPeer		( DEFAULT_XPLUGINWINDOWPEER			)
		,	m_seqProperties			( DEFAULT_SEQPROPERTIES				)
		,	m_aURL					( DEFAULT_AURL						)
		,	m_bILoad				( DEFAULT_BILOAD					)
		,	m_bIHaveDocument		( DEFAULT_BIHAVEDOCUMENT			)
{
    // Overwrite these property of frame!
	m_bIsPlugIn = sal_True;
}

//*****************************************************************************************************************
//	destructor
//*****************************************************************************************************************
PlugInFrame::~PlugInFrame()
{
}

//*****************************************************************************************************************
//	XInterface, XTypeProvider, XServiceInfo
//*****************************************************************************************************************

DEFINE_XINTERFACE_3						(	PlugInFrame									,
                                            Frame                                       ,
											DIRECT_INTERFACE(XInitialization			),
											DIRECT_INTERFACE(XPluginInstance			),
											DIRECT_INTERFACE(XDispatchResultListener	)
										)

DEFINE_XTYPEPROVIDER_2_WITH_BASECLASS	(	PlugInFrame					,
                                            Frame                       ,
											XInitialization				,
											XPluginInstance
										)

DEFINE_XSERVICEINFO_MULTISERVICE		(	PlugInFrame						,
                                            ::cppu::OWeakObject             ,
											SERVICENAME_PLUGINFRAME			,
											IMPLEMENTATIONNAME_PLUGINFRAME
										)

DEFINE_INIT_SERVICE_WITH_BASECLASS( PlugInFrame, Frame,
    {
    }
)

// Don't initialize static member in header or in class methods ... do it here.
sal_Bool PlugInFrame::m_bRemoteFactoriesExist = sal_False;

//*****************************************************************************************************************
//	XInitialization
//*****************************************************************************************************************
void SAL_CALL PlugInFrame::initialize( const Sequence< Any >& seqArguments ) throw(	Exception			,
																					RuntimeException	)
{
	// Be sure - all calls of this method must free his own mutex, if it the same as i use!!!???
	// impl_tryToLoadDocument() is asynchron ...
	ResetableGuard aGuard( m_aLock );
	// Safe impossible cases
	// Method is not defined for all incoming parameters.
	LOG_ASSERT( impldbg_checkParameter_initialize( seqArguments ), "PlugInFrame::initialize()\nInvalid parameter detected.\n" )

	// Our plugin need information about his parent!
	// If someone dispatch anything to this plugin instance, he will create a new window and load the content.
	// Then he must append himself to our frame tree !!! => Thats why he need a valid reference to the desktop
	// as parent to do this.
	// We can giv him these reference, because the desktop MUST BE a OneInstance-Service!
	// If we instanciate a ne reference, we share the only one desktop object with others.
    Reference< XFramesSupplier > xDesktop( impl_getFactory()->createInstance( SERVICENAME_DESKTOP ), UNO_QUERY );
	// Safe impossible cases
	// The desktop must exist at this point or we have created a new one, because we have called creation of OneInstanceService at first.
	LOG_ASSERT( !(xDesktop.is()==sal_False), "PlugInFrame::PlugInFrame()\nThere is no valid desktop as parent for our new plugin!\n" )
	// Append frame at parent.
	// This will set desktop as parent automaticly!
	Reference< XFrames > xFramesHelper = xDesktop->getFrames();
	xFramesHelper->append( Reference< XFrame >( static_cast< OWeakObject* >( this ), UNO_QUERY ) );
	// In special debug mode only(!) ... log current tree state in file.
//	LOG_TREE( xDesktop )

    // We accept two arguments for initializing only.
	// It must be a reference of XPluginInstancePeer first and one of XPluginWindowPeer as second!
	// We check it in impldbg_checkParameter... function in debug version.
	// In release version it must be true!
	seqArguments[0] >>= m_xPlugInInstancePeer	;
	seqArguments[1] >>= m_xPlugInWindowPeer		;
    // To support our new help agent and for comming features we share
	// our uno service manager instances between plugin and office!
	if( seqArguments.getLength() == 3 )
	{
        // Look for remote service manager ... and share some special factories
        // between client and server installation!
        // Attention: Use global lock for static member access!
        ResetableGuard aGlobalGuard( LockHelper::getGlobalLock() );
        if( m_bRemoteFactoriesExist == sal_False )
        {
            Reference< XMultiServiceFactory > xRemoteServiceManager;
            seqArguments[2] >>= xRemoteServiceManager;
            m_bRemoteFactoriesExist = impl_registerRemoteFactories( xRemoteServiceManager );
        }
        aGlobalGuard.unlock();

		// Try to set our manager at plugin DLL.
		Reference< XInitialization > xPlugInInit( m_xPlugInInstancePeer, UNO_QUERY );
		if( xPlugInInit.is() == sal_True )
		{
			Sequence< Any > seqParameter(1);
            seqParameter[0] <<= impl_getFactory();
			xPlugInInit->initialize( seqParameter );
		}
	}

	if( m_xPlugInDispatcher.is() == sal_False )
	{
		// Initialize a new dispatchhelper-object to handle dispatches PRIVATE!
		// We have already a helper in our baseclass (!), but to forward special dispatches we must have a special one too.
		// We forward "_blank"/CREATE and "_self"/""/SELF to the plugin dll and the webserver. And we will get it back from these programs
		// sometimes later if it's a staroffice url. Otherwise the browser open it by himself!
		//		PlugInFrame::m_xPlugInDispatcher	=> send to browser
		//		Frame::m_xDispatchHelper			=> load component for sended and recieved url (!)
        OPlugInFrameDispatcher* pDispatchHelper = new OPlugInFrameDispatcher( impl_getFactory(), this, m_xPlugInInstancePeer );
		m_xPlugInDispatcher = Reference< XDispatchProvider >( (OWeakObject*)pDispatchHelper, UNO_QUERY );
		// Safe impossible cases
		// We can't work without these helper!
		LOG_ASSERT( !(m_xPlugInDispatcher.is()==sal_False), "PlugInFrame::initialize()\nDispatchHelper is not valid. XDispatchProvider and XDispatch are not supported!\n" )
	}

	impl_tryToLoadDocument();
}

//*****************************************************************************************************************
//	XPluginInstance
//*****************************************************************************************************************
void SAL_CALL PlugInFrame::start() throw( RuntimeException )
{
	// Synchronize call with main thread.
	cIMPL_MainThreadExecutorRequest* pForward = new cIMPL_MainThreadExecutorRequest( START, this );
	cIMPL_MainThreadExecutor::execute( pForward );
}

//-----------------------------------------------------------------------------------------------------------------
void SAL_CALL PlugInFrame::implcb_start() throw( RuntimeException )
{
	// Ready for multithreading
	ResetableGuard aGuard( m_aLock );
	// If we are ready to work ... or somewhere has reactivated us (browser history!) ...
    if( impl_getContainerWindow().is() == sal_True )
	{
		// ... we must show us.
//      impl_getContainerWindow()->setVisible( sal_True );
	}
}

//*****************************************************************************************************************
//	XPluginInstance
//*****************************************************************************************************************
void SAL_CALL PlugInFrame::stop() throw( RuntimeException )
{
	// Synchronize call with main thread.
	cIMPL_MainThreadExecutorRequest* pForward = new cIMPL_MainThreadExecutorRequest( STOP, this );
	cIMPL_MainThreadExecutor::execute( pForward );
}

//-----------------------------------------------------------------------------------------------------------------
void SAL_CALL PlugInFrame::implcb_stop() throw( RuntimeException )
{
	// Ready for multithreading
	ResetableGuard aGuard( m_aLock );
	// If somewhere has deactivated us (browser history!) ...
    if( impl_getContainerWindow().is() == sal_True )
	{
		// ... we must hide us.
        impl_getContainerWindow()->setVisible( sal_False );
	}
}

//*****************************************************************************************************************
//	XPluginInstance
//*****************************************************************************************************************
void SAL_CALL PlugInFrame::destroy() throw( RuntimeException )
{
	// Synchronize call with main thread.
	cIMPL_MainThreadExecutorRequest* pForward = new cIMPL_MainThreadExecutorRequest( DESTROY, this );
	cIMPL_MainThreadExecutor::execute( pForward );
}

//-----------------------------------------------------------------------------------------------------------------
void SAL_CALL PlugInFrame::implcb_destroy() throw( RuntimeException )
{
    /* SAFE */{
        ResetableGuard aGuard( m_aLock );
        // Reset working state to DESTROYED.
        m_bIHaveDocument = sal_False;
    }/* SAFE */

    // Then we must close us as frame XCloseable.
    // This will close all childs and remove this plugin frame from our parent ... the desktop!
    Reference< XFrame > xFrame( static_cast< ::cppu::OWeakObject*>(this), UNO_QUERY );
    
	// #110897#
	// ModifiedDocumentsWindow::CheckForAdding( xFrame );
    ModifiedDocumentsWindow::CheckForAdding( impl_getFactory(), xFrame );

	// Don't show any dialogs, errors or something else at close!
	// We save changed documents in every way. If saving failed ... it doesnt matter!
	// Don't forget to enable dialogs after closing again.
	Application::EnableDialogCancel( sal_True  );
    Frame::close(sal_True); // force closing of this frame and let source of possible throwed veto exception be the new owner of thios frame
	Application::EnableDialogCancel( sal_False );
}

//*****************************************************************************************************************
//	XPluginInstance
//*****************************************************************************************************************
void SAL_CALL PlugInFrame::createWindow(	const	Any&		aPlatformWindowHandle,
								 					sal_Bool	bEmbedded			) throw( RuntimeException )
{
	// Synchronize call with main thread.
	cIMPL_MainThreadExecutorRequest* pForward = new cIMPL_MainThreadExecutorRequest( CREATEWINDOW, this, aPlatformWindowHandle, bEmbedded );
	cIMPL_MainThreadExecutor::execute( pForward );
}

//-----------------------------------------------------------------------------------------------------------------
void SAL_CALL PlugInFrame::implcb_createWindow(	const	Any&		aPlatformWindowHandle,
								 						sal_Bool	bEmbedded			) throw( RuntimeException )
{
	// Ready for multithreading
	ResetableGuard aGuard( m_aLock );
	// Safe impossible cases
	// Method is not defined for all incoming parameters.
	LOG_ASSERT( impldbg_checkParameter_createWindow( aPlatformWindowHandle, bEmbedded ), "PlugInFrame::implcb_createWindow()\nInvalid parameter detected.\n" )

	// Create a new remote rvp workwindow, get information from it and set it on our plugin dll.
	// The initiylize THIS frame with the new created window and try to load the document in it.
	WorkWindow* pWorkWindow				= new WorkWindow( NULL, aPlatformWindowHandle );
	Any			aReturnWindowDescriptor	= pWorkWindow->GetSystemDataAny();

	m_xPlugInWindowPeer->setChildWindow( aReturnWindowDescriptor );
	Frame::initialize( VCLUnoHelper::GetInterface( pWorkWindow ) );
	impl_tryToLoadDocument();
}

//*****************************************************************************************************************
//	XPluginInstance
//*****************************************************************************************************************
void SAL_CALL PlugInFrame::newStream(	const	OUString&					sMIMEDescription,
										const	OUString&					sURL			,
										const	OUString&					sFilter			,
										const	Reference< XInputStream >&	xStream			,
										const	Any&						aSessionId		) throw( RuntimeException )
{
	// Synchronize call with main thread.
	cIMPL_MainThreadExecutorRequest* pForward = new cIMPL_MainThreadExecutorRequest( NEWSTREAM, this, sMIMEDescription, sURL, sFilter, xStream, aSessionId );
	cIMPL_MainThreadExecutor::execute( pForward );
}

//-----------------------------------------------------------------------------------------------------------------
void SAL_CALL PlugInFrame::implcb_newStream(	const	OUString&					sMIMEDescription,
												const	OUString&					sURL			,
												const	OUString&					sFilter			,
												const	Reference< XInputStream >&	xStream			,
												const	Any&						aSessionId		) throw( RuntimeException )
{
	// Be sure - all calls of this method must free his own mutex, if it the same as i use!!!???
	// impl_tryToLoadDocument() is asynchron ...
	ResetableGuard aGuard( m_aLock );
	// Safe impossible cases
	// Method is not defined for all incoming parameters.
	LOG_ASSERT( impldbg_checkParameter_newStream( sMIMEDescription, sURL, sFilter, xStream ), "PlugInFrame::newStream()\nInvalid parameter detected.\n" )
	// In special debug mode you can log parameter in file!
    LOG_PARAMETER_NEWSTREAM( impl_getName(), sMIMEDescription, sURL, sFilter, xStream, aSessionId )

	/* HACK _______________________________________________________________________________________________________
	 	Bis am URLTransformer eine Method zum Rueckwandeln einer PraesentationURL nach interner Darstellung
	 	existiert mu hier per Hand gewandelt werden!
	 */

	UniString sExternalURL = sURL;
	UniString sInternalURL;
	INetURLObject::translateToInternal( sExternalURL, sInternalURL );

    LOG_URLRECEIVE( impl_getName(), "newStream", sExternalURL, sInternalURL )

	/* HACK _______________________________________________________________________________________________________*/

    // Save all information needed for trying to load the stream.
    // Creation of window is asynchron and we must collect all needed information before loading.
	// Pack parameter in sequence and safe given URL.
    // (Attention: Add a referrer to parameter list every time. Sfx needs it for security checks!)
    sal_Int32 nTotalLength = sFilter.getLength() ? 4 : 3;
    const Reference < XInputStream > xInputStream( xStream );
    ::rtl::OUString sMIMEType( sMIMEDescription );
    ::rtl::OUString sFilterName( sFilter );
    ::rtl::OUString sReferer( REFERRERVALUE );

    // get all parameters that have been saved before calling the browser
    const Sequence < PropertyValue >* pSeq = OPlugInFrameDispatcher::GetArguments( sInternalURL );
    if ( pSeq )
    {
        // got parameters; add all parameters that are not already given here
        const PropertyValue* pProps = pSeq->getConstArray();
        sal_Int32 nLength = pSeq->getLength();

        // first assume that all saved parameters have to be added to the internal sequence
        nTotalLength += nLength;
        for ( sal_Int32 nProp=0; nProp<nLength; nProp++ )
        {
            ::rtl::OUString aName = pProps[nProp].Name;
            if ( aName.equals( ARGUMENTNAME_MEDIATYPE ) )
            {
                // use MIMEType in saved sequence only if browser has not given one
                if ( sMIMEType.getLength() )
                    nTotalLength--;
                else
                    pProps[nProp].Value >>= sMIMEType;
            }
            else if ( aName.equals( ARGUMENTNAME_INPUTSTREAM ) )
            {
                // never use input stream in saved sequence
                if( xInputStream.is() )
                    nTotalLength--;
            }
            else if ( aName.equals( ARGUMENTNAME_FILTERNAME ) )
            {
                // use filter name in saved sequence only if browser has not given one
                if( sFilterName.getLength() )
                    nTotalLength--;
                else
                {
                    // if browser gave no filter name, the number of given arguments does not contain it
                    nTotalLength++;
                    pProps[nProp].Value >>= sFilterName;
                }
            }
            else if ( aName.equals( ARGUMENTNAME_REFERRER ) )
            {
                // user referer name, because sReferer is only a default value
                pProps[nProp].Value >>= sReferer;
            }
        }
    }

    sal_Int32 nDone = 0;
    m_seqProperties.realloc( nTotalLength );

    // add all properties that are always present
    m_seqProperties[nDone].Name   = ARGUMENTNAME_MEDIATYPE       ;
    m_seqProperties[nDone++].Value<<= sMIMEType             ;
    m_seqProperties[nDone].Name   = ARGUMENTNAME_INPUTSTREAM    ;
    m_seqProperties[nDone++].Value<<= xInputStream          ;
    m_seqProperties[nDone].Name   = ARGUMENTNAME_REFERRER       ;
    m_seqProperties[nDone++].Value<<= sReferer              ;
    if( sFilterName.getLength() > 0 )
	{
        m_seqProperties[nDone].Name   = ARGUMENTNAME_FILTERNAME ;
        m_seqProperties[nDone++].Value<<= sFilterName       ;
	}

    if ( pSeq )
    {
        // got parameters; add all parameters that are not already given here
        const PropertyValue* pProps = pSeq->getConstArray();
        sal_Int32 nLength = pSeq->getLength();
        nTotalLength += nLength;
        for ( sal_Int32 nProp=0; nProp<nLength; nProp++ )
        {
            ::rtl::OUString aName = pProps[nProp].Name;

            // skip all properties that are already in the sequence
            if ( aName.equals( ARGUMENTNAME_MEDIATYPE ) )
                continue;
            else if ( aName.equals( ARGUMENTNAME_INPUTSTREAM ) )
                continue;
            else if ( aName.equals( ARGUMENTNAME_FILTERNAME ) )
                continue;
            else if ( aName.equals( ARGUMENTNAME_REFERRER ) )
                continue;
            else
                m_seqProperties[nDone++] = pProps[nProp];
        }
    }

    // now release save arguments
    OPlugInFrameDispatcher::RemoveArguments( sInternalURL );

	m_aURL.Complete = sInternalURL;
	impl_tryToLoadDocument();
}

//*****************************************************************************************************************
//	XPluginInstance
//*****************************************************************************************************************
void SAL_CALL PlugInFrame::newURL(	const	OUString&	sMIMEDescription,
									const	OUString&	sURL			,
									const	OUString&	sFilter			,
									const	Any&		aSessionId		) throw( RuntimeException )
{
	cIMPL_MainThreadExecutorRequest* pForward = new cIMPL_MainThreadExecutorRequest( NEWURL, this, sMIMEDescription, sURL, sFilter, Reference< XInputStream >(), aSessionId );
	cIMPL_MainThreadExecutor::execute( pForward );
}

//-----------------------------------------------------------------------------------------------------------------
void SAL_CALL PlugInFrame::implcb_newURL(	const	OUString&	sMIMEDescription,
											const	OUString&	sURL			,
											const	OUString&	sFilter			,
											const	Any&		aSessionId		) throw( RuntimeException )
{
	// Ready for multithreading
	ResetableGuard aGuard( m_aLock );
	// Safe impossible cases
	// Method is not defined for all incoming parameters.
	LOG_ASSERT( impldbg_checkParameter_newURL( sMIMEDescription, sURL, sFilter ), "PlugInFrame::newURL()\nInvalid parameter detected.\n" )
	// In special debug mode you can log parameter in file!
    LOG_PARAMETER_NEWURL( impl_getName(), sMIMEDescription, sURL, sFilter, aSessionId )

	/* HACK _______________________________________________________________________________________________________
	 	Bis am URLTransformer eine Method zum Rueckwandeln einer PraesentationURL nach interner Darstellung
	 	existiert mu hier per Hand gewandelt werden!
	 */

	UniString sExternalURL = sURL;
	UniString sInternalURL;
	INetURLObject::translateToInternal( sExternalURL, sInternalURL );

    LOG_URLRECEIVE( impl_getName(), "newURL", sExternalURL, sInternalURL )

	/* HACK _______________________________________________________________________________________________________*/

    // Save all information needed for trying to load the stream.
    // Creation of window is asynchron and we must collect all needed information before loading.
	// Pack parameter in sequence and safe given URL.
    // (Attention: Add a referrer to parameter list every time. Sfx needs it for security checks!)
    sal_Int32 nTotalLength = sFilter.getLength() ? 3 : 2;
    ::rtl::OUString sMIMEType( sMIMEDescription );
    ::rtl::OUString sFilterName( sFilter );
    ::rtl::OUString sReferer( REFERRERVALUE );

    // get all parameters that have been saved before calling the browser
    const Sequence < PropertyValue >* pSeq = OPlugInFrameDispatcher::GetArguments( sInternalURL );
    if ( pSeq )
    {
        // got parameters; add all parameters that are not already given here
        const PropertyValue* pProps = pSeq->getConstArray();
        sal_Int32 nLength = pSeq->getLength();

        // first assume that all saved parameters have to be added to the internal sequence
        nTotalLength += nLength;
        for ( sal_Int32 nProp=0; nProp<nLength; nProp++ )
        {
            ::rtl::OUString aName = pProps[nProp].Name;
            if ( aName.equals( ARGUMENTNAME_MEDIATYPE ) )
            {
                // use MIMEType in saved sequence only if browser has not given one
                if ( sMIMEType.getLength() )
                    nTotalLength--;
                else
                    pProps[nProp].Value >>= sMIMEType;
            }
            else if ( aName.equals( ARGUMENTNAME_FILTERNAME ) )
            {
                // use filter name in saved sequence only if browser has not given one
                if( sFilterName.getLength() )
                    nTotalLength--;
                else
                {
                    // if browser gave no filter name, the number of given arguments does not contain it
                    nTotalLength++;
                    pProps[nProp].Value >>= sFilterName;
                }
            }
            else if ( aName.equals( ARGUMENTNAME_REFERRER ) )
            {
                // user referer name, because sReferer is only a default value
                pProps[nProp].Value >>= sReferer;
            }
        }
    }

    sal_Int32 nDone = 0;
    m_seqProperties.realloc( nTotalLength );

    // add all properties that are always present
    m_seqProperties[nDone].Name   = ARGUMENTNAME_MEDIATYPE       ;
    m_seqProperties[nDone++].Value<<= sMIMEType             ;
    m_seqProperties[nDone].Name   = ARGUMENTNAME_REFERRER       ;
    m_seqProperties[nDone++].Value<<= sReferer              ;
    if( sFilterName.getLength() > 0 )
	{
        m_seqProperties[nDone].Name   = ARGUMENTNAME_FILTERNAME ;
        m_seqProperties[nDone++].Value<<= sFilterName       ;
	}

    if ( pSeq )
    {
        // got parameters; add all parameters that are not already given here
        const PropertyValue* pProps = pSeq->getConstArray();
        sal_Int32 nLength = pSeq->getLength();
        nTotalLength += nLength;
        for ( sal_Int32 nProp=0; nProp<nLength; nProp++ )
        {
            ::rtl::OUString aName = pProps[nProp].Name;

            // skip all properties that are already in the sequence
            if ( aName.equals( ARGUMENTNAME_MEDIATYPE ) )
                continue;
            else if ( aName.equals( ARGUMENTNAME_FILTERNAME ) )
                continue;
            else if ( aName.equals( ARGUMENTNAME_REFERRER ) )
                continue;
            else
                m_seqProperties[nDone++] = pProps[nProp];
        }
    }

    // now release save arguments
    OPlugInFrameDispatcher::RemoveArguments( sInternalURL );

	m_aURL.Complete = sInternalURL;
	impl_tryToLoadDocument();
}

//*****************************************************************************************************************
//	XPluginInstance
//*****************************************************************************************************************
void SAL_CALL PlugInFrame::getHttpServerURL(	OUString&	sHost	,
												sal_uInt16&	nPort	,
												OUString&	sPrefix	) throw( RuntimeException )
{
	// Ready for multithreading
	ResetableGuard aGuard( m_aLock );
	// Safe impossible cases
	// Method is not defined for all incoming parameters.
	LOG_ASSERT( impldbg_checkParameter_getHttpServerURL( sHost, nPort, sPrefix ), "PlugInFrame::getHttpServerUR()\nInvalid parameter detected.\n" )

	// First reset incoming references and set default values if follow operations failed!
	sHost	=	OUString()	;
	nPort	=	0			;
	sPrefix	=	OUString()	;

	// Catch all exceptions of configuration management!
	// We return our default values if something is wrong.
	try
	{
		// Get reference to our configuration managemenet.
        Reference< XSimpleRegistry > xPortalPackage( impl_getFactory()->createInstance( SERVICENAME_CONFIGURATION ), UNO_QUERY );
		LOG_ASSERT( !(xPortalPackage.is()==sal_False), "PlugInFrame::getHttpServerURL()\nConfiguration management not registered ...!?\n" )
		if( xPortalPackage.is() == sal_True )
		{
			// Try to open right package and get full access to it.
			// (Open it readonly and don't create it, if it not exist!)
			xPortalPackage->open( PACKAGENAME_PORTAL, sal_True, sal_False );
			Reference< XRegistryKey > xRootKey = xPortalPackage->getRootKey();
			LOG_ASSERT( !(xPortalPackage->isValid()==sal_False), "PlugInFrame::getHttpServerURL()\nOpen of package \"com.sun.star.Portal\" failed.\n" )
			LOG_ASSERT( !(xRootKey.is()==sal_False), "PlugInFrame::getHttpServerURL()\nCant get rootkey of portal package.\n" )
			if( xRootKey.is() == sal_True )
			{
				// Read values from configuration management to fill return variables.
				// Don't check type of values! We know ... STRING, LONG, STRING!!!
				// If an exception is thrown, something has changed in our configuration and we return our default values.
				Reference< XRegistryKey > xEntry = xRootKey->openKey( KEYNAME_HTTPLOADBALANCING_HOST );
				if( xEntry.is() == sal_True )
				{
					sHost = xEntry->getStringValue();
					xEntry->closeKey();
				}
				xEntry = xRootKey->openKey( KEYNAME_HTTPLOADBALANCING_PORT );
				if( xEntry.is() == sal_True )
				{
					nPort = (sal_uInt16)(xEntry->getLongValue());
					xEntry->closeKey();
				}
				xEntry = xRootKey->openKey( KEYNAME_WEBAPPS_PORTAL_PREFIXPATH );
				if( xEntry.is() == sal_True )
				{
					sPrefix = xEntry->getStringValue();
					xEntry->closeKey();
				}
				xRootKey->closeKey();
			}
			xPortalPackage->close();
		}
	}
	catch( InvalidRegistryException& )
	{
		LOG_ASSERT( sal_False, "PlugInFrame::getHttpServerURL()\nInvalidRegistryException catched ...\n" )
		// Reset return values. It can be we have set some of it before exception was thrown!
		sHost	=	OUString()	;
		nPort	=	0			;
		sPrefix	=	OUString()	;
	}
	catch( RuntimeException& )
	{
		LOG_ASSERT( sal_False, "PlugInFrame::getHttpServerURL()\nRuntimeException catched ...\n" )
	}
}

//*****************************************************************************************************************
//	XDispatchProvider
//*****************************************************************************************************************
Reference< XDispatch > SAL_CALL PlugInFrame::queryDispatch(	const	URL&	 	aURL			,
										   					const	OUString&	sTargetFrameName,
										   							sal_Int32	nSearchFlags	) throw( RuntimeException )
{
	const char UNO_PROTOCOL[] = ".uno:";

	// Ready for multithreading
	ResetableGuard aGuard( m_aLock );
	// Safe impossible cases
	// Method not defined for all incoming parameter.
	LOG_ASSERT( impldbg_checkParameter_queryDispatch( aURL, sTargetFrameName, nSearchFlags ), "OPlugInFrameDispatcher::queryDispatch()\nInvalid parameter detected.\n" )

	// Set default return value.
	Reference< XDispatch > xReturn;

	String aCommand( aURL.Main );
	if ( aURL.Protocol.equalsIgnoreAsciiCaseAsciiL( UNO_PROTOCOL, sizeof( UNO_PROTOCOL )-1 ))
		aCommand = aURL.Path;

	// Make hash_map lookup if the current URL is in the disabled list
	if ( !m_aCommandOptions.Lookup( SvtCommandOptions::CMDOPTION_DISABLED, aCommand ) )
	{
		// First we ask our special plugin dispatch helper if he will handle these case.
		// If not - we can forward query to our other dispatch helper of our base class!
		xReturn = m_xPlugInDispatcher->queryDispatch( aURL, sTargetFrameName, nSearchFlags );
		if( xReturn.is() == sal_False )
		{
			xReturn = impl_getDispatchHelper()->queryDispatch( aURL, sTargetFrameName, nSearchFlags );
		}
	}

	// Return result of query.
	return xReturn;
}

//*****************************************************************************************************************
//	XDispatchProvider
//*****************************************************************************************************************
Sequence< Reference< XDispatch > > SAL_CALL PlugInFrame::queryDispatches( const Sequence< DispatchDescriptor >& seqDescripts ) throw( RuntimeException )
{
	LOG_ERROR( "PlugInFrame::queryDispatches()", "Not implemented yet!" )
	return Sequence< Reference< XDispatch > >();
}

//*****************************************************************************************************************
//   XDispatchResultListener
//*****************************************************************************************************************
void SAL_CALL PlugInFrame::dispatchFinished( const DispatchResultEvent& aEvent ) throw( RuntimeException )
{
	// Ready for multithreading
	ResetableGuard aGuard( m_aLock );

    // Loading was successful.
    if( aEvent.State == css::frame::DispatchResultState::SUCCESS )
    {
        // Then we must forward the information about finished loading to browser!
        // Send a reference to an object for scripting to browser.
        // We use these object for it, because it's the most flexibility object we can send.
        // How can recipient distinguish between loadFinished() and loadCancelled() ... ?!
        // It's easy ... on loadFinished() we send a valid reference ...
        // on loadCancelled() we do nothing!
        m_xPlugInInstancePeer->enableScripting( static_cast< OWeakObject* >( this ), impl_getFactory() );
        // Reset state for loading.
        m_bILoad            =   sal_False   ;
        m_bIHaveDocument    =   sal_True    ;
    }
    // Loading was cancelled.
    else
    {
        // Reset state for loading.
        m_bILoad            =   sal_False   ;
        m_bIHaveDocument    =   sal_False   ;
    }
    // We have the result of loading ... we can remove us as listener for status events of our dispatch helper.
    Reference< XDispatch > xDispatcher = impl_getDispatchHelper()->queryDispatch( m_aURL, DECLARE_ASCII("_self"), 0 );

    // Special mode for plugin!
    // We know the result of loading operation ... but our plugin don't know it!
    // Normaly he must be a listener on this instance ... but as a quick hack
    // we could cast it to right interface and put event to it!!!
    // => We make it because we must redesign this plugin interface too
    // and it's not clever to implement so much for obsolete things ...
    Reference< XDispatchResultListener > xForwardToPlugin( m_xPlugInWindowPeer, UNO_QUERY );
    if( xForwardToPlugin.is() == sal_True )
    {
        xForwardToPlugin->dispatchFinished( aEvent );
    }
    else
    {
        Reference< XStatusListener > xForwardToPlugin2( m_xPlugInWindowPeer, UNO_QUERY );
        if(xForwardToPlugin2.is())
        {
            FeatureStateEvent aEvent2;
            aEvent2.IsEnabled = ( aEvent.State == css::frame::DispatchResultState::SUCCESS );
            xForwardToPlugin2->statusChanged(aEvent2);
        }
    }
}

//*****************************************************************************************************************
//	 XEventListener
//*****************************************************************************************************************
void SAL_CALL PlugInFrame::disposing( const EventObject& aEvent ) throw( RuntimeException )
{
	// Ready for multithreading
	ResetableGuard aGuard( m_aLock );
	// Reset our member to default values.
	m_bILoad				=	DEFAULT_BILOAD						;
	m_bIHaveDocument		=	DEFAULT_BIHAVEDOCUMENT				;
	m_xPlugInInstancePeer	=	DEFAULT_XPLUGININSTANCEPEER			;
	m_xPlugInWindowPeer		=	DEFAULT_XPLUGINWINDOWPEER			;
	m_seqProperties			=	DEFAULT_SEQPROPERTIES				;
	m_aURL					=	DEFAULT_AURL						;
	// Don't forget to reset member of our baseclasses too!
    Frame::disposing( aEvent );
}

//*****************************************************************************************************************
//	 private method
//*****************************************************************************************************************
void PlugInFrame::impl_tryToLoadDocument()
{
	// Some things at these class working asynchron! We get all needed informations at different times.
	// If we have all informations ...
	if	(
			( m_bILoad						==	sal_False	)	&&
			( m_aURL.Complete.getLength()	>	0			)	&&
            ( impl_getContainerWindow().is()       ==  sal_True    )   &&
            ( impl_getParent().is()                ==  sal_True    )
		)
	{
		// ... we can load the specified document.
		// But first we must initialize these instance append it as child frame of our parent - the desktop!
		// Attention: Don't show our window yet. We must be READY first.
		// If method start() called at us we can show our window!

        impl_getParent()->setActiveFrame( Reference< XFrame >( static_cast< OWeakObject* >( this ), UNO_QUERY ) );

		// #110897#
		// ModifiedDocumentsWindow* pWnd = ModifiedDocumentsWindow::Get();
        ModifiedDocumentsWindow* pWnd = ModifiedDocumentsWindow::Get( impl_getFactory() );

		if ( !pWnd->TryToLoad( m_aURL.Complete, m_seqProperties, this ) )
		{
        	Reference< XDispatch > xDispatcher = impl_getDispatchHelper()->queryDispatch( m_aURL, DECLARE_ASCII("_self"), 0 );
            Reference< XNotifyingDispatch > xNotifyer( xDispatcher, css::uno::UNO_QUERY );
            if ( xNotifyer.is() )
                xNotifyer->dispatchWithNotification( m_aURL, m_seqProperties, this );
            else
            if ( xDispatcher.is() )
                xDispatcher->dispatch( m_aURL, m_seqProperties );

			// Now we have all needed informations, are a member of our frame tree and have load the document ...
			// We wait for any impl_loadFinished() calls to enable scripting at brwoser.
			// For next time we set our state to "LOADING".
			m_bILoad = sal_True;
		}
	}
	else
	{
		// Else; We don't have all neccessary informations for right working.
		m_bILoad = sal_False;
	}
}

//*****************************************************************************************************************
//	 private method
//*****************************************************************************************************************
sal_Bool PlugInFrame::impl_registerRemoteFactories( const Reference< XMultiServiceFactory >& xRemoteServiceManager )
{
    sal_Bool bRegistered = sal_False;

    Reference< XContentEnumerationAccess > xAccess( xRemoteServiceManager, UNO_QUERY );
    if( xAccess.is() == sal_True )
    {
        Reference< XEnumeration > xEnumeration = xAccess->createContentEnumeration( SERVICENAME_LOGINDIALOG );
        if( xEnumeration->hasMoreElements() == sal_True )
        {
            Any aLoginFactory = xEnumeration->nextElement();
            Reference< XSet > xSet( impl_getFactory(), UNO_QUERY );
            if(
                ( xSet.is()                == sal_True )   &&
                ( aLoginFactory.hasValue() == sal_True )
              )
            {
                try
                {
                    xSet->insert( aLoginFactory );
                    bRegistered = sal_True;
                }
                catch( Exception& )
                {
                    bRegistered = sal_True;
                }
            }
        }
    }

    return bRegistered;
}

//_________________________________________________________________________________________________________________
//	debug methods
//_________________________________________________________________________________________________________________

/*-----------------------------------------------------------------------------------------------------------------
	The follow methods checks the parameter for other functions. If a parameter or his value is non valid,
	we return "sal_False". (else sal_True) This mechanism is used to throw an ASSERT!

	ATTENTION

		If you miss a test for one of this parameters, contact the autor or add it himself !(?)
		But ... look for right testing! See using of this methods!
-----------------------------------------------------------------------------------------------------------------*/

#ifdef ENABLE_ASSERTIONS

//*****************************************************************************************************************
// We accept two arguments only and it must be reference of XPluginInstancePeer and XPluginWindowPeer for communication with the browser!
sal_Bool PlugInFrame::impldbg_checkParameter_initialize( const Sequence< Any >& seqArguments)
{
	// Set default return value.
	sal_Bool bOK = sal_True;
	// Check parameter.
	if	(
			( &seqArguments						==	NULL														)	||
			( seqArguments.getLength()			<	1															)	||
			( seqArguments.getLength()			>	3															)	||
			( seqArguments[0].getValueType()	!=	::getCppuType((const Reference< XPluginInstancePeer >*)NULL))	||
			( seqArguments[1].getValueType()	!=	::getCppuType((const Reference< XPluginWindowPeer >*)NULL)	)
		)
	{
		bOK = sal_False ;
	}
	// Return result of check.
	return bOK ;
}

//*****************************************************************************************************************
sal_Bool PlugInFrame::impldbg_checkParameter_createWindow(	const	Any&		aPlatformWindowHandle,
												   		 			sal_Bool	bEmbedded			 )
{
	// Set default return value.
	sal_Bool bOK = sal_True;
	// Check parameter.
	if	(
			( &aPlatformWindowHandle == NULL )	||
			(
				( bEmbedded	!=	sal_True	)	&&
				( bEmbedded	!=	sal_False	)
			)
		)
	{
		bOK = sal_False ;
	}
	// Return result of check.
	return bOK ;
}

//*****************************************************************************************************************
sal_Bool PlugInFrame::impldbg_checkParameter_newStream(	const	OUString&					sMIMEDescription,
														const	OUString&					sURL			,
														const	OUString&					sFilter			,
														const	Reference< XInputStream >&	xStream			)
{
	// Set default return value.
	sal_Bool bOK = sal_True;
	// Check parameter.
	if	(
			( &sMIMEDescription				==	NULL		)	||
			( &sURL							==	NULL		)	||
			( &sFilter						==	NULL		)	||
			( &xStream						==	NULL		)	||
			( sMIMEDescription.getLength()	<	1			)	||
			( sURL.getLength()				<	1			)	||
			( xStream.is()					==	sal_False	)
		)
	{
		bOK = sal_False ;
	}
	// Return result of check.
	return bOK ;
}

//*****************************************************************************************************************
sal_Bool PlugInFrame::impldbg_checkParameter_newURL(	const	OUString&	sMIMEDescription,
														const	OUString&	sURL			,
														const	OUString&	sFilter			)
{
	// Set default return value.
	sal_Bool bOK = sal_True;
	// Check parameter.
	if	(
			( &sMIMEDescription				==	NULL		)	||
			( &sURL							==	NULL		)	||
			( &sFilter						==	NULL		)	||
			( sMIMEDescription.getLength()	<	1			)	||
			( sURL.getLength()				<	1			)
		)
	{
		bOK = sal_False ;
	}
	// Return result of check.
	return bOK ;
}

//*****************************************************************************************************************
// These variables are "out" parameter! Check for valid pointer only - not for valid values!
sal_Bool PlugInFrame::impldbg_checkParameter_getHttpServerURL(		OUString&	sHost	,
																	sal_uInt16&	nPort	,
																	OUString&	sPrefix	)
{
	// Set default return value.
	sal_Bool bOK = sal_True;
	// Check parameter.
	if	(
			( &sHost	==	NULL	)	||
			( &nPort	==	NULL	)	||
			( &sPrefix	==	NULL	)
		)
	{
		bOK = sal_False ;
	}
	// Return result of check.
	return bOK ;
}

//*****************************************************************************************************************
sal_Bool PlugInFrame::impldbg_checkParameter_queryDispatch(	const	URL&	 	aURL			,
															const	OUString&	sTargetFrameName,
																	sal_Int32	nSearchFlags	)
{
	// Set default return value.
	sal_Bool bOK = sal_True;
	// Check parameter.
	if	(
			( &aURL							==	NULL		)	||
			( aURL.Complete.getLength()		<	1			)	||
			( &sTargetFrameName				==	NULL		)	||
			// sTargetFrameName can be ""!
			(
				( 	 nSearchFlags != FrameSearchFlag::AUTO		  )	&&
				( !( nSearchFlags &  FrameSearchFlag::PARENT	) )	&&
				( !( nSearchFlags &  FrameSearchFlag::SELF		) )	&&
				( !( nSearchFlags &  FrameSearchFlag::CHILDREN	) )	&&
				( !( nSearchFlags &  FrameSearchFlag::CREATE	) )	&&
				( !( nSearchFlags &  FrameSearchFlag::SIBLINGS	) )	&&
				( !( nSearchFlags &  FrameSearchFlag::TASKS		) )	&&
				( !( nSearchFlags &  FrameSearchFlag::ALL		) )	&&
				( !( nSearchFlags &  FrameSearchFlag::GLOBAL	) )
			)
		)
	{
		bOK = sal_False ;
	}
	// Return result of check.
	return bOK ;
}

//*****************************************************************************************************************
sal_Bool PlugInFrame::impldbg_checkParameter_queryDispatches( const Sequence< DispatchDescriptor >& seqDescriptor )
{
	// Set default return value.
	sal_Bool bOK = sal_True;

	// Check parameter.
	if	(
			( &seqDescriptor			==	NULL	)	||
			( seqDescriptor.getLength()	<	1		)
		)
	{
		bOK = sal_False ;
	}

	// Return result of check.
	return bOK ;
}

//*****************************************************************************************************************
sal_Bool PlugInFrame::impldbg_checkParameter_statusChanged( const FeatureStateEvent& aEvent )
{
	// Set default return value.
	sal_Bool bOK = sal_True;
	// Check parameter.
	if	(
			( &aEvent								==	NULL	)	||
			( aEvent.FeatureDescriptor.getLength()	<	1		)
		)
	{
		bOK = sal_False ;
	}
	// Return result of check.
	return bOK ;
}

//*****************************************************************************************************************
sal_Bool PlugInFrame::impldbg_checkParameter_disposing( const EventObject& aEvent )
{
	// Set default return value.
	sal_Bool bOK = sal_True;
	// Check parameter.
	if	(
			( &aEvent				==	NULL		)	||
			( aEvent.Source.is()	==	sal_False	)
		)
	{
		bOK = sal_False ;
	}
	// Return result of check.
	return bOK ;
}
/*OBSOLETE
//*****************************************************************************************************************
sal_Bool PlugInFrame::impldbg_checkParameter_registerDispatchProviderInterceptor( const Reference< XDispatchProviderInterceptor >& xInterceptor )
{
	// Set default return value.
	sal_Bool bOK = sal_True;
	// Check parameter.
	if	(
			( &xInterceptor		==	NULL		)	||
			( xInterceptor.is()	==	sal_False	)
		)
	{
		bOK = sal_False ;
	}
	// Return result of check.
	return bOK ;
}

//*****************************************************************************************************************
sal_Bool PlugInFrame::impldbg_checkParameter_releaseDispatchProviderInterceptor( const Reference< XDispatchProviderInterceptor >& xInterceptor )
{
	// Set default return value.
	sal_Bool bOK = sal_True;
	// Check parameter.
	if	(
			( &xInterceptor		==	NULL		)	||
			( xInterceptor.is()	==	sal_False	)
		)
	{
		bOK = sal_False ;
	}
	// Return result of check.
	return bOK ;
}
*/
#endif	//	#ifdef ENABLE_ASSERTIONS

}		//	namespace framework
