/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: pcrservices.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 20:21:24 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _EXTENSIONS_PROPCTRLR_MODULEPRC_HXX_
#include "modulepcr.hxx"
#endif

//---------------------------------------------------------------------------------------

using namespace ::rtl;
using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::lang;
using namespace ::com::sun::star::registry;

//---------------------------------------------------------------------------------------

extern "C" void SAL_CALL createRegistryInfo_OPropertyBrowserController();
extern "C" void SAL_CALL createRegistryInfo_OControlFontDialog();
extern "C" void SAL_CALL createRegistryInfo_OTabOrderDialog();

//---------------------------------------------------------------------------------------

extern "C" void SAL_CALL dbi_initializeModule()
{
	static sal_Bool s_bInit = sal_False;
	if (!s_bInit)
	{
		createRegistryInfo_OPropertyBrowserController();
		createRegistryInfo_OControlFontDialog();
        createRegistryInfo_OTabOrderDialog();
		::pcr::OModule::setResourceFilePrefix("pcr");
		s_bInit = sal_True;
	}
}

//---------------------------------------------------------------------------------------

extern "C" void SAL_CALL component_getImplementationEnvironment(
				const sal_Char	**ppEnvTypeName,
				uno_Environment	**ppEnv
			)
{
	dbi_initializeModule();
	*ppEnvTypeName = CPPU_CURRENT_LANGUAGE_BINDING_NAME;
}

//---------------------------------------------------------------------------------------
extern "C" sal_Bool SAL_CALL component_writeInfo(
				void* pServiceManager,
				void* pRegistryKey
			)
{
	if (pRegistryKey) 
	try 
	{
		return ::pcr::OModule::writeComponentInfos(
			static_cast<XMultiServiceFactory*>(pServiceManager),
			static_cast<XRegistryKey*>(pRegistryKey));
	}
	catch (InvalidRegistryException& )
	{
		OSL_ASSERT("pcr::component_writeInfo: could not create a registry key (InvalidRegistryException) !");
	}

	return sal_False;
}

//---------------------------------------------------------------------------------------
extern "C" void* SAL_CALL component_getFactory(
					const sal_Char* pImplementationName,
					void* pServiceManager,
					void* pRegistryKey)
{
	Reference< XInterface > xRet;
	if (pServiceManager && pImplementationName)
	{
		xRet = ::pcr::OModule::getComponentFactory(
			::rtl::OUString::createFromAscii(pImplementationName),
			static_cast< XMultiServiceFactory* >(pServiceManager));
	}

	if (xRet.is())
		xRet->acquire();
	return xRet.get();
};

