/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: querydesignaccess.cxx,v $
 *
 *  $Revision: 1.18 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 16:16:28 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _DBAUI_QUERYDESIGNACCESS_HXX_
#include "querydesignaccess.hxx"
#endif
#ifndef _OSL_DIAGNOSE_H_
#include <osl/diagnose.h>
#endif
#ifndef DBACCESS_SHARED_DBUSTRINGS_HRC
#include "dbustrings.hrc"
#endif
#ifndef _COM_SUN_STAR_FRAME_XDISPATCHPROVIDER_HPP_
#include <com/sun/star/frame/XDispatchProvider.hpp>
#endif
#ifndef _COM_SUN_STAR_FRAME_XFRAME_HPP_
#include <com/sun/star/frame/XFrame.hpp>
#endif
#ifndef _COM_SUN_STAR_FRAME_XFRAMES_HPP_
#include <com/sun/star/frame/XFrames.hpp>
#endif
#ifndef _COM_SUN_STAR_FRAME_FRAMESEARCHFLAG_HPP_
#include <com/sun/star/frame/FrameSearchFlag.hpp>
#endif
#ifndef _COM_SUN_STAR_SDB_COMMANDTYPE_HPP_
#include <com/sun/star/sdb/CommandType.hpp>
#endif
#ifndef _COMPHELPER_EXTRACT_HXX_
#include <comphelper/extract.hxx>
#endif
#ifndef _COMPHELPER_SEQUENCE_HXX_
#include <comphelper/sequence.hxx>
#endif
#ifndef DBAUI_COMPONENTCLIENTMONITOR_HXX
#include "componentclientmonitor.hxx"
#endif
#ifndef _CONNECTIVITY_DBTOOLS_HXX_
#include <connectivity/dbtools.hxx>
#endif

// .........................................................................
namespace dbaui
{
// .........................................................................

	using namespace ::com::sun::star::uno;
	using namespace ::com::sun::star::sdbc;
	using namespace ::com::sun::star::sdb;
	using namespace ::com::sun::star::frame;
	using namespace ::com::sun::star::lang;
	using namespace ::com::sun::star::beans;

	//======================================================================
	//= ODesignAccess
	//======================================================================
	ODesignAccess::ODesignAccess(const Reference< XMultiServiceFactory >& _rxORB
								,const Reference< XComponentLoader >& _xFrameLoader)
		:m_xORB(_rxORB)
		,m_xFrameLoader(_xFrameLoader)
	{
		OSL_ENSURE(m_xORB.is(), "ODesignAccess::ODesignAccess: invalid service factory!");
	}

	//----------------------------------------------------------------------
	Reference< XComponent > ODesignAccess::create(const Reference< XDataSource >& _xDataSource, const Reference< XConnection >& _rxConnection)
	{
		Sequence< PropertyValue > aArguments;
		fill( aArguments, makeAny(_xDataSource), _rxConnection,::rtl::OUString() );
		return doDispatch( aArguments );
	}

	//----------------------------------------------------------------------
	Reference< XComponent > ODesignAccess::create(const Reference< XDataSource >& _xDataSource, const ::vos::ORef< OComponentClientMonitor >& _rClientMonitor)
	{
		OSL_ENSURE( _rClientMonitor.isValid(), "ODesignAccess::create: invalid monitor!" );
		Reference< XComponent > xReturn;

		if ( _rClientMonitor.isValid() )
		{
			Reference< XConnection > xConn( _rClientMonitor->getComponent(), UNO_QUERY );
			OSL_ENSURE( xConn.is(), "ODesignAccess::create: invalid connection!" );

			xReturn = create( _xDataSource, xConn );
			if ( xReturn.is() )
				_rClientMonitor->registerClient( xReturn );
		}

		return xReturn;
	}

	//----------------------------------------------------------------------
	Reference< XComponent > ODesignAccess::doDispatch( const Sequence< PropertyValue >& _rArgs )
	{
		Reference< XComponent > xReturn;
		if ( m_xORB.is() )
		{
			try
			{
				// get the desktop object
				sal_Int32 nFrameSearchFlag = FrameSearchFlag::SELF;
				::rtl::OUString sTarget(RTL_CONSTASCII_USTRINGPARAM("_self"));
				if ( !m_xFrameLoader.is() )
				{
					m_xFrameLoader.set(m_xORB->createInstance(SERVICE_FRAME_DESKTOP),UNO_QUERY);
					nFrameSearchFlag = FrameSearchFlag::TASKS | FrameSearchFlag::CREATE;
					sTarget = ::rtl::OUString(RTL_CONSTASCII_USTRINGPARAM("_blank"));
				}

				OSL_ENSURE(m_xFrameLoader.is(), "ODesignAccess::doDispatch: invalid desktop object!");

				if ( m_xFrameLoader.is() )
				{
					// create a new frame and remove it from the desktop, so we care for it
					Reference<XFrame> xFrame = Reference<XFrame>(m_xFrameLoader,UNO_QUERY)->findFrame(sTarget,nFrameSearchFlag);
					Reference<XFramesSupplier> xSup(m_xFrameLoader,UNO_QUERY);
					if ( xSup.is() )
					{
						Reference<XFrames> xFrames = xSup->getFrames();
						xFrames->remove(xFrame);
					}

					Reference<XComponentLoader> xFrameLoad(xFrame,UNO_QUERY);
					if ( xFrameLoad.is() )
					{
						xReturn = xFrameLoad->loadComponentFromURL(
							getDispatchURL(),
							::rtl::OUString(RTL_CONSTASCII_USTRINGPARAM("_self")),
							FrameSearchFlag::SELF,
							_rArgs
						);
						if ( xReturn.is() )
							xReturn.set(xFrame,UNO_QUERY);
					}
				}
			}
			catch(Exception&)
			{
				OSL_ENSURE(sal_False, "ODesignAccess::getDispatcher: caught an exception while loading the component!");
			}
		}
		return xReturn;
	}

	//----------------------------------------------------------------------
	Reference< XComponent > ODesignAccess::edit(const ::com::sun::star::uno::Any& _aDataSource, const ::rtl::OUString& _rName, const Reference< XConnection >& _rxConnection,const Sequence< PropertyValue >& _rArgs)
	{
		Sequence< PropertyValue > aArguments;
		fill(aArguments, _aDataSource, _rxConnection, _rName);
		return doDispatch( ::comphelper::concatSequences(aArguments,_rArgs));
	}

	//----------------------------------------------------------------------
	Reference< XComponent > ODesignAccess::edit(const ::com::sun::star::uno::Any& _aDataSource, const ::rtl::OUString& _rName, const ::vos::ORef< OComponentClientMonitor >& _rClientMonitor,const Sequence< PropertyValue >& _rArgs)
	{
		OSL_ENSURE( _rClientMonitor.isValid(), "ODesignAccess::edit: invalid monitor!" );
		Reference< XComponent > xReturn;

		if ( _rClientMonitor.isValid() )
		{
			Reference< XConnection > xConn( _rClientMonitor->getComponent(), UNO_QUERY );
			OSL_ENSURE( xConn.is(), "ODesignAccess::edit: invalid connection!" );

			xReturn = edit( _aDataSource, _rName, xConn ,_rArgs);
			if ( xReturn.is() )
				_rClientMonitor->registerClient( xReturn );
		}

		return xReturn;
	}
	//----------------------------------------------------------------------
	void ODesignAccess::fill(
			Sequence< PropertyValue >& _rDispatchArguments,
			const Any& _aDataSource,
			const Reference< XConnection >& _rxConnection,
			const ::rtl::OUString& _rName
		)
	{
		sal_Int32 nPos = _rDispatchArguments.getLength();
		_rDispatchArguments.realloc( (_rxConnection.is() ? 2 : 1));
		
		::rtl::OUString sDataSource;
		Reference<XDataSource> xDataSource;
		if ( _aDataSource >>= sDataSource )
		{
			_rDispatchArguments[nPos  ].Name = PROPERTY_DATASOURCENAME;
			_rDispatchArguments[nPos++].Value <<= sDataSource;
		}
		else if ( _aDataSource >>= xDataSource )
		{
			_rDispatchArguments[nPos  ].Name = PROPERTY_DATASOURCE;
			_rDispatchArguments[nPos++].Value <<= xDataSource;
		}

		if (_rxConnection.is())
		{
			_rDispatchArguments[nPos  ].Name = PROPERTY_ACTIVECONNECTION;
			_rDispatchArguments[nPos++].Value <<= _rxConnection;
		}

	}

	//======================================================================
	//= OQueryDesignAccess
	//======================================================================
	//----------------------------------------------------------------------
	OQueryDesignAccess::OQueryDesignAccess(const Reference< XMultiServiceFactory >& _rxORB
											, sal_Bool _bCreateView
											, sal_Bool _bPreferSQLView
											,const Reference< XComponentLoader >& _xFrameLoader)
		:ODesignAccess(_rxORB,_xFrameLoader)
		,m_bCreateView(_bCreateView)
		,m_bPreferSQLView(_bPreferSQLView)
	{
	}

	//----------------------------------------------------------------------
	::rtl::OUString OQueryDesignAccess::getDispatchURL() const
	{
		return static_cast< ::rtl::OUString>(URL_COMPONENT_QUERYDESIGN);
	}

	//----------------------------------------------------------------------
	void OQueryDesignAccess::fill(Sequence< PropertyValue >& _rDispatchArguments, const Any& _aDataSource,
		const Reference< XConnection >& _rxConnection, const ::rtl::OUString& _rQueryName)
	{
		ODesignAccess::fill(_rDispatchArguments,_aDataSource,_rxConnection,_rQueryName);

		sal_Bool bIncludeQueryName = 0 != _rQueryName.getLength();

		sal_Int32 nPos = _rDispatchArguments.getLength();
		_rDispatchArguments.realloc(_rDispatchArguments.getLength() + 2 + (bIncludeQueryName ? 1 : 0) );
		

		_rDispatchArguments[nPos  ].Name = PROPERTY_QUERYDESIGNVIEW;
		_rDispatchArguments[nPos++].Value <<= ::cppu::bool2any(!m_bPreferSQLView);

		_rDispatchArguments[nPos  ].Name = PROPERTY_CREATEVIEW;
		_rDispatchArguments[nPos++].Value <<= ::cppu::bool2any(m_bCreateView);

		if (bIncludeQueryName)
		{
			_rDispatchArguments[nPos  ].Name = PROPERTY_CURRENTQUERY;
			_rDispatchArguments[nPos++].Value <<= _rQueryName;
		}
	}

	//======================================================================
	//= OTableDesignAccess
	//======================================================================
	//----------------------------------------------------------------------
	OTableDesignAccess::OTableDesignAccess(const Reference< XMultiServiceFactory >& _rxORB
											,const Reference< XComponentLoader >& _xFrameLoader)
		: ODesignAccess(_rxORB,_xFrameLoader)
	{
	}

	//----------------------------------------------------------------------
	::rtl::OUString OTableDesignAccess::getDispatchURL() const
	{
		return static_cast< ::rtl::OUString>(URL_COMPONENT_TABLEDESIGN);
	}

	//----------------------------------------------------------------------
	void OTableDesignAccess::fill(Sequence< PropertyValue >& _rDispatchArguments, const Any& _aDataSource,
		const Reference< XConnection >& _rxConnection, const ::rtl::OUString& _rTableName)
	{
		ODesignAccess::fill(_rDispatchArguments,_aDataSource,_rxConnection,_rTableName);
		sal_Bool bIncludeName = 0 != _rTableName.getLength();

		if (bIncludeName)
		{
			sal_Int32 nPos = _rDispatchArguments.getLength();
			_rDispatchArguments.realloc(_rDispatchArguments.getLength() + 1);
			_rDispatchArguments[nPos  ].Name = PROPERTY_CURRENTTABLE;
			_rDispatchArguments[nPos++].Value <<= _rTableName;
		}
	}
	//======================================================================
	//= OTableAccess
	//======================================================================
	//----------------------------------------------------------------------
	OTableAccess::OTableAccess(const Reference< XMultiServiceFactory >& _rxORB
								,sal_Bool _bTable
								,const Reference< XComponentLoader >& _xFrameLoader)
		: ODesignAccess(_rxORB,_xFrameLoader)
		,m_bTable(_bTable)
	{
	}

	//----------------------------------------------------------------------
	::rtl::OUString OTableAccess::getDispatchURL() const
	{
		return static_cast < ::rtl::OUString>(URL_COMPONENT_DATASOURCEBROWSER);
	}
	//----------------------------------------------------------------------
	void OTableAccess::fill(Sequence< PropertyValue >& _rDispatchArguments, const Any& _aDataSource,
		const Reference< XConnection >& _rxConnection, const ::rtl::OUString& _rQualifiedName)
	{
		ODesignAccess::fill(_rDispatchArguments,_aDataSource,_rxConnection,_rQualifiedName);
		OSL_ENSURE( 0 != _rQualifiedName.getLength(),"A Table name must be set");
		::rtl::OUString sCatalog;
		::rtl::OUString sSchema;
		::rtl::OUString sTable;
		if ( m_bTable )
		{
			OSL_ENSURE(_rxConnection.is(),"Connection must be set! -> GPF");
			::dbtools::qualifiedNameComponents(_rxConnection->getMetaData(),_rQualifiedName,sCatalog,sSchema,sTable,::dbtools::eInDataManipulation);
		}

		sal_Int32 nPos = _rDispatchArguments.getLength();
		_rDispatchArguments.realloc( _rDispatchArguments.getLength() + 4 + (m_bTable ? 3 : 0) );
		
		_rDispatchArguments[nPos  ].Name = PROPERTY_COMMANDTYPE;
		_rDispatchArguments[nPos++].Value <<= (m_bTable ? CommandType::TABLE : CommandType::QUERY);

		_rDispatchArguments[nPos  ].Name = PROPERTY_COMMAND;
		_rDispatchArguments[nPos++].Value <<= _rQualifiedName;

		_rDispatchArguments[nPos  ].Name = PROPERTY_SHOWTREEVIEW;
		_rDispatchArguments[nPos++].Value <<= sal_False;

		_rDispatchArguments[nPos  ].Name = PROPERTY_SHOWTREEVIEWBUTTON;
		_rDispatchArguments[nPos++].Value <<= sal_False;

		if ( m_bTable )
		{
			_rDispatchArguments[nPos  ].Name = PROPERTY_UPDATE_CATALOGNAME;
			_rDispatchArguments[nPos++].Value <<= sCatalog;
			_rDispatchArguments[nPos  ].Name = PROPERTY_UPDATE_SCHEMANAME;
			_rDispatchArguments[nPos++].Value <<= sSchema;
			_rDispatchArguments[nPos  ].Name = PROPERTY_UPDATE_TABLENAME;
			_rDispatchArguments[nPos++].Value <<= sTable;
		}

	}
	//======================================================================
	//= ORelationDesignAccess
	//======================================================================
	//----------------------------------------------------------------------
	ORelationDesignAccess::ORelationDesignAccess(const Reference< XMultiServiceFactory >& _rxORB)	: ODesignAccess(_rxORB)
	{
	}

	//----------------------------------------------------------------------
	::rtl::OUString ORelationDesignAccess::getDispatchURL() const
	{
		return static_cast< ::rtl::OUString>(URL_COMPONENT_RELATIONDESIGN);
	}

	//----------------------------------------------------------------------
	void ORelationDesignAccess::fill(Sequence< PropertyValue >& _rDispatchArguments, const Any& _aDataSource,
		const Reference< XConnection >& _rxConnection, const ::rtl::OUString& _rTableName)
	{
		ODesignAccess::fill(_rDispatchArguments,_aDataSource,_rxConnection,_rTableName);
	}

// .........................................................................
}	// namespace dbaui
// .........................................................................

