/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: comp_propertysetmixin.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 02:42:20 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#include "sal/config.h"

#include "test/comphelper/propertysetmixin/XSupplier.hpp"
#include "test/comphelper/propertysetmixin/XTest3.hpp"

#include "com/sun/star/beans/Ambiguous.hpp"
#include "com/sun/star/beans/Defaulted.hpp"
#include "com/sun/star/beans/Optional.hpp"
#include "com/sun/star/beans/PropertyVetoException.hpp"
#include "com/sun/star/beans/UnknownPropertyException.hpp"
#include "com/sun/star/lang/XComponent.hpp"
#include "comphelper/propertysetmixin.hxx"
#include "cppuhelper/factory.hxx"
#include "cppuhelper/implbase1.hxx"
#include "cppuhelper/implementationentry.hxx"
#include "cppuhelper/queryinterface.hxx"
#include "cppuhelper/weak.hxx"
#include "com/sun/star/uno/Any.hxx"
#include "com/sun/star/uno/Exception.hpp"
#include "com/sun/star/uno/Reference.hxx"
#include "com/sun/star/uno/RuntimeException.hpp"
#include "com/sun/star/uno/Sequence.hxx"
#include "com/sun/star/uno/Type.hxx"
#include "com/sun/star/uno/XComponentContext.hpp"
#include "com/sun/star/uno/XInterface.hpp"
#include "osl/mutex.hxx"
#include "rtl/ustring.h"
#include "rtl/ustring.hxx"
#include "sal/types.h"
#include "uno/lbnames.h"

namespace com { namespace sun { namespace star {
    class XEventListener;
} } }

namespace css = com::sun::star;

namespace {

class Empty1:
    public cppu::OWeakObject, public css::lang::XComponent,
    public comphelper::PropertySetMixin< css::lang::XComponent >
{
public:
    explicit Empty1(
        css::uno::Reference< css::uno::XComponentContext > const & context):
        comphelper::PropertySetMixin< css::lang::XComponent >(
            context, static_cast< Implements >(0))
    {}

    virtual css::uno::Any SAL_CALL queryInterface(css::uno::Type const & type)
        throw (css::uno::RuntimeException);

    virtual void SAL_CALL acquire() throw () { OWeakObject::acquire(); }

    virtual void SAL_CALL release() throw () { OWeakObject::release(); }

    virtual void SAL_CALL dispose() throw (css::uno::RuntimeException) {
        comphelper::PropertySetMixin< css::lang::XComponent >::dispose();
    }

    virtual void SAL_CALL addEventListener(
        css::uno::Reference< css::lang::XEventListener > const &)
        throw (css::uno::RuntimeException)
    {}

    virtual void SAL_CALL removeEventListener(
        css::uno::Reference< css::lang::XEventListener > const &)
        throw (css::uno::RuntimeException)
    {}

private:
    Empty1(Empty1 &); // not defined
    void operator =(Empty1 &); // not defined

    virtual ~Empty1() {}
};

css::uno::Any Empty1::queryInterface(css::uno::Type const & type)
    throw (css::uno::RuntimeException)
{
    css::uno::Any a(OWeakObject::queryInterface(type));
    if (a.hasValue()) {
        return a;
    }
    a = cppu::queryInterface(
        type, static_cast< css::lang::XComponent * >(this));
    return a.hasValue()
        ? a
        : comphelper::PropertySetMixin< css::lang::XComponent >::queryInterface(
            type);
}

class Empty2:
    public cppu::OWeakObject, public css::lang::XComponent,
    public comphelper::PropertySetMixin< css::lang::XComponent >
{
public:
    explicit Empty2(
        css::uno::Reference< css::uno::XComponentContext > const & context):
        comphelper::PropertySetMixin< css::lang::XComponent >(
            context,
            static_cast< Implements >(
                IMPLEMENTS_PROPERTY_SET | IMPLEMENTS_FAST_PROPERTY_SET
                | IMPLEMENTS_PROPERTY_ACCESS))
    {}

    virtual css::uno::Any SAL_CALL queryInterface(css::uno::Type const & type)
        throw (css::uno::RuntimeException);

    virtual void SAL_CALL acquire() throw () { OWeakObject::acquire(); }

    virtual void SAL_CALL release() throw () { OWeakObject::release(); }

    virtual void SAL_CALL dispose() throw (css::uno::RuntimeException) {
        comphelper::PropertySetMixin< css::lang::XComponent >::dispose();
    }

    virtual void SAL_CALL addEventListener(
        css::uno::Reference< css::lang::XEventListener > const &)
        throw (css::uno::RuntimeException)
    {}

    virtual void SAL_CALL removeEventListener(
        css::uno::Reference< css::lang::XEventListener > const &)
        throw (css::uno::RuntimeException)
    {}

private:
    Empty2(Empty2 &); // not defined
    void operator =(Empty2 &); // not defined

    virtual ~Empty2() {}
};

css::uno::Any Empty2::queryInterface(css::uno::Type const & type)
    throw (css::uno::RuntimeException)
{
    css::uno::Any a(OWeakObject::queryInterface(type));
    if (a.hasValue()) {
        return a;
    }
    a = cppu::queryInterface(
        type, static_cast< css::lang::XComponent * >(this));
    return a.hasValue()
        ? a
        : comphelper::PropertySetMixin< css::lang::XComponent >::queryInterface(
            type);
}

class Full:
    public cppu::OWeakObject, public test::comphelper::propertysetmixin::XTest3,
    public comphelper::PropertySetMixin<
    test::comphelper::propertysetmixin::XTest3 >
{
public:
    explicit Full(
        css::uno::Reference< css::uno::XComponentContext > const & context):
        comphelper::PropertySetMixin<
        test::comphelper::propertysetmixin::XTest3 >(
            context,
            static_cast< Implements >(
                IMPLEMENTS_PROPERTY_SET | IMPLEMENTS_FAST_PROPERTY_SET
                | IMPLEMENTS_PROPERTY_ACCESS)),
        m_a1(0),
        m_a2(
            css::beans::Defaulted< css::beans::Optional< sal_Int32 > >(
                css::beans::Optional< sal_Int32 >(), true),
            false)
    {}

    virtual css::uno::Any SAL_CALL queryInterface(css::uno::Type const & type)
        throw (css::uno::RuntimeException);

    virtual void SAL_CALL acquire() throw () { OWeakObject::acquire(); }

    virtual void SAL_CALL release() throw () { OWeakObject::release(); }

    virtual sal_Int32 SAL_CALL getA1() throw (css::uno::RuntimeException);

    virtual void SAL_CALL setA1(sal_Int32 value)
        throw (css::uno::RuntimeException);

    virtual
    css::beans::Ambiguous<
        css::beans::Defaulted< css::beans::Optional< sal_Int32 > > >
    SAL_CALL getA2()
        throw (
            css::beans::UnknownPropertyException, css::uno::RuntimeException);

    virtual void SAL_CALL setA2(
        css::beans::Ambiguous<
        css::beans::Defaulted< css::beans::Optional< ::sal_Int32 > > > const &
        value)
        throw (
            css::beans::PropertyVetoException,
            css::beans::UnknownPropertyException, css::uno::RuntimeException);

private:
    Full(Full &); // not defined
    void operator =(Full &); // not defined

    virtual ~Full() {}

    osl::Mutex m_mutex;
    sal_Int32 m_a1;
    css::beans::Ambiguous<
        css::beans::Defaulted< css::beans::Optional< sal_Int32 > > > m_a2;
};

css::uno::Any Full::queryInterface(css::uno::Type const & type)
    throw (css::uno::RuntimeException)
{
    css::uno::Any a(OWeakObject::queryInterface(type));
    if (a.hasValue()) {
        return a;
    }
    a = cppu::queryInterface(
        type,
        static_cast< test::comphelper::propertysetmixin::XTest3 * >(this));
    return a.hasValue()
        ? a
        : (comphelper::PropertySetMixin<
           test::comphelper::propertysetmixin::XTest3 >::queryInterface(
               type));
}

sal_Int32 Full::getA1() throw (css::uno::RuntimeException) {
    osl::MutexGuard g(m_mutex);
    return m_a1;
}

void Full::setA1(sal_Int32 value) throw (css::uno::RuntimeException) {
    prepareSet(
        rtl::OUString(RTL_CONSTASCII_USTRINGPARAM("A1")), css::uno::Any(), 0);
    osl::MutexGuard g(m_mutex);
    m_a1 = value;
}

css::beans::Ambiguous<
    css::beans::Defaulted< css::beans::Optional< sal_Int32 > > >
Full::getA2()
    throw (css::beans::UnknownPropertyException, css::uno::RuntimeException)
{
    osl::MutexGuard g(m_mutex);
    return m_a2;
}

void Full::setA2(
    css::beans::Ambiguous<
    css::beans::Defaulted< css::beans::Optional< ::sal_Int32 > > > const &
    value)
    throw (
        css::beans::PropertyVetoException, css::beans::UnknownPropertyException,
        css::uno::RuntimeException)
{
    css::uno::Any v;
    if (value.Value.Value.IsPresent) {
        v <<= value.Value.Value.Value;
    }
    BoundListeners l;
    prepareSet(rtl::OUString(RTL_CONSTASCII_USTRINGPARAM("A1")), v, &l);
    {
        osl::MutexGuard g(m_mutex);
        m_a2 = value;
    }
    l.notify();
}

class Supplier:
    public cppu::WeakImplHelper1<
    test::comphelper::propertysetmixin::XSupplier >
{
public:
    explicit Supplier(
        css::uno::Reference< css::uno::XComponentContext > const & context):
        m_context(context) {}

    virtual css::uno::Reference< css::lang::XComponent > SAL_CALL getEmpty1()
        throw (css::uno::RuntimeException)
    { return new Empty1(m_context); }

    virtual css::uno::Reference< css::lang::XComponent > SAL_CALL getEmpty2()
        throw (css::uno::RuntimeException)
    { return new Empty2(m_context); }

    virtual css::uno::Reference< test::comphelper::propertysetmixin::XTest3 >
    SAL_CALL getFull() throw (css::uno::RuntimeException)
    { return new Full(m_context); }

private:
    Supplier(Supplier &); // not defined
    void operator =(Supplier &); // not defined

    virtual ~Supplier() {}

    css::uno::Reference< css::uno::XComponentContext > m_context;
};

css::uno::Reference< css::uno::XInterface > SAL_CALL create(
    css::uno::Reference< css::uno::XComponentContext > const & context)
    SAL_THROW((css::uno::Exception))
{
    return static_cast< cppu::OWeakObject * >(new Supplier(context));
}

rtl::OUString SAL_CALL getImplementationName() {
    return rtl::OUString(
        RTL_CONSTASCII_USTRINGPARAM(
            "test.comphelper.propertysetmixin.comp.CppSupplier"));
}

css::uno::Sequence< rtl::OUString > SAL_CALL getSupportedServiceNames() {
    css::uno::Sequence< rtl::OUString > s(1);
    s[0] = rtl::OUString(
        RTL_CONSTASCII_USTRINGPARAM(
            "test.comphelper.propertysetmixin.CppSupplier"));
    return s;
}

cppu::ImplementationEntry entries[] = {
    { &create, &getImplementationName, &getSupportedServiceNames,
      &cppu::createSingleComponentFactory, 0, 0 } };

}

extern "C" void * SAL_CALL component_getFactory(
    char const * implName, void * serviceManager, void * registryKey)
{
    return cppu::component_getFactoryHelper(
        implName, serviceManager, registryKey, entries);
}

extern "C" void SAL_CALL component_getImplementationEnvironment(
    char const ** envTypeName, uno_Environment **)
{
    *envTypeName = CPPU_CURRENT_LANGUAGE_BINDING_NAME;
}

extern "C" sal_Bool SAL_CALL component_writeInfo(
    void * serviceManager, void * registryKey)
{
    return cppu::component_writeInfoHelper(
        serviceManager, registryKey, entries);
}
