/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: ChartView.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 00:48:32 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef _CHART2_CHARTVIEW_HXX
#define _CHART2_CHARTVIEW_HXX

#include "chartview/ExplicitValueProvider.hxx"

#ifndef _COM_SUN_STAR_FRAME_XMODEL_HPP_
#include <com/sun/star/frame/XModel.hpp>
#endif
#ifndef _COM_SUN_STAR_UNO_XCOMPONENTCONTEXT_HPP_
#include <com/sun/star/uno/XComponentContext.hpp>
#endif
#ifndef _COM_SUN_STAR_DRAWING_XDRAWPAGESSUPPLIER_HPP_
#include <com/sun/star/drawing/XDrawPagesSupplier.hpp>
#endif

//.............................................................................
namespace chart
{
//.............................................................................

class NumberFormatterWrapper;

//-----------------------------------------------------------------------------
/** The ChartView is responsible to manage the generation of Drawing Objects
for visualization on a given OutputDevice. It is furthermore responsible to
keep this Objects up to date according to changes of the underlying ChartModel.

It is not responsible to handle single user events (what is instead done by the ChartWindow).
*/
class ChartView : public ExplicitValueProvider
{
public:
    virtual ~ChartView();

	virtual bool create( const ::com::sun::star::awt::Size& rPageSize )=0;

    static ChartView* createView(
                 const ::com::sun::star::uno::Reference<
                       ::com::sun::star::uno::XComponentContext >& xCC
               , const ::com::sun::star::uno::Reference<
                       ::com::sun::star::frame::XModel >& xChartModel
               , const ::com::sun::star::uno::Reference<
                       ::com::sun::star::drawing::XDrawPagesSupplier>& xDrawPagesSuplier
               , NumberFormatterWrapper* pNumberFormatterWrapper );
};

//.............................................................................
} //namespace chart
//.............................................................................

#endif
