/* libwpd
 * Copyright (C) 2002 William Lachance (wrlach@gmail.com)
 * Copyright (C) 2002 Marc Maurer (uwog@uwog.net)
 *  
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 *
 * For further information visit http://libwpd.sourceforge.net
 */

/* "This product is not manufactured, approved, or supported by 
 * Corel Corporation or Corel Corporation Limited."
 */

#ifndef _WP6HEADER_H
#define _WP6HEADER_H

#include "WPXHeader.h"

class WP6Header : public WPXHeader
{
 public:
	WP6Header(WPXInputStream * input, WPXEncryption *encryption, uint32_t documentOffset, uint8_t productType,
		uint8_t fileType, uint8_t majorVersion, uint8_t minorVersion, uint16_t documentEncryption);
	virtual ~WP6Header() {};
	
	uint16_t getIndexHeaderOffset() const { return m_indexHeaderOffset; }
	uint16_t getNumPrefixIndices() const { return m_numPrefixIndices; }

protected:
	void _readIndexInformation(WPXInputStream *input, WPXEncryption *encryption);
		
private:
	uint16_t m_indexHeaderOffset;
	uint16_t m_numPrefixIndices;
};
#endif /* _WP6HEADER_H  */
