/*
 * Copyright (C) 2011 Canonical, Ltd.
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License
 * version 3.0 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3.0 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see
 * <http://www.gnu.org/licenses/>.
 *
 * Authored by Neil Jagdish Patel <neil.patel@canonical.com>
 *
 */

using GLib;
using Dee;

namespace Unity.Protocol {

/* The raw structs that get's passed over DBus to/from the parent Lens */
public struct ScopeInfo
{
  public string dbus_path;
  public Variant sources;
  public bool search_in_global;
  public string private_connection_name;
  public string results_model_name;
  public string global_results_model_name;
  public string filters_model_name;
  public HashTable<string, Variant> hints;
}

public struct ActivationReplyRaw
{
  public string uri;
  public uint handled;
  public HashTable<string, Variant> hints;
}

/* The error types that can be thrown from DBus methods */
[DBus (name = "com.canonical.Unity.ScopeError")]
public errordomain ScopeError
{
  SEARCH_CANCELLED,
  UNKNOWN
}

/**
 * ScopeService:
 *
 * The Scope interface exported on DBus
 */
[DBus (name = "com.canonical.Unity.Scope")]
public interface ScopeService : GLib.Object
{
  public abstract async void info_request () throws IOError;

  public abstract async ActivationReplyRaw activate (
      string uri, uint action_type, HashTable<string, Variant> hints) throws IOError;

  public abstract async HashTable<string, Variant> update_preview_property (
      string uri, HashTable<string, Variant> values) throws IOError;

  public abstract async HashTable<string, Variant> search (
      string search_string,
      HashTable<string, Variant> hints) throws IOError, ScopeError;

  public abstract async HashTable<string, Variant> global_search (
      string search_string,
      HashTable<string, Variant> hints) throws IOError, ScopeError;
  
  public abstract async void set_view_type (uint view_type) throws IOError;

  public abstract async void set_active_sources (string[] sources) throws IOError;
  
  public signal void changed (ScopeInfo lens_info);
}

} /* namespace unity */
