/* test-launcher-integration.c generated by valac 0.14.2, the Vala compiler
 * generated from test-launcher-integration.vala, do not modify */

/*
 * Copyright (C) 2011 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Mikkel Kamstrup Erlandsen <mikkel.kamstrup@canonical.com>
 *
 */
/*
 * Despite the relative simplicity of this API we still need to relegate it
 * to the integration tests suite because it depends on the GSettings schema
 * from Unity.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <config.h>
#include <gio/gio.h>
#include <unity-internal.h>
#include <gio/gdesktopappinfo.h>
#include <gobject/gvaluecollector.h>


#define TYPE_MAIN (main_get_type ())
#define MAIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN, Main))
#define MAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN, MainClass))
#define IS_MAIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN))
#define IS_MAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN))
#define MAIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN, MainClass))

typedef struct _Main Main;
typedef struct _MainClass MainClass;
typedef struct _MainPrivate MainPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block1Data Block1Data;
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
typedef struct _ParamSpecMain ParamSpecMain;

struct _Main {
	GTypeInstance parent_instance;
	volatile int ref_count;
	MainPrivate * priv;
};

struct _MainClass {
	GTypeClass parent_class;
	void (*finalize) (Main *self);
};

struct _Block1Data {
	int _ref_count_;
	gboolean was_changed;
	GMainLoop* ml;
};

struct _ParamSpecMain {
	GParamSpec parent_instance;
};


static gpointer main_parent_class = NULL;

gpointer main_ref (gpointer instance);
void main_unref (gpointer instance);
GParamSpec* param_spec_main (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_main (GValue* value, gpointer v_object);
void value_take_main (GValue* value, gpointer v_object);
gpointer value_get_main (const GValue* value);
GType main_get_type (void) G_GNUC_CONST;
enum  {
	MAIN_DUMMY_PROPERTY
};
gint main_main (gchar** args, int args_length1);
void main_test_has_unknown_apps (void);
static void _main_test_has_unknown_apps_gtest_data_func (gpointer self);
void main_test_has_sample_apps (void);
static void _main_test_has_sample_apps_gtest_data_func (gpointer self);
void main_test_lookup (void);
static void _main_test_lookup_gtest_data_func (gpointer self);
void main_test_enumerate_ids (void);
static void _main_test_enumerate_ids_gtest_data_func (gpointer self);
void main_test_enumerate_app_infos (void);
static void _main_test_enumerate_app_infos_gtest_data_func (gpointer self);
void main_test_changes (void);
static void _main_test_changes_gtest_data_func (gpointer self);
void main_set_up (void);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (Block1Data* _data1_);
static void __lambda0_ (Block1Data* _data1_);
static void ___lambda0__unity_launcher_favorites_changed (UnityLauncherFavorites* _sender, gpointer self);
static gboolean __lambda1_ (Block1Data* _data1_);
static gboolean ___lambda1__gsource_func (gpointer self);
Main* main_new (void);
Main* main_construct (GType object_type);
static void main_finalize (Main* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static void _main_test_has_unknown_apps_gtest_data_func (gpointer self) {
	main_test_has_unknown_apps ();
}


static void _main_test_has_sample_apps_gtest_data_func (gpointer self) {
	main_test_has_sample_apps ();
}


static void _main_test_lookup_gtest_data_func (gpointer self) {
	main_test_lookup ();
}


static void _main_test_enumerate_ids_gtest_data_func (gpointer self) {
	main_test_enumerate_ids ();
}


static void _main_test_enumerate_app_infos_gtest_data_func (gpointer self) {
	main_test_enumerate_app_infos ();
}


static void _main_test_changes_gtest_data_func (gpointer self) {
	main_test_changes ();
}


gint main_main (gchar** args, int args_length1) {
	gint result = 0;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	gchar* datadirs;
	const gchar* _tmp2_;
	const gchar* _tmp6_;
	_tmp0_ = g_getenv ("XDG_DATA_DIRS");
	_tmp1_ = g_strdup (_tmp0_);
	datadirs = _tmp1_;
	_tmp2_ = datadirs;
	if (_tmp2_ != NULL) {
		const gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp3_ = datadirs;
		_tmp4_ = g_strconcat (TESTDIR "/data:", _tmp3_, NULL);
		_g_free0 (datadirs);
		datadirs = _tmp4_;
	} else {
		gchar* _tmp5_;
		_tmp5_ = g_strdup (TESTDIR "/data");
		_g_free0 (datadirs);
		datadirs = _tmp5_;
	}
	_tmp6_ = datadirs;
	g_setenv ("XDG_DATA_DIRS", _tmp6_, TRUE);
	g_setenv ("GSETTINGS_BACKEND", "memory", TRUE);
	g_test_init (&args_length1, &args, NULL);
	g_test_add_data_func ("/Integration/Launcher/Favorites/UnknownApps", NULL, _main_test_has_unknown_apps_gtest_data_func);
	g_test_add_data_func ("/Integration/Launcher/Favorites/HasSampleApps", NULL, _main_test_has_sample_apps_gtest_data_func);
	g_test_add_data_func ("/Integration/Launcher/Favorites/Lookup", NULL, _main_test_lookup_gtest_data_func);
	g_test_add_data_func ("/Integration/Launcher/Favorites/EnumerateIds", NULL, _main_test_enumerate_ids_gtest_data_func);
	g_test_add_data_func ("/Integration/Launcher/Favorites/EnumerateAppInfos", NULL, _main_test_enumerate_app_infos_gtest_data_func);
	g_test_add_data_func ("/Integration/Launcher/Favorites/Changes", NULL, _main_test_changes_gtest_data_func);
	g_test_run ();
	result = 0;
	_g_free0 (datadirs);
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return main_main (argv, argc);
}


void main_set_up (void) {
	const gchar* _tmp0_ = NULL;
	GSettings* _tmp1_;
	GSettings* settings;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar** _tmp5_ = NULL;
	gchar** faves;
	gint faves_length1;
	gint _faves_size_;
	_tmp0_ = g_getenv ("GSETTINGS_BACKEND");
	g_assert (g_strcmp0 ("memory", _tmp0_) == 0);
	_tmp1_ = g_settings_new ("com.canonical.Unity.Launcher");
	settings = _tmp1_;
	_tmp2_ = g_strdup ("rhythmbox.desktop");
	_tmp3_ = g_strdup ("testapp1.desktop");
	_tmp4_ = g_strdup ("ubuntu-about.desktop");
	_tmp5_ = g_new0 (gchar*, 3 + 1);
	_tmp5_[0] = _tmp2_;
	_tmp5_[1] = _tmp3_;
	_tmp5_[2] = _tmp4_;
	faves = _tmp5_;
	faves_length1 = 3;
	_faves_size_ = faves_length1;
	g_settings_set_strv (settings, "favorites", faves);
	faves = (_vala_array_free (faves, faves_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (settings);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void main_test_has_unknown_apps (void) {
	UnityLauncherFavorites* _tmp0_ = NULL;
	UnityLauncherFavorites* _tmp1_;
	UnityLauncherFavorites* faves;
	gboolean _tmp2_ = FALSE;
	GDesktopAppInfo* _tmp3_;
	GDesktopAppInfo* appinfo;
	gboolean _tmp4_ = FALSE;
	main_set_up ();
	_tmp0_ = unity_launcher_favorites_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	faves = _tmp1_;
	_tmp2_ = unity_launcher_favorites_has_app_id (faves, "hulabaloola");
	g_assert (!_tmp2_);
	_tmp3_ = g_desktop_app_info_new ("asdasdasd.desktop");
	appinfo = _tmp3_;
	g_assert (appinfo != NULL);
	_tmp4_ = unity_launcher_favorites_has_app_info (faves, (GAppInfo*) appinfo);
	g_assert (!_tmp4_);
	_g_object_unref0 (appinfo);
	_g_object_unref0 (faves);
}


void main_test_has_sample_apps (void) {
	UnityLauncherFavorites* _tmp0_ = NULL;
	UnityLauncherFavorites* _tmp1_;
	UnityLauncherFavorites* faves;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	GDesktopAppInfo* _tmp5_;
	GDesktopAppInfo* appinfo;
	GDesktopAppInfo* _tmp6_;
	gboolean _tmp7_ = FALSE;
	GDesktopAppInfo* _tmp8_;
	GDesktopAppInfo* _tmp9_;
	gboolean _tmp10_ = FALSE;
	GDesktopAppInfo* _tmp11_;
	GDesktopAppInfo* _tmp12_;
	gboolean _tmp13_ = FALSE;
	main_set_up ();
	_tmp0_ = unity_launcher_favorites_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	faves = _tmp1_;
	_tmp2_ = unity_launcher_favorites_has_app_id (faves, "rhythmbox.desktop");
	g_assert (_tmp2_);
	_tmp3_ = unity_launcher_favorites_has_app_id (faves, "testapp1.desktop");
	g_assert (_tmp3_);
	_tmp4_ = unity_launcher_favorites_has_app_id (faves, "ubuntu-about.desktop");
	g_assert (_tmp4_);
	_tmp5_ = g_desktop_app_info_new ("rhythmbox.desktop");
	appinfo = _tmp5_;
	_tmp6_ = appinfo;
	_tmp7_ = unity_launcher_favorites_has_app_info (faves, (GAppInfo*) _tmp6_);
	g_assert (_tmp7_);
	_tmp8_ = g_desktop_app_info_new ("testapp1.desktop");
	_g_object_unref0 (appinfo);
	appinfo = _tmp8_;
	_tmp9_ = appinfo;
	_tmp10_ = unity_launcher_favorites_has_app_info (faves, (GAppInfo*) _tmp9_);
	g_assert (_tmp10_);
	_tmp11_ = g_desktop_app_info_new ("ubuntu-about.desktop");
	_g_object_unref0 (appinfo);
	appinfo = _tmp11_;
	_tmp12_ = appinfo;
	_tmp13_ = unity_launcher_favorites_has_app_info (faves, (GAppInfo*) _tmp12_);
	g_assert (_tmp13_);
	_g_object_unref0 (appinfo);
	_g_object_unref0 (faves);
}


void main_test_lookup (void) {
	UnityLauncherFavorites* _tmp0_ = NULL;
	UnityLauncherFavorites* _tmp1_;
	UnityLauncherFavorites* faves;
	GAppInfo* _tmp2_ = NULL;
	GAppInfo* appinfo;
	GAppInfo* _tmp3_;
	const gchar* _tmp4_ = NULL;
	GAppInfo* _tmp5_ = NULL;
	GAppInfo* _tmp6_;
	const gchar* _tmp7_ = NULL;
	GAppInfo* _tmp8_ = NULL;
	GAppInfo* _tmp9_;
	const gchar* _tmp10_ = NULL;
	GAppInfo* _tmp11_ = NULL;
	GAppInfo* _tmp12_;
	main_set_up ();
	_tmp0_ = unity_launcher_favorites_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	faves = _tmp1_;
	_tmp2_ = unity_launcher_favorites_lookup (faves, "rhythmbox.desktop");
	appinfo = _tmp2_;
	_tmp3_ = appinfo;
	_tmp4_ = g_app_info_get_name (_tmp3_);
	g_assert (g_strcmp0 (_tmp4_, "Rhythmbox") == 0);
	_tmp5_ = unity_launcher_favorites_lookup (faves, "testapp1.desktop");
	_g_object_unref0 (appinfo);
	appinfo = _tmp5_;
	_tmp6_ = appinfo;
	_tmp7_ = g_app_info_get_name (_tmp6_);
	g_assert (g_strcmp0 (_tmp7_, "libunity test app 1") == 0);
	_tmp8_ = unity_launcher_favorites_lookup (faves, "ubuntu-about.desktop");
	_g_object_unref0 (appinfo);
	appinfo = _tmp8_;
	_tmp9_ = appinfo;
	_tmp10_ = g_app_info_get_name (_tmp9_);
	g_assert (g_strcmp0 (_tmp10_, "About Ubuntu") == 0);
	_tmp11_ = unity_launcher_favorites_lookup (faves, "pakupachupikamachu.desktop");
	_g_object_unref0 (appinfo);
	appinfo = _tmp11_;
	_tmp12_ = appinfo;
	g_assert (_tmp12_ == NULL);
	_g_object_unref0 (appinfo);
	_g_object_unref0 (faves);
}


void main_test_enumerate_ids (void) {
	UnityLauncherFavorites* _tmp0_ = NULL;
	UnityLauncherFavorites* _tmp1_;
	UnityLauncherFavorites* faves;
	gint _tmp2_ = 0;
	gchar** _tmp3_ = NULL;
	gchar** ids;
	gint ids_length1;
	gint _ids_size_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	main_set_up ();
	_tmp0_ = unity_launcher_favorites_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	faves = _tmp1_;
	_tmp3_ = unity_launcher_favorites_enumerate_ids (faves, &_tmp2_);
	ids = _tmp3_;
	ids_length1 = _tmp2_;
	_ids_size_ = ids_length1;
	g_assert (ids_length1 == 3);
	_tmp4_ = ids[0];
	g_assert (g_strcmp0 (_tmp4_, "rhythmbox.desktop") == 0);
	_tmp5_ = ids[1];
	g_assert (g_strcmp0 (_tmp5_, "testapp1.desktop") == 0);
	_tmp6_ = ids[2];
	g_assert (g_strcmp0 (_tmp6_, "ubuntu-about.desktop") == 0);
	ids = (_vala_array_free (ids, ids_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (faves);
}


void main_test_enumerate_app_infos (void) {
	UnityLauncherFavorites* _tmp0_ = NULL;
	UnityLauncherFavorites* _tmp1_;
	UnityLauncherFavorites* faves;
	gint _tmp2_ = 0;
	GAppInfo** _tmp3_ = NULL;
	GAppInfo** infos;
	gint infos_length1;
	gint _infos_size_;
	GAppInfo* _tmp4_;
	const gchar* _tmp5_ = NULL;
	GAppInfo* _tmp6_;
	const gchar* _tmp7_ = NULL;
	GAppInfo* _tmp8_;
	const gchar* _tmp9_ = NULL;
	main_set_up ();
	_tmp0_ = unity_launcher_favorites_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	faves = _tmp1_;
	_tmp3_ = unity_launcher_favorites_enumerate_app_infos (faves, &_tmp2_);
	infos = _tmp3_;
	infos_length1 = _tmp2_;
	_infos_size_ = infos_length1;
	g_assert (infos_length1 == 3);
	_tmp4_ = infos[0];
	_tmp5_ = g_app_info_get_name (_tmp4_);
	g_assert (g_strcmp0 (_tmp5_, "Rhythmbox") == 0);
	_tmp6_ = infos[1];
	_tmp7_ = g_app_info_get_name (_tmp6_);
	g_assert (g_strcmp0 (_tmp7_, "libunity test app 1") == 0);
	_tmp8_ = infos[2];
	_tmp9_ = g_app_info_get_name (_tmp8_);
	g_assert (g_strcmp0 (_tmp9_, "About Ubuntu") == 0);
	infos = (_vala_array_free (infos, infos_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (faves);
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (Block1Data* _data1_) {
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		_g_main_loop_unref0 (_data1_->ml);
		g_slice_free (Block1Data, _data1_);
	}
}


static void __lambda0_ (Block1Data* _data1_) {
	_data1_->was_changed = TRUE;
}


static void ___lambda0__unity_launcher_favorites_changed (UnityLauncherFavorites* _sender, gpointer self) {
	__lambda0_ (self);
}


static gboolean __lambda1_ (Block1Data* _data1_) {
	gboolean result = FALSE;
	g_main_loop_quit (_data1_->ml);
	result = FALSE;
	return result;
}


static gboolean ___lambda1__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda1_ (self);
	return result;
}


void main_test_changes (void) {
	Block1Data* _data1_;
	UnityLauncherFavorites* _tmp0_ = NULL;
	UnityLauncherFavorites* _tmp1_;
	UnityLauncherFavorites* faves;
	GSettings* _tmp2_;
	GSettings* settings;
	gchar* _tmp3_;
	gchar** _tmp4_ = NULL;
	gchar** new_faves;
	gint new_faves_length1;
	gint _new_faves_size_;
	GMainLoop* _tmp5_;
	gint _tmp6_ = 0;
	gchar** _tmp7_ = NULL;
	gchar** _tmp8_;
	gint _tmp8__length1;
	gint _tmp9_ = 0;
	gchar** _tmp10_ = NULL;
	gchar** _tmp11_;
	gint _tmp11__length1;
	const gchar* _tmp12_;
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	main_set_up ();
	_tmp0_ = unity_launcher_favorites_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	faves = _tmp1_;
	_data1_->was_changed = FALSE;
	g_signal_connect_data (faves, "changed", (GCallback) ___lambda0__unity_launcher_favorites_changed, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	_tmp2_ = g_settings_new ("com.canonical.Unity.Launcher");
	settings = _tmp2_;
	_tmp3_ = g_strdup ("rhythmbox.desktop");
	_tmp4_ = g_new0 (gchar*, 1 + 1);
	_tmp4_[0] = _tmp3_;
	new_faves = _tmp4_;
	new_faves_length1 = 1;
	_new_faves_size_ = new_faves_length1;
	g_settings_set_strv (settings, "favorites", new_faves);
	_tmp5_ = g_main_loop_new (NULL, FALSE);
	_data1_->ml = _tmp5_;
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda1__gsource_func, block1_data_ref (_data1_), block1_data_unref);
	g_main_loop_run (_data1_->ml);
	g_assert (_data1_->was_changed == TRUE);
	_tmp7_ = unity_launcher_favorites_enumerate_ids (faves, &_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp8__length1 = _tmp6_;
	g_assert (_tmp6_ == 1);
	_tmp8_ = (_vala_array_free (_tmp8_, _tmp8__length1, (GDestroyNotify) g_free), NULL);
	_tmp10_ = unity_launcher_favorites_enumerate_ids (faves, &_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp11__length1 = _tmp9_;
	_tmp12_ = _tmp11_[0];
	g_assert (g_strcmp0 (_tmp12_, "rhythmbox.desktop") == 0);
	_tmp11_ = (_vala_array_free (_tmp11_, _tmp11__length1, (GDestroyNotify) g_free), NULL);
	new_faves = (_vala_array_free (new_faves, new_faves_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (settings);
	_g_object_unref0 (faves);
	block1_data_unref (_data1_);
	_data1_ = NULL;
}


Main* main_construct (GType object_type) {
	Main* self = NULL;
	self = (Main*) g_type_create_instance (object_type);
	return self;
}


Main* main_new (void) {
	return main_construct (TYPE_MAIN);
}


static void value_main_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_main_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		main_unref (value->data[0].v_pointer);
	}
}


static void value_main_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = main_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_main_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_main_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		Main* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = main_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_main_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	Main** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = main_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_main (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecMain* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_MAIN), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_main (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_MAIN), NULL);
	return value->data[0].v_pointer;
}


void value_set_main (GValue* value, gpointer v_object) {
	Main* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_MAIN));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_MAIN));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		main_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		main_unref (old);
	}
}


void value_take_main (GValue* value, gpointer v_object) {
	Main* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_MAIN));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_MAIN));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		main_unref (old);
	}
}


static void main_class_init (MainClass * klass) {
	main_parent_class = g_type_class_peek_parent (klass);
	MAIN_CLASS (klass)->finalize = main_finalize;
}


static void main_instance_init (Main * self) {
	self->ref_count = 1;
}


static void main_finalize (Main* obj) {
	Main * self;
	self = MAIN (obj);
}


GType main_get_type (void) {
	static volatile gsize main_type_id__volatile = 0;
	if (g_once_init_enter (&main_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_main_init, value_main_free_value, value_main_copy_value, value_main_peek_pointer, "p", value_main_collect_value, "p", value_main_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (MainClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) main_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Main), 0, (GInstanceInitFunc) main_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType main_type_id;
		main_type_id = g_type_register_fundamental (g_type_fundamental_next (), "Main", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&main_type_id__volatile, main_type_id);
	}
	return main_type_id__volatile;
}


gpointer main_ref (gpointer instance) {
	Main* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void main_unref (gpointer instance) {
	Main* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		MAIN_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



