/* unity-sound-menu-mpris.c generated by valac 0.14.2, the Vala compiler
 * generated from unity-sound-menu-mpris.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: nil; c-basic-offset: 2; tab-width: 2 -*- */
/*
 * Copyright (C) 2011 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Conor Curran <conor.curran@canonical.com>
 *
 * Note: We aim to not wrap a typical MPRIS server but just expose to the consumer
 * the elements we need for it to populate. So that means things like Supported
 * Mime Types which are part of MPRIS but are not relevant to the consumer should 
 * remain hidden and as a result not used.
 */
/****************************************************************************************/
/****************************************************************************************/
/***************************************************************************************/

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include "unity.h"
#include <gio/gio.h>
#include <unity-trace.h>
#include <libdbusmenu-glib/client.h>
#include <libdbusmenu-glib/dbusmenu-glib.h>
#include <libdbusmenu-glib/enum-types.h>
#include <libdbusmenu-glib/menuitem-proxy.h>
#include <libdbusmenu-glib/menuitem.h>
#include <libdbusmenu-glib/server.h>
#include <libdbusmenu-glib/types.h>
#include <gee.h>


#define UNITY_TYPE_MPRIS_GATEWAY (unity_mpris_gateway_get_type ())
#define UNITY_MPRIS_GATEWAY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_TYPE_MPRIS_GATEWAY, UnityMPRISGateway))
#define UNITY_MPRIS_GATEWAY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_TYPE_MPRIS_GATEWAY, UnityMPRISGatewayClass))
#define UNITY_IS_MPRIS_GATEWAY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_TYPE_MPRIS_GATEWAY))
#define UNITY_IS_MPRIS_GATEWAY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_TYPE_MPRIS_GATEWAY))
#define UNITY_MPRIS_GATEWAY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_TYPE_MPRIS_GATEWAY, UnityMPRISGatewayClass))

typedef struct _UnityMPRISGateway UnityMPRISGateway;
typedef struct _UnityMPRISGatewayClass UnityMPRISGatewayClass;
typedef struct _UnityMPRISGatewayPrivate UnityMPRISGatewayPrivate;

#define UNITY_TYPE_MPRIS_ROOT (unity_mpris_root_get_type ())
#define UNITY_MPRIS_ROOT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_TYPE_MPRIS_ROOT, UnityMprisRoot))
#define UNITY_MPRIS_ROOT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_TYPE_MPRIS_ROOT, UnityMprisRootClass))
#define UNITY_IS_MPRIS_ROOT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_TYPE_MPRIS_ROOT))
#define UNITY_IS_MPRIS_ROOT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_TYPE_MPRIS_ROOT))
#define UNITY_MPRIS_ROOT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_TYPE_MPRIS_ROOT, UnityMprisRootClass))

typedef struct _UnityMprisRoot UnityMprisRoot;
typedef struct _UnityMprisRootClass UnityMprisRootClass;

#define UNITY_TYPE_MPRIS_PLAYER (unity_mpris_player_get_type ())
#define UNITY_MPRIS_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_TYPE_MPRIS_PLAYER, UnityMprisPlayer))
#define UNITY_MPRIS_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_TYPE_MPRIS_PLAYER, UnityMprisPlayerClass))
#define UNITY_IS_MPRIS_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_TYPE_MPRIS_PLAYER))
#define UNITY_IS_MPRIS_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_TYPE_MPRIS_PLAYER))
#define UNITY_MPRIS_PLAYER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_TYPE_MPRIS_PLAYER, UnityMprisPlayerClass))

typedef struct _UnityMprisPlayer UnityMprisPlayer;
typedef struct _UnityMprisPlayerClass UnityMprisPlayerClass;

#define UNITY_TYPE_MPRIS_PLAYLISTS (unity_mpris_playlists_get_type ())
#define UNITY_MPRIS_PLAYLISTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_TYPE_MPRIS_PLAYLISTS, UnityMprisPlaylists))
#define UNITY_MPRIS_PLAYLISTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_TYPE_MPRIS_PLAYLISTS, UnityMprisPlaylistsClass))
#define UNITY_IS_MPRIS_PLAYLISTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_TYPE_MPRIS_PLAYLISTS))
#define UNITY_IS_MPRIS_PLAYLISTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_TYPE_MPRIS_PLAYLISTS))
#define UNITY_MPRIS_PLAYLISTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_TYPE_MPRIS_PLAYLISTS, UnityMprisPlaylistsClass))

typedef struct _UnityMprisPlaylists UnityMprisPlaylists;
typedef struct _UnityMprisPlaylistsClass UnityMprisPlaylistsClass;

#define UNITY_TYPE_PROPERTY_UPDATE_MANAGER (unity_property_update_manager_get_type ())
#define UNITY_PROPERTY_UPDATE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_TYPE_PROPERTY_UPDATE_MANAGER, UnityPropertyUpdateManager))
#define UNITY_PROPERTY_UPDATE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_TYPE_PROPERTY_UPDATE_MANAGER, UnityPropertyUpdateManagerClass))
#define UNITY_IS_PROPERTY_UPDATE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_TYPE_PROPERTY_UPDATE_MANAGER))
#define UNITY_IS_PROPERTY_UPDATE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_TYPE_PROPERTY_UPDATE_MANAGER))
#define UNITY_PROPERTY_UPDATE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_TYPE_PROPERTY_UPDATE_MANAGER, UnityPropertyUpdateManagerClass))

typedef struct _UnityPropertyUpdateManager UnityPropertyUpdateManager;
typedef struct _UnityPropertyUpdateManagerClass UnityPropertyUpdateManagerClass;

#define UNITY_TYPE_BLACKLIST_MANAGER (unity_blacklist_manager_get_type ())
#define UNITY_BLACKLIST_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_TYPE_BLACKLIST_MANAGER, UnityBlacklistManager))
#define UNITY_BLACKLIST_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_TYPE_BLACKLIST_MANAGER, UnityBlacklistManagerClass))
#define UNITY_IS_BLACKLIST_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_TYPE_BLACKLIST_MANAGER))
#define UNITY_IS_BLACKLIST_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_TYPE_BLACKLIST_MANAGER))
#define UNITY_BLACKLIST_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_TYPE_BLACKLIST_MANAGER, UnityBlacklistManagerClass))

typedef struct _UnityBlacklistManager UnityBlacklistManager;
typedef struct _UnityBlacklistManagerClass UnityBlacklistManagerClass;

#define UNITY_TYPE_SPECIFIC_ITEM_MANAGER (unity_specific_item_manager_get_type ())
#define UNITY_SPECIFIC_ITEM_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_TYPE_SPECIFIC_ITEM_MANAGER, UnitySpecificItemManager))
#define UNITY_SPECIFIC_ITEM_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_TYPE_SPECIFIC_ITEM_MANAGER, UnitySpecificItemManagerClass))
#define UNITY_IS_SPECIFIC_ITEM_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_TYPE_SPECIFIC_ITEM_MANAGER))
#define UNITY_IS_SPECIFIC_ITEM_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_TYPE_SPECIFIC_ITEM_MANAGER))
#define UNITY_SPECIFIC_ITEM_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_TYPE_SPECIFIC_ITEM_MANAGER, UnitySpecificItemManagerClass))

typedef struct _UnitySpecificItemManager UnitySpecificItemManager;
typedef struct _UnitySpecificItemManagerClass UnitySpecificItemManagerClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block10Data Block10Data;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _UnitySpecificItemManagerPrivate UnitySpecificItemManagerPrivate;

#define UNITY_TYPE_SOUND_SERVICE_INTERFACE (unity_sound_service_interface_get_type ())
#define UNITY_SOUND_SERVICE_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_TYPE_SOUND_SERVICE_INTERFACE, UnitySoundServiceInterface))
#define UNITY_IS_SOUND_SERVICE_INTERFACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_TYPE_SOUND_SERVICE_INTERFACE))
#define UNITY_SOUND_SERVICE_INTERFACE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), UNITY_TYPE_SOUND_SERVICE_INTERFACE, UnitySoundServiceInterfaceIface))

typedef struct _UnitySoundServiceInterface UnitySoundServiceInterface;
typedef struct _UnitySoundServiceInterfaceIface UnitySoundServiceInterfaceIface;

#define UNITY_TYPE_SOUND_SERVICE_INTERFACE_PROXY (unity_sound_service_interface_proxy_get_type ())
typedef struct _UnityPropertyUpdateManagerPrivate UnityPropertyUpdateManagerPrivate;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
typedef struct _Block11Data Block11Data;
#define _g_variant_type_free0(var) ((var == NULL) ? NULL : (var = (g_variant_type_free (var), NULL)))
#define _g_variant_builder_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_builder_unref (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
typedef struct _UnityBlacklistManagerPrivate UnityBlacklistManagerPrivate;
typedef GDBusProxy UnitySoundServiceInterfaceProxy;
typedef GDBusProxyClass UnitySoundServiceInterfaceProxyClass;
typedef struct _UnityMprisRootPrivate UnityMprisRootPrivate;
typedef struct _UnityMprisRootRaiseData UnityMprisRootRaiseData;
typedef struct _UnityMprisPlayerPrivate UnityMprisPlayerPrivate;
typedef struct _UnityMprisPlayerPlayPauseData UnityMprisPlayerPlayPauseData;
typedef struct _UnityMprisPlayerNextData UnityMprisPlayerNextData;
typedef struct _UnityMprisPlayerPreviousData UnityMprisPlayerPreviousData;
typedef struct _UnityMprisPlaylistsPrivate UnityMprisPlaylistsPrivate;
typedef struct _UnityMprisPlaylistsActivatePlaylistData UnityMprisPlaylistsActivatePlaylistData;
typedef struct _UnityMprisPlaylistsGetPlaylistsData UnityMprisPlaylistsGetPlaylistsData;

struct _UnityMPRISGateway {
	GObject parent_instance;
	UnityMPRISGatewayPrivate * priv;
};

struct _UnityMPRISGatewayClass {
	GObjectClass parent_class;
};

struct _UnityMPRISGatewayPrivate {
	UnityMusicPlayer* _consumer;
	UnityMprisRoot* mpris_root_interface;
	UnityMprisPlayer* mpris_player_interface;
	UnityMprisPlaylists* mpris_playlist_interface;
	UnityPropertyUpdateManager* prop_manager;
	UnityBlacklistManager* blacklist_mgr;
	UnitySpecificItemManager* specific_menuitem_mgr;
	GDBusConnection* dbus_connection;
	gboolean playlist_interface_raised;
	UnityPlaylist* _edited_playlist;
	gint _playlist_count;
	guint bus_name_owner_handle;
	guint bus_root_iface_handle;
	guint bus_player_iface_handle;
};

struct _Block10Data {
	int _ref_count_;
	UnityMPRISGateway * self;
	gchar* dbus_name;
};

struct _UnitySpecificItemManager {
	GObject parent_instance;
	UnitySpecificItemManagerPrivate * priv;
	char* _player_specific_object_path;
	char* _track_specific_object_path;
};

struct _UnitySpecificItemManagerClass {
	GObjectClass parent_class;
};

struct _UnitySoundServiceInterfaceIface {
	GTypeInterface parent_iface;
	void (*EnableTrackSpecificItems) (UnitySoundServiceInterface* self, const char* object_path, const gchar* desktop_id, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*EnableTrackSpecificItems_finish) (UnitySoundServiceInterface* self, GAsyncResult* _res_, GError** error);
	void (*EnablePlayerSpecificItems) (UnitySoundServiceInterface* self, const char* object_path, const gchar* desktop_id, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*EnablePlayerSpecificItems_finish) (UnitySoundServiceInterface* self, GAsyncResult* _res_, GError** error);
};

struct _UnitySpecificItemManagerPrivate {
	DbusmenuServer* _player_item_server;
	DbusmenuServer* _track_item_server;
	UnityMusicPlayer* _consumer;
	UnitySoundServiceInterface* sound_service_interface;
};

struct _UnityPropertyUpdateManager {
	GObject parent_instance;
	UnityPropertyUpdateManagerPrivate * priv;
};

struct _UnityPropertyUpdateManagerClass {
	GObjectClass parent_class;
};

struct _UnityPropertyUpdateManagerPrivate {
	GHashTable* queued_properties;
	GHashTable* source_ids;
	GDBusConnection* _connection;
};

struct _Block11Data {
	int _ref_count_;
	UnityPropertyUpdateManager * self;
	gchar* interface_name;
};

struct _UnityBlacklistManager {
	GObject parent_instance;
	UnityBlacklistManagerPrivate * priv;
};

struct _UnityBlacklistManagerClass {
	GObjectClass parent_class;
};

struct _UnityBlacklistManagerPrivate {
	GSettings* settings;
	UnityMusicPlayer* consumer;
};

struct _UnityMprisRoot {
	GObject parent_instance;
	UnityMprisRootPrivate * priv;
};

struct _UnityMprisRootClass {
	GObjectClass parent_class;
};

struct _UnityMprisRootPrivate {
	UnityMusicPlayer* consumer;
	UnityPropertyUpdateManager* prop_mgr;
	gchar* mpris_desktop_entry;
};

struct _UnityMprisRootRaiseData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	UnityMprisRoot* self;
	UnityMusicPlayer* _tmp0_;
};

struct _UnityMprisPlayer {
	GObject parent_instance;
	UnityMprisPlayerPrivate * priv;
};

struct _UnityMprisPlayerClass {
	GObjectClass parent_class;
};

struct _UnityMprisPlayerPrivate {
	UnityMusicPlayer* consumer;
	UnityPropertyUpdateManager* prop_mgr;
	GHashTable* current_metadata;
};

struct _UnityMprisPlayerPlayPauseData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	UnityMprisPlayer* self;
	UnityMusicPlayer* _tmp0_;
};

struct _UnityMprisPlayerNextData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	UnityMprisPlayer* self;
	UnityMusicPlayer* _tmp0_;
};

struct _UnityMprisPlayerPreviousData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	UnityMprisPlayer* self;
	UnityMusicPlayer* _tmp0_;
};

struct _UnityMprisPlaylists {
	GObject parent_instance;
	UnityMprisPlaylistsPrivate * priv;
};

struct _UnityMprisPlaylistsClass {
	GObjectClass parent_class;
};

struct _UnityMprisPlaylistsPrivate {
	UnityMusicPlayer* consumer;
	UnityPropertyUpdateManager* prop_mgr;
	UnityMPRISGateway* gateway;
};

struct _UnityMprisPlaylistsActivatePlaylistData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	UnityMprisPlaylists* self;
	char* playlist_id;
	UnityMusicPlayer* _tmp0_;
	const char* _tmp1_;
};

struct _UnityMprisPlaylistsGetPlaylistsData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	UnityMprisPlaylists* self;
	guint32 index;
	guint32 max_count;
	gchar* order;
	gboolean reverse_order;
	UnityPlaylistDetails* result;
	gint result_length1;
	UnityPlaylistDetails* _tmp0_;
	UnityPlaylistDetails* _result_;
	gint _result__length1;
	gint __result__size_;
	UnityMusicPlayer* _tmp1_;
	gint _tmp2_;
	UnityPlaylist** _tmp3_;
	UnityPlaylist** up_collection;
	gint up_collection_length1;
	gint _up_collection_size_;
	gint up_it;
	UnityPlaylist* _tmp4_;
	UnityPlaylist* up;
	UnityPlaylistDetails details;
	UnityPlaylist* _tmp5_;
	UnityPlaylistDetails* _tmp6_;
	gint _tmp6__length1;
	UnityPlaylistDetails _tmp7_;
	UnityPlaylistDetails _tmp8_;
	UnityPlaylistDetails* _tmp9_;
	gint _tmp9__length1;
};


static gpointer unity_mpris_gateway_parent_class = NULL;
static gpointer unity_specific_item_manager_parent_class = NULL;
static gpointer unity_property_update_manager_parent_class = NULL;
static gpointer unity_blacklist_manager_parent_class = NULL;
static gpointer unity_mpris_root_parent_class = NULL;
static gpointer unity_mpris_player_parent_class = NULL;
static gpointer unity_mpris_playlists_parent_class = NULL;

#define UNITY_MPRIS_INTERFACE_ROOT_PATH "/org/mpris/MediaPlayer2"
#define UNITY_MPRIS_INTERFACE_ROOT "org.mpris.MediaPlayer2"
#define UNITY_MPRIS_INTERFACE_PREFIX "org.mpris.MediaPlayer2."
#define UNITY_MPRIS_INTERFACE_PLAYER "org.mpris.MediaPlayer2.Player"
#define UNITY_MPRIS_INTERFACE_PLAYLISTS "org.mpris.MediaPlayer2.Playlists"
GType unity_mpris_gateway_get_type (void) G_GNUC_CONST;
GType unity_mpris_root_get_type (void) G_GNUC_CONST;
guint unity_mpris_root_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType unity_mpris_player_get_type (void) G_GNUC_CONST;
guint unity_mpris_player_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType unity_mpris_playlists_get_type (void) G_GNUC_CONST;
guint unity_mpris_playlists_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType unity_property_update_manager_get_type (void) G_GNUC_CONST;
GType unity_blacklist_manager_get_type (void) G_GNUC_CONST;
GType unity_specific_item_manager_get_type (void) G_GNUC_CONST;
#define UNITY_MPRIS_GATEWAY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), UNITY_TYPE_MPRIS_GATEWAY, UnityMPRISGatewayPrivate))
enum  {
	UNITY_MPRIS_GATEWAY_DUMMY_PROPERTY,
	UNITY_MPRIS_GATEWAY_CONSUMER,
	UNITY_MPRIS_GATEWAY_EDITED_PLAYLIST,
	UNITY_MPRIS_GATEWAY_PLAYLIST_COUNT
};
UnityMPRISGateway* unity_mpris_gateway_new (UnityMusicPlayer* client);
UnityMPRISGateway* unity_mpris_gateway_construct (GType object_type, UnityMusicPlayer* client);
void unity_mpris_gateway_export (UnityMPRISGateway* self);
static Block10Data* block10_data_ref (Block10Data* _data10_);
static void block10_data_unref (Block10Data* _data10_);
UnityPropertyUpdateManager* unity_property_update_manager_new (GDBusConnection* conn);
UnityPropertyUpdateManager* unity_property_update_manager_construct (GType object_type, GDBusConnection* conn);
UnityMusicPlayer* unity_mpris_gateway_get_consumer (UnityMPRISGateway* self);
UnityMprisRoot* unity_mpris_root_new (UnityMusicPlayer* client, UnityPropertyUpdateManager* prop_mgr);
UnityMprisRoot* unity_mpris_root_construct (GType object_type, UnityMusicPlayer* client, UnityPropertyUpdateManager* prop_mgr);
UnityMprisPlayer* unity_mpris_player_new (UnityMusicPlayer* client, UnityPropertyUpdateManager* prop_mgr);
UnityMprisPlayer* unity_mpris_player_construct (GType object_type, UnityMusicPlayer* client, UnityPropertyUpdateManager* prop_mgr);
UnityMprisPlaylists* unity_mpris_playlists_new (UnityMusicPlayer* consumer, UnityPropertyUpdateManager* prop_mgr, UnityMPRISGateway* gw);
UnityMprisPlaylists* unity_mpris_playlists_construct (GType object_type, UnityMusicPlayer* consumer, UnityPropertyUpdateManager* prop_mgr, UnityMPRISGateway* gw);
static void __lambda23_ (Block10Data* _data10_);
static void ___lambda23__gbus_name_acquired_callback (GDBusConnection* connection, const gchar* name, gpointer self);
static void unity_mpris_gateway_on_name_lost (UnityMPRISGateway* self, GDBusConnection* conn, const gchar* name);
static void _unity_mpris_gateway_on_name_lost_gbus_name_lost_callback (GDBusConnection* connection, const gchar* name, gpointer self);
void unity_mpris_gateway_unexport (UnityMPRISGateway* self);
void unity_mpris_gateway_ensure_playlist_interface_is_raised (UnityMPRISGateway* self);
static void unity_mpris_gateway_set_consumer (UnityMPRISGateway* self, UnityMusicPlayer* value);
UnityPlaylist* unity_mpris_gateway_get_edited_playlist (UnityMPRISGateway* self);
void unity_mpris_gateway_set_edited_playlist (UnityMPRISGateway* self, UnityPlaylist* value);
gint unity_mpris_gateway_get_playlist_count (UnityMPRISGateway* self);
void unity_mpris_gateway_set_playlist_count (UnityMPRISGateway* self, gint value);
static GObject * unity_mpris_gateway_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
UnityBlacklistManager* unity_blacklist_manager_new (UnityMusicPlayer* client);
UnityBlacklistManager* unity_blacklist_manager_construct (GType object_type, UnityMusicPlayer* client);
UnitySpecificItemManager* unity_specific_item_manager_new (UnityMusicPlayer* client);
UnitySpecificItemManager* unity_specific_item_manager_construct (GType object_type, UnityMusicPlayer* client);
static void unity_mpris_gateway_finalize (GObject* obj);
static void _vala_unity_mpris_gateway_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_unity_mpris_gateway_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType unity_sound_service_interface_proxy_get_type (void) G_GNUC_CONST;
guint unity_sound_service_interface_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType unity_sound_service_interface_get_type (void) G_GNUC_CONST;
#define UNITY_SPECIFIC_ITEM_MANAGER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), UNITY_TYPE_SPECIFIC_ITEM_MANAGER, UnitySpecificItemManagerPrivate))
enum  {
	UNITY_SPECIFIC_ITEM_MANAGER_DUMMY_PROPERTY,
	UNITY_SPECIFIC_ITEM_MANAGER_CONSUMER
};
static void unity_specific_item_manager_on_track_specific_change (UnitySpecificItemManager* self, GParamSpec* p);
UnityMusicPlayer* unity_specific_item_manager_get_consumer (UnitySpecificItemManager* self);
void unity_sound_service_interface_EnableTrackSpecificItems (UnitySoundServiceInterface* self, const char* object_path, const gchar* desktop_id, GAsyncReadyCallback _callback_, gpointer _user_data_);
void unity_sound_service_interface_EnableTrackSpecificItems_finish (UnitySoundServiceInterface* self, GAsyncResult* _res_, GError** error);
static void unity_specific_item_manager_on_player_specific_change (UnitySpecificItemManager* self, GParamSpec* p);
void unity_sound_service_interface_EnablePlayerSpecificItems (UnitySoundServiceInterface* self, const char* object_path, const gchar* desktop_id, GAsyncReadyCallback _callback_, gpointer _user_data_);
void unity_sound_service_interface_EnablePlayerSpecificItems_finish (UnitySoundServiceInterface* self, GAsyncResult* _res_, GError** error);
static void unity_specific_item_manager_set_consumer (UnitySpecificItemManager* self, UnityMusicPlayer* value);
static GObject * unity_specific_item_manager_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void _unity_specific_item_manager_on_track_specific_change_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _unity_specific_item_manager_on_player_specific_change_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void unity_specific_item_manager_finalize (GObject* obj);
static void _vala_unity_specific_item_manager_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_unity_specific_item_manager_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
#define UNITY_PROPERTY_UPDATE_MANAGER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), UNITY_TYPE_PROPERTY_UPDATE_MANAGER, UnityPropertyUpdateManagerPrivate))
enum  {
	UNITY_PROPERTY_UPDATE_MANAGER_DUMMY_PROPERTY,
	UNITY_PROPERTY_UPDATE_MANAGER_CONNECTION
};
void unity_property_update_manager_queue_property_update (UnityPropertyUpdateManager* self, const gchar* prop_name, GVariant* update, const gchar* interface_name);
static Block11Data* block11_data_ref (Block11Data* _data11_);
static void block11_data_unref (Block11Data* _data11_);
static gboolean ___lambda16_ (Block11Data* _data11_);
static gboolean unity_property_update_manager_dispatch_property_update (UnityPropertyUpdateManager* self, const gchar* interface_name);
static gboolean ____lambda16__gsource_func (gpointer self);
void unity_property_update_manager_emit_dbus_signal (UnityPropertyUpdateManager* self, const gchar* interface_name, const gchar* signal_name, GVariant* payload);
GDBusConnection* unity_property_update_manager_get_connection (UnityPropertyUpdateManager* self);
static void unity_property_update_manager_set_connection (UnityPropertyUpdateManager* self, GDBusConnection* value);
static GObject * unity_property_update_manager_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void _g_free0_ (gpointer var);
static void _g_hash_table_unref0_ (gpointer var);
static void _g_variant_unref0_ (gpointer var);
static void unity_property_update_manager_finalize (GObject* obj);
static void _vala_unity_property_update_manager_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_unity_property_update_manager_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
#define UNITY_BLACKLIST_MANAGER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), UNITY_TYPE_BLACKLIST_MANAGER, UnityBlacklistManagerPrivate))
enum  {
	UNITY_BLACKLIST_MANAGER_DUMMY_PROPERTY
};
static void unity_blacklist_manager_wire_it_up (UnityBlacklistManager* self);
gboolean unity_blacklist_manager_check_presence (UnityBlacklistManager* self);
static void unity_blacklist_manager_on_blacklist_event (UnityBlacklistManager* self);
static void _unity_blacklist_manager_on_blacklist_event_g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
static void unity_blacklist_manager_consumer_blacklist_change (UnityBlacklistManager* self);
static void _unity_blacklist_manager_consumer_blacklist_change_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void unity_blacklist_manager_add_to_blacklist (UnityBlacklistManager* self);
static void unity_blacklist_manager_remove_from_blacklist (UnityBlacklistManager* self);
static gchar* unity_blacklist_manager_get_blacklist_name (UnityBlacklistManager* self);
static GObject * unity_blacklist_manager_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void unity_blacklist_manager_finalize (GObject* obj);
static void unity_sound_service_interface_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters);
static void _vala_g_async_ready_callback (GObject *source_object, GAsyncResult *res, void *user_data);
static void unity_sound_service_interface_proxy_EnableTrackSpecificItems_async (UnitySoundServiceInterface* self, const char* object_path, const gchar* desktop_id, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void unity_sound_service_interface_proxy_EnableTrackSpecificItems_finish (UnitySoundServiceInterface* self, GAsyncResult* _res_, GError** error);
static void unity_sound_service_interface_proxy_EnablePlayerSpecificItems_async (UnitySoundServiceInterface* self, const char* object_path, const gchar* desktop_id, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void unity_sound_service_interface_proxy_EnablePlayerSpecificItems_finish (UnitySoundServiceInterface* self, GAsyncResult* _res_, GError** error);
static void unity_sound_service_interface_proxy_unity_sound_service_interface_interface_init (UnitySoundServiceInterfaceIface* iface);
static void _dbus_unity_sound_service_interface_EnableTrackSpecificItems (UnitySoundServiceInterface* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_unity_sound_service_interface_EnableTrackSpecificItems_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_);
static void _dbus_unity_sound_service_interface_EnablePlayerSpecificItems (UnitySoundServiceInterface* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_unity_sound_service_interface_EnablePlayerSpecificItems_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_);
static void unity_sound_service_interface_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data);
static GVariant* unity_sound_service_interface_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data);
static gboolean unity_sound_service_interface_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data);
static void _unity_sound_service_interface_unregister_object (gpointer user_data);
#define UNITY_MPRIS_ROOT_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), UNITY_TYPE_MPRIS_ROOT, UnityMprisRootPrivate))
enum  {
	UNITY_MPRIS_ROOT_DUMMY_PROPERTY,
	UNITY_MPRIS_ROOT_HAS_TRACKLIST,
	UNITY_MPRIS_ROOT_CAN_QUIT,
	UNITY_MPRIS_ROOT_CAN_RAISE,
	UNITY_MPRIS_ROOT_IDENTITY,
	UNITY_MPRIS_ROOT_DESKTOP_ENTRY
};
static void unity_mpris_root_wire_up (UnityMprisRoot* self);
static void __lambda17_ (UnityMprisRoot* self, GObject* obj, GParamSpec* pspec);
static GVariant* _variant_new66 (const gchar* value);
static void ___lambda17__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void unity_mpris_root_raise_data_free (gpointer _data);
void unity_mpris_root_raise (UnityMprisRoot* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void unity_mpris_root_raise_finish (UnityMprisRoot* self, GAsyncResult* _res_, GError** error);
static gboolean unity_mpris_root_raise_co (UnityMprisRootRaiseData* _data_);
gboolean unity_mpris_root_get_has_tracklist (UnityMprisRoot* self);
gboolean unity_mpris_root_get_can_quit (UnityMprisRoot* self);
gboolean unity_mpris_root_get_can_raise (UnityMprisRoot* self);
const gchar* unity_mpris_root_get_identity (UnityMprisRoot* self);
const gchar* unity_mpris_root_get_desktop_entry (UnityMprisRoot* self);
static GObject * unity_mpris_root_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void unity_mpris_root_finalize (GObject* obj);
static void _vala_unity_mpris_root_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _dbus_unity_mpris_root_raise (UnityMprisRoot* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_unity_mpris_root_raise_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_);
static void unity_mpris_root_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data);
static GVariant* unity_mpris_root_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data);
static GVariant* _dbus_unity_mpris_root_get_has_tracklist (UnityMprisRoot* self);
static GVariant* _dbus_unity_mpris_root_get_can_quit (UnityMprisRoot* self);
static GVariant* _dbus_unity_mpris_root_get_can_raise (UnityMprisRoot* self);
static GVariant* _dbus_unity_mpris_root_get_identity (UnityMprisRoot* self);
static GVariant* _dbus_unity_mpris_root_get_desktop_entry (UnityMprisRoot* self);
static gboolean unity_mpris_root_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data);
static void _unity_mpris_root_unregister_object (gpointer user_data);
#define UNITY_MPRIS_PLAYER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), UNITY_TYPE_MPRIS_PLAYER, UnityMprisPlayerPrivate))
enum  {
	UNITY_MPRIS_PLAYER_DUMMY_PROPERTY,
	UNITY_MPRIS_PLAYER_METADATA,
	UNITY_MPRIS_PLAYER_PLAYBACK_STATUS,
	UNITY_MPRIS_PLAYER_CAN_CONTROL,
	UNITY_MPRIS_PLAYER_CAN_GO_NEXT,
	UNITY_MPRIS_PLAYER_CAN_GO_PREVIOUS,
	UNITY_MPRIS_PLAYER_CAN_PLAY,
	UNITY_MPRIS_PLAYER_CAN_PAUSE
};
static void unity_mpris_player_wire_it_up (UnityMprisPlayer* self);
void unity_mpris_player_on_metadata_update (UnityMprisPlayer* self, GParamSpec* pspec);
static void _unity_mpris_player_on_metadata_update_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void __lambda18_ (UnityMprisPlayer* self, GObject* obj, GParamSpec* pspec);
static GVariant* _variant_new67 (const gchar* value);
static void ___lambda18__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void __lambda19_ (UnityMprisPlayer* self, GObject* obj, GParamSpec* pspec);
static GVariant* _variant_new68 (gboolean value);
static void ___lambda19__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void __lambda20_ (UnityMprisPlayer* self, GObject* obj, GParamSpec* pspec);
static GVariant* _variant_new69 (gboolean value);
static void ___lambda20__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void __lambda21_ (UnityMprisPlayer* self, GObject* obj, GParamSpec* pspec);
static GVariant* _variant_new70 (gboolean value);
static void ___lambda21__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void __lambda22_ (UnityMprisPlayer* self, GObject* obj, GParamSpec* pspec);
static GVariant* _variant_new71 (gboolean value);
static void ___lambda22__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static GVariant* _variant_new72 (const gchar* value);
static GVariant* _variant_new73 (gchar* value);
static GVariant* _variant_new74 (const gchar* value);
static GVariant* _variant_new75 (const gchar* value);
static GVariant* _variant_new76 (const gchar* value);
static GVariant* _variant_new77 (GHashTable* value);
static void unity_mpris_player_play_pause_data_free (gpointer _data);
void unity_mpris_player_play_pause (UnityMprisPlayer* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void unity_mpris_player_play_pause_finish (UnityMprisPlayer* self, GAsyncResult* _res_, GError** error);
static gboolean unity_mpris_player_play_pause_co (UnityMprisPlayerPlayPauseData* _data_);
static void unity_mpris_player_next_data_free (gpointer _data);
void unity_mpris_player_next (UnityMprisPlayer* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void unity_mpris_player_next_finish (UnityMprisPlayer* self, GAsyncResult* _res_, GError** error);
static gboolean unity_mpris_player_next_co (UnityMprisPlayerNextData* _data_);
static void unity_mpris_player_previous_data_free (gpointer _data);
void unity_mpris_player_previous (UnityMprisPlayer* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void unity_mpris_player_previous_finish (UnityMprisPlayer* self, GAsyncResult* _res_, GError** error);
static gboolean unity_mpris_player_previous_co (UnityMprisPlayerPreviousData* _data_);
GHashTable* unity_mpris_player_get_metadata (UnityMprisPlayer* self);
const gchar* unity_mpris_player_get_playback_status (UnityMprisPlayer* self);
gboolean unity_mpris_player_get_can_control (UnityMprisPlayer* self);
gboolean unity_mpris_player_get_can_go_next (UnityMprisPlayer* self);
gboolean unity_mpris_player_get_can_go_previous (UnityMprisPlayer* self);
gboolean unity_mpris_player_get_can_play (UnityMprisPlayer* self);
gboolean unity_mpris_player_get_can_pause (UnityMprisPlayer* self);
static GObject * unity_mpris_player_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void unity_mpris_player_finalize (GObject* obj);
static void _vala_unity_mpris_player_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _dbus_unity_mpris_player_play_pause (UnityMprisPlayer* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_unity_mpris_player_play_pause_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_);
static void _dbus_unity_mpris_player_next (UnityMprisPlayer* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_unity_mpris_player_next_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_);
static void _dbus_unity_mpris_player_previous (UnityMprisPlayer* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_unity_mpris_player_previous_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_);
static void unity_mpris_player_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data);
static GVariant* unity_mpris_player_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data);
static GVariant* _dbus_unity_mpris_player_get_metadata (UnityMprisPlayer* self);
static GVariant* _dbus_unity_mpris_player_get_playback_status (UnityMprisPlayer* self);
static GVariant* _dbus_unity_mpris_player_get_can_control (UnityMprisPlayer* self);
static GVariant* _dbus_unity_mpris_player_get_can_go_next (UnityMprisPlayer* self);
static GVariant* _dbus_unity_mpris_player_get_can_go_previous (UnityMprisPlayer* self);
static GVariant* _dbus_unity_mpris_player_get_can_play (UnityMprisPlayer* self);
static GVariant* _dbus_unity_mpris_player_get_can_pause (UnityMprisPlayer* self);
static gboolean unity_mpris_player_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data);
static void _unity_mpris_player_unregister_object (gpointer user_data);
#define UNITY_MPRIS_PLAYLISTS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), UNITY_TYPE_MPRIS_PLAYLISTS, UnityMprisPlaylistsPrivate))
enum  {
	UNITY_MPRIS_PLAYLISTS_DUMMY_PROPERTY,
	UNITY_MPRIS_PLAYLISTS_ORDERINGS,
	UNITY_MPRIS_PLAYLISTS_PLAYLIST_COUNT,
	UNITY_MPRIS_PLAYLISTS_ACTIVE_PLAYLIST
};
static void unity_mpris_playlists_wire_up (UnityMprisPlaylists* self);
static void unity_mpris_playlists_on_current_playlist_update (UnityMprisPlaylists* self, GParamSpec* p);
static void _unity_mpris_playlists_on_current_playlist_update_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void unity_mpris_playlists_on_playlist_name_change (UnityMprisPlaylists* self, GParamSpec* p);
static void _unity_mpris_playlists_on_playlist_name_change_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void unity_mpris_playlists_on_playlist_count_change (UnityMprisPlaylists* self, GParamSpec* p);
static void _unity_mpris_playlists_on_playlist_count_change_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
void unity_mpris_playlists_get_active_playlist (UnityMprisPlaylists* self, UnityActivePlaylistContainer* result);
static GVariant* _variant_new78 (UnityActivePlaylistContainer value);
static void unity_mpris_playlists_prep_playlist (UnityMprisPlaylists* self, UnityPlaylist* unity_pl, UnityPlaylistDetails* outward);
static GVariant* _variant_new79 (gint value);
static void unity_mpris_playlists_activate_playlist_data_free (gpointer _data);
void unity_mpris_playlists_activate_playlist (UnityMprisPlaylists* self, const char* playlist_id, GAsyncReadyCallback _callback_, gpointer _user_data_);
void unity_mpris_playlists_activate_playlist_finish (UnityMprisPlaylists* self, GAsyncResult* _res_, GError** error);
static gboolean unity_mpris_playlists_activate_playlist_co (UnityMprisPlaylistsActivatePlaylistData* _data_);
static void _vala_UnityPlaylistDetails_array_free (UnityPlaylistDetails* array, gint array_length);
static void unity_mpris_playlists_get_playlists_data_free (gpointer _data);
void unity_mpris_playlists_get_playlists (UnityMprisPlaylists* self, guint32 index, guint32 max_count, const gchar* order, gboolean reverse_order, GAsyncReadyCallback _callback_, gpointer _user_data_);
UnityPlaylistDetails* unity_mpris_playlists_get_playlists_finish (UnityMprisPlaylists* self, GAsyncResult* _res_, int* result_length1, GError** error);
static gboolean unity_mpris_playlists_get_playlists_co (UnityMprisPlaylistsGetPlaylistsData* _data_);
static void _vala_array_add4 (UnityPlaylistDetails** array, int* length, int* size, const UnityPlaylistDetails* value);
gchar** unity_mpris_playlists_get_orderings (UnityMprisPlaylists* self, int* result_length1);
guint32 unity_mpris_playlists_get_playlist_count (UnityMprisPlaylists* self);
static GObject * unity_mpris_playlists_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void unity_mpris_playlists_finalize (GObject* obj);
static void _vala_unity_mpris_playlists_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _dbus_unity_mpris_playlists_activate_playlist (UnityMprisPlaylists* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_unity_mpris_playlists_activate_playlist_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_);
static void _dbus_unity_mpris_playlists_get_playlists (UnityMprisPlaylists* self, GVariant* parameters, GDBusMethodInvocation* invocation);
static void _dbus_unity_mpris_playlists_get_playlists_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_);
static void unity_mpris_playlists_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data);
static GVariant* unity_mpris_playlists_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data);
static GVariant* _dbus_unity_mpris_playlists_get_orderings (UnityMprisPlaylists* self);
static GVariant* _dbus_unity_mpris_playlists_get_playlist_count (UnityMprisPlaylists* self);
static GVariant* _dbus_unity_mpris_playlists_get_active_playlist (UnityMprisPlaylists* self);
static gboolean unity_mpris_playlists_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data);
static void _unity_mpris_playlists_unregister_object (gpointer user_data);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static const GDBusArgInfo _unity_sound_service_interface_dbus_arg_info_EnableTrackSpecificItems_object_path = {-1, "object_path", "o"};
static const GDBusArgInfo _unity_sound_service_interface_dbus_arg_info_EnableTrackSpecificItems_desktop_id = {-1, "desktop_id", "s"};
static const GDBusArgInfo * const _unity_sound_service_interface_dbus_arg_info_EnableTrackSpecificItems_in[] = {&_unity_sound_service_interface_dbus_arg_info_EnableTrackSpecificItems_object_path, &_unity_sound_service_interface_dbus_arg_info_EnableTrackSpecificItems_desktop_id, NULL};
static const GDBusArgInfo * const _unity_sound_service_interface_dbus_arg_info_EnableTrackSpecificItems_out[] = {NULL};
static const GDBusMethodInfo _unity_sound_service_interface_dbus_method_info_EnableTrackSpecificItems = {-1, "EnableTrackSpecificItems", (GDBusArgInfo **) (&_unity_sound_service_interface_dbus_arg_info_EnableTrackSpecificItems_in), (GDBusArgInfo **) (&_unity_sound_service_interface_dbus_arg_info_EnableTrackSpecificItems_out)};
static const GDBusArgInfo _unity_sound_service_interface_dbus_arg_info_EnablePlayerSpecificItems_object_path = {-1, "object_path", "o"};
static const GDBusArgInfo _unity_sound_service_interface_dbus_arg_info_EnablePlayerSpecificItems_desktop_id = {-1, "desktop_id", "s"};
static const GDBusArgInfo * const _unity_sound_service_interface_dbus_arg_info_EnablePlayerSpecificItems_in[] = {&_unity_sound_service_interface_dbus_arg_info_EnablePlayerSpecificItems_object_path, &_unity_sound_service_interface_dbus_arg_info_EnablePlayerSpecificItems_desktop_id, NULL};
static const GDBusArgInfo * const _unity_sound_service_interface_dbus_arg_info_EnablePlayerSpecificItems_out[] = {NULL};
static const GDBusMethodInfo _unity_sound_service_interface_dbus_method_info_EnablePlayerSpecificItems = {-1, "EnablePlayerSpecificItems", (GDBusArgInfo **) (&_unity_sound_service_interface_dbus_arg_info_EnablePlayerSpecificItems_in), (GDBusArgInfo **) (&_unity_sound_service_interface_dbus_arg_info_EnablePlayerSpecificItems_out)};
static const GDBusMethodInfo * const _unity_sound_service_interface_dbus_method_info[] = {&_unity_sound_service_interface_dbus_method_info_EnableTrackSpecificItems, &_unity_sound_service_interface_dbus_method_info_EnablePlayerSpecificItems, NULL};
static const GDBusSignalInfo * const _unity_sound_service_interface_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo * const _unity_sound_service_interface_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _unity_sound_service_interface_dbus_interface_info = {-1, "com.canonical.indicators.sound", (GDBusMethodInfo **) (&_unity_sound_service_interface_dbus_method_info), (GDBusSignalInfo **) (&_unity_sound_service_interface_dbus_signal_info), (GDBusPropertyInfo **) (&_unity_sound_service_interface_dbus_property_info)};
static const GDBusInterfaceVTable _unity_sound_service_interface_dbus_interface_vtable = {unity_sound_service_interface_dbus_interface_method_call, unity_sound_service_interface_dbus_interface_get_property, unity_sound_service_interface_dbus_interface_set_property};
static const GDBusArgInfo * const _unity_mpris_root_dbus_arg_info_raise_in[] = {NULL};
static const GDBusArgInfo * const _unity_mpris_root_dbus_arg_info_raise_out[] = {NULL};
static const GDBusMethodInfo _unity_mpris_root_dbus_method_info_raise = {-1, "Raise", (GDBusArgInfo **) (&_unity_mpris_root_dbus_arg_info_raise_in), (GDBusArgInfo **) (&_unity_mpris_root_dbus_arg_info_raise_out)};
static const GDBusMethodInfo * const _unity_mpris_root_dbus_method_info[] = {&_unity_mpris_root_dbus_method_info_raise, NULL};
static const GDBusSignalInfo * const _unity_mpris_root_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo _unity_mpris_root_dbus_property_info_has_tracklist = {-1, "HasTracklist", "b", G_DBUS_PROPERTY_INFO_FLAGS_READABLE};
static const GDBusPropertyInfo _unity_mpris_root_dbus_property_info_can_quit = {-1, "CanQuit", "b", G_DBUS_PROPERTY_INFO_FLAGS_READABLE};
static const GDBusPropertyInfo _unity_mpris_root_dbus_property_info_can_raise = {-1, "CanRaise", "b", G_DBUS_PROPERTY_INFO_FLAGS_READABLE};
static const GDBusPropertyInfo _unity_mpris_root_dbus_property_info_identity = {-1, "Identity", "s", G_DBUS_PROPERTY_INFO_FLAGS_READABLE};
static const GDBusPropertyInfo _unity_mpris_root_dbus_property_info_desktop_entry = {-1, "DesktopEntry", "s", G_DBUS_PROPERTY_INFO_FLAGS_READABLE};
static const GDBusPropertyInfo * const _unity_mpris_root_dbus_property_info[] = {&_unity_mpris_root_dbus_property_info_has_tracklist, &_unity_mpris_root_dbus_property_info_can_quit, &_unity_mpris_root_dbus_property_info_can_raise, &_unity_mpris_root_dbus_property_info_identity, &_unity_mpris_root_dbus_property_info_desktop_entry, NULL};
static const GDBusInterfaceInfo _unity_mpris_root_dbus_interface_info = {-1, "org.mpris.MediaPlayer2", (GDBusMethodInfo **) (&_unity_mpris_root_dbus_method_info), (GDBusSignalInfo **) (&_unity_mpris_root_dbus_signal_info), (GDBusPropertyInfo **) (&_unity_mpris_root_dbus_property_info)};
static const GDBusInterfaceVTable _unity_mpris_root_dbus_interface_vtable = {unity_mpris_root_dbus_interface_method_call, unity_mpris_root_dbus_interface_get_property, unity_mpris_root_dbus_interface_set_property};
static const GDBusArgInfo * const _unity_mpris_player_dbus_arg_info_play_pause_in[] = {NULL};
static const GDBusArgInfo * const _unity_mpris_player_dbus_arg_info_play_pause_out[] = {NULL};
static const GDBusMethodInfo _unity_mpris_player_dbus_method_info_play_pause = {-1, "PlayPause", (GDBusArgInfo **) (&_unity_mpris_player_dbus_arg_info_play_pause_in), (GDBusArgInfo **) (&_unity_mpris_player_dbus_arg_info_play_pause_out)};
static const GDBusArgInfo * const _unity_mpris_player_dbus_arg_info_next_in[] = {NULL};
static const GDBusArgInfo * const _unity_mpris_player_dbus_arg_info_next_out[] = {NULL};
static const GDBusMethodInfo _unity_mpris_player_dbus_method_info_next = {-1, "Next", (GDBusArgInfo **) (&_unity_mpris_player_dbus_arg_info_next_in), (GDBusArgInfo **) (&_unity_mpris_player_dbus_arg_info_next_out)};
static const GDBusArgInfo * const _unity_mpris_player_dbus_arg_info_previous_in[] = {NULL};
static const GDBusArgInfo * const _unity_mpris_player_dbus_arg_info_previous_out[] = {NULL};
static const GDBusMethodInfo _unity_mpris_player_dbus_method_info_previous = {-1, "Previous", (GDBusArgInfo **) (&_unity_mpris_player_dbus_arg_info_previous_in), (GDBusArgInfo **) (&_unity_mpris_player_dbus_arg_info_previous_out)};
static const GDBusMethodInfo * const _unity_mpris_player_dbus_method_info[] = {&_unity_mpris_player_dbus_method_info_play_pause, &_unity_mpris_player_dbus_method_info_next, &_unity_mpris_player_dbus_method_info_previous, NULL};
static const GDBusSignalInfo * const _unity_mpris_player_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo _unity_mpris_player_dbus_property_info_metadata = {-1, "Metadata", "a{sv}", G_DBUS_PROPERTY_INFO_FLAGS_READABLE};
static const GDBusPropertyInfo _unity_mpris_player_dbus_property_info_playback_status = {-1, "PlaybackStatus", "s", G_DBUS_PROPERTY_INFO_FLAGS_READABLE};
static const GDBusPropertyInfo _unity_mpris_player_dbus_property_info_can_control = {-1, "CanControl", "b", G_DBUS_PROPERTY_INFO_FLAGS_READABLE};
static const GDBusPropertyInfo _unity_mpris_player_dbus_property_info_can_go_next = {-1, "CanGoNext", "b", G_DBUS_PROPERTY_INFO_FLAGS_READABLE};
static const GDBusPropertyInfo _unity_mpris_player_dbus_property_info_can_go_previous = {-1, "CanGoPrevious", "b", G_DBUS_PROPERTY_INFO_FLAGS_READABLE};
static const GDBusPropertyInfo _unity_mpris_player_dbus_property_info_can_play = {-1, "CanPlay", "b", G_DBUS_PROPERTY_INFO_FLAGS_READABLE};
static const GDBusPropertyInfo _unity_mpris_player_dbus_property_info_can_pause = {-1, "CanPause", "b", G_DBUS_PROPERTY_INFO_FLAGS_READABLE};
static const GDBusPropertyInfo * const _unity_mpris_player_dbus_property_info[] = {&_unity_mpris_player_dbus_property_info_metadata, &_unity_mpris_player_dbus_property_info_playback_status, &_unity_mpris_player_dbus_property_info_can_control, &_unity_mpris_player_dbus_property_info_can_go_next, &_unity_mpris_player_dbus_property_info_can_go_previous, &_unity_mpris_player_dbus_property_info_can_play, &_unity_mpris_player_dbus_property_info_can_pause, NULL};
static const GDBusInterfaceInfo _unity_mpris_player_dbus_interface_info = {-1, "org.mpris.MediaPlayer2.Player", (GDBusMethodInfo **) (&_unity_mpris_player_dbus_method_info), (GDBusSignalInfo **) (&_unity_mpris_player_dbus_signal_info), (GDBusPropertyInfo **) (&_unity_mpris_player_dbus_property_info)};
static const GDBusInterfaceVTable _unity_mpris_player_dbus_interface_vtable = {unity_mpris_player_dbus_interface_method_call, unity_mpris_player_dbus_interface_get_property, unity_mpris_player_dbus_interface_set_property};
static const GDBusArgInfo _unity_mpris_playlists_dbus_arg_info_activate_playlist_playlist_id = {-1, "playlist_id", "o"};
static const GDBusArgInfo * const _unity_mpris_playlists_dbus_arg_info_activate_playlist_in[] = {&_unity_mpris_playlists_dbus_arg_info_activate_playlist_playlist_id, NULL};
static const GDBusArgInfo * const _unity_mpris_playlists_dbus_arg_info_activate_playlist_out[] = {NULL};
static const GDBusMethodInfo _unity_mpris_playlists_dbus_method_info_activate_playlist = {-1, "ActivatePlaylist", (GDBusArgInfo **) (&_unity_mpris_playlists_dbus_arg_info_activate_playlist_in), (GDBusArgInfo **) (&_unity_mpris_playlists_dbus_arg_info_activate_playlist_out)};
static const GDBusArgInfo _unity_mpris_playlists_dbus_arg_info_get_playlists_index = {-1, "index", "u"};
static const GDBusArgInfo _unity_mpris_playlists_dbus_arg_info_get_playlists_max_count = {-1, "max_count", "u"};
static const GDBusArgInfo _unity_mpris_playlists_dbus_arg_info_get_playlists_order = {-1, "order", "s"};
static const GDBusArgInfo _unity_mpris_playlists_dbus_arg_info_get_playlists_reverse_order = {-1, "reverse_order", "b"};
static const GDBusArgInfo _unity_mpris_playlists_dbus_arg_info_get_playlists_result = {-1, "result", "a(oss)"};
static const GDBusArgInfo * const _unity_mpris_playlists_dbus_arg_info_get_playlists_in[] = {&_unity_mpris_playlists_dbus_arg_info_get_playlists_index, &_unity_mpris_playlists_dbus_arg_info_get_playlists_max_count, &_unity_mpris_playlists_dbus_arg_info_get_playlists_order, &_unity_mpris_playlists_dbus_arg_info_get_playlists_reverse_order, NULL};
static const GDBusArgInfo * const _unity_mpris_playlists_dbus_arg_info_get_playlists_out[] = {&_unity_mpris_playlists_dbus_arg_info_get_playlists_result, NULL};
static const GDBusMethodInfo _unity_mpris_playlists_dbus_method_info_get_playlists = {-1, "GetPlaylists", (GDBusArgInfo **) (&_unity_mpris_playlists_dbus_arg_info_get_playlists_in), (GDBusArgInfo **) (&_unity_mpris_playlists_dbus_arg_info_get_playlists_out)};
static const GDBusMethodInfo * const _unity_mpris_playlists_dbus_method_info[] = {&_unity_mpris_playlists_dbus_method_info_activate_playlist, &_unity_mpris_playlists_dbus_method_info_get_playlists, NULL};
static const GDBusSignalInfo * const _unity_mpris_playlists_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo _unity_mpris_playlists_dbus_property_info_orderings = {-1, "Orderings", "as", G_DBUS_PROPERTY_INFO_FLAGS_READABLE};
static const GDBusPropertyInfo _unity_mpris_playlists_dbus_property_info_playlist_count = {-1, "PlaylistCount", "u", G_DBUS_PROPERTY_INFO_FLAGS_READABLE};
static const GDBusPropertyInfo _unity_mpris_playlists_dbus_property_info_active_playlist = {-1, "ActivePlaylist", "(b(oss))", G_DBUS_PROPERTY_INFO_FLAGS_READABLE};
static const GDBusPropertyInfo * const _unity_mpris_playlists_dbus_property_info[] = {&_unity_mpris_playlists_dbus_property_info_orderings, &_unity_mpris_playlists_dbus_property_info_playlist_count, &_unity_mpris_playlists_dbus_property_info_active_playlist, NULL};
static const GDBusInterfaceInfo _unity_mpris_playlists_dbus_interface_info = {-1, "org.mpris.MediaPlayer2.Playlists", (GDBusMethodInfo **) (&_unity_mpris_playlists_dbus_method_info), (GDBusSignalInfo **) (&_unity_mpris_playlists_dbus_signal_info), (GDBusPropertyInfo **) (&_unity_mpris_playlists_dbus_property_info)};
static const GDBusInterfaceVTable _unity_mpris_playlists_dbus_interface_vtable = {unity_mpris_playlists_dbus_interface_method_call, unity_mpris_playlists_dbus_interface_get_property, unity_mpris_playlists_dbus_interface_set_property};

UnityMPRISGateway* unity_mpris_gateway_construct (GType object_type, UnityMusicPlayer* client) {
	UnityMPRISGateway * self = NULL;
	UnityMusicPlayer* _tmp0_;
	g_return_val_if_fail (client != NULL, NULL);
	_tmp0_ = client;
	self = (UnityMPRISGateway*) g_object_new (object_type, "consumer", _tmp0_, NULL);
	return self;
}


UnityMPRISGateway* unity_mpris_gateway_new (UnityMusicPlayer* client) {
	return unity_mpris_gateway_construct (UNITY_TYPE_MPRIS_GATEWAY, client);
}


static Block10Data* block10_data_ref (Block10Data* _data10_) {
	g_atomic_int_inc (&_data10_->_ref_count_);
	return _data10_;
}


static void block10_data_unref (Block10Data* _data10_) {
	if (g_atomic_int_dec_and_test (&_data10_->_ref_count_)) {
		_g_object_unref0 (_data10_->self);
		_g_free0 (_data10_->dbus_name);
		g_slice_free (Block10Data, _data10_);
	}
}


static void __lambda23_ (Block10Data* _data10_) {
	UnityMPRISGateway * self;
	const gchar* _tmp0_;
	self = _data10_->self;
	_tmp0_ = _data10_->dbus_name;
	unity_trace_log ("Owning name %s", _tmp0_);
}


static void ___lambda23__gbus_name_acquired_callback (GDBusConnection* connection, const gchar* name, gpointer self) {
	__lambda23_ (self);
}


static void _unity_mpris_gateway_on_name_lost_gbus_name_lost_callback (GDBusConnection* connection, const gchar* name, gpointer self) {
	unity_mpris_gateway_on_name_lost (self, connection, name);
}


void unity_mpris_gateway_export (UnityMPRISGateway* self) {
	Block10Data* _data10_;
	guint _tmp0_;
	GDBusConnection* _tmp1_;
	UnityPropertyUpdateManager* _tmp4_;
	UnityMprisRoot* _tmp7_;
	UnityMprisPlayer* _tmp11_;
	UnityMprisPlaylists* _tmp15_;
	UnityMusicPlayer* _tmp33_;
	GAppInfo* _tmp34_;
	GAppInfo* _tmp35_;
	const gchar* _tmp36_ = NULL;
	gchar* _tmp37_ = NULL;
	gchar* mpris_extension;
	const gchar* _tmp38_;
	gchar* _tmp39_ = NULL;
	const gchar* _tmp40_;
	guint _tmp41_ = 0U;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_data10_ = g_slice_new0 (Block10Data);
	_data10_->_ref_count_ = 1;
	_data10_->self = g_object_ref (self);
	_tmp0_ = self->priv->bus_name_owner_handle;
	if (_tmp0_ != ((guint) 0)) {
		g_critical ("unity-sound-menu-mpris.vala:73: Can not export MPRISGateway@%p. It is " \
"already exported", self);
		block10_data_unref (_data10_);
		_data10_ = NULL;
		return;
	}
	_tmp1_ = self->priv->dbus_connection;
	if (_tmp1_ == NULL) {
		{
			GDBusConnection* _tmp2_ = NULL;
			GDBusConnection* _tmp3_;
			_tmp2_ = g_bus_get_sync (G_BUS_TYPE_SESSION, NULL, &_inner_error_);
			_tmp3_ = _tmp2_;
			if (_inner_error_ != NULL) {
				if (_inner_error_->domain == G_IO_ERROR) {
					goto __catch34_g_io_error;
				}
				block10_data_unref (_data10_);
				_data10_ = NULL;
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
			_g_object_unref0 (self->priv->dbus_connection);
			self->priv->dbus_connection = _tmp3_;
		}
		goto __finally34;
		__catch34_g_io_error:
		{
			GError* e = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			g_critical ("unity-sound-menu-mpris.vala:83: unity-sound-menu-mpris-MPRISGateway: C" \
"annot connect to the session bus.");
			_g_error_free0 (e);
		}
		__finally34:
		if (_inner_error_ != NULL) {
			block10_data_unref (_data10_);
			_data10_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp4_ = self->priv->prop_manager;
	if (_tmp4_ == NULL) {
		GDBusConnection* _tmp5_;
		UnityPropertyUpdateManager* _tmp6_;
		_tmp5_ = self->priv->dbus_connection;
		_tmp6_ = unity_property_update_manager_new (_tmp5_);
		_g_object_unref0 (self->priv->prop_manager);
		self->priv->prop_manager = _tmp6_;
	}
	_tmp7_ = self->priv->mpris_root_interface;
	if (_tmp7_ == NULL) {
		UnityMusicPlayer* _tmp8_;
		UnityPropertyUpdateManager* _tmp9_;
		UnityMprisRoot* _tmp10_;
		_tmp8_ = self->priv->_consumer;
		_tmp9_ = self->priv->prop_manager;
		_tmp10_ = unity_mpris_root_new (_tmp8_, _tmp9_);
		_g_object_unref0 (self->priv->mpris_root_interface);
		self->priv->mpris_root_interface = _tmp10_;
	}
	_tmp11_ = self->priv->mpris_player_interface;
	if (_tmp11_ == NULL) {
		UnityMusicPlayer* _tmp12_;
		UnityPropertyUpdateManager* _tmp13_;
		UnityMprisPlayer* _tmp14_;
		_tmp12_ = self->priv->_consumer;
		_tmp13_ = self->priv->prop_manager;
		_tmp14_ = unity_mpris_player_new (_tmp12_, _tmp13_);
		_g_object_unref0 (self->priv->mpris_player_interface);
		self->priv->mpris_player_interface = _tmp14_;
	}
	_tmp15_ = self->priv->mpris_playlist_interface;
	if (_tmp15_ == NULL) {
		UnityMusicPlayer* _tmp16_;
		UnityPropertyUpdateManager* _tmp17_;
		UnityMprisPlaylists* _tmp18_;
		_tmp16_ = self->priv->_consumer;
		_tmp17_ = self->priv->prop_manager;
		_tmp18_ = unity_mpris_playlists_new (_tmp16_, _tmp17_, self);
		_g_object_unref0 (self->priv->mpris_playlist_interface);
		self->priv->mpris_playlist_interface = _tmp18_;
	}
	{
		GDBusConnection* _tmp19_;
		UnityMprisRoot* _tmp20_;
		guint _tmp21_ = 0U;
		guint _tmp22_;
		GDBusConnection* _tmp23_;
		UnityMprisPlayer* _tmp24_;
		guint _tmp25_ = 0U;
		guint _tmp26_;
		_tmp19_ = self->priv->dbus_connection;
		_tmp20_ = self->priv->mpris_root_interface;
		_tmp21_ = unity_mpris_root_register_object (_tmp20_, _tmp19_, UNITY_MPRIS_INTERFACE_ROOT_PATH, &_inner_error_);
		_tmp22_ = _tmp21_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_IO_ERROR) {
				goto __catch35_g_io_error;
			}
			block10_data_unref (_data10_);
			_data10_ = NULL;
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		self->priv->bus_root_iface_handle = _tmp22_;
		_tmp23_ = self->priv->dbus_connection;
		_tmp24_ = self->priv->mpris_player_interface;
		_tmp25_ = unity_mpris_player_register_object (_tmp24_, _tmp23_, UNITY_MPRIS_INTERFACE_ROOT_PATH, &_inner_error_);
		_tmp26_ = _tmp25_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_IO_ERROR) {
				goto __catch35_g_io_error;
			}
			block10_data_unref (_data10_);
			_data10_ = NULL;
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		self->priv->bus_root_iface_handle = _tmp26_;
	}
	goto __finally35;
	__catch35_g_io_error:
	{
		GError* e = NULL;
		UnityMusicPlayer* _tmp27_;
		GAppInfo* _tmp28_;
		GAppInfo* _tmp29_;
		const gchar* _tmp30_ = NULL;
		GError* _tmp31_;
		const gchar* _tmp32_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp27_ = self->priv->_consumer;
		_tmp28_ = unity_music_player_get_app_info (_tmp27_);
		_tmp29_ = _tmp28_;
		_tmp30_ = g_app_info_get_name (_tmp29_);
		_tmp31_ = e;
		_tmp32_ = _tmp31_->message;
		g_critical ("unity-sound-menu-mpris.vala:107: Could not register root or player int" \
"erface for '%s': %s", _tmp30_, _tmp32_);
		_g_error_free0 (e);
	}
	__finally35:
	if (_inner_error_ != NULL) {
		block10_data_unref (_data10_);
		_data10_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp33_ = self->priv->_consumer;
	_tmp34_ = unity_music_player_get_app_info (_tmp33_);
	_tmp35_ = _tmp34_;
	_tmp36_ = g_app_info_get_name (_tmp35_);
	_tmp37_ = g_utf8_strdown (_tmp36_, (gssize) (-1));
	mpris_extension = _tmp37_;
	_tmp38_ = mpris_extension;
	_tmp39_ = g_strconcat (UNITY_MPRIS_INTERFACE_PREFIX, _tmp38_, NULL);
	_data10_->dbus_name = _tmp39_;
	_tmp40_ = _data10_->dbus_name;
	_tmp41_ = g_bus_own_name_with_closures (G_BUS_TYPE_SESSION, _tmp40_, G_BUS_NAME_OWNER_FLAGS_NONE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)), (GClosure*) ((___lambda23__gbus_name_acquired_callback == NULL) ? NULL : g_cclosure_new ((GCallback) ___lambda23__gbus_name_acquired_callback, block10_data_ref (_data10_), block10_data_unref)), (GClosure*) ((_unity_mpris_gateway_on_name_lost_gbus_name_lost_callback == NULL) ? NULL : g_cclosure_new ((GCallback) _unity_mpris_gateway_on_name_lost_gbus_name_lost_callback, g_object_ref (self), g_object_unref)));
	self->priv->bus_name_owner_handle = _tmp41_;
	_g_free0 (mpris_extension);
	block10_data_unref (_data10_);
	_data10_ = NULL;
}


void unity_mpris_gateway_unexport (UnityMPRISGateway* self) {
	guint _tmp0_;
	guint _tmp1_;
	GDBusConnection* _tmp2_;
	guint _tmp3_;
	GDBusConnection* _tmp4_;
	guint _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->bus_name_owner_handle;
	if (_tmp0_ == ((guint) 0)) {
		g_critical ("unity-sound-menu-mpris.vala:126: Can not unexport MPRISGateway@%p. It " \
"is not exported", self);
		return;
	}
	_tmp1_ = self->priv->bus_name_owner_handle;
	g_bus_unown_name (_tmp1_);
	self->priv->bus_name_owner_handle = (guint) 0;
	_tmp2_ = self->priv->dbus_connection;
	_tmp3_ = self->priv->bus_root_iface_handle;
	g_dbus_connection_unregister_object (_tmp2_, _tmp3_);
	self->priv->bus_root_iface_handle = (guint) 0;
	_tmp4_ = self->priv->dbus_connection;
	_tmp5_ = self->priv->bus_player_iface_handle;
	g_dbus_connection_unregister_object (_tmp4_, _tmp5_);
	self->priv->bus_player_iface_handle = (guint) 0;
}


static void unity_mpris_gateway_on_name_lost (UnityMPRISGateway* self, GDBusConnection* conn, const gchar* name) {
	const gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (conn != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = name;
	unity_trace_log_object ((GObject*) self, "Lost name '%s'", _tmp0_);
}


void unity_mpris_gateway_ensure_playlist_interface_is_raised (UnityMPRISGateway* self) {
	gboolean _tmp0_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->playlist_interface_raised;
	if (_tmp0_ == TRUE) {
		return;
	}
	{
		GDBusConnection* _tmp1_;
		UnityMprisPlaylists* _tmp2_;
		_tmp1_ = self->priv->dbus_connection;
		_tmp2_ = self->priv->mpris_playlist_interface;
		unity_mpris_playlists_register_object (_tmp2_, _tmp1_, UNITY_MPRIS_INTERFACE_ROOT_PATH, &_inner_error_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_IO_ERROR) {
				goto __catch36_g_io_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		self->priv->playlist_interface_raised = TRUE;
	}
	goto __finally36;
	__catch36_g_io_error:
	{
		GError* e = NULL;
		UnityMusicPlayer* _tmp3_;
		GAppInfo* _tmp4_;
		GAppInfo* _tmp5_;
		const gchar* _tmp6_ = NULL;
		GError* _tmp7_;
		const gchar* _tmp8_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = self->priv->_consumer;
		_tmp4_ = unity_music_player_get_app_info (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = g_app_info_get_name (_tmp5_);
		_tmp7_ = e;
		_tmp8_ = _tmp7_->message;
		g_critical ("unity-sound-menu-mpris.vala:155: Could not register playlist interface" \
" for %s: %s", _tmp6_, _tmp8_);
		_g_error_free0 (e);
	}
	__finally36:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


UnityMusicPlayer* unity_mpris_gateway_get_consumer (UnityMPRISGateway* self) {
	UnityMusicPlayer* result;
	UnityMusicPlayer* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_consumer;
	result = _tmp0_;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void unity_mpris_gateway_set_consumer (UnityMPRISGateway* self, UnityMusicPlayer* value) {
	UnityMusicPlayer* _tmp0_;
	UnityMusicPlayer* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_consumer);
	self->priv->_consumer = _tmp1_;
	g_object_notify ((GObject *) self, "consumer");
}


UnityPlaylist* unity_mpris_gateway_get_edited_playlist (UnityMPRISGateway* self) {
	UnityPlaylist* result;
	UnityPlaylist* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_edited_playlist;
	result = _tmp0_;
	return result;
}


void unity_mpris_gateway_set_edited_playlist (UnityMPRISGateway* self, UnityPlaylist* value) {
	UnityPlaylist* _tmp0_;
	UnityPlaylist* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_edited_playlist);
	self->priv->_edited_playlist = _tmp1_;
	g_object_notify ((GObject *) self, "edited-playlist");
}


gint unity_mpris_gateway_get_playlist_count (UnityMPRISGateway* self) {
	gint result;
	gint _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_playlist_count;
	result = _tmp0_;
	return result;
}


void unity_mpris_gateway_set_playlist_count (UnityMPRISGateway* self, gint value) {
	gint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_playlist_count = _tmp0_;
	g_object_notify ((GObject *) self, "playlist-count");
}


static GObject * unity_mpris_gateway_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	UnityMPRISGateway * self;
	UnityMusicPlayer* _tmp0_;
	UnityBlacklistManager* _tmp1_;
	UnityMusicPlayer* _tmp2_;
	UnitySpecificItemManager* _tmp3_;
	parent_class = G_OBJECT_CLASS (unity_mpris_gateway_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = UNITY_MPRIS_GATEWAY (obj);
	_tmp0_ = self->priv->_consumer;
	_tmp1_ = unity_blacklist_manager_new (_tmp0_);
	_g_object_unref0 (self->priv->blacklist_mgr);
	self->priv->blacklist_mgr = _tmp1_;
	_tmp2_ = self->priv->_consumer;
	_tmp3_ = unity_specific_item_manager_new (_tmp2_);
	_g_object_unref0 (self->priv->specific_menuitem_mgr);
	self->priv->specific_menuitem_mgr = _tmp3_;
	self->priv->playlist_interface_raised = FALSE;
	self->priv->bus_name_owner_handle = (guint) 0;
	self->priv->bus_root_iface_handle = (guint) 0;
	self->priv->bus_player_iface_handle = (guint) 0;
	return obj;
}


static void unity_mpris_gateway_class_init (UnityMPRISGatewayClass * klass) {
	unity_mpris_gateway_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (UnityMPRISGatewayPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_unity_mpris_gateway_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_unity_mpris_gateway_set_property;
	G_OBJECT_CLASS (klass)->constructor = unity_mpris_gateway_constructor;
	G_OBJECT_CLASS (klass)->finalize = unity_mpris_gateway_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_MPRIS_GATEWAY_CONSUMER, g_param_spec_object ("consumer", "consumer", "consumer", UNITY_TYPE_MUSIC_PLAYER, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_MPRIS_GATEWAY_EDITED_PLAYLIST, g_param_spec_object ("edited-playlist", "edited-playlist", "edited-playlist", UNITY_TYPE_PLAYLIST, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_MPRIS_GATEWAY_PLAYLIST_COUNT, g_param_spec_int ("playlist-count", "playlist-count", "playlist-count", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void unity_mpris_gateway_instance_init (UnityMPRISGateway * self) {
	self->priv = UNITY_MPRIS_GATEWAY_GET_PRIVATE (self);
}


static void unity_mpris_gateway_finalize (GObject* obj) {
	UnityMPRISGateway * self;
	self = UNITY_MPRIS_GATEWAY (obj);
	_g_object_unref0 (self->priv->_consumer);
	_g_object_unref0 (self->priv->mpris_root_interface);
	_g_object_unref0 (self->priv->mpris_player_interface);
	_g_object_unref0 (self->priv->mpris_playlist_interface);
	_g_object_unref0 (self->priv->prop_manager);
	_g_object_unref0 (self->priv->blacklist_mgr);
	_g_object_unref0 (self->priv->specific_menuitem_mgr);
	_g_object_unref0 (self->priv->dbus_connection);
	_g_object_unref0 (self->priv->_edited_playlist);
	G_OBJECT_CLASS (unity_mpris_gateway_parent_class)->finalize (obj);
}


GType unity_mpris_gateway_get_type (void) {
	static volatile gsize unity_mpris_gateway_type_id__volatile = 0;
	if (g_once_init_enter (&unity_mpris_gateway_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UnityMPRISGatewayClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unity_mpris_gateway_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnityMPRISGateway), 0, (GInstanceInitFunc) unity_mpris_gateway_instance_init, NULL };
		GType unity_mpris_gateway_type_id;
		unity_mpris_gateway_type_id = g_type_register_static (G_TYPE_OBJECT, "UnityMPRISGateway", &g_define_type_info, 0);
		g_once_init_leave (&unity_mpris_gateway_type_id__volatile, unity_mpris_gateway_type_id);
	}
	return unity_mpris_gateway_type_id__volatile;
}


static void _vala_unity_mpris_gateway_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	UnityMPRISGateway * self;
	self = UNITY_MPRIS_GATEWAY (object);
	switch (property_id) {
		case UNITY_MPRIS_GATEWAY_CONSUMER:
		g_value_set_object (value, unity_mpris_gateway_get_consumer (self));
		break;
		case UNITY_MPRIS_GATEWAY_EDITED_PLAYLIST:
		g_value_set_object (value, unity_mpris_gateway_get_edited_playlist (self));
		break;
		case UNITY_MPRIS_GATEWAY_PLAYLIST_COUNT:
		g_value_set_int (value, unity_mpris_gateway_get_playlist_count (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_unity_mpris_gateway_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	UnityMPRISGateway * self;
	self = UNITY_MPRIS_GATEWAY (object);
	switch (property_id) {
		case UNITY_MPRIS_GATEWAY_CONSUMER:
		unity_mpris_gateway_set_consumer (self, g_value_get_object (value));
		break;
		case UNITY_MPRIS_GATEWAY_EDITED_PLAYLIST:
		unity_mpris_gateway_set_edited_playlist (self, g_value_get_object (value));
		break;
		case UNITY_MPRIS_GATEWAY_PLAYLIST_COUNT:
		unity_mpris_gateway_set_playlist_count (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


UnitySpecificItemManager* unity_specific_item_manager_construct (GType object_type, UnityMusicPlayer* client) {
	UnitySpecificItemManager * self = NULL;
	UnityMusicPlayer* _tmp0_;
	g_return_val_if_fail (client != NULL, NULL);
	_tmp0_ = client;
	self = (UnitySpecificItemManager*) g_object_new (object_type, "consumer", _tmp0_, NULL);
	return self;
}


UnitySpecificItemManager* unity_specific_item_manager_new (UnityMusicPlayer* client) {
	return unity_specific_item_manager_construct (UNITY_TYPE_SPECIFIC_ITEM_MANAGER, client);
}


static void unity_specific_item_manager_on_track_specific_change (UnitySpecificItemManager* self, GParamSpec* p) {
	gboolean _tmp0_ = FALSE;
	UnityMusicPlayer* _tmp1_;
	DbusmenuMenuitem* _tmp2_;
	DbusmenuMenuitem* _tmp3_;
	gboolean _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (p != NULL);
	_tmp1_ = self->priv->_consumer;
	_tmp2_ = unity_music_player_get_track_menu (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ != NULL) {
		DbusmenuServer* _tmp4_;
		_tmp4_ = self->priv->_track_item_server;
		_tmp0_ = _tmp4_ == NULL;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp5_ = _tmp0_;
	if (_tmp5_) {
		const char* _tmp6_;
		DbusmenuServer* _tmp7_;
		UnitySoundServiceInterface* _tmp8_;
		const char* _tmp9_;
		UnityMusicPlayer* _tmp10_;
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		gchar** _tmp13_;
		gchar** _tmp14_ = NULL;
		gchar** _tmp15_;
		gint _tmp15__length1;
		const gchar* _tmp16_;
		DbusmenuServer* _tmp17_;
		UnityMusicPlayer* _tmp18_;
		DbusmenuMenuitem* _tmp19_;
		DbusmenuMenuitem* _tmp20_;
		_tmp6_ = self->_track_specific_object_path;
		_tmp7_ = dbusmenu_server_new ((const gchar*) _tmp6_);
		_g_object_unref0 (self->priv->_track_item_server);
		self->priv->_track_item_server = _tmp7_;
		_tmp8_ = self->priv->sound_service_interface;
		_tmp9_ = self->_track_specific_object_path;
		_tmp10_ = self->priv->_consumer;
		_tmp11_ = unity_music_player_get_desktop_file_name (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp14_ = _tmp13_ = g_strsplit (_tmp12_, ".", 0);
		_tmp15_ = _tmp14_;
		_tmp15__length1 = _vala_array_length (_tmp13_);
		_tmp16_ = _tmp15_[0];
		unity_sound_service_interface_EnableTrackSpecificItems (_tmp8_, _tmp9_, _tmp16_, NULL, NULL);
		_tmp15_ = (_vala_array_free (_tmp15_, _tmp15__length1, (GDestroyNotify) g_free), NULL);
		_tmp17_ = self->priv->_track_item_server;
		_tmp18_ = self->priv->_consumer;
		_tmp19_ = unity_music_player_get_track_menu (_tmp18_);
		_tmp20_ = _tmp19_;
		g_object_set (_tmp17_, "root-node", _tmp20_, NULL);
	} else {
		UnityMusicPlayer* _tmp21_;
		DbusmenuMenuitem* _tmp22_;
		DbusmenuMenuitem* _tmp23_;
		_tmp21_ = self->priv->_consumer;
		_tmp22_ = unity_music_player_get_track_menu (_tmp21_);
		_tmp23_ = _tmp22_;
		if (_tmp23_ == NULL) {
			_g_object_unref0 (self->priv->_track_item_server);
			self->priv->_track_item_server = NULL;
		}
	}
}


static void unity_specific_item_manager_on_player_specific_change (UnitySpecificItemManager* self, GParamSpec* p) {
	gboolean _tmp0_ = FALSE;
	UnityMusicPlayer* _tmp1_;
	DbusmenuMenuitem* _tmp2_;
	DbusmenuMenuitem* _tmp3_;
	gboolean _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (p != NULL);
	_tmp1_ = self->priv->_consumer;
	_tmp2_ = unity_music_player_get_player_menu (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ != NULL) {
		DbusmenuServer* _tmp4_;
		_tmp4_ = self->priv->_player_item_server;
		_tmp0_ = _tmp4_ == NULL;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp5_ = _tmp0_;
	if (_tmp5_) {
		const char* _tmp6_;
		DbusmenuServer* _tmp7_;
		UnitySoundServiceInterface* _tmp8_;
		const char* _tmp9_;
		UnityMusicPlayer* _tmp10_;
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		gchar** _tmp13_;
		gchar** _tmp14_ = NULL;
		gchar** _tmp15_;
		gint _tmp15__length1;
		const gchar* _tmp16_;
		DbusmenuServer* _tmp17_;
		UnityMusicPlayer* _tmp18_;
		DbusmenuMenuitem* _tmp19_;
		DbusmenuMenuitem* _tmp20_;
		_tmp6_ = self->_player_specific_object_path;
		_tmp7_ = dbusmenu_server_new ((const gchar*) _tmp6_);
		_g_object_unref0 (self->priv->_player_item_server);
		self->priv->_player_item_server = _tmp7_;
		_tmp8_ = self->priv->sound_service_interface;
		_tmp9_ = self->_player_specific_object_path;
		_tmp10_ = self->priv->_consumer;
		_tmp11_ = unity_music_player_get_desktop_file_name (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp14_ = _tmp13_ = g_strsplit (_tmp12_, ".", 0);
		_tmp15_ = _tmp14_;
		_tmp15__length1 = _vala_array_length (_tmp13_);
		_tmp16_ = _tmp15_[0];
		unity_sound_service_interface_EnablePlayerSpecificItems (_tmp8_, _tmp9_, _tmp16_, NULL, NULL);
		_tmp15_ = (_vala_array_free (_tmp15_, _tmp15__length1, (GDestroyNotify) g_free), NULL);
		_tmp17_ = self->priv->_player_item_server;
		_tmp18_ = self->priv->_consumer;
		_tmp19_ = unity_music_player_get_player_menu (_tmp18_);
		_tmp20_ = _tmp19_;
		g_object_set (_tmp17_, "root-node", _tmp20_, NULL);
	} else {
		UnityMusicPlayer* _tmp21_;
		DbusmenuMenuitem* _tmp22_;
		DbusmenuMenuitem* _tmp23_;
		_tmp21_ = self->priv->_consumer;
		_tmp22_ = unity_music_player_get_player_menu (_tmp21_);
		_tmp23_ = _tmp22_;
		if (_tmp23_ == NULL) {
			_g_object_unref0 (self->priv->_player_item_server);
			self->priv->_player_item_server = NULL;
		}
	}
}


UnityMusicPlayer* unity_specific_item_manager_get_consumer (UnitySpecificItemManager* self) {
	UnityMusicPlayer* result;
	UnityMusicPlayer* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_consumer;
	result = _tmp0_;
	return result;
}


static void unity_specific_item_manager_set_consumer (UnitySpecificItemManager* self, UnityMusicPlayer* value) {
	UnityMusicPlayer* _tmp0_;
	UnityMusicPlayer* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_consumer);
	self->priv->_consumer = _tmp1_;
	g_object_notify ((GObject *) self, "consumer");
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


static void _unity_specific_item_manager_on_track_specific_change_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	unity_specific_item_manager_on_track_specific_change (self, pspec);
}


static void _unity_specific_item_manager_on_player_specific_change_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	unity_specific_item_manager_on_player_specific_change (self, pspec);
}


static GObject * unity_specific_item_manager_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	UnitySpecificItemManager * self;
	UnityMusicPlayer* _tmp0_;
	GAppInfo* _tmp1_;
	GAppInfo* _tmp2_;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_;
	char* _tmp9_;
	UnityMusicPlayer* _tmp10_;
	GAppInfo* _tmp11_;
	GAppInfo* _tmp12_;
	const gchar* _tmp13_ = NULL;
	gchar* _tmp14_ = NULL;
	gchar* _tmp15_;
	const gchar* _tmp16_ = NULL;
	gchar* _tmp17_ = NULL;
	gchar* _tmp18_;
	char* _tmp19_;
	UnityMusicPlayer* _tmp22_;
	UnityMusicPlayer* _tmp23_;
	GError * _inner_error_ = NULL;
	parent_class = G_OBJECT_CLASS (unity_specific_item_manager_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = UNITY_SPECIFIC_ITEM_MANAGER (obj);
	_g_object_unref0 (self->priv->_track_item_server);
	self->priv->_track_item_server = NULL;
	_g_object_unref0 (self->priv->_player_item_server);
	self->priv->_player_item_server = NULL;
	_tmp0_ = self->priv->_consumer;
	_tmp1_ = unity_music_player_get_app_info (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_app_info_get_name (_tmp2_);
	_tmp4_ = g_utf8_strdown (_tmp3_, (gssize) (-1));
	_tmp5_ = _tmp4_;
	_tmp6_ = string_to_string (_tmp5_);
	_tmp7_ = g_strconcat ("/com/canonical/indicators/sound/track_specific/", _tmp6_, NULL);
	_tmp8_ = _tmp7_;
	_tmp9_ = g_strdup (_tmp8_);
	_g_free0 (self->_track_specific_object_path);
	self->_track_specific_object_path = _tmp9_;
	_g_free0 (_tmp8_);
	_g_free0 (_tmp5_);
	_tmp10_ = self->priv->_consumer;
	_tmp11_ = unity_music_player_get_app_info (_tmp10_);
	_tmp12_ = _tmp11_;
	_tmp13_ = g_app_info_get_name (_tmp12_);
	_tmp14_ = g_utf8_strdown (_tmp13_, (gssize) (-1));
	_tmp15_ = _tmp14_;
	_tmp16_ = string_to_string (_tmp15_);
	_tmp17_ = g_strconcat ("/com/canonical/indicators/sound/player_specific/", _tmp16_, NULL);
	_tmp18_ = _tmp17_;
	_tmp19_ = g_strdup (_tmp18_);
	_g_free0 (self->_player_specific_object_path);
	self->_player_specific_object_path = _tmp19_;
	_g_free0 (_tmp18_);
	_g_free0 (_tmp15_);
	{
		UnitySoundServiceInterface* _tmp20_ = NULL;
		UnitySoundServiceInterface* _tmp21_;
		_tmp20_ = g_initable_new (UNITY_TYPE_SOUND_SERVICE_INTERFACE_PROXY, NULL, &_inner_error_, "g-flags", G_DBUS_PROXY_FLAGS_DO_NOT_AUTO_START, "g-name", "com.canonical.indicators.sound", "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", "/com/canonical/indicators/sound/service", "g-interface-name", "com.canonical.indicators.sound", NULL);
		_tmp21_ = (UnitySoundServiceInterface*) _tmp20_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_IO_ERROR) {
				goto __catch37_g_io_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
		}
		_g_object_unref0 (self->priv->sound_service_interface);
		self->priv->sound_service_interface = _tmp21_;
	}
	goto __finally37;
	__catch37_g_io_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("unity-sound-menu-mpris.vala:184: mpris-sound-menu-mpris - SpecificItem" \
"Manager - Unable to connect to indicator-sound's interface");
		_g_error_free0 (e);
	}
	__finally37:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
	}
	_tmp22_ = self->priv->_consumer;
	g_signal_connect_object ((GObject*) _tmp22_, "notify::track-menu", (GCallback) _unity_specific_item_manager_on_track_specific_change_g_object_notify, self, 0);
	_tmp23_ = self->priv->_consumer;
	g_signal_connect_object ((GObject*) _tmp23_, "notify::player-menu", (GCallback) _unity_specific_item_manager_on_player_specific_change_g_object_notify, self, 0);
	return obj;
}


static void unity_specific_item_manager_class_init (UnitySpecificItemManagerClass * klass) {
	unity_specific_item_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (UnitySpecificItemManagerPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_unity_specific_item_manager_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_unity_specific_item_manager_set_property;
	G_OBJECT_CLASS (klass)->constructor = unity_specific_item_manager_constructor;
	G_OBJECT_CLASS (klass)->finalize = unity_specific_item_manager_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_SPECIFIC_ITEM_MANAGER_CONSUMER, g_param_spec_object ("consumer", "consumer", "consumer", UNITY_TYPE_MUSIC_PLAYER, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}


static void unity_specific_item_manager_instance_init (UnitySpecificItemManager * self) {
	self->priv = UNITY_SPECIFIC_ITEM_MANAGER_GET_PRIVATE (self);
}


static void unity_specific_item_manager_finalize (GObject* obj) {
	UnitySpecificItemManager * self;
	self = UNITY_SPECIFIC_ITEM_MANAGER (obj);
	_g_object_unref0 (self->priv->_player_item_server);
	_g_free0 (self->_player_specific_object_path);
	_g_object_unref0 (self->priv->_track_item_server);
	_g_free0 (self->_track_specific_object_path);
	_g_object_unref0 (self->priv->_consumer);
	_g_object_unref0 (self->priv->sound_service_interface);
	G_OBJECT_CLASS (unity_specific_item_manager_parent_class)->finalize (obj);
}


GType unity_specific_item_manager_get_type (void) {
	static volatile gsize unity_specific_item_manager_type_id__volatile = 0;
	if (g_once_init_enter (&unity_specific_item_manager_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UnitySpecificItemManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unity_specific_item_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnitySpecificItemManager), 0, (GInstanceInitFunc) unity_specific_item_manager_instance_init, NULL };
		GType unity_specific_item_manager_type_id;
		unity_specific_item_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "UnitySpecificItemManager", &g_define_type_info, 0);
		g_once_init_leave (&unity_specific_item_manager_type_id__volatile, unity_specific_item_manager_type_id);
	}
	return unity_specific_item_manager_type_id__volatile;
}


static void _vala_unity_specific_item_manager_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	UnitySpecificItemManager * self;
	self = UNITY_SPECIFIC_ITEM_MANAGER (object);
	switch (property_id) {
		case UNITY_SPECIFIC_ITEM_MANAGER_CONSUMER:
		g_value_set_object (value, unity_specific_item_manager_get_consumer (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_unity_specific_item_manager_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	UnitySpecificItemManager * self;
	self = UNITY_SPECIFIC_ITEM_MANAGER (object);
	switch (property_id) {
		case UNITY_SPECIFIC_ITEM_MANAGER_CONSUMER:
		unity_specific_item_manager_set_consumer (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


UnityPropertyUpdateManager* unity_property_update_manager_construct (GType object_type, GDBusConnection* conn) {
	UnityPropertyUpdateManager * self = NULL;
	GDBusConnection* _tmp0_;
	g_return_val_if_fail (conn != NULL, NULL);
	_tmp0_ = conn;
	self = (UnityPropertyUpdateManager*) g_object_new (object_type, "connection", _tmp0_, NULL);
	return self;
}


UnityPropertyUpdateManager* unity_property_update_manager_new (GDBusConnection* conn) {
	return unity_property_update_manager_construct (UNITY_TYPE_PROPERTY_UPDATE_MANAGER, conn);
}


static Block11Data* block11_data_ref (Block11Data* _data11_) {
	g_atomic_int_inc (&_data11_->_ref_count_);
	return _data11_;
}


static void block11_data_unref (Block11Data* _data11_) {
	if (g_atomic_int_dec_and_test (&_data11_->_ref_count_)) {
		_g_object_unref0 (_data11_->self);
		_g_free0 (_data11_->interface_name);
		g_slice_free (Block11Data, _data11_);
	}
}


static gpointer _g_hash_table_ref0 (gpointer self) {
	return self ? g_hash_table_ref (self) : NULL;
}


static gpointer _g_variant_ref0 (gpointer self) {
	return self ? g_variant_ref (self) : NULL;
}


static gboolean ___lambda16_ (Block11Data* _data11_) {
	UnityPropertyUpdateManager * self;
	gboolean result = FALSE;
	const gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	self = _data11_->self;
	_tmp0_ = _data11_->interface_name;
	_tmp1_ = unity_property_update_manager_dispatch_property_update (self, _tmp0_);
	result = _tmp1_;
	return result;
}


static gboolean ____lambda16__gsource_func (gpointer self) {
	gboolean result;
	result = ___lambda16_ (self);
	return result;
}


void unity_property_update_manager_queue_property_update (UnityPropertyUpdateManager* self, const gchar* prop_name, GVariant* update, const gchar* interface_name) {
	Block11Data* _data11_;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	GHashTable* _tmp2_;
	const gchar* _tmp3_;
	gconstpointer _tmp4_ = NULL;
	GHashTable* _tmp5_;
	GHashTable* appropriate_hash;
	GHashTable* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	GVariant* _tmp9_;
	GVariant* _tmp10_;
	GHashTable* _tmp11_;
	const gchar* _tmp12_;
	gconstpointer _tmp13_ = NULL;
	guint appropriate_source_id;
	guint _tmp14_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (prop_name != NULL);
	g_return_if_fail (update != NULL);
	g_return_if_fail (interface_name != NULL);
	_data11_ = g_slice_new0 (Block11Data);
	_data11_->_ref_count_ = 1;
	_data11_->self = g_object_ref (self);
	_tmp0_ = interface_name;
	_tmp1_ = g_strdup (_tmp0_);
	_data11_->interface_name = _tmp1_;
	_tmp2_ = self->priv->queued_properties;
	_tmp3_ = _data11_->interface_name;
	_tmp4_ = g_hash_table_lookup (_tmp2_, _tmp3_);
	_tmp5_ = _g_hash_table_ref0 ((GHashTable*) _tmp4_);
	appropriate_hash = _tmp5_;
	_tmp6_ = appropriate_hash;
	_tmp7_ = prop_name;
	_tmp8_ = g_strdup (_tmp7_);
	_tmp9_ = update;
	_tmp10_ = _g_variant_ref0 (_tmp9_);
	g_hash_table_insert (_tmp6_, _tmp8_, _tmp10_);
	_tmp11_ = self->priv->source_ids;
	_tmp12_ = _data11_->interface_name;
	_tmp13_ = g_hash_table_lookup (_tmp11_, _tmp12_);
	appropriate_source_id = GPOINTER_TO_UINT (_tmp13_);
	_tmp14_ = appropriate_source_id;
	if (_tmp14_ == ((guint) 0)) {
		guint _tmp15_ = 0U;
		GHashTable* _tmp16_;
		const gchar* _tmp17_;
		gchar* _tmp18_;
		guint _tmp19_;
		_tmp15_ = g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ____lambda16__gsource_func, block11_data_ref (_data11_), block11_data_unref);
		appropriate_source_id = _tmp15_;
		_tmp16_ = self->priv->source_ids;
		_tmp17_ = _data11_->interface_name;
		_tmp18_ = g_strdup (_tmp17_);
		_tmp19_ = appropriate_source_id;
		g_hash_table_insert (_tmp16_, _tmp18_, GUINT_TO_POINTER (_tmp19_));
	}
	_g_hash_table_unref0 (appropriate_hash);
	block11_data_unref (_data11_);
	_data11_ = NULL;
}


static gboolean unity_property_update_manager_dispatch_property_update (UnityPropertyUpdateManager* self, const gchar* interface_name) {
	gboolean result = FALSE;
	GVariantType* _tmp0_;
	GVariantType* _tmp1_;
	GVariantBuilder* _tmp2_;
	GVariantBuilder* _tmp3_;
	GVariantBuilder* builder;
	GVariantType* _tmp4_;
	GVariantType* _tmp5_;
	GVariantBuilder* _tmp6_;
	GVariantBuilder* _tmp7_;
	GVariantBuilder* invalidated_builder;
	GHashTable* _tmp8_;
	const gchar* _tmp9_;
	gconstpointer _tmp10_ = NULL;
	GHashTable* _tmp11_;
	GHashTable* appropriate_hash;
	GHashTable* _tmp12_;
	GHashTable* _tmp14_;
	guint _tmp15_ = 0U;
	GHashTable* _tmp19_;
	GList* _tmp20_ = NULL;
	const gchar* _tmp31_;
	GVariantBuilder* _tmp32_;
	GVariantBuilder* _tmp33_;
	GVariant* _tmp34_;
	GVariant* _tmp35_;
	GHashTable* _tmp36_;
	const gchar* _tmp37_;
	gchar* _tmp38_;
	GHashTable* _tmp39_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (interface_name != NULL, FALSE);
	_tmp0_ = g_variant_type_new ("a{sv}");
	_tmp1_ = _tmp0_;
	_tmp2_ = g_variant_builder_new (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_variant_type_free0 (_tmp1_);
	builder = _tmp3_;
	_tmp4_ = g_variant_type_new ("as");
	_tmp5_ = _tmp4_;
	_tmp6_ = g_variant_builder_new (_tmp5_);
	_tmp7_ = _tmp6_;
	_g_variant_type_free0 (_tmp5_);
	invalidated_builder = _tmp7_;
	_tmp8_ = self->priv->queued_properties;
	_tmp9_ = interface_name;
	_tmp10_ = g_hash_table_lookup (_tmp8_, _tmp9_);
	_tmp11_ = _g_hash_table_ref0 ((GHashTable*) _tmp10_);
	appropriate_hash = _tmp11_;
	_tmp12_ = appropriate_hash;
	if (_tmp12_ == NULL) {
		const gchar* _tmp13_;
		_tmp13_ = interface_name;
		g_warning ("unity-sound-menu-mpris.vala:262: can't find the appropriate hash withi" \
"n queued properties for name %s", _tmp13_);
		result = FALSE;
		_g_hash_table_unref0 (appropriate_hash);
		_g_variant_builder_unref0 (invalidated_builder);
		_g_variant_builder_unref0 (builder);
		return result;
	}
	_tmp14_ = appropriate_hash;
	_tmp15_ = g_hash_table_size (_tmp14_);
	if (_tmp15_ == ((guint) 0)) {
		GHashTable* _tmp16_;
		const gchar* _tmp17_;
		gchar* _tmp18_;
		g_warning ("unity-sound-menu-mpris.vala:266: dispatch called on an empty array !!!");
		_tmp16_ = self->priv->source_ids;
		_tmp17_ = interface_name;
		_tmp18_ = g_strdup (_tmp17_);
		g_hash_table_insert (_tmp16_, _tmp18_, GUINT_TO_POINTER ((guint) 0));
		result = FALSE;
		_g_hash_table_unref0 (appropriate_hash);
		_g_variant_builder_unref0 (invalidated_builder);
		_g_variant_builder_unref0 (builder);
		return result;
	}
	_tmp19_ = appropriate_hash;
	_tmp20_ = g_hash_table_get_keys (_tmp19_);
	{
		GList* name_collection = NULL;
		GList* name_it = NULL;
		name_collection = _tmp20_;
		for (name_it = name_collection; name_it != NULL; name_it = name_it->next) {
			gchar* _tmp21_;
			gchar* name = NULL;
			_tmp21_ = g_strdup ((const gchar*) name_it->data);
			name = _tmp21_;
			{
				GHashTable* _tmp22_;
				const gchar* _tmp23_;
				gconstpointer _tmp24_ = NULL;
				GVariant* _tmp25_;
				GVariant* variant;
				GVariantBuilder* _tmp26_;
				const gchar* _tmp27_;
				gchar* _tmp28_ = NULL;
				gchar* _tmp29_;
				GVariant* _tmp30_;
				_tmp22_ = appropriate_hash;
				_tmp23_ = name;
				_tmp24_ = g_hash_table_lookup (_tmp22_, _tmp23_);
				_tmp25_ = _g_variant_ref0 ((GVariant*) _tmp24_);
				variant = _tmp25_;
				_tmp26_ = builder;
				_tmp27_ = name;
				_tmp28_ = g_strdup (_tmp27_);
				_tmp29_ = _tmp28_;
				_tmp30_ = variant;
				g_variant_builder_add (_tmp26_, "{sv}", _tmp29_, _tmp30_, NULL);
				_g_free0 (_tmp29_);
				_g_variant_unref0 (variant);
				_g_free0 (name);
			}
		}
		_g_list_free0 (name_collection);
	}
	_tmp31_ = interface_name;
	_tmp32_ = builder;
	_tmp33_ = invalidated_builder;
	_tmp34_ = g_variant_new ("(sa{sv}as)", _tmp31_, _tmp32_, _tmp33_, NULL);
	_tmp35_ = g_variant_ref_sink (_tmp34_);
	unity_property_update_manager_emit_dbus_signal (self, "org.freedesktop.DBus.Properties", "PropertiesChanged", _tmp35_);
	_g_variant_unref0 (_tmp35_);
	_tmp36_ = self->priv->source_ids;
	_tmp37_ = interface_name;
	_tmp38_ = g_strdup (_tmp37_);
	g_hash_table_insert (_tmp36_, _tmp38_, GUINT_TO_POINTER ((guint) 0));
	_tmp39_ = appropriate_hash;
	g_hash_table_remove_all (_tmp39_);
	result = FALSE;
	_g_hash_table_unref0 (appropriate_hash);
	_g_variant_builder_unref0 (invalidated_builder);
	_g_variant_builder_unref0 (builder);
	return result;
}


void unity_property_update_manager_emit_dbus_signal (UnityPropertyUpdateManager* self, const gchar* interface_name, const gchar* signal_name, GVariant* payload) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (interface_name != NULL);
	g_return_if_fail (signal_name != NULL);
	g_return_if_fail (payload != NULL);
	{
		GDBusConnection* _tmp0_;
		const gchar* _tmp1_;
		const gchar* _tmp2_;
		GVariant* _tmp3_;
		_tmp0_ = self->priv->_connection;
		_tmp1_ = interface_name;
		_tmp2_ = signal_name;
		_tmp3_ = payload;
		g_dbus_connection_emit_signal (_tmp0_, NULL, UNITY_MPRIS_INTERFACE_ROOT_PATH, _tmp1_, _tmp2_, _tmp3_, &_inner_error_);
		if (_inner_error_ != NULL) {
			goto __catch38_g_error;
		}
	}
	goto __finally38;
	__catch38_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		GError* _tmp6_;
		const gchar* _tmp7_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp4_ = interface_name;
		_tmp5_ = signal_name;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		g_warning ("unity-sound-menu-mpris.vala:301: Error emitting DBus signal '%s.%s': %" \
"s\n", _tmp4_, _tmp5_, _tmp7_);
		_g_error_free0 (e);
	}
	__finally38:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


GDBusConnection* unity_property_update_manager_get_connection (UnityPropertyUpdateManager* self) {
	GDBusConnection* result;
	GDBusConnection* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_connection;
	result = _tmp0_;
	return result;
}


static void unity_property_update_manager_set_connection (UnityPropertyUpdateManager* self, GDBusConnection* value) {
	GDBusConnection* _tmp0_;
	GDBusConnection* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_connection);
	self->priv->_connection = _tmp1_;
	g_object_notify ((GObject *) self, "connection");
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_hash_table_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL));
}


static void _g_variant_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_variant_unref (var), NULL));
}


static GObject * unity_property_update_manager_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	UnityPropertyUpdateManager * self;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	GHashTable* _tmp3_;
	gchar* _tmp4_;
	GHashFunc _tmp5_;
	GEqualFunc _tmp6_;
	GHashTable* _tmp7_;
	GHashTable* _tmp8_;
	gchar* _tmp9_;
	GHashFunc _tmp10_;
	GEqualFunc _tmp11_;
	GHashTable* _tmp12_;
	GHashTable* _tmp13_;
	gchar* _tmp14_;
	GHashFunc _tmp15_;
	GEqualFunc _tmp16_;
	GHashTable* _tmp17_;
	GHashFunc _tmp18_;
	GEqualFunc _tmp19_;
	GHashTable* _tmp20_;
	GHashTable* _tmp21_;
	gchar* _tmp22_;
	GHashTable* _tmp23_;
	gchar* _tmp24_;
	GHashTable* _tmp25_;
	gchar* _tmp26_;
	parent_class = G_OBJECT_CLASS (unity_property_update_manager_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = UNITY_PROPERTY_UPDATE_MANAGER (obj);
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, _g_hash_table_unref0_);
	_g_hash_table_unref0 (self->priv->queued_properties);
	self->priv->queued_properties = _tmp2_;
	_tmp3_ = self->priv->queued_properties;
	_tmp4_ = g_strdup (UNITY_MPRIS_INTERFACE_ROOT);
	_tmp5_ = g_str_hash;
	_tmp6_ = g_str_equal;
	_tmp7_ = g_hash_table_new_full (_tmp5_, _tmp6_, _g_free0_, _g_variant_unref0_);
	g_hash_table_insert (_tmp3_, _tmp4_, _tmp7_);
	_tmp8_ = self->priv->queued_properties;
	_tmp9_ = g_strdup (UNITY_MPRIS_INTERFACE_PLAYER);
	_tmp10_ = g_str_hash;
	_tmp11_ = g_str_equal;
	_tmp12_ = g_hash_table_new_full (_tmp10_, _tmp11_, _g_free0_, _g_variant_unref0_);
	g_hash_table_insert (_tmp8_, _tmp9_, _tmp12_);
	_tmp13_ = self->priv->queued_properties;
	_tmp14_ = g_strdup (UNITY_MPRIS_INTERFACE_PLAYLISTS);
	_tmp15_ = g_str_hash;
	_tmp16_ = g_str_equal;
	_tmp17_ = g_hash_table_new_full (_tmp15_, _tmp16_, _g_free0_, _g_variant_unref0_);
	g_hash_table_insert (_tmp13_, _tmp14_, _tmp17_);
	_tmp18_ = g_str_hash;
	_tmp19_ = g_str_equal;
	_tmp20_ = g_hash_table_new_full (_tmp18_, _tmp19_, _g_free0_, NULL);
	_g_hash_table_unref0 (self->priv->source_ids);
	self->priv->source_ids = _tmp20_;
	_tmp21_ = self->priv->source_ids;
	_tmp22_ = g_strdup (UNITY_MPRIS_INTERFACE_ROOT);
	g_hash_table_insert (_tmp21_, _tmp22_, GUINT_TO_POINTER ((guint) 0));
	_tmp23_ = self->priv->source_ids;
	_tmp24_ = g_strdup (UNITY_MPRIS_INTERFACE_PLAYER);
	g_hash_table_insert (_tmp23_, _tmp24_, GUINT_TO_POINTER ((guint) 0));
	_tmp25_ = self->priv->source_ids;
	_tmp26_ = g_strdup (UNITY_MPRIS_INTERFACE_PLAYLISTS);
	g_hash_table_insert (_tmp25_, _tmp26_, GUINT_TO_POINTER ((guint) 0));
	return obj;
}


static void unity_property_update_manager_class_init (UnityPropertyUpdateManagerClass * klass) {
	unity_property_update_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (UnityPropertyUpdateManagerPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_unity_property_update_manager_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_unity_property_update_manager_set_property;
	G_OBJECT_CLASS (klass)->constructor = unity_property_update_manager_constructor;
	G_OBJECT_CLASS (klass)->finalize = unity_property_update_manager_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_PROPERTY_UPDATE_MANAGER_CONNECTION, g_param_spec_object ("connection", "connection", "connection", G_TYPE_DBUS_CONNECTION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}


static void unity_property_update_manager_instance_init (UnityPropertyUpdateManager * self) {
	self->priv = UNITY_PROPERTY_UPDATE_MANAGER_GET_PRIVATE (self);
}


static void unity_property_update_manager_finalize (GObject* obj) {
	UnityPropertyUpdateManager * self;
	self = UNITY_PROPERTY_UPDATE_MANAGER (obj);
	_g_hash_table_unref0 (self->priv->queued_properties);
	_g_hash_table_unref0 (self->priv->source_ids);
	_g_object_unref0 (self->priv->_connection);
	G_OBJECT_CLASS (unity_property_update_manager_parent_class)->finalize (obj);
}


/**
  PropertyUpdate Manager
  Handles all property updates for each of the 3 MPRIS interfaces
  **/
GType unity_property_update_manager_get_type (void) {
	static volatile gsize unity_property_update_manager_type_id__volatile = 0;
	if (g_once_init_enter (&unity_property_update_manager_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UnityPropertyUpdateManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unity_property_update_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnityPropertyUpdateManager), 0, (GInstanceInitFunc) unity_property_update_manager_instance_init, NULL };
		GType unity_property_update_manager_type_id;
		unity_property_update_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "UnityPropertyUpdateManager", &g_define_type_info, 0);
		g_once_init_leave (&unity_property_update_manager_type_id__volatile, unity_property_update_manager_type_id);
	}
	return unity_property_update_manager_type_id__volatile;
}


static void _vala_unity_property_update_manager_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	UnityPropertyUpdateManager * self;
	self = UNITY_PROPERTY_UPDATE_MANAGER (object);
	switch (property_id) {
		case UNITY_PROPERTY_UPDATE_MANAGER_CONNECTION:
		g_value_set_object (value, unity_property_update_manager_get_connection (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_unity_property_update_manager_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	UnityPropertyUpdateManager * self;
	self = UNITY_PROPERTY_UPDATE_MANAGER (object);
	switch (property_id) {
		case UNITY_PROPERTY_UPDATE_MANAGER_CONNECTION:
		unity_property_update_manager_set_connection (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


UnityBlacklistManager* unity_blacklist_manager_construct (GType object_type, UnityMusicPlayer* client) {
	UnityBlacklistManager * self = NULL;
	UnityMusicPlayer* _tmp0_;
	UnityMusicPlayer* _tmp1_;
	g_return_val_if_fail (client != NULL, NULL);
	self = (UnityBlacklistManager*) g_object_new (object_type, NULL);
	_tmp0_ = client;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->consumer);
	self->priv->consumer = _tmp1_;
	unity_blacklist_manager_wire_it_up (self);
	return self;
}


UnityBlacklistManager* unity_blacklist_manager_new (UnityMusicPlayer* client) {
	return unity_blacklist_manager_construct (UNITY_TYPE_BLACKLIST_MANAGER, client);
}


static void _unity_blacklist_manager_on_blacklist_event_g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
	unity_blacklist_manager_on_blacklist_event (self);
}


static void _unity_blacklist_manager_consumer_blacklist_change_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	unity_blacklist_manager_consumer_blacklist_change (self);
}


static void unity_blacklist_manager_wire_it_up (UnityBlacklistManager* self) {
	GSettings* _tmp0_;
	UnityMusicPlayer* _tmp1_;
	gboolean _tmp2_ = FALSE;
	GSettings* _tmp3_;
	UnityMusicPlayer* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_settings_new ("com.canonical.indicator.sound");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp0_;
	_tmp1_ = self->priv->consumer;
	_tmp2_ = unity_blacklist_manager_check_presence (self);
	unity_music_player_set_is_blacklisted (_tmp1_, _tmp2_);
	_tmp3_ = self->priv->settings;
	g_signal_connect_object (_tmp3_, "changed::blacklisted-media-players", (GCallback) _unity_blacklist_manager_on_blacklist_event_g_settings_changed, self, 0);
	_tmp4_ = self->priv->consumer;
	g_signal_connect_object ((GObject*) _tmp4_, "notify::is-blacklisted", (GCallback) _unity_blacklist_manager_consumer_blacklist_change_g_object_notify, self, 0);
}


static void unity_blacklist_manager_consumer_blacklist_change (UnityBlacklistManager* self) {
	UnityMusicPlayer* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->consumer;
	_tmp1_ = unity_music_player_get_is_blacklisted (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == TRUE) {
		unity_blacklist_manager_add_to_blacklist (self);
	} else {
		unity_blacklist_manager_remove_from_blacklist (self);
	}
}


static void unity_blacklist_manager_on_blacklist_event (UnityBlacklistManager* self) {
	gboolean _tmp0_ = FALSE;
	gboolean is_present;
	UnityMusicPlayer* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = unity_blacklist_manager_check_presence (self);
	is_present = _tmp0_;
	_tmp1_ = self->priv->consumer;
	_tmp2_ = unity_music_player_get_is_blacklisted (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = is_present;
	if (_tmp3_ != _tmp4_) {
		UnityMusicPlayer* _tmp5_;
		gboolean _tmp6_;
		unity_trace_log_object ((GObject*) self, "Blacklist Event - consumer blacklist is not the same as the situation");
		_tmp5_ = self->priv->consumer;
		_tmp6_ = is_present;
		unity_music_player_set_is_blacklisted (_tmp5_, _tmp6_);
	}
}


static gchar* unity_blacklist_manager_get_blacklist_name (UnityBlacklistManager* self) {
	gchar* result = NULL;
	UnityMusicPlayer* _tmp0_;
	GAppInfo* _tmp1_;
	GAppInfo* _tmp2_;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	gchar* app_id;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar** _tmp7_;
	gchar** _tmp8_ = NULL;
	gchar** components;
	gint components_length1;
	gint _components_size_;
	gchar** _tmp9_;
	gint _tmp9__length1;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->consumer;
	_tmp1_ = unity_music_player_get_app_info (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_app_info_get_id (_tmp2_);
	_tmp4_ = g_strdup (_tmp3_);
	app_id = _tmp4_;
	_tmp5_ = app_id;
	if (_tmp5_ == NULL) {
		result = NULL;
		_g_free0 (app_id);
		return result;
	}
	_tmp6_ = app_id;
	_tmp8_ = _tmp7_ = g_strsplit (_tmp6_, ".", 0);
	components = _tmp8_;
	components_length1 = _vala_array_length (_tmp7_);
	_components_size_ = components_length1;
	_tmp9_ = components;
	_tmp9__length1 = components_length1;
	_tmp10_ = _tmp9_[0];
	_tmp11_ = g_strdup (_tmp10_);
	result = _tmp11_;
	components = (_vala_array_free (components, components_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (app_id);
	return result;
}


gboolean unity_blacklist_manager_check_presence (UnityBlacklistManager* self) {
	gboolean result = FALSE;
	GSettings* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_ = NULL;
	gchar** blacklist;
	gint blacklist_length1;
	gint _blacklist_size_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->settings;
	_tmp2_ = _tmp1_ = g_settings_get_strv (_tmp0_, "blacklisted-media-players");
	blacklist = _tmp2_;
	blacklist_length1 = _vala_array_length (_tmp1_);
	_blacklist_size_ = blacklist_length1;
	_tmp3_ = blacklist;
	_tmp3__length1 = blacklist_length1;
	{
		gchar** s_collection = NULL;
		gint s_collection_length1 = 0;
		gint _s_collection_size_ = 0;
		gint s_it = 0;
		s_collection = _tmp3_;
		s_collection_length1 = _tmp3__length1;
		for (s_it = 0; s_it < _tmp3__length1; s_it = s_it + 1) {
			gchar* _tmp4_;
			gchar* s = NULL;
			_tmp4_ = g_strdup (s_collection[s_it]);
			s = _tmp4_;
			{
				const gchar* _tmp5_;
				gchar* _tmp6_ = NULL;
				gchar* _tmp7_;
				gboolean _tmp8_;
				_tmp5_ = s;
				_tmp6_ = unity_blacklist_manager_get_blacklist_name (self);
				_tmp7_ = _tmp6_;
				_tmp8_ = g_strcmp0 (_tmp5_, _tmp7_) == 0;
				_g_free0 (_tmp7_);
				if (_tmp8_) {
					result = TRUE;
					_g_free0 (s);
					blacklist = (_vala_array_free (blacklist, blacklist_length1, (GDestroyNotify) g_free), NULL);
					return result;
				}
				_g_free0 (s);
			}
		}
	}
	result = FALSE;
	blacklist = (_vala_array_free (blacklist, blacklist_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


static void unity_blacklist_manager_add_to_blacklist (UnityBlacklistManager* self) {
	GSettings* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_ = NULL;
	gchar** already_bl;
	gint already_bl_length1;
	gint _already_bl_size_;
	GeeArrayList* _tmp3_;
	GeeArrayList* new_bl;
	gchar** _tmp4_;
	gint _tmp4__length1;
	GeeArrayList* _tmp13_;
	gchar* _tmp14_ = NULL;
	gchar* _tmp15_;
	GSettings* _tmp16_;
	GeeArrayList* _tmp17_;
	gint _tmp18_ = 0;
	gpointer* _tmp19_ = NULL;
	gchar** _tmp20_;
	gint _tmp20__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->settings;
	_tmp2_ = _tmp1_ = g_settings_get_strv (_tmp0_, "blacklisted-media-players");
	already_bl = _tmp2_;
	already_bl_length1 = _vala_array_length (_tmp1_);
	_already_bl_size_ = already_bl_length1;
	_tmp3_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
	new_bl = _tmp3_;
	_tmp4_ = already_bl;
	_tmp4__length1 = already_bl_length1;
	{
		gchar** s_collection = NULL;
		gint s_collection_length1 = 0;
		gint _s_collection_size_ = 0;
		gint s_it = 0;
		s_collection = _tmp4_;
		s_collection_length1 = _tmp4__length1;
		for (s_it = 0; s_it < _tmp4__length1; s_it = s_it + 1) {
			gchar* _tmp5_;
			gchar* s = NULL;
			_tmp5_ = g_strdup (s_collection[s_it]);
			s = _tmp5_;
			{
				const gchar* _tmp6_;
				gchar* _tmp7_ = NULL;
				gchar* _tmp8_;
				gboolean _tmp9_;
				const gchar* _tmp10_;
				GeeArrayList* _tmp11_;
				const gchar* _tmp12_;
				_tmp6_ = s;
				_tmp7_ = unity_blacklist_manager_get_blacklist_name (self);
				_tmp8_ = _tmp7_;
				_tmp9_ = g_strcmp0 (_tmp6_, _tmp8_) == 0;
				_g_free0 (_tmp8_);
				if (_tmp9_) {
					_g_free0 (s);
					_g_object_unref0 (new_bl);
					already_bl = (_vala_array_free (already_bl, already_bl_length1, (GDestroyNotify) g_free), NULL);
					return;
				}
				_tmp10_ = s;
				unity_trace_log_object ((GObject*) self, "add_to_blacklist: %s", _tmp10_);
				_tmp11_ = new_bl;
				_tmp12_ = s;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp11_, _tmp12_);
				_g_free0 (s);
			}
		}
	}
	_tmp13_ = new_bl;
	_tmp14_ = unity_blacklist_manager_get_blacklist_name (self);
	_tmp15_ = _tmp14_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp13_, _tmp15_);
	_g_free0 (_tmp15_);
	_tmp16_ = self->priv->settings;
	_tmp17_ = new_bl;
	_tmp19_ = gee_abstract_collection_to_array ((GeeAbstractCollection*) _tmp17_, &_tmp18_);
	_tmp20_ = _tmp19_;
	_tmp20__length1 = _tmp18_;
	g_settings_set_strv (_tmp16_, "blacklisted-media-players", _tmp20_);
	_tmp20_ = (_vala_array_free (_tmp20_, _tmp20__length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (new_bl);
	already_bl = (_vala_array_free (already_bl, already_bl_length1, (GDestroyNotify) g_free), NULL);
}


static void unity_blacklist_manager_remove_from_blacklist (UnityBlacklistManager* self) {
	GSettings* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_ = NULL;
	gchar** already_bl;
	gint already_bl_length1;
	gint _already_bl_size_;
	GeeArrayList* _tmp3_;
	GeeArrayList* new_bl;
	gchar** _tmp4_;
	gint _tmp4__length1;
	GSettings* _tmp12_;
	GeeArrayList* _tmp13_;
	gint _tmp14_ = 0;
	gpointer* _tmp15_ = NULL;
	gchar** _tmp16_;
	gint _tmp16__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->settings;
	_tmp2_ = _tmp1_ = g_settings_get_strv (_tmp0_, "blacklisted-media-players");
	already_bl = _tmp2_;
	already_bl_length1 = _vala_array_length (_tmp1_);
	_already_bl_size_ = already_bl_length1;
	_tmp3_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL);
	new_bl = _tmp3_;
	_tmp4_ = already_bl;
	_tmp4__length1 = already_bl_length1;
	{
		gchar** s_collection = NULL;
		gint s_collection_length1 = 0;
		gint _s_collection_size_ = 0;
		gint s_it = 0;
		s_collection = _tmp4_;
		s_collection_length1 = _tmp4__length1;
		for (s_it = 0; s_it < _tmp4__length1; s_it = s_it + 1) {
			gchar* _tmp5_;
			gchar* s = NULL;
			_tmp5_ = g_strdup (s_collection[s_it]);
			s = _tmp5_;
			{
				const gchar* _tmp6_;
				gchar* _tmp7_ = NULL;
				gchar* _tmp8_;
				gboolean _tmp9_;
				GeeArrayList* _tmp10_;
				const gchar* _tmp11_;
				_tmp6_ = s;
				_tmp7_ = unity_blacklist_manager_get_blacklist_name (self);
				_tmp8_ = _tmp7_;
				_tmp9_ = g_strcmp0 (_tmp6_, _tmp8_) == 0;
				_g_free0 (_tmp8_);
				if (_tmp9_) {
					_g_free0 (s);
					continue;
				}
				_tmp10_ = new_bl;
				_tmp11_ = s;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp10_, _tmp11_);
				_g_free0 (s);
			}
		}
	}
	_tmp12_ = self->priv->settings;
	_tmp13_ = new_bl;
	_tmp15_ = gee_abstract_collection_to_array ((GeeAbstractCollection*) _tmp13_, &_tmp14_);
	_tmp16_ = _tmp15_;
	_tmp16__length1 = _tmp14_;
	g_settings_set_strv (_tmp12_, "blacklisted-media-players", _tmp16_);
	_tmp16_ = (_vala_array_free (_tmp16_, _tmp16__length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (new_bl);
	already_bl = (_vala_array_free (already_bl, already_bl_length1, (GDestroyNotify) g_free), NULL);
}


static GObject * unity_blacklist_manager_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	UnityBlacklistManager * self;
	parent_class = G_OBJECT_CLASS (unity_blacklist_manager_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = UNITY_BLACKLIST_MANAGER (obj);
	return obj;
}


static void unity_blacklist_manager_class_init (UnityBlacklistManagerClass * klass) {
	unity_blacklist_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (UnityBlacklistManagerPrivate));
	G_OBJECT_CLASS (klass)->constructor = unity_blacklist_manager_constructor;
	G_OBJECT_CLASS (klass)->finalize = unity_blacklist_manager_finalize;
}


static void unity_blacklist_manager_instance_init (UnityBlacklistManager * self) {
	self->priv = UNITY_BLACKLIST_MANAGER_GET_PRIVATE (self);
}


static void unity_blacklist_manager_finalize (GObject* obj) {
	UnityBlacklistManager * self;
	self = UNITY_BLACKLIST_MANAGER (obj);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->consumer);
	G_OBJECT_CLASS (unity_blacklist_manager_parent_class)->finalize (obj);
}


GType unity_blacklist_manager_get_type (void) {
	static volatile gsize unity_blacklist_manager_type_id__volatile = 0;
	if (g_once_init_enter (&unity_blacklist_manager_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UnityBlacklistManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unity_blacklist_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnityBlacklistManager), 0, (GInstanceInitFunc) unity_blacklist_manager_instance_init, NULL };
		GType unity_blacklist_manager_type_id;
		unity_blacklist_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "UnityBlacklistManager", &g_define_type_info, 0);
		g_once_init_leave (&unity_blacklist_manager_type_id__volatile, unity_blacklist_manager_type_id);
	}
	return unity_blacklist_manager_type_id__volatile;
}


void unity_sound_service_interface_EnableTrackSpecificItems (UnitySoundServiceInterface* self, const char* object_path, const gchar* desktop_id, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UNITY_SOUND_SERVICE_INTERFACE_GET_INTERFACE (self)->EnableTrackSpecificItems (self, object_path, desktop_id, _callback_, _user_data_);
}


void unity_sound_service_interface_EnableTrackSpecificItems_finish (UnitySoundServiceInterface* self, GAsyncResult* _res_, GError** error) {
	UNITY_SOUND_SERVICE_INTERFACE_GET_INTERFACE (self)->EnableTrackSpecificItems_finish (self, _res_, error);
}


void unity_sound_service_interface_EnablePlayerSpecificItems (UnitySoundServiceInterface* self, const char* object_path, const gchar* desktop_id, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UNITY_SOUND_SERVICE_INTERFACE_GET_INTERFACE (self)->EnablePlayerSpecificItems (self, object_path, desktop_id, _callback_, _user_data_);
}


void unity_sound_service_interface_EnablePlayerSpecificItems_finish (UnitySoundServiceInterface* self, GAsyncResult* _res_, GError** error) {
	UNITY_SOUND_SERVICE_INTERFACE_GET_INTERFACE (self)->EnablePlayerSpecificItems_finish (self, _res_, error);
}


static void unity_sound_service_interface_base_init (UnitySoundServiceInterfaceIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
	}
}


/***************************************************************************************/
GType unity_sound_service_interface_get_type (void) {
	static volatile gsize unity_sound_service_interface_type_id__volatile = 0;
	if (g_once_init_enter (&unity_sound_service_interface_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UnitySoundServiceInterfaceIface), (GBaseInitFunc) unity_sound_service_interface_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType unity_sound_service_interface_type_id;
		unity_sound_service_interface_type_id = g_type_register_static (G_TYPE_INTERFACE, "UnitySoundServiceInterface", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (unity_sound_service_interface_type_id, G_TYPE_OBJECT);
		g_type_set_qdata (unity_sound_service_interface_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) unity_sound_service_interface_proxy_get_type);
		g_type_set_qdata (unity_sound_service_interface_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "com.canonical.indicators.sound");
		g_type_set_qdata (unity_sound_service_interface_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) unity_sound_service_interface_register_object);
		g_once_init_leave (&unity_sound_service_interface_type_id__volatile, unity_sound_service_interface_type_id);
	}
	return unity_sound_service_interface_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (UnitySoundServiceInterfaceProxy, unity_sound_service_interface_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (UNITY_TYPE_SOUND_SERVICE_INTERFACE, unity_sound_service_interface_proxy_unity_sound_service_interface_interface_init) )
static void unity_sound_service_interface_proxy_class_init (UnitySoundServiceInterfaceProxyClass* klass) {
	G_DBUS_PROXY_CLASS (klass)->g_signal = unity_sound_service_interface_proxy_g_signal;
}


static void unity_sound_service_interface_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters) {
}


static void unity_sound_service_interface_proxy_init (UnitySoundServiceInterfaceProxy* self) {
}


static void _vala_g_async_ready_callback (GObject *source_object, GAsyncResult *res, void *user_data) {
	g_simple_async_result_set_op_res_gpointer (user_data, g_object_ref (res), g_object_unref);
	g_simple_async_result_complete (user_data);
	g_object_unref (user_data);
}


static void unity_sound_service_interface_proxy_EnableTrackSpecificItems_async (UnitySoundServiceInterface* self, const char* object_path, const gchar* desktop_id, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "com.canonical.indicators.sound", "EnableTrackSpecificItems");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_object_path (object_path));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (desktop_id));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_simple_async_result_new ((GObject *) self, _callback_, _user_data_, NULL));
	g_object_unref (_message);
}


static void unity_sound_service_interface_proxy_EnableTrackSpecificItems_finish (UnitySoundServiceInterface* self, GAsyncResult* _res_, GError** error) {
	GDBusMessage *_reply_message;
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), g_simple_async_result_get_op_res_gpointer ((GSimpleAsyncResult *) _res_), error);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}


static void unity_sound_service_interface_proxy_EnablePlayerSpecificItems_async (UnitySoundServiceInterface* self, const char* object_path, const gchar* desktop_id, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "com.canonical.indicators.sound", "EnablePlayerSpecificItems");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_object_path (object_path));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (desktop_id));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_simple_async_result_new ((GObject *) self, _callback_, _user_data_, NULL));
	g_object_unref (_message);
}


static void unity_sound_service_interface_proxy_EnablePlayerSpecificItems_finish (UnitySoundServiceInterface* self, GAsyncResult* _res_, GError** error) {
	GDBusMessage *_reply_message;
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), g_simple_async_result_get_op_res_gpointer ((GSimpleAsyncResult *) _res_), error);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}


static void unity_sound_service_interface_proxy_unity_sound_service_interface_interface_init (UnitySoundServiceInterfaceIface* iface) {
	iface->EnableTrackSpecificItems = unity_sound_service_interface_proxy_EnableTrackSpecificItems_async;
	iface->EnableTrackSpecificItems_finish = unity_sound_service_interface_proxy_EnableTrackSpecificItems_finish;
	iface->EnablePlayerSpecificItems = unity_sound_service_interface_proxy_EnablePlayerSpecificItems_async;
	iface->EnablePlayerSpecificItems_finish = unity_sound_service_interface_proxy_EnablePlayerSpecificItems_finish;
}


static void _dbus_unity_sound_service_interface_EnableTrackSpecificItems (UnitySoundServiceInterface* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GVariantIter _arguments_iter;
	char* object_path = NULL;
	GVariant* _tmp211_;
	gchar* desktop_id = NULL;
	GVariant* _tmp212_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp211_ = g_variant_iter_next_value (&_arguments_iter);
	object_path = g_variant_dup_string (_tmp211_, NULL);
	g_variant_unref (_tmp211_);
	_tmp212_ = g_variant_iter_next_value (&_arguments_iter);
	desktop_id = g_variant_dup_string (_tmp212_, NULL);
	g_variant_unref (_tmp212_);
	unity_sound_service_interface_EnableTrackSpecificItems (self, object_path, desktop_id, (GAsyncReadyCallback) _dbus_unity_sound_service_interface_EnableTrackSpecificItems_ready, invocation);
	_g_free0 (object_path);
	_g_free0 (desktop_id);
}


static void _dbus_unity_sound_service_interface_EnableTrackSpecificItems_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_) {
	GDBusMethodInvocation * invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	invocation = _user_data_;
	unity_sound_service_interface_EnableTrackSpecificItems_finish ((UnitySoundServiceInterface*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_unity_sound_service_interface_EnablePlayerSpecificItems (UnitySoundServiceInterface* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GVariantIter _arguments_iter;
	char* object_path = NULL;
	GVariant* _tmp213_;
	gchar* desktop_id = NULL;
	GVariant* _tmp214_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp213_ = g_variant_iter_next_value (&_arguments_iter);
	object_path = g_variant_dup_string (_tmp213_, NULL);
	g_variant_unref (_tmp213_);
	_tmp214_ = g_variant_iter_next_value (&_arguments_iter);
	desktop_id = g_variant_dup_string (_tmp214_, NULL);
	g_variant_unref (_tmp214_);
	unity_sound_service_interface_EnablePlayerSpecificItems (self, object_path, desktop_id, (GAsyncReadyCallback) _dbus_unity_sound_service_interface_EnablePlayerSpecificItems_ready, invocation);
	_g_free0 (object_path);
	_g_free0 (desktop_id);
}


static void _dbus_unity_sound_service_interface_EnablePlayerSpecificItems_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_) {
	GDBusMethodInvocation * invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	invocation = _user_data_;
	unity_sound_service_interface_EnablePlayerSpecificItems_finish ((UnitySoundServiceInterface*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void unity_sound_service_interface_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "EnableTrackSpecificItems") == 0) {
		_dbus_unity_sound_service_interface_EnableTrackSpecificItems (object, parameters, invocation);
	} else if (strcmp (method_name, "EnablePlayerSpecificItems") == 0) {
		_dbus_unity_sound_service_interface_EnablePlayerSpecificItems (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}


static GVariant* unity_sound_service_interface_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}


static gboolean unity_sound_service_interface_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}


guint unity_sound_service_interface_register_object (gpointer object, GDBusConnection* connection, const gchar* path, GError** error) {
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_unity_sound_service_interface_dbus_interface_info), &_unity_sound_service_interface_dbus_interface_vtable, data, _unity_sound_service_interface_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}


static void _unity_sound_service_interface_unregister_object (gpointer user_data) {
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}


UnityMprisRoot* unity_mpris_root_construct (GType object_type, UnityMusicPlayer* client, UnityPropertyUpdateManager* prop_mgr) {
	UnityMprisRoot * self = NULL;
	UnityMusicPlayer* _tmp0_;
	UnityMusicPlayer* _tmp1_;
	UnityPropertyUpdateManager* _tmp2_;
	UnityPropertyUpdateManager* _tmp3_;
	g_return_val_if_fail (client != NULL, NULL);
	g_return_val_if_fail (prop_mgr != NULL, NULL);
	self = (UnityMprisRoot*) g_object_new (object_type, NULL);
	_tmp0_ = client;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->consumer);
	self->priv->consumer = _tmp1_;
	_tmp2_ = prop_mgr;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (self->priv->prop_mgr);
	self->priv->prop_mgr = _tmp3_;
	unity_mpris_root_wire_up (self);
	return self;
}


UnityMprisRoot* unity_mpris_root_new (UnityMusicPlayer* client, UnityPropertyUpdateManager* prop_mgr) {
	return unity_mpris_root_construct (UNITY_TYPE_MPRIS_ROOT, client, prop_mgr);
}


static GVariant* _variant_new66 (const gchar* value) {
	return g_variant_ref_sink (g_variant_new_string (value));
}


static void __lambda17_ (UnityMprisRoot* self, GObject* obj, GParamSpec* pspec) {
	UnityPropertyUpdateManager* _tmp0_;
	UnityMusicPlayer* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	GVariant* _tmp4_;
	g_return_if_fail (obj != NULL);
	g_return_if_fail (pspec != NULL);
	_tmp0_ = self->priv->prop_mgr;
	_tmp1_ = self->priv->consumer;
	_tmp2_ = unity_music_player_get_title (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _variant_new66 (_tmp3_);
	unity_property_update_manager_queue_property_update (_tmp0_, "Identity", _tmp4_, UNITY_MPRIS_INTERFACE_ROOT);
}


static void ___lambda17__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	__lambda17_ (self, _sender, pspec);
}


static void unity_mpris_root_wire_up (UnityMprisRoot* self) {
	UnityMusicPlayer* _tmp0_;
	UnityMusicPlayer* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar** _tmp4_;
	gchar** _tmp5_ = NULL;
	gchar** _tmp6_;
	gint _tmp6__length1;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->consumer;
	g_signal_connect_object ((GObject*) _tmp0_, "notify::title", (GCallback) ___lambda17__g_object_notify, self, 0);
	_tmp1_ = self->priv->consumer;
	_tmp2_ = unity_music_player_get_desktop_file_name (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp5_ = _tmp4_ = g_strsplit (_tmp3_, ".", 0);
	_tmp6_ = _tmp5_;
	_tmp6__length1 = _vala_array_length (_tmp4_);
	_tmp7_ = _tmp6_[0];
	_tmp8_ = g_strdup (_tmp7_);
	_g_free0 (self->priv->mpris_desktop_entry);
	self->priv->mpris_desktop_entry = _tmp8_;
	_tmp6_ = (_vala_array_free (_tmp6_, _tmp6__length1, (GDestroyNotify) g_free), NULL);
}


static void unity_mpris_root_raise_data_free (gpointer _data) {
	UnityMprisRootRaiseData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (UnityMprisRootRaiseData, _data_);
}


void unity_mpris_root_raise (UnityMprisRoot* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UnityMprisRootRaiseData* _data_;
	UnityMprisRoot* _tmp0_;
	_data_ = g_slice_new0 (UnityMprisRootRaiseData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, unity_mpris_root_raise);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, unity_mpris_root_raise_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	unity_mpris_root_raise_co (_data_);
}


void unity_mpris_root_raise_finish (UnityMprisRoot* self, GAsyncResult* _res_, GError** error) {
	UnityMprisRootRaiseData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static gboolean unity_mpris_root_raise_co (UnityMprisRootRaiseData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->consumer;
	g_signal_emit_by_name (_data_->_tmp0_, "raise");
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


gboolean unity_mpris_root_get_has_tracklist (UnityMprisRoot* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = FALSE;
	return result;
}


gboolean unity_mpris_root_get_can_quit (UnityMprisRoot* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = FALSE;
	return result;
}


gboolean unity_mpris_root_get_can_raise (UnityMprisRoot* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = TRUE;
	return result;
}


const gchar* unity_mpris_root_get_identity (UnityMprisRoot* self) {
	const gchar* result;
	UnityMusicPlayer* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->consumer;
	_tmp1_ = unity_music_player_get_title (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}


const gchar* unity_mpris_root_get_desktop_entry (UnityMprisRoot* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->mpris_desktop_entry;
	result = _tmp0_;
	return result;
}


static GObject * unity_mpris_root_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	UnityMprisRoot * self;
	parent_class = G_OBJECT_CLASS (unity_mpris_root_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = UNITY_MPRIS_ROOT (obj);
	return obj;
}


static void unity_mpris_root_class_init (UnityMprisRootClass * klass) {
	unity_mpris_root_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (UnityMprisRootPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_unity_mpris_root_get_property;
	G_OBJECT_CLASS (klass)->constructor = unity_mpris_root_constructor;
	G_OBJECT_CLASS (klass)->finalize = unity_mpris_root_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_MPRIS_ROOT_HAS_TRACKLIST, g_param_spec_boolean ("has-tracklist", "has-tracklist", "has-tracklist", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_MPRIS_ROOT_CAN_QUIT, g_param_spec_boolean ("can-quit", "can-quit", "can-quit", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_MPRIS_ROOT_CAN_RAISE, g_param_spec_boolean ("can-raise", "can-raise", "can-raise", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_MPRIS_ROOT_IDENTITY, g_param_spec_string ("identity", "identity", "identity", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_MPRIS_ROOT_DESKTOP_ENTRY, g_param_spec_string ("desktop-entry", "desktop-entry", "desktop-entry", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void unity_mpris_root_instance_init (UnityMprisRoot * self) {
	self->priv = UNITY_MPRIS_ROOT_GET_PRIVATE (self);
}


static void unity_mpris_root_finalize (GObject* obj) {
	UnityMprisRoot * self;
	self = UNITY_MPRIS_ROOT (obj);
	_g_object_unref0 (self->priv->consumer);
	_g_object_unref0 (self->priv->prop_mgr);
	_g_free0 (self->priv->mpris_desktop_entry);
	G_OBJECT_CLASS (unity_mpris_root_parent_class)->finalize (obj);
}


/**
  MPRIS Root 
  **/
GType unity_mpris_root_get_type (void) {
	static volatile gsize unity_mpris_root_type_id__volatile = 0;
	if (g_once_init_enter (&unity_mpris_root_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UnityMprisRootClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unity_mpris_root_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnityMprisRoot), 0, (GInstanceInitFunc) unity_mpris_root_instance_init, NULL };
		GType unity_mpris_root_type_id;
		unity_mpris_root_type_id = g_type_register_static (G_TYPE_OBJECT, "UnityMprisRoot", &g_define_type_info, 0);
		g_type_set_qdata (unity_mpris_root_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) unity_mpris_root_register_object);
		g_once_init_leave (&unity_mpris_root_type_id__volatile, unity_mpris_root_type_id);
	}
	return unity_mpris_root_type_id__volatile;
}


static void _vala_unity_mpris_root_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	UnityMprisRoot * self;
	self = UNITY_MPRIS_ROOT (object);
	switch (property_id) {
		case UNITY_MPRIS_ROOT_HAS_TRACKLIST:
		g_value_set_boolean (value, unity_mpris_root_get_has_tracklist (self));
		break;
		case UNITY_MPRIS_ROOT_CAN_QUIT:
		g_value_set_boolean (value, unity_mpris_root_get_can_quit (self));
		break;
		case UNITY_MPRIS_ROOT_CAN_RAISE:
		g_value_set_boolean (value, unity_mpris_root_get_can_raise (self));
		break;
		case UNITY_MPRIS_ROOT_IDENTITY:
		g_value_set_string (value, unity_mpris_root_get_identity (self));
		break;
		case UNITY_MPRIS_ROOT_DESKTOP_ENTRY:
		g_value_set_string (value, unity_mpris_root_get_desktop_entry (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _dbus_unity_mpris_root_raise (UnityMprisRoot* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GVariantIter _arguments_iter;
	g_variant_iter_init (&_arguments_iter, parameters);
	unity_mpris_root_raise (self, (GAsyncReadyCallback) _dbus_unity_mpris_root_raise_ready, invocation);
}


static void _dbus_unity_mpris_root_raise_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_) {
	GDBusMethodInvocation * invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	invocation = _user_data_;
	unity_mpris_root_raise_finish ((UnityMprisRoot*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void unity_mpris_root_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "Raise") == 0) {
		_dbus_unity_mpris_root_raise (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}


static GVariant* _dbus_unity_mpris_root_get_has_tracklist (UnityMprisRoot* self) {
	gboolean result;
	GVariant* _reply;
	result = unity_mpris_root_get_has_tracklist (self);
	_reply = g_variant_new_boolean (result);
	return _reply;
}


static GVariant* _dbus_unity_mpris_root_get_can_quit (UnityMprisRoot* self) {
	gboolean result;
	GVariant* _reply;
	result = unity_mpris_root_get_can_quit (self);
	_reply = g_variant_new_boolean (result);
	return _reply;
}


static GVariant* _dbus_unity_mpris_root_get_can_raise (UnityMprisRoot* self) {
	gboolean result;
	GVariant* _reply;
	result = unity_mpris_root_get_can_raise (self);
	_reply = g_variant_new_boolean (result);
	return _reply;
}


static GVariant* _dbus_unity_mpris_root_get_identity (UnityMprisRoot* self) {
	const gchar* result;
	GVariant* _reply;
	result = unity_mpris_root_get_identity (self);
	_reply = g_variant_new_string (result);
	return _reply;
}


static GVariant* _dbus_unity_mpris_root_get_desktop_entry (UnityMprisRoot* self) {
	const gchar* result;
	GVariant* _reply;
	result = unity_mpris_root_get_desktop_entry (self);
	_reply = g_variant_new_string (result);
	return _reply;
}


static GVariant* unity_mpris_root_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (property_name, "HasTracklist") == 0) {
		return _dbus_unity_mpris_root_get_has_tracklist (object);
	} else if (strcmp (property_name, "CanQuit") == 0) {
		return _dbus_unity_mpris_root_get_can_quit (object);
	} else if (strcmp (property_name, "CanRaise") == 0) {
		return _dbus_unity_mpris_root_get_can_raise (object);
	} else if (strcmp (property_name, "Identity") == 0) {
		return _dbus_unity_mpris_root_get_identity (object);
	} else if (strcmp (property_name, "DesktopEntry") == 0) {
		return _dbus_unity_mpris_root_get_desktop_entry (object);
	}
	return NULL;
}


static gboolean unity_mpris_root_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}


guint unity_mpris_root_register_object (gpointer object, GDBusConnection* connection, const gchar* path, GError** error) {
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_unity_mpris_root_dbus_interface_info), &_unity_mpris_root_dbus_interface_vtable, data, _unity_mpris_root_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}


static void _unity_mpris_root_unregister_object (gpointer user_data) {
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}


UnityMprisPlayer* unity_mpris_player_construct (GType object_type, UnityMusicPlayer* client, UnityPropertyUpdateManager* prop_mgr) {
	UnityMprisPlayer * self = NULL;
	UnityMusicPlayer* _tmp0_;
	UnityMusicPlayer* _tmp1_;
	UnityPropertyUpdateManager* _tmp2_;
	UnityPropertyUpdateManager* _tmp3_;
	g_return_val_if_fail (client != NULL, NULL);
	g_return_val_if_fail (prop_mgr != NULL, NULL);
	self = (UnityMprisPlayer*) g_object_new (object_type, NULL);
	_tmp0_ = client;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->consumer);
	self->priv->consumer = _tmp1_;
	_tmp2_ = prop_mgr;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (self->priv->prop_mgr);
	self->priv->prop_mgr = _tmp3_;
	unity_mpris_player_wire_it_up (self);
	return self;
}


UnityMprisPlayer* unity_mpris_player_new (UnityMusicPlayer* client, UnityPropertyUpdateManager* prop_mgr) {
	return unity_mpris_player_construct (UNITY_TYPE_MPRIS_PLAYER, client, prop_mgr);
}


static void _unity_mpris_player_on_metadata_update_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	unity_mpris_player_on_metadata_update (self, pspec);
}


static GVariant* _variant_new67 (const gchar* value) {
	return g_variant_ref_sink (g_variant_new_string (value));
}


static void __lambda18_ (UnityMprisPlayer* self, GObject* obj, GParamSpec* pspec) {
	const gchar* _tmp0_ = NULL;
	UnityMusicPlayer* _tmp1_;
	UnityPlaybackState _tmp2_;
	UnityPlaybackState _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* update;
	UnityPropertyUpdateManager* _tmp6_;
	GVariant* _tmp7_;
	g_return_if_fail (obj != NULL);
	g_return_if_fail (pspec != NULL);
	_tmp1_ = self->priv->consumer;
	_tmp2_ = unity_music_player_get_playback_state (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == UNITY_PLAYBACK_STATE_PAUSED) {
		_tmp0_ = "Paused";
	} else {
		_tmp0_ = "Playing";
	}
	_tmp4_ = _tmp0_;
	_tmp5_ = g_strdup (_tmp4_);
	update = _tmp5_;
	_tmp6_ = self->priv->prop_mgr;
	_tmp7_ = _variant_new67 (update);
	unity_property_update_manager_queue_property_update (_tmp6_, "PlaybackStatus", _tmp7_, UNITY_MPRIS_INTERFACE_PLAYER);
	_g_free0 (update);
}


static void ___lambda18__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	__lambda18_ (self, _sender, pspec);
}


static GVariant* _variant_new68 (gboolean value) {
	return g_variant_ref_sink (g_variant_new_boolean (value));
}


static void __lambda19_ (UnityMprisPlayer* self, GObject* obj, GParamSpec* pspec) {
	UnityPropertyUpdateManager* _tmp0_;
	UnityMusicPlayer* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	GVariant* _tmp4_;
	g_return_if_fail (obj != NULL);
	g_return_if_fail (pspec != NULL);
	_tmp0_ = self->priv->prop_mgr;
	_tmp1_ = self->priv->consumer;
	_tmp2_ = unity_music_player_get_can_go_next (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _variant_new68 (_tmp3_);
	unity_property_update_manager_queue_property_update (_tmp0_, "CanGoNext", _tmp4_, UNITY_MPRIS_INTERFACE_PLAYER);
}


static void ___lambda19__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	__lambda19_ (self, _sender, pspec);
}


static GVariant* _variant_new69 (gboolean value) {
	return g_variant_ref_sink (g_variant_new_boolean (value));
}


static void __lambda20_ (UnityMprisPlayer* self, GObject* obj, GParamSpec* pspec) {
	UnityPropertyUpdateManager* _tmp0_;
	UnityMusicPlayer* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	GVariant* _tmp4_;
	g_return_if_fail (obj != NULL);
	g_return_if_fail (pspec != NULL);
	_tmp0_ = self->priv->prop_mgr;
	_tmp1_ = self->priv->consumer;
	_tmp2_ = unity_music_player_get_can_go_previous (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _variant_new69 (_tmp3_);
	unity_property_update_manager_queue_property_update (_tmp0_, "CanGoPrevious", _tmp4_, UNITY_MPRIS_INTERFACE_PLAYER);
}


static void ___lambda20__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	__lambda20_ (self, _sender, pspec);
}


static GVariant* _variant_new70 (gboolean value) {
	return g_variant_ref_sink (g_variant_new_boolean (value));
}


static void __lambda21_ (UnityMprisPlayer* self, GObject* obj, GParamSpec* pspec) {
	UnityPropertyUpdateManager* _tmp0_;
	UnityMusicPlayer* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	GVariant* _tmp4_;
	g_return_if_fail (obj != NULL);
	g_return_if_fail (pspec != NULL);
	_tmp0_ = self->priv->prop_mgr;
	_tmp1_ = self->priv->consumer;
	_tmp2_ = unity_music_player_get_can_play (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _variant_new70 (_tmp3_);
	unity_property_update_manager_queue_property_update (_tmp0_, "CanPlay", _tmp4_, UNITY_MPRIS_INTERFACE_PLAYER);
}


static void ___lambda21__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	__lambda21_ (self, _sender, pspec);
}


static GVariant* _variant_new71 (gboolean value) {
	return g_variant_ref_sink (g_variant_new_boolean (value));
}


static void __lambda22_ (UnityMprisPlayer* self, GObject* obj, GParamSpec* pspec) {
	UnityPropertyUpdateManager* _tmp0_;
	UnityMusicPlayer* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	GVariant* _tmp4_;
	g_return_if_fail (obj != NULL);
	g_return_if_fail (pspec != NULL);
	_tmp0_ = self->priv->prop_mgr;
	_tmp1_ = self->priv->consumer;
	_tmp2_ = unity_music_player_get_can_pause (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _variant_new71 (_tmp3_);
	unity_property_update_manager_queue_property_update (_tmp0_, "CanPause", _tmp4_, UNITY_MPRIS_INTERFACE_PLAYER);
}


static void ___lambda22__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	__lambda22_ (self, _sender, pspec);
}


static GVariant* _variant_new72 (const gchar* value) {
	return g_variant_ref_sink (g_variant_new_string (value));
}


static void unity_mpris_player_wire_it_up (UnityMprisPlayer* self) {
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	UnityMusicPlayer* _tmp3_;
	UnityMusicPlayer* _tmp4_;
	UnityMusicPlayer* _tmp5_;
	UnityMusicPlayer* _tmp6_;
	UnityMusicPlayer* _tmp7_;
	UnityMusicPlayer* _tmp8_;
	const gchar* _tmp9_ = NULL;
	UnityMusicPlayer* _tmp10_;
	UnityPlaybackState _tmp11_;
	UnityPlaybackState _tmp12_;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* update;
	UnityPropertyUpdateManager* _tmp15_;
	GVariant* _tmp16_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, _g_variant_unref0_);
	_g_hash_table_unref0 (self->priv->current_metadata);
	self->priv->current_metadata = _tmp2_;
	_tmp3_ = self->priv->consumer;
	g_signal_connect_object ((GObject*) _tmp3_, "notify::current-track", (GCallback) _unity_mpris_player_on_metadata_update_g_object_notify, self, 0);
	_tmp4_ = self->priv->consumer;
	g_signal_connect_object ((GObject*) _tmp4_, "notify::playback-state", (GCallback) ___lambda18__g_object_notify, self, 0);
	_tmp5_ = self->priv->consumer;
	g_signal_connect_object ((GObject*) _tmp5_, "notify::can-go-next", (GCallback) ___lambda19__g_object_notify, self, 0);
	_tmp6_ = self->priv->consumer;
	g_signal_connect_object ((GObject*) _tmp6_, "notify::can-go-previous", (GCallback) ___lambda20__g_object_notify, self, 0);
	_tmp7_ = self->priv->consumer;
	g_signal_connect_object ((GObject*) _tmp7_, "notify::can-play", (GCallback) ___lambda21__g_object_notify, self, 0);
	_tmp8_ = self->priv->consumer;
	g_signal_connect_object ((GObject*) _tmp8_, "notify::can-pause", (GCallback) ___lambda22__g_object_notify, self, 0);
	_tmp10_ = self->priv->consumer;
	_tmp11_ = unity_music_player_get_playback_state (_tmp10_);
	_tmp12_ = _tmp11_;
	if (_tmp12_ == UNITY_PLAYBACK_STATE_PAUSED) {
		_tmp9_ = "Paused";
	} else {
		_tmp9_ = "Playing";
	}
	_tmp13_ = _tmp9_;
	_tmp14_ = g_strdup (_tmp13_);
	update = _tmp14_;
	_tmp15_ = self->priv->prop_mgr;
	_tmp16_ = _variant_new72 (update);
	unity_property_update_manager_queue_property_update (_tmp15_, "PlaybackStatus", _tmp16_, UNITY_MPRIS_INTERFACE_PLAYER);
	_g_free0 (update);
}


static GVariant* _variant_new73 (gchar* value) {
	return g_variant_ref_sink (g_variant_new_string (value));
}


static GVariant* _variant_new74 (const gchar* value) {
	return g_variant_ref_sink (g_variant_new_string (value));
}


static GVariant* _variant_new75 (const gchar* value) {
	return g_variant_ref_sink (g_variant_new_string (value));
}


static GVariant* _variant_new76 (const gchar* value) {
	return g_variant_ref_sink (g_variant_new_string (value));
}


static GVariant* _variant_new77 (GHashTable* value) {
	GVariantBuilder _tmp56_;
	GHashTableIter _tmp57_;
	gpointer _tmp58_;
	gpointer _tmp59_;
	g_hash_table_iter_init (&_tmp57_, value);
	g_variant_builder_init (&_tmp56_, G_VARIANT_TYPE ("a{sv}"));
	while (g_hash_table_iter_next (&_tmp57_, &_tmp58_, &_tmp59_)) {
		gchar* _key;
		GVariant* _value;
		_key = (gchar*) _tmp58_;
		_value = (GVariant*) _tmp59_;
		g_variant_builder_add (&_tmp56_, "{?*}", g_variant_new_string (_key), g_variant_new_variant (_value));
	}
	return g_variant_ref_sink (g_variant_builder_end (&_tmp56_));
}


void unity_mpris_player_on_metadata_update (UnityMprisPlayer* self, GParamSpec* pspec) {
	GHashTable* _tmp0_;
	UnityMusicPlayer* _tmp1_;
	UnityTrackMetadata* _tmp2_;
	UnityTrackMetadata* _tmp3_;
	GFile* _tmp4_;
	GFile* _tmp5_;
	UnityMusicPlayer* _tmp15_;
	UnityTrackMetadata* _tmp16_;
	UnityTrackMetadata* _tmp17_;
	const gchar* _tmp18_;
	const gchar* _tmp19_;
	UnityMusicPlayer* _tmp28_;
	UnityTrackMetadata* _tmp29_;
	UnityTrackMetadata* _tmp30_;
	const gchar* _tmp31_;
	const gchar* _tmp32_;
	UnityMusicPlayer* _tmp41_;
	UnityTrackMetadata* _tmp42_;
	UnityTrackMetadata* _tmp43_;
	const gchar* _tmp44_;
	const gchar* _tmp45_;
	UnityPropertyUpdateManager* _tmp54_;
	GHashTable* _tmp55_;
	GVariant* _tmp60_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (pspec != NULL);
	_tmp0_ = self->priv->current_metadata;
	g_hash_table_remove_all (_tmp0_);
	_tmp1_ = self->priv->consumer;
	_tmp2_ = unity_music_player_get_current_track (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = unity_track_metadata_get_art_location (_tmp3_);
	_tmp5_ = _tmp4_;
	if (_tmp5_ != NULL) {
		GHashTable* _tmp6_;
		gchar* _tmp7_;
		UnityMusicPlayer* _tmp8_;
		UnityTrackMetadata* _tmp9_;
		UnityTrackMetadata* _tmp10_;
		GFile* _tmp11_;
		GFile* _tmp12_;
		gchar* _tmp13_ = NULL;
		GVariant* _tmp14_;
		_tmp6_ = self->priv->current_metadata;
		_tmp7_ = g_strdup ("mpris:artUrl");
		_tmp8_ = self->priv->consumer;
		_tmp9_ = unity_music_player_get_current_track (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = unity_track_metadata_get_art_location (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = g_file_get_uri (_tmp12_);
		_tmp14_ = _variant_new73 (_tmp13_);
		g_hash_table_insert (_tmp6_, _tmp7_, _tmp14_);
	}
	_tmp15_ = self->priv->consumer;
	_tmp16_ = unity_music_player_get_current_track (_tmp15_);
	_tmp17_ = _tmp16_;
	_tmp18_ = unity_track_metadata_get_artist (_tmp17_);
	_tmp19_ = _tmp18_;
	if (_tmp19_ != NULL) {
		GHashTable* _tmp20_;
		gchar* _tmp21_;
		UnityMusicPlayer* _tmp22_;
		UnityTrackMetadata* _tmp23_;
		UnityTrackMetadata* _tmp24_;
		const gchar* _tmp25_;
		const gchar* _tmp26_;
		GVariant* _tmp27_;
		_tmp20_ = self->priv->current_metadata;
		_tmp21_ = g_strdup ("xesam:artist");
		_tmp22_ = self->priv->consumer;
		_tmp23_ = unity_music_player_get_current_track (_tmp22_);
		_tmp24_ = _tmp23_;
		_tmp25_ = unity_track_metadata_get_artist (_tmp24_);
		_tmp26_ = _tmp25_;
		_tmp27_ = _variant_new74 (_tmp26_);
		g_hash_table_insert (_tmp20_, _tmp21_, _tmp27_);
	}
	_tmp28_ = self->priv->consumer;
	_tmp29_ = unity_music_player_get_current_track (_tmp28_);
	_tmp30_ = _tmp29_;
	_tmp31_ = unity_track_metadata_get_album (_tmp30_);
	_tmp32_ = _tmp31_;
	if (_tmp32_ != NULL) {
		GHashTable* _tmp33_;
		gchar* _tmp34_;
		UnityMusicPlayer* _tmp35_;
		UnityTrackMetadata* _tmp36_;
		UnityTrackMetadata* _tmp37_;
		const gchar* _tmp38_;
		const gchar* _tmp39_;
		GVariant* _tmp40_;
		_tmp33_ = self->priv->current_metadata;
		_tmp34_ = g_strdup ("xesam:album");
		_tmp35_ = self->priv->consumer;
		_tmp36_ = unity_music_player_get_current_track (_tmp35_);
		_tmp37_ = _tmp36_;
		_tmp38_ = unity_track_metadata_get_album (_tmp37_);
		_tmp39_ = _tmp38_;
		_tmp40_ = _variant_new75 (_tmp39_);
		g_hash_table_insert (_tmp33_, _tmp34_, _tmp40_);
	}
	_tmp41_ = self->priv->consumer;
	_tmp42_ = unity_music_player_get_current_track (_tmp41_);
	_tmp43_ = _tmp42_;
	_tmp44_ = unity_track_metadata_get_title (_tmp43_);
	_tmp45_ = _tmp44_;
	if (_tmp45_ != NULL) {
		GHashTable* _tmp46_;
		gchar* _tmp47_;
		UnityMusicPlayer* _tmp48_;
		UnityTrackMetadata* _tmp49_;
		UnityTrackMetadata* _tmp50_;
		const gchar* _tmp51_;
		const gchar* _tmp52_;
		GVariant* _tmp53_;
		_tmp46_ = self->priv->current_metadata;
		_tmp47_ = g_strdup ("xesam:title");
		_tmp48_ = self->priv->consumer;
		_tmp49_ = unity_music_player_get_current_track (_tmp48_);
		_tmp50_ = _tmp49_;
		_tmp51_ = unity_track_metadata_get_title (_tmp50_);
		_tmp52_ = _tmp51_;
		_tmp53_ = _variant_new76 (_tmp52_);
		g_hash_table_insert (_tmp46_, _tmp47_, _tmp53_);
	}
	_tmp54_ = self->priv->prop_mgr;
	_tmp55_ = self->priv->current_metadata;
	_tmp60_ = _variant_new77 (_tmp55_);
	unity_property_update_manager_queue_property_update (_tmp54_, "Metadata", _tmp60_, UNITY_MPRIS_INTERFACE_PLAYER);
}


static void unity_mpris_player_play_pause_data_free (gpointer _data) {
	UnityMprisPlayerPlayPauseData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (UnityMprisPlayerPlayPauseData, _data_);
}


void unity_mpris_player_play_pause (UnityMprisPlayer* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UnityMprisPlayerPlayPauseData* _data_;
	UnityMprisPlayer* _tmp0_;
	_data_ = g_slice_new0 (UnityMprisPlayerPlayPauseData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, unity_mpris_player_play_pause);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, unity_mpris_player_play_pause_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	unity_mpris_player_play_pause_co (_data_);
}


void unity_mpris_player_play_pause_finish (UnityMprisPlayer* self, GAsyncResult* _res_, GError** error) {
	UnityMprisPlayerPlayPauseData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static gboolean unity_mpris_player_play_pause_co (UnityMprisPlayerPlayPauseData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->consumer;
	g_signal_emit_by_name (_data_->_tmp0_, "play-pause");
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void unity_mpris_player_next_data_free (gpointer _data) {
	UnityMprisPlayerNextData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (UnityMprisPlayerNextData, _data_);
}


void unity_mpris_player_next (UnityMprisPlayer* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UnityMprisPlayerNextData* _data_;
	UnityMprisPlayer* _tmp0_;
	_data_ = g_slice_new0 (UnityMprisPlayerNextData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, unity_mpris_player_next);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, unity_mpris_player_next_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	unity_mpris_player_next_co (_data_);
}


void unity_mpris_player_next_finish (UnityMprisPlayer* self, GAsyncResult* _res_, GError** error) {
	UnityMprisPlayerNextData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static gboolean unity_mpris_player_next_co (UnityMprisPlayerNextData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->consumer;
	g_signal_emit_by_name (_data_->_tmp0_, "next");
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void unity_mpris_player_previous_data_free (gpointer _data) {
	UnityMprisPlayerPreviousData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (UnityMprisPlayerPreviousData, _data_);
}


void unity_mpris_player_previous (UnityMprisPlayer* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UnityMprisPlayerPreviousData* _data_;
	UnityMprisPlayer* _tmp0_;
	_data_ = g_slice_new0 (UnityMprisPlayerPreviousData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, unity_mpris_player_previous);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, unity_mpris_player_previous_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	unity_mpris_player_previous_co (_data_);
}


void unity_mpris_player_previous_finish (UnityMprisPlayer* self, GAsyncResult* _res_, GError** error) {
	UnityMprisPlayerPreviousData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static gboolean unity_mpris_player_previous_co (UnityMprisPlayerPreviousData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->consumer;
	g_signal_emit_by_name (_data_->_tmp0_, "previous");
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


GHashTable* unity_mpris_player_get_metadata (UnityMprisPlayer* self) {
	GHashTable* result;
	GHashTable* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->current_metadata;
	result = _tmp0_;
	return result;
}


const gchar* unity_mpris_player_get_playback_status (UnityMprisPlayer* self) {
	const gchar* result;
	const gchar* _tmp0_ = NULL;
	UnityMusicPlayer* _tmp1_;
	UnityPlaybackState _tmp2_;
	UnityPlaybackState _tmp3_;
	const gchar* _tmp4_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = self->priv->consumer;
	_tmp2_ = unity_music_player_get_playback_state (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_ == UNITY_PLAYBACK_STATE_PAUSED) {
		_tmp0_ = "Paused";
	} else {
		_tmp0_ = "Playing";
	}
	_tmp4_ = _tmp0_;
	result = _tmp4_;
	return result;
}


gboolean unity_mpris_player_get_can_control (UnityMprisPlayer* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = TRUE;
	return result;
}


gboolean unity_mpris_player_get_can_go_next (UnityMprisPlayer* self) {
	gboolean result;
	UnityMusicPlayer* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->consumer;
	_tmp1_ = unity_music_player_get_can_go_next (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}


gboolean unity_mpris_player_get_can_go_previous (UnityMprisPlayer* self) {
	gboolean result;
	UnityMusicPlayer* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->consumer;
	_tmp1_ = unity_music_player_get_can_go_previous (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}


gboolean unity_mpris_player_get_can_play (UnityMprisPlayer* self) {
	gboolean result;
	UnityMusicPlayer* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->consumer;
	_tmp1_ = unity_music_player_get_can_play (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}


gboolean unity_mpris_player_get_can_pause (UnityMprisPlayer* self) {
	gboolean result;
	UnityMusicPlayer* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->consumer;
	_tmp1_ = unity_music_player_get_can_pause (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}


static GObject * unity_mpris_player_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	UnityMprisPlayer * self;
	parent_class = G_OBJECT_CLASS (unity_mpris_player_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = UNITY_MPRIS_PLAYER (obj);
	return obj;
}


static void unity_mpris_player_class_init (UnityMprisPlayerClass * klass) {
	unity_mpris_player_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (UnityMprisPlayerPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_unity_mpris_player_get_property;
	G_OBJECT_CLASS (klass)->constructor = unity_mpris_player_constructor;
	G_OBJECT_CLASS (klass)->finalize = unity_mpris_player_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_MPRIS_PLAYER_METADATA, g_param_spec_boxed ("metadata", "metadata", "metadata", G_TYPE_HASH_TABLE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_MPRIS_PLAYER_PLAYBACK_STATUS, g_param_spec_string ("playback-status", "playback-status", "playback-status", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_MPRIS_PLAYER_CAN_CONTROL, g_param_spec_boolean ("can-control", "can-control", "can-control", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_MPRIS_PLAYER_CAN_GO_NEXT, g_param_spec_boolean ("can-go-next", "can-go-next", "can-go-next", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_MPRIS_PLAYER_CAN_GO_PREVIOUS, g_param_spec_boolean ("can-go-previous", "can-go-previous", "can-go-previous", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_MPRIS_PLAYER_CAN_PLAY, g_param_spec_boolean ("can-play", "can-play", "can-play", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_MPRIS_PLAYER_CAN_PAUSE, g_param_spec_boolean ("can-pause", "can-pause", "can-pause", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void unity_mpris_player_instance_init (UnityMprisPlayer * self) {
	self->priv = UNITY_MPRIS_PLAYER_GET_PRIVATE (self);
}


static void unity_mpris_player_finalize (GObject* obj) {
	UnityMprisPlayer * self;
	self = UNITY_MPRIS_PLAYER (obj);
	_g_object_unref0 (self->priv->consumer);
	_g_object_unref0 (self->priv->prop_mgr);
	_g_hash_table_unref0 (self->priv->current_metadata);
	G_OBJECT_CLASS (unity_mpris_player_parent_class)->finalize (obj);
}


/**
  MPRIS Player
  **/
GType unity_mpris_player_get_type (void) {
	static volatile gsize unity_mpris_player_type_id__volatile = 0;
	if (g_once_init_enter (&unity_mpris_player_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UnityMprisPlayerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unity_mpris_player_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnityMprisPlayer), 0, (GInstanceInitFunc) unity_mpris_player_instance_init, NULL };
		GType unity_mpris_player_type_id;
		unity_mpris_player_type_id = g_type_register_static (G_TYPE_OBJECT, "UnityMprisPlayer", &g_define_type_info, 0);
		g_type_set_qdata (unity_mpris_player_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) unity_mpris_player_register_object);
		g_once_init_leave (&unity_mpris_player_type_id__volatile, unity_mpris_player_type_id);
	}
	return unity_mpris_player_type_id__volatile;
}


static void _vala_unity_mpris_player_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	UnityMprisPlayer * self;
	self = UNITY_MPRIS_PLAYER (object);
	switch (property_id) {
		case UNITY_MPRIS_PLAYER_METADATA:
		g_value_set_boxed (value, unity_mpris_player_get_metadata (self));
		break;
		case UNITY_MPRIS_PLAYER_PLAYBACK_STATUS:
		g_value_set_string (value, unity_mpris_player_get_playback_status (self));
		break;
		case UNITY_MPRIS_PLAYER_CAN_CONTROL:
		g_value_set_boolean (value, unity_mpris_player_get_can_control (self));
		break;
		case UNITY_MPRIS_PLAYER_CAN_GO_NEXT:
		g_value_set_boolean (value, unity_mpris_player_get_can_go_next (self));
		break;
		case UNITY_MPRIS_PLAYER_CAN_GO_PREVIOUS:
		g_value_set_boolean (value, unity_mpris_player_get_can_go_previous (self));
		break;
		case UNITY_MPRIS_PLAYER_CAN_PLAY:
		g_value_set_boolean (value, unity_mpris_player_get_can_play (self));
		break;
		case UNITY_MPRIS_PLAYER_CAN_PAUSE:
		g_value_set_boolean (value, unity_mpris_player_get_can_pause (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _dbus_unity_mpris_player_play_pause (UnityMprisPlayer* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GVariantIter _arguments_iter;
	g_variant_iter_init (&_arguments_iter, parameters);
	unity_mpris_player_play_pause (self, (GAsyncReadyCallback) _dbus_unity_mpris_player_play_pause_ready, invocation);
}


static void _dbus_unity_mpris_player_play_pause_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_) {
	GDBusMethodInvocation * invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	invocation = _user_data_;
	unity_mpris_player_play_pause_finish ((UnityMprisPlayer*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_unity_mpris_player_next (UnityMprisPlayer* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GVariantIter _arguments_iter;
	g_variant_iter_init (&_arguments_iter, parameters);
	unity_mpris_player_next (self, (GAsyncReadyCallback) _dbus_unity_mpris_player_next_ready, invocation);
}


static void _dbus_unity_mpris_player_next_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_) {
	GDBusMethodInvocation * invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	invocation = _user_data_;
	unity_mpris_player_next_finish ((UnityMprisPlayer*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_unity_mpris_player_previous (UnityMprisPlayer* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GVariantIter _arguments_iter;
	g_variant_iter_init (&_arguments_iter, parameters);
	unity_mpris_player_previous (self, (GAsyncReadyCallback) _dbus_unity_mpris_player_previous_ready, invocation);
}


static void _dbus_unity_mpris_player_previous_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_) {
	GDBusMethodInvocation * invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	invocation = _user_data_;
	unity_mpris_player_previous_finish ((UnityMprisPlayer*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void unity_mpris_player_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "PlayPause") == 0) {
		_dbus_unity_mpris_player_play_pause (object, parameters, invocation);
	} else if (strcmp (method_name, "Next") == 0) {
		_dbus_unity_mpris_player_next (object, parameters, invocation);
	} else if (strcmp (method_name, "Previous") == 0) {
		_dbus_unity_mpris_player_previous (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}


static GVariant* _dbus_unity_mpris_player_get_metadata (UnityMprisPlayer* self) {
	GHashTable* result;
	GVariantBuilder _tmp215_;
	GHashTableIter _tmp216_;
	gpointer _tmp217_;
	gpointer _tmp218_;
	GVariant* _reply;
	result = unity_mpris_player_get_metadata (self);
	g_hash_table_iter_init (&_tmp216_, result);
	g_variant_builder_init (&_tmp215_, G_VARIANT_TYPE ("a{sv}"));
	while (g_hash_table_iter_next (&_tmp216_, &_tmp217_, &_tmp218_)) {
		gchar* _key;
		GVariant* _value;
		_key = (gchar*) _tmp217_;
		_value = (GVariant*) _tmp218_;
		g_variant_builder_add (&_tmp215_, "{?*}", g_variant_new_string (_key), g_variant_new_variant (_value));
	}
	_reply = g_variant_builder_end (&_tmp215_);
	return _reply;
}


static GVariant* _dbus_unity_mpris_player_get_playback_status (UnityMprisPlayer* self) {
	const gchar* result;
	GVariant* _reply;
	result = unity_mpris_player_get_playback_status (self);
	_reply = g_variant_new_string (result);
	return _reply;
}


static GVariant* _dbus_unity_mpris_player_get_can_control (UnityMprisPlayer* self) {
	gboolean result;
	GVariant* _reply;
	result = unity_mpris_player_get_can_control (self);
	_reply = g_variant_new_boolean (result);
	return _reply;
}


static GVariant* _dbus_unity_mpris_player_get_can_go_next (UnityMprisPlayer* self) {
	gboolean result;
	GVariant* _reply;
	result = unity_mpris_player_get_can_go_next (self);
	_reply = g_variant_new_boolean (result);
	return _reply;
}


static GVariant* _dbus_unity_mpris_player_get_can_go_previous (UnityMprisPlayer* self) {
	gboolean result;
	GVariant* _reply;
	result = unity_mpris_player_get_can_go_previous (self);
	_reply = g_variant_new_boolean (result);
	return _reply;
}


static GVariant* _dbus_unity_mpris_player_get_can_play (UnityMprisPlayer* self) {
	gboolean result;
	GVariant* _reply;
	result = unity_mpris_player_get_can_play (self);
	_reply = g_variant_new_boolean (result);
	return _reply;
}


static GVariant* _dbus_unity_mpris_player_get_can_pause (UnityMprisPlayer* self) {
	gboolean result;
	GVariant* _reply;
	result = unity_mpris_player_get_can_pause (self);
	_reply = g_variant_new_boolean (result);
	return _reply;
}


static GVariant* unity_mpris_player_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (property_name, "Metadata") == 0) {
		return _dbus_unity_mpris_player_get_metadata (object);
	} else if (strcmp (property_name, "PlaybackStatus") == 0) {
		return _dbus_unity_mpris_player_get_playback_status (object);
	} else if (strcmp (property_name, "CanControl") == 0) {
		return _dbus_unity_mpris_player_get_can_control (object);
	} else if (strcmp (property_name, "CanGoNext") == 0) {
		return _dbus_unity_mpris_player_get_can_go_next (object);
	} else if (strcmp (property_name, "CanGoPrevious") == 0) {
		return _dbus_unity_mpris_player_get_can_go_previous (object);
	} else if (strcmp (property_name, "CanPlay") == 0) {
		return _dbus_unity_mpris_player_get_can_play (object);
	} else if (strcmp (property_name, "CanPause") == 0) {
		return _dbus_unity_mpris_player_get_can_pause (object);
	}
	return NULL;
}


static gboolean unity_mpris_player_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}


guint unity_mpris_player_register_object (gpointer object, GDBusConnection* connection, const gchar* path, GError** error) {
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_unity_mpris_player_dbus_interface_info), &_unity_mpris_player_dbus_interface_vtable, data, _unity_mpris_player_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}


static void _unity_mpris_player_unregister_object (gpointer user_data) {
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}


void unity_playlist_details_copy (const UnityPlaylistDetails* self, UnityPlaylistDetails* dest) {
	const char* _tmp0_;
	char* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	_tmp0_ = (*self).id;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).id);
	(*dest).id = _tmp1_;
	_tmp2_ = (*self).name;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 ((*dest).name);
	(*dest).name = _tmp3_;
	_tmp4_ = (*self).icon_name;
	_tmp5_ = g_strdup (_tmp4_);
	_g_free0 ((*dest).icon_name);
	(*dest).icon_name = _tmp5_;
}


void unity_playlist_details_destroy (UnityPlaylistDetails* self) {
	_g_free0 ((*self).id);
	_g_free0 ((*self).name);
	_g_free0 ((*self).icon_name);
}


UnityPlaylistDetails* unity_playlist_details_dup (const UnityPlaylistDetails* self) {
	UnityPlaylistDetails* dup;
	dup = g_new0 (UnityPlaylistDetails, 1);
	unity_playlist_details_copy (self, dup);
	return dup;
}


void unity_playlist_details_free (UnityPlaylistDetails* self) {
	unity_playlist_details_destroy (self);
	g_free (self);
}


GType unity_playlist_details_get_type (void) {
	static volatile gsize unity_playlist_details_type_id__volatile = 0;
	if (g_once_init_enter (&unity_playlist_details_type_id__volatile)) {
		GType unity_playlist_details_type_id;
		unity_playlist_details_type_id = g_boxed_type_register_static ("UnityPlaylistDetails", (GBoxedCopyFunc) unity_playlist_details_dup, (GBoxedFreeFunc) unity_playlist_details_free);
		g_once_init_leave (&unity_playlist_details_type_id__volatile, unity_playlist_details_type_id);
	}
	return unity_playlist_details_type_id__volatile;
}


void unity_active_playlist_container_copy (const UnityActivePlaylistContainer* self, UnityActivePlaylistContainer* dest) {
	gboolean _tmp0_;
	UnityPlaylistDetails _tmp1_;
	UnityPlaylistDetails _tmp2_ = {0};
	_tmp0_ = (*self).valid;
	(*dest).valid = _tmp0_;
	_tmp1_ = (*self).details;
	unity_playlist_details_copy (&_tmp1_, &_tmp2_);
	unity_playlist_details_destroy (&(*dest).details);
	(*dest).details = _tmp2_;
}


void unity_active_playlist_container_destroy (UnityActivePlaylistContainer* self) {
	unity_playlist_details_destroy (&(*self).details);
}


UnityActivePlaylistContainer* unity_active_playlist_container_dup (const UnityActivePlaylistContainer* self) {
	UnityActivePlaylistContainer* dup;
	dup = g_new0 (UnityActivePlaylistContainer, 1);
	unity_active_playlist_container_copy (self, dup);
	return dup;
}


void unity_active_playlist_container_free (UnityActivePlaylistContainer* self) {
	unity_active_playlist_container_destroy (self);
	g_free (self);
}


GType unity_active_playlist_container_get_type (void) {
	static volatile gsize unity_active_playlist_container_type_id__volatile = 0;
	if (g_once_init_enter (&unity_active_playlist_container_type_id__volatile)) {
		GType unity_active_playlist_container_type_id;
		unity_active_playlist_container_type_id = g_boxed_type_register_static ("UnityActivePlaylistContainer", (GBoxedCopyFunc) unity_active_playlist_container_dup, (GBoxedFreeFunc) unity_active_playlist_container_free);
		g_once_init_leave (&unity_active_playlist_container_type_id__volatile, unity_active_playlist_container_type_id);
	}
	return unity_active_playlist_container_type_id__volatile;
}


UnityMprisPlaylists* unity_mpris_playlists_construct (GType object_type, UnityMusicPlayer* consumer, UnityPropertyUpdateManager* prop_mgr, UnityMPRISGateway* gw) {
	UnityMprisPlaylists * self = NULL;
	UnityMPRISGateway* _tmp0_;
	UnityMPRISGateway* _tmp1_;
	UnityMusicPlayer* _tmp2_;
	UnityMusicPlayer* _tmp3_;
	UnityPropertyUpdateManager* _tmp4_;
	UnityPropertyUpdateManager* _tmp5_;
	g_return_val_if_fail (consumer != NULL, NULL);
	g_return_val_if_fail (prop_mgr != NULL, NULL);
	g_return_val_if_fail (gw != NULL, NULL);
	self = (UnityMprisPlaylists*) g_object_new (object_type, NULL);
	_tmp0_ = gw;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->gateway);
	self->priv->gateway = _tmp1_;
	_tmp2_ = consumer;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (self->priv->consumer);
	self->priv->consumer = _tmp3_;
	_tmp4_ = prop_mgr;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	_g_object_unref0 (self->priv->prop_mgr);
	self->priv->prop_mgr = _tmp5_;
	unity_mpris_playlists_wire_up (self);
	return self;
}


UnityMprisPlaylists* unity_mpris_playlists_new (UnityMusicPlayer* consumer, UnityPropertyUpdateManager* prop_mgr, UnityMPRISGateway* gw) {
	return unity_mpris_playlists_construct (UNITY_TYPE_MPRIS_PLAYLISTS, consumer, prop_mgr, gw);
}


static void _unity_mpris_playlists_on_current_playlist_update_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	unity_mpris_playlists_on_current_playlist_update (self, pspec);
}


static void _unity_mpris_playlists_on_playlist_name_change_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	unity_mpris_playlists_on_playlist_name_change (self, pspec);
}


static void _unity_mpris_playlists_on_playlist_count_change_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	unity_mpris_playlists_on_playlist_count_change (self, pspec);
}


static void unity_mpris_playlists_wire_up (UnityMprisPlaylists* self) {
	UnityMusicPlayer* _tmp0_;
	UnityMPRISGateway* _tmp1_;
	UnityMPRISGateway* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->consumer;
	g_signal_connect_object ((GObject*) _tmp0_, "notify::current-playlist", (GCallback) _unity_mpris_playlists_on_current_playlist_update_g_object_notify, self, 0);
	_tmp1_ = self->priv->gateway;
	g_signal_connect_object ((GObject*) _tmp1_, "notify::edited-playlist", (GCallback) _unity_mpris_playlists_on_playlist_name_change_g_object_notify, self, 0);
	_tmp2_ = self->priv->gateway;
	g_signal_connect_object ((GObject*) _tmp2_, "notify::playlist-count", (GCallback) _unity_mpris_playlists_on_playlist_count_change_g_object_notify, self, 0);
}


static GVariant* _variant_new78 (UnityActivePlaylistContainer value) {
	GVariantBuilder _tmp4_;
	GVariantBuilder _tmp5_;
	g_variant_builder_init (&_tmp4_, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_tmp4_, g_variant_new_boolean (value.valid));
	g_variant_builder_init (&_tmp5_, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_tmp5_, g_variant_new_object_path (value.details.id));
	g_variant_builder_add_value (&_tmp5_, g_variant_new_string (value.details.name));
	g_variant_builder_add_value (&_tmp5_, g_variant_new_string (value.details.icon_name));
	g_variant_builder_add_value (&_tmp4_, g_variant_builder_end (&_tmp5_));
	return g_variant_ref_sink (g_variant_builder_end (&_tmp4_));
}


static void unity_mpris_playlists_on_current_playlist_update (UnityMprisPlaylists* self, GParamSpec* p) {
	UnityPropertyUpdateManager* _tmp0_;
	UnityActivePlaylistContainer _tmp1_;
	UnityActivePlaylistContainer _tmp2_;
	UnityActivePlaylistContainer _tmp3_;
	GVariant* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (p != NULL);
	_tmp0_ = self->priv->prop_mgr;
	unity_mpris_playlists_get_active_playlist (self, &_tmp1_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp6_ = _variant_new78 (_tmp3_);
	unity_property_update_manager_queue_property_update (_tmp0_, "ActivePlaylist", _tmp6_, UNITY_MPRIS_INTERFACE_PLAYLISTS);
	unity_active_playlist_container_destroy (&_tmp3_);
}


static void unity_mpris_playlists_on_playlist_name_change (UnityMprisPlaylists* self, GParamSpec* p) {
	UnityPlaylistDetails details = {0};
	UnityMPRISGateway* _tmp0_;
	UnityPlaylist* _tmp1_;
	UnityPlaylist* _tmp2_;
	UnityPlaylistDetails _tmp3_;
	const char* _tmp4_;
	UnityPlaylistDetails _tmp5_;
	const gchar* _tmp6_;
	UnityPlaylistDetails _tmp7_;
	const gchar* _tmp8_;
	GVariant* _tmp9_;
	GVariant* _tmp10_;
	GVariant* output;
	UnityPropertyUpdateManager* _tmp11_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (p != NULL);
	memset (&details, 0, sizeof (UnityPlaylistDetails));
	_tmp0_ = self->priv->gateway;
	_tmp1_ = unity_mpris_gateway_get_edited_playlist (_tmp0_);
	_tmp2_ = _tmp1_;
	unity_mpris_playlists_prep_playlist (self, _tmp2_, &details);
	_tmp3_ = details;
	_tmp4_ = _tmp3_.id;
	_tmp5_ = details;
	_tmp6_ = _tmp5_.name;
	_tmp7_ = details;
	_tmp8_ = _tmp7_.icon_name;
	_tmp9_ = g_variant_new ("(oss)", _tmp4_, _tmp6_, _tmp8_, NULL);
	_tmp10_ = g_variant_ref_sink (_tmp9_);
	output = _tmp10_;
	_tmp11_ = self->priv->prop_mgr;
	unity_property_update_manager_emit_dbus_signal (_tmp11_, UNITY_MPRIS_INTERFACE_PLAYLISTS, "PlaylistChanged", output);
	_g_variant_unref0 (output);
	unity_playlist_details_destroy (&details);
}


static GVariant* _variant_new79 (gint value) {
	return g_variant_ref_sink (g_variant_new_int32 (value));
}


static void unity_mpris_playlists_on_playlist_count_change (UnityMprisPlaylists* self, GParamSpec* p) {
	UnityPropertyUpdateManager* _tmp0_;
	UnityMPRISGateway* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	GVariant* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (p != NULL);
	_tmp0_ = self->priv->prop_mgr;
	_tmp1_ = self->priv->gateway;
	_tmp2_ = unity_mpris_gateway_get_playlist_count (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = _variant_new79 (_tmp3_);
	unity_property_update_manager_queue_property_update (_tmp0_, "PlaylistCount", _tmp4_, UNITY_MPRIS_INTERFACE_PLAYLISTS);
}


static void unity_mpris_playlists_prep_playlist (UnityMprisPlaylists* self, UnityPlaylist* unity_pl, UnityPlaylistDetails* outward) {
	UnityPlaylistDetails* _tmp0_;
	UnityPlaylist* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	char* _tmp4_;
	UnityPlaylistDetails* _tmp5_;
	UnityPlaylist* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	UnityPlaylistDetails* _tmp10_;
	UnityPlaylist* _tmp11_;
	GIcon* _tmp12_;
	GIcon* _tmp13_;
	gchar* _tmp14_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (unity_pl != NULL);
	_tmp0_ = outward;
	_tmp1_ = unity_pl;
	_tmp2_ = unity_playlist_get_id (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup (_tmp3_);
	_g_free0 ((*_tmp0_).id);
	(*_tmp0_).id = _tmp4_;
	_tmp5_ = outward;
	_tmp6_ = unity_pl;
	_tmp7_ = unity_playlist_get_name (_tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = g_strdup (_tmp8_);
	_g_free0 ((*_tmp5_).name);
	(*_tmp5_).name = _tmp9_;
	_tmp10_ = outward;
	_tmp11_ = unity_pl;
	_tmp12_ = unity_playlist_get_icon (_tmp11_);
	_tmp13_ = _tmp12_;
	_tmp14_ = g_icon_to_string (_tmp13_);
	_g_free0 ((*_tmp10_).icon_name);
	(*_tmp10_).icon_name = _tmp14_;
}


static void unity_mpris_playlists_activate_playlist_data_free (gpointer _data) {
	UnityMprisPlaylistsActivatePlaylistData* _data_;
	_data_ = _data;
	_g_free0 (_data_->playlist_id);
	_g_object_unref0 (_data_->self);
	g_slice_free (UnityMprisPlaylistsActivatePlaylistData, _data_);
}


void unity_mpris_playlists_activate_playlist (UnityMprisPlaylists* self, const char* playlist_id, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UnityMprisPlaylistsActivatePlaylistData* _data_;
	UnityMprisPlaylists* _tmp0_;
	const char* _tmp1_;
	char* _tmp2_;
	_data_ = g_slice_new0 (UnityMprisPlaylistsActivatePlaylistData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, unity_mpris_playlists_activate_playlist);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, unity_mpris_playlists_activate_playlist_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = playlist_id;
	_tmp2_ = g_strdup (_tmp1_);
	_data_->playlist_id = _tmp2_;
	unity_mpris_playlists_activate_playlist_co (_data_);
}


void unity_mpris_playlists_activate_playlist_finish (UnityMprisPlaylists* self, GAsyncResult* _res_, GError** error) {
	UnityMprisPlaylistsActivatePlaylistData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static gboolean unity_mpris_playlists_activate_playlist_co (UnityMprisPlaylistsActivatePlaylistData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->consumer;
	_data_->_tmp1_ = _data_->playlist_id;
	g_signal_emit_by_name (_data_->_tmp0_, "activate-playlist", _data_->_tmp1_);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void _vala_UnityPlaylistDetails_array_free (UnityPlaylistDetails* array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			unity_playlist_details_destroy (&array[i]);
		}
	}
	g_free (array);
}


static void unity_mpris_playlists_get_playlists_data_free (gpointer _data) {
	UnityMprisPlaylistsGetPlaylistsData* _data_;
	_data_ = _data;
	_g_free0 (_data_->order);
	_data_->result = (_vala_UnityPlaylistDetails_array_free (_data_->result, _data_->result_length1), NULL);
	_g_object_unref0 (_data_->self);
	g_slice_free (UnityMprisPlaylistsGetPlaylistsData, _data_);
}


void unity_mpris_playlists_get_playlists (UnityMprisPlaylists* self, guint32 index, guint32 max_count, const gchar* order, gboolean reverse_order, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UnityMprisPlaylistsGetPlaylistsData* _data_;
	UnityMprisPlaylists* _tmp0_;
	guint32 _tmp1_;
	guint32 _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gboolean _tmp5_;
	_data_ = g_slice_new0 (UnityMprisPlaylistsGetPlaylistsData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, unity_mpris_playlists_get_playlists);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, unity_mpris_playlists_get_playlists_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = index;
	_data_->index = _tmp1_;
	_tmp2_ = max_count;
	_data_->max_count = _tmp2_;
	_tmp3_ = order;
	_tmp4_ = g_strdup (_tmp3_);
	_data_->order = _tmp4_;
	_tmp5_ = reverse_order;
	_data_->reverse_order = _tmp5_;
	unity_mpris_playlists_get_playlists_co (_data_);
}


UnityPlaylistDetails* unity_mpris_playlists_get_playlists_finish (UnityMprisPlaylists* self, GAsyncResult* _res_, int* result_length1, GError** error) {
	UnityPlaylistDetails* result;
	UnityMprisPlaylistsGetPlaylistsData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	*result_length1 = _data_->result_length1;
	_data_->result = NULL;
	return result;
}


static void _vala_array_add4 (UnityPlaylistDetails** array, int* length, int* size, const UnityPlaylistDetails* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (UnityPlaylistDetails, *array, *size);
	}
	(*array)[(*length)++] = *value;
}


static gboolean unity_mpris_playlists_get_playlists_co (UnityMprisPlaylistsGetPlaylistsData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = NULL;
	_data_->_tmp0_ = g_new0 (UnityPlaylistDetails, 0);
	_data_->_result_ = _data_->_tmp0_;
	_data_->_result__length1 = 0;
	_data_->__result__size_ = _data_->_result__length1;
	_data_->_tmp1_ = _data_->self->priv->consumer;
	_data_->_tmp2_ = 0;
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = unity_music_player_get_playlists (_data_->_tmp1_, &_data_->_tmp2_);
	{
		_data_->up_collection_length1 = 0;
		_data_->_up_collection_size_ = 0;
		_data_->up_collection = _data_->_tmp3_;
		_data_->up_collection_length1 = _data_->_tmp2_;
		_data_->up_it = 0;
		for (_data_->up_it = 0; _data_->up_it < _data_->_tmp2_; _data_->up_it = _data_->up_it + 1) {
			_data_->_tmp4_ = _g_object_ref0 (_data_->up_collection[_data_->up_it]);
			_data_->up = _data_->_tmp4_;
			{
				memset (&_data_->details, 0, sizeof (UnityPlaylistDetails));
				_data_->_tmp5_ = _data_->up;
				unity_mpris_playlists_prep_playlist (_data_->self, _data_->_tmp5_, &_data_->details);
				_data_->_tmp6_ = _data_->_result_;
				_data_->_tmp6__length1 = _data_->_result__length1;
				_data_->_tmp7_ = _data_->details;
				memset (&_data_->_tmp8_, 0, sizeof (UnityPlaylistDetails));
				unity_playlist_details_copy (&_data_->_tmp7_, &_data_->_tmp8_);
				_vala_array_add4 (&_data_->_result_, &_data_->_result__length1, &_data_->__result__size_, &_data_->_tmp8_);
				unity_playlist_details_destroy (&_data_->details);
				_g_object_unref0 (_data_->up);
			}
		}
		_data_->up_collection = (_vala_array_free (_data_->up_collection, _data_->up_collection_length1, (GDestroyNotify) g_object_unref), NULL);
	}
	_data_->_tmp9_ = _data_->_result_;
	_data_->_tmp9__length1 = _data_->_result__length1;
	_data_->result_length1 = _data_->_tmp9__length1;
	_data_->result = _data_->_tmp9_;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	_data_->_result_ = (_vala_UnityPlaylistDetails_array_free (_data_->_result_, _data_->_result__length1), NULL);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


gchar** unity_mpris_playlists_get_orderings (UnityMprisPlaylists* self, int* result_length1) {
	gchar** result;
	gchar* _tmp0_;
	gchar** _tmp1_ = NULL;
	gchar** _tmp2_;
	gint _tmp2__length1;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup ("alphabetical");
	_tmp1_ = g_new0 (gchar*, 1 + 1);
	_tmp1_[0] = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp2__length1 = 1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}


guint32 unity_mpris_playlists_get_playlist_count (UnityMprisPlaylists* self) {
	guint32 result;
	UnityMusicPlayer* _tmp0_;
	gint _tmp1_ = 0;
	UnityPlaylist** _tmp2_ = NULL;
	UnityPlaylist** _tmp3_;
	gint _tmp3__length1;
	guint32 _tmp4_;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->priv->consumer;
	_tmp2_ = unity_music_player_get_playlists (_tmp0_, &_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp3__length1 = _tmp1_;
	_tmp4_ = (guint32) _tmp1_;
	_tmp3_ = (_vala_array_free (_tmp3_, _tmp3__length1, (GDestroyNotify) g_object_unref), NULL);
	result = _tmp4_;
	return result;
}


void unity_mpris_playlists_get_active_playlist (UnityMprisPlaylists* self, UnityActivePlaylistContainer* result) {
	UnityActivePlaylistContainer c = {0};
	UnityPlaylistDetails details = {0};
	UnityMusicPlayer* _tmp0_;
	UnityPlaylist* _tmp1_;
	UnityPlaylist* _tmp2_;
	UnityActivePlaylistContainer _tmp3_;
	gboolean _tmp4_;
	UnityPlaylistDetails _tmp11_;
	UnityPlaylistDetails _tmp12_ = {0};
	g_return_if_fail (self != NULL);
	memset (&c, 0, sizeof (UnityActivePlaylistContainer));
	memset (&details, 0, sizeof (UnityPlaylistDetails));
	_tmp0_ = self->priv->consumer;
	_tmp1_ = unity_music_player_get_current_playlist (_tmp0_);
	_tmp2_ = _tmp1_;
	c.valid = _tmp2_ != NULL;
	_tmp3_ = c;
	_tmp4_ = _tmp3_.valid;
	if (_tmp4_) {
		UnityMusicPlayer* _tmp5_;
		UnityPlaylist* _tmp6_;
		UnityPlaylist* _tmp7_;
		_tmp5_ = self->priv->consumer;
		_tmp6_ = unity_music_player_get_current_playlist (_tmp5_);
		_tmp7_ = _tmp6_;
		unity_mpris_playlists_prep_playlist (self, _tmp7_, &details);
	} else {
		char* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp8_ = g_strdup ("/");
		_g_free0 (details.id);
		details.id = _tmp8_;
		_tmp9_ = g_strdup ("");
		_g_free0 (details.name);
		details.name = _tmp9_;
		_tmp10_ = g_strdup ("");
		_g_free0 (details.icon_name);
		details.icon_name = _tmp10_;
	}
	_tmp11_ = details;
	unity_playlist_details_copy (&_tmp11_, &_tmp12_);
	unity_playlist_details_destroy (&c.details);
	c.details = _tmp12_;
	*result = c;
	unity_playlist_details_destroy (&details);
	return;
}


static GObject * unity_mpris_playlists_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	UnityMprisPlaylists * self;
	parent_class = G_OBJECT_CLASS (unity_mpris_playlists_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = UNITY_MPRIS_PLAYLISTS (obj);
	return obj;
}


static void unity_mpris_playlists_class_init (UnityMprisPlaylistsClass * klass) {
	unity_mpris_playlists_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (UnityMprisPlaylistsPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_unity_mpris_playlists_get_property;
	G_OBJECT_CLASS (klass)->constructor = unity_mpris_playlists_constructor;
	G_OBJECT_CLASS (klass)->finalize = unity_mpris_playlists_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_MPRIS_PLAYLISTS_ORDERINGS, g_param_spec_boxed ("orderings", "orderings", "orderings", G_TYPE_STRV, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_MPRIS_PLAYLISTS_PLAYLIST_COUNT, g_param_spec_uint ("playlist-count", "playlist-count", "playlist-count", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_MPRIS_PLAYLISTS_ACTIVE_PLAYLIST, g_param_spec_boxed ("active-playlist", "active-playlist", "active-playlist", UNITY_TYPE_ACTIVE_PLAYLIST_CONTAINER, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void unity_mpris_playlists_instance_init (UnityMprisPlaylists * self) {
	self->priv = UNITY_MPRIS_PLAYLISTS_GET_PRIVATE (self);
}


static void unity_mpris_playlists_finalize (GObject* obj) {
	UnityMprisPlaylists * self;
	self = UNITY_MPRIS_PLAYLISTS (obj);
	_g_object_unref0 (self->priv->consumer);
	_g_object_unref0 (self->priv->prop_mgr);
	_g_object_unref0 (self->priv->gateway);
	G_OBJECT_CLASS (unity_mpris_playlists_parent_class)->finalize (obj);
}


GType unity_mpris_playlists_get_type (void) {
	static volatile gsize unity_mpris_playlists_type_id__volatile = 0;
	if (g_once_init_enter (&unity_mpris_playlists_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UnityMprisPlaylistsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unity_mpris_playlists_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnityMprisPlaylists), 0, (GInstanceInitFunc) unity_mpris_playlists_instance_init, NULL };
		GType unity_mpris_playlists_type_id;
		unity_mpris_playlists_type_id = g_type_register_static (G_TYPE_OBJECT, "UnityMprisPlaylists", &g_define_type_info, 0);
		g_type_set_qdata (unity_mpris_playlists_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) unity_mpris_playlists_register_object);
		g_once_init_leave (&unity_mpris_playlists_type_id__volatile, unity_mpris_playlists_type_id);
	}
	return unity_mpris_playlists_type_id__volatile;
}


static void _vala_unity_mpris_playlists_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	UnityMprisPlaylists * self;
	self = UNITY_MPRIS_PLAYLISTS (object);
	switch (property_id) {
		case UNITY_MPRIS_PLAYLISTS_ORDERINGS:
		{
			int length;
			g_value_take_boxed (value, unity_mpris_playlists_get_orderings (self, &length));
		}
		break;
		case UNITY_MPRIS_PLAYLISTS_PLAYLIST_COUNT:
		g_value_set_uint (value, unity_mpris_playlists_get_playlist_count (self));
		break;
		case UNITY_MPRIS_PLAYLISTS_ACTIVE_PLAYLIST:
		{
			UnityActivePlaylistContainer boxed;
			unity_mpris_playlists_get_active_playlist (self, &boxed);
			g_value_set_boxed (value, &boxed);
			unity_active_playlist_container_destroy (&boxed);
		}
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _dbus_unity_mpris_playlists_activate_playlist (UnityMprisPlaylists* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GVariantIter _arguments_iter;
	char* playlist_id = NULL;
	GVariant* _tmp219_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp219_ = g_variant_iter_next_value (&_arguments_iter);
	playlist_id = g_variant_dup_string (_tmp219_, NULL);
	g_variant_unref (_tmp219_);
	unity_mpris_playlists_activate_playlist (self, playlist_id, (GAsyncReadyCallback) _dbus_unity_mpris_playlists_activate_playlist_ready, invocation);
	_g_free0 (playlist_id);
}


static void _dbus_unity_mpris_playlists_activate_playlist_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_) {
	GDBusMethodInvocation * invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	invocation = _user_data_;
	unity_mpris_playlists_activate_playlist_finish ((UnityMprisPlaylists*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_unity_mpris_playlists_get_playlists (UnityMprisPlaylists* self, GVariant* parameters, GDBusMethodInvocation* invocation) {
	GVariantIter _arguments_iter;
	guint32 index = 0U;
	GVariant* _tmp220_;
	guint32 max_count = 0U;
	GVariant* _tmp221_;
	gchar* order = NULL;
	GVariant* _tmp222_;
	gboolean reverse_order = FALSE;
	GVariant* _tmp223_;
	g_variant_iter_init (&_arguments_iter, parameters);
	_tmp220_ = g_variant_iter_next_value (&_arguments_iter);
	index = g_variant_get_uint32 (_tmp220_);
	g_variant_unref (_tmp220_);
	_tmp221_ = g_variant_iter_next_value (&_arguments_iter);
	max_count = g_variant_get_uint32 (_tmp221_);
	g_variant_unref (_tmp221_);
	_tmp222_ = g_variant_iter_next_value (&_arguments_iter);
	order = g_variant_dup_string (_tmp222_, NULL);
	g_variant_unref (_tmp222_);
	_tmp223_ = g_variant_iter_next_value (&_arguments_iter);
	reverse_order = g_variant_get_boolean (_tmp223_);
	g_variant_unref (_tmp223_);
	unity_mpris_playlists_get_playlists (self, index, max_count, order, reverse_order, (GAsyncReadyCallback) _dbus_unity_mpris_playlists_get_playlists_ready, invocation);
	_g_free0 (order);
}


static void _dbus_unity_mpris_playlists_get_playlists_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_) {
	GDBusMethodInvocation * invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	UnityPlaylistDetails* result;
	int result_length1 = 0;
	UnityPlaylistDetails* _tmp224_;
	GVariantBuilder _tmp225_;
	int _tmp226_;
	invocation = _user_data_;
	result = unity_mpris_playlists_get_playlists_finish ((UnityMprisPlaylists*) source_object, _res_, &result_length1, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_tmp224_ = result;
	g_variant_builder_init (&_tmp225_, G_VARIANT_TYPE ("a(oss)"));
	for (_tmp226_ = 0; _tmp226_ < result_length1; _tmp226_++) {
		GVariantBuilder _tmp227_;
		g_variant_builder_init (&_tmp227_, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_tmp227_, g_variant_new_object_path ((*_tmp224_).id));
		g_variant_builder_add_value (&_tmp227_, g_variant_new_string ((*_tmp224_).name));
		g_variant_builder_add_value (&_tmp227_, g_variant_new_string ((*_tmp224_).icon_name));
		g_variant_builder_add_value (&_tmp225_, g_variant_builder_end (&_tmp227_));
		_tmp224_++;
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp225_));
	result = (_vala_UnityPlaylistDetails_array_free (result, result_length1), NULL);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void unity_mpris_playlists_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "ActivatePlaylist") == 0) {
		_dbus_unity_mpris_playlists_activate_playlist (object, parameters, invocation);
	} else if (strcmp (method_name, "GetPlaylists") == 0) {
		_dbus_unity_mpris_playlists_get_playlists (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}


static GVariant* _dbus_unity_mpris_playlists_get_orderings (UnityMprisPlaylists* self) {
	gchar** result;
	int result_length1;
	gchar** _tmp228_;
	GVariantBuilder _tmp229_;
	int _tmp230_;
	GVariant* _reply;
	result = unity_mpris_playlists_get_orderings (self, &result_length1);
	_tmp228_ = result;
	g_variant_builder_init (&_tmp229_, G_VARIANT_TYPE ("as"));
	for (_tmp230_ = 0; _tmp230_ < result_length1; _tmp230_++) {
		g_variant_builder_add_value (&_tmp229_, g_variant_new_string (*_tmp228_));
		_tmp228_++;
	}
	_reply = g_variant_builder_end (&_tmp229_);
	result = (_vala_array_free (result, result_length1, (GDestroyNotify) g_free), NULL);
	return _reply;
}


static GVariant* _dbus_unity_mpris_playlists_get_playlist_count (UnityMprisPlaylists* self) {
	guint32 result;
	GVariant* _reply;
	result = unity_mpris_playlists_get_playlist_count (self);
	_reply = g_variant_new_uint32 (result);
	return _reply;
}


static GVariant* _dbus_unity_mpris_playlists_get_active_playlist (UnityMprisPlaylists* self) {
	UnityActivePlaylistContainer result = {0};
	GVariantBuilder _tmp231_;
	GVariantBuilder _tmp232_;
	GVariant* _reply;
	unity_mpris_playlists_get_active_playlist (self, &result);
	g_variant_builder_init (&_tmp231_, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_tmp231_, g_variant_new_boolean (result.valid));
	g_variant_builder_init (&_tmp232_, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_tmp232_, g_variant_new_object_path (result.details.id));
	g_variant_builder_add_value (&_tmp232_, g_variant_new_string (result.details.name));
	g_variant_builder_add_value (&_tmp232_, g_variant_new_string (result.details.icon_name));
	g_variant_builder_add_value (&_tmp231_, g_variant_builder_end (&_tmp232_));
	_reply = g_variant_builder_end (&_tmp231_);
	unity_active_playlist_container_destroy (&result);
	return _reply;
}


static GVariant* unity_mpris_playlists_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (property_name, "Orderings") == 0) {
		return _dbus_unity_mpris_playlists_get_orderings (object);
	} else if (strcmp (property_name, "PlaylistCount") == 0) {
		return _dbus_unity_mpris_playlists_get_playlist_count (object);
	} else if (strcmp (property_name, "ActivePlaylist") == 0) {
		return _dbus_unity_mpris_playlists_get_active_playlist (object);
	}
	return NULL;
}


static gboolean unity_mpris_playlists_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}


guint unity_mpris_playlists_register_object (gpointer object, GDBusConnection* connection, const gchar* path, GError** error) {
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_unity_mpris_playlists_dbus_interface_info), &_unity_mpris_playlists_dbus_interface_vtable, data, _unity_mpris_playlists_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}


static void _unity_mpris_playlists_unregister_object (gpointer user_data) {
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



