/* unity-scope-proxy-remote.c generated by valac 0.14.2, the Vala compiler
 * generated from unity-scope-proxy-remote.vala, do not modify */

/*
 * Copyright (C) 2011 Canonical, Ltd.
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License
 * version 3.0 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3.0 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see
 * <http://www.gnu.org/licenses/>.
 *
 * Authored by Neil Jagdish Patel <neil.patel@canonical.com>
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include "unity.h"
#include <dee.h>
#include <unity-trace.h>


#define UNITY_TYPE_SCOPE_PROXY (unity_scope_proxy_get_type ())
#define UNITY_SCOPE_PROXY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_TYPE_SCOPE_PROXY, UnityScopeProxy))
#define UNITY_IS_SCOPE_PROXY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_TYPE_SCOPE_PROXY))
#define UNITY_SCOPE_PROXY_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), UNITY_TYPE_SCOPE_PROXY, UnityScopeProxyIface))

typedef struct _UnityScopeProxy UnityScopeProxy;
typedef struct _UnityScopeProxyIface UnityScopeProxyIface;

#define UNITY_TYPE_ACTIVATION_REPLY_RAW (unity_activation_reply_raw_get_type ())
typedef struct _UnityActivationReplyRaw UnityActivationReplyRaw;

#define UNITY_TYPE_PREVIEW_REPLY_RAW (unity_preview_reply_raw_get_type ())
typedef struct _UnityPreviewReplyRaw UnityPreviewReplyRaw;

#define UNITY_TYPE_VIEW_TYPE (unity_view_type_get_type ())

#define UNITY_TYPE_SCOPE_PROXY_REMOTE (unity_scope_proxy_remote_get_type ())
#define UNITY_SCOPE_PROXY_REMOTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_TYPE_SCOPE_PROXY_REMOTE, UnityScopeProxyRemote))
#define UNITY_SCOPE_PROXY_REMOTE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_TYPE_SCOPE_PROXY_REMOTE, UnityScopeProxyRemoteClass))
#define UNITY_IS_SCOPE_PROXY_REMOTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_TYPE_SCOPE_PROXY_REMOTE))
#define UNITY_IS_SCOPE_PROXY_REMOTE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_TYPE_SCOPE_PROXY_REMOTE))
#define UNITY_SCOPE_PROXY_REMOTE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_TYPE_SCOPE_PROXY_REMOTE, UnityScopeProxyRemoteClass))

typedef struct _UnityScopeProxyRemote UnityScopeProxyRemote;
typedef struct _UnityScopeProxyRemoteClass UnityScopeProxyRemoteClass;
typedef struct _UnityScopeProxyRemotePrivate UnityScopeProxyRemotePrivate;

#define UNITY_TYPE_SCOPE_SERVICE (unity_scope_service_get_type ())
#define UNITY_SCOPE_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_TYPE_SCOPE_SERVICE, UnityScopeService))
#define UNITY_IS_SCOPE_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_TYPE_SCOPE_SERVICE))
#define UNITY_SCOPE_SERVICE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), UNITY_TYPE_SCOPE_SERVICE, UnityScopeServiceIface))

typedef struct _UnityScopeService UnityScopeService;
typedef struct _UnityScopeServiceIface UnityScopeServiceIface;

#define UNITY_TYPE_SCOPE_SERVICE_PROXY (unity_scope_service_proxy_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define UNITY_TYPE_SCOPE_INFO (unity_scope_info_get_type ())
typedef struct _UnityScopeInfo UnityScopeInfo;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _UnityScopeProxyRemoteConnectToScopeData UnityScopeProxyRemoteConnectToScopeData;
typedef struct _UnityScopeProxyRemoteActivateData UnityScopeProxyRemoteActivateData;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
typedef struct _UnityScopeProxyRemoteSearchData UnityScopeProxyRemoteSearchData;
typedef struct _UnityScopeProxyRemoteGlobalSearchData UnityScopeProxyRemoteGlobalSearchData;
typedef struct _UnityScopeProxyRemotePreviewData UnityScopeProxyRemotePreviewData;
typedef struct _UnityScopeProxyRemoteSetViewTypeData UnityScopeProxyRemoteSetViewTypeData;
typedef struct _UnityScopeProxyRemoteSetActiveSourcesData UnityScopeProxyRemoteSetActiveSourcesData;

struct _UnityActivationReplyRaw {
	gchar* uri;
	guint handled;
	GHashTable* hints;
};

struct _UnityPreviewReplyRaw {
	gchar* uri;
	gchar* renderer_name;
	GHashTable* properties;
};

typedef enum  {
	UNITY_VIEW_TYPE_HIDDEN,
	UNITY_VIEW_TYPE_HOME_VIEW,
	UNITY_VIEW_TYPE_LENS_VIEW
} UnityViewType;

struct _UnityScopeProxyIface {
	GTypeInterface parent_iface;
	void (*activate) (UnityScopeProxy* self, const gchar* uri, guint action_type, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*activate_finish) (UnityScopeProxy* self, GAsyncResult* _res_, UnityActivationReplyRaw* result);
	void (*search) (UnityScopeProxy* self, const gchar* search_string, GHashTable* hints, GAsyncReadyCallback _callback_, gpointer _user_data_);
	GHashTable* (*search_finish) (UnityScopeProxy* self, GAsyncResult* _res_);
	void (*global_search) (UnityScopeProxy* self, const gchar* search_string, GHashTable* hints, GAsyncReadyCallback _callback_, gpointer _user_data_);
	GHashTable* (*global_search_finish) (UnityScopeProxy* self, GAsyncResult* _res_);
	void (*preview) (UnityScopeProxy* self, const gchar* uri, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*preview_finish) (UnityScopeProxy* self, GAsyncResult* _res_, UnityPreviewReplyRaw* result);
	void (*set_active_sources) (UnityScopeProxy* self, gchar** sources, int sources_length1, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*set_active_sources_finish) (UnityScopeProxy* self, GAsyncResult* _res_);
	UnityOptionsFilter* (*get_sources) (UnityScopeProxy* self);
	void (*set_sources) (UnityScopeProxy* self, UnityOptionsFilter* value);
	gboolean (*get_search_in_global) (UnityScopeProxy* self);
	void (*set_search_in_global) (UnityScopeProxy* self, gboolean value);
	UnityViewType (*get_view_type) (UnityScopeProxy* self);
	void (*set_view_type) (UnityScopeProxy* self, UnityViewType value);
	DeeSerializableModel* (*get_results_model) (UnityScopeProxy* self);
	void (*set_results_model) (UnityScopeProxy* self, DeeSerializableModel* value);
	DeeSerializableModel* (*get_global_results_model) (UnityScopeProxy* self);
	void (*set_global_results_model) (UnityScopeProxy* self, DeeSerializableModel* value);
	DeeSerializableModel* (*get_filters_model) (UnityScopeProxy* self);
	void (*set_filters_model) (UnityScopeProxy* self, DeeSerializableModel* value);
};

struct _UnityScopeProxyRemote {
	GObject parent_instance;
	UnityScopeProxyRemotePrivate * priv;
};

struct _UnityScopeProxyRemoteClass {
	GObjectClass parent_class;
};

struct _UnityScopeServiceIface {
	GTypeInterface parent_iface;
	void (*info_request) (UnityScopeService* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*info_request_finish) (UnityScopeService* self, GAsyncResult* _res_, GError** error);
	void (*activate) (UnityScopeService* self, const gchar* uri, guint action_type, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*activate_finish) (UnityScopeService* self, GAsyncResult* _res_, UnityActivationReplyRaw* result, GError** error);
	void (*search) (UnityScopeService* self, const gchar* search_string, GHashTable* hints, GAsyncReadyCallback _callback_, gpointer _user_data_);
	GHashTable* (*search_finish) (UnityScopeService* self, GAsyncResult* _res_, GError** error);
	void (*global_search) (UnityScopeService* self, const gchar* search_string, GHashTable* hints, GAsyncReadyCallback _callback_, gpointer _user_data_);
	GHashTable* (*global_search_finish) (UnityScopeService* self, GAsyncResult* _res_, GError** error);
	void (*preview) (UnityScopeService* self, const gchar* uri, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*preview_finish) (UnityScopeService* self, GAsyncResult* _res_, UnityPreviewReplyRaw* result, GError** error);
	void (*set_view_type) (UnityScopeService* self, guint view_type, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*set_view_type_finish) (UnityScopeService* self, GAsyncResult* _res_, GError** error);
	void (*set_active_sources) (UnityScopeService* self, gchar** sources, int sources_length1, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*set_active_sources_finish) (UnityScopeService* self, GAsyncResult* _res_, GError** error);
};

struct _UnityScopeProxyRemotePrivate {
	gchar* _dbus_name;
	gchar* _dbus_path;
	UnityOptionsFilter* _sources;
	gboolean _search_in_global;
	UnityViewType _view_type;
	GDBusConnection* _bus;
	guint _watcher;
	UnityScopeService* _service;
	DeeSharedModel* _results_model;
	DeeSharedModel* _global_results_model;
	DeeSharedModel* _filters_model;
	guint _reconnection_id;
	gboolean synchronized;
};

struct _UnityScopeInfo {
	gchar* dbus_path;
	GVariant* sources;
	gboolean search_in_global;
	gchar* private_connection_name;
	gchar* results_model_name;
	gchar* global_results_model_name;
	gchar* filters_model_name;
	GHashTable* hints;
};

struct _UnityScopeProxyRemoteConnectToScopeData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	UnityScopeProxyRemote* self;
	GDBusConnection* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	UnityScopeService* _tmp3_;
	UnityScopeService* _tmp4_;
	UnityScopeService* _tmp5_;
	UnityScopeService* _tmp6_;
	GError* e;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	GError* _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	GError * _inner_error_;
};

struct _UnityScopeProxyRemoteActivateData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	UnityScopeProxyRemote* self;
	gchar* uri;
	guint action_type;
	UnityActivationReplyRaw result;
	gboolean _tmp0_;
	UnityScopeService* _tmp1_;
	const gchar* _tmp2_;
	guint _tmp3_;
	UnityActivationReplyRaw _tmp4_;
	UnityActivationReplyRaw raw;
	GError* e;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	GError* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	UnityActivationReplyRaw _tmp12_;
	GError * _inner_error_;
};

struct _UnityScopeProxyRemoteSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	UnityScopeProxyRemote* self;
	gchar* search_string;
	GHashTable* hints;
	GHashTable* result;
	gboolean _tmp0_;
	UnityScopeService* _tmp1_;
	const gchar* _tmp2_;
	GHashTable* _tmp3_;
	GHashTable* _tmp4_;
	GHashTable* ht;
	GError* scope_error;
	GError* e;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	GError* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	GHashFunc _tmp14_;
	GEqualFunc _tmp15_;
	GHashTable* _tmp16_;
	GError * _inner_error_;
};

struct _UnityScopeProxyRemoteGlobalSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	UnityScopeProxyRemote* self;
	gchar* search_string;
	GHashTable* hints;
	GHashTable* result;
	gboolean _tmp0_;
	UnityScopeService* _tmp1_;
	const gchar* _tmp2_;
	GHashTable* _tmp3_;
	GHashTable* _tmp4_;
	GHashTable* _result_;
	GError* scope_error;
	GError* e;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	GError* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	GHashFunc _tmp14_;
	GEqualFunc _tmp15_;
	GHashTable* _tmp16_;
	GError * _inner_error_;
};

struct _UnityScopeProxyRemotePreviewData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	UnityScopeProxyRemote* self;
	gchar* uri;
	UnityPreviewReplyRaw result;
	gboolean _tmp0_;
	UnityScopeService* _tmp1_;
	const gchar* _tmp2_;
	UnityPreviewReplyRaw _tmp3_;
	UnityPreviewReplyRaw raw;
	GError* e;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	GError* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	UnityPreviewReplyRaw _tmp11_;
	GError * _inner_error_;
};

struct _UnityScopeProxyRemoteSetViewTypeData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	UnityScopeProxyRemote* self;
	UnityViewType view_type;
	UnityViewType _tmp0_;
	gboolean _tmp1_;
	UnityScopeService* _tmp2_;
	UnityViewType _tmp3_;
	GError* e;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	GError* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	GError * _inner_error_;
};

struct _UnityScopeProxyRemoteSetActiveSourcesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	UnityScopeProxyRemote* self;
	gchar** sources;
	gint sources_length1;
	gboolean _tmp0_;
	UnityScopeService* _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	GError* e;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	GError* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	GError * _inner_error_;
};


static gpointer unity_scope_proxy_remote_parent_class = NULL;
static UnityScopeProxyIface* unity_scope_proxy_remote_unity_scope_proxy_parent_iface = NULL;

GType unity_activation_reply_raw_get_type (void) G_GNUC_CONST;
UnityActivationReplyRaw* unity_activation_reply_raw_dup (const UnityActivationReplyRaw* self);
void unity_activation_reply_raw_free (UnityActivationReplyRaw* self);
void unity_activation_reply_raw_copy (const UnityActivationReplyRaw* self, UnityActivationReplyRaw* dest);
void unity_activation_reply_raw_destroy (UnityActivationReplyRaw* self);
GType unity_preview_reply_raw_get_type (void) G_GNUC_CONST;
UnityPreviewReplyRaw* unity_preview_reply_raw_dup (const UnityPreviewReplyRaw* self);
void unity_preview_reply_raw_free (UnityPreviewReplyRaw* self);
void unity_preview_reply_raw_copy (const UnityPreviewReplyRaw* self, UnityPreviewReplyRaw* dest);
void unity_preview_reply_raw_destroy (UnityPreviewReplyRaw* self);
GType unity_view_type_get_type (void) G_GNUC_CONST;
GType unity_scope_proxy_get_type (void) G_GNUC_CONST;
GType unity_scope_proxy_remote_get_type (void) G_GNUC_CONST;
GType unity_scope_service_proxy_get_type (void) G_GNUC_CONST;
guint unity_scope_service_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType unity_scope_service_get_type (void) G_GNUC_CONST;
#define UNITY_SCOPE_PROXY_REMOTE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), UNITY_TYPE_SCOPE_PROXY_REMOTE, UnityScopeProxyRemotePrivate))
enum  {
	UNITY_SCOPE_PROXY_REMOTE_DUMMY_PROPERTY,
	UNITY_SCOPE_PROXY_REMOTE_DBUS_NAME,
	UNITY_SCOPE_PROXY_REMOTE_DBUS_PATH,
	UNITY_SCOPE_PROXY_REMOTE_SOURCES,
	UNITY_SCOPE_PROXY_REMOTE_SEARCH_IN_GLOBAL,
	UNITY_SCOPE_PROXY_REMOTE_RESULTS_MODEL,
	UNITY_SCOPE_PROXY_REMOTE_GLOBAL_RESULTS_MODEL,
	UNITY_SCOPE_PROXY_REMOTE_FILTERS_MODEL,
	UNITY_SCOPE_PROXY_REMOTE_VIEW_TYPE
};
UnityScopeProxyRemote* unity_scope_proxy_remote_new (const gchar* dbus_name_, const gchar* dbus_path_);
UnityScopeProxyRemote* unity_scope_proxy_remote_construct (GType object_type, const gchar* dbus_name_, const gchar* dbus_path_);
static void unity_scope_proxy_remote_connect_to_scope_data_free (gpointer _data);
static void unity_scope_proxy_remote_connect_to_scope (UnityScopeProxyRemote* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void unity_scope_proxy_remote_connect_to_scope_finish (UnityScopeProxyRemote* self, GAsyncResult* _res_);
static gboolean unity_scope_proxy_remote_connect_to_scope_co (UnityScopeProxyRemoteConnectToScopeData* _data_);
const gchar* unity_scope_proxy_remote_get_dbus_name (UnityScopeProxyRemote* self);
const gchar* unity_scope_proxy_remote_get_dbus_path (UnityScopeProxyRemote* self);
static void unity_scope_proxy_remote_connect_to_scope_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
GType unity_scope_info_get_type (void) G_GNUC_CONST;
UnityScopeInfo* unity_scope_info_dup (const UnityScopeInfo* self);
void unity_scope_info_free (UnityScopeInfo* self);
void unity_scope_info_copy (const UnityScopeInfo* self, UnityScopeInfo* dest);
void unity_scope_info_destroy (UnityScopeInfo* self);
void unity_scope_proxy_remote_on_changed (UnityScopeProxyRemote* self, UnityScopeInfo* scope_info);
static void _unity_scope_proxy_remote_on_changed_unity_scope_service_changed (UnityScopeService* _sender, UnityScopeInfo* lens_info, gpointer self);
void unity_scope_service_info_request (UnityScopeService* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
void unity_scope_service_info_request_finish (UnityScopeService* self, GAsyncResult* _res_, GError** error);
static void unity_scope_proxy_remote_on_scope_appeared (UnityScopeProxyRemote* self, GDBusConnection* conn, const gchar* name, const gchar* name_owner);
static void unity_scope_proxy_remote_on_scope_vanished (UnityScopeProxyRemote* self, GDBusConnection* conn, const gchar* name);
void unity_scope_proxy_set_search_in_global (UnityScopeProxy* self, gboolean value);
void unity_scope_proxy_set_sources (UnityScopeProxy* self, UnityOptionsFilter* value);
static void unity_scope_proxy_remote_start_reconnection_timeout (UnityScopeProxyRemote* self);
static gboolean __lambda0_ (UnityScopeProxyRemote* self);
static gboolean ___lambda0__gsource_func (gpointer self);
static void unity_scope_proxy_remote_real_activate_data_free (gpointer _data);
static void unity_scope_proxy_remote_real_activate (UnityScopeProxy* base, const gchar* uri, guint action_type, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean unity_scope_proxy_remote_real_activate_co (UnityScopeProxyRemoteActivateData* _data_);
void unity_scope_service_activate (UnityScopeService* self, const gchar* uri, guint action_type, GAsyncReadyCallback _callback_, gpointer _user_data_);
void unity_scope_service_activate_finish (UnityScopeService* self, GAsyncResult* _res_, UnityActivationReplyRaw* result, GError** error);
static void unity_scope_proxy_remote_activate_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void unity_scope_proxy_remote_real_search_data_free (gpointer _data);
static void unity_scope_proxy_remote_real_search (UnityScopeProxy* base, const gchar* search_string, GHashTable* hints, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean unity_scope_proxy_remote_real_search_co (UnityScopeProxyRemoteSearchData* _data_);
void unity_scope_service_search (UnityScopeService* self, const gchar* search_string, GHashTable* hints, GAsyncReadyCallback _callback_, gpointer _user_data_);
GHashTable* unity_scope_service_search_finish (UnityScopeService* self, GAsyncResult* _res_, GError** error);
static void unity_scope_proxy_remote_search_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void _g_free0_ (gpointer var);
static void _g_variant_unref0_ (gpointer var);
static void unity_scope_proxy_remote_real_global_search_data_free (gpointer _data);
static void unity_scope_proxy_remote_real_global_search (UnityScopeProxy* base, const gchar* search_string, GHashTable* hints, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean unity_scope_proxy_remote_real_global_search_co (UnityScopeProxyRemoteGlobalSearchData* _data_);
void unity_scope_service_global_search (UnityScopeService* self, const gchar* search_string, GHashTable* hints, GAsyncReadyCallback _callback_, gpointer _user_data_);
GHashTable* unity_scope_service_global_search_finish (UnityScopeService* self, GAsyncResult* _res_, GError** error);
static void unity_scope_proxy_remote_global_search_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void unity_scope_proxy_remote_real_preview_data_free (gpointer _data);
static void unity_scope_proxy_remote_real_preview (UnityScopeProxy* base, const gchar* uri, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean unity_scope_proxy_remote_real_preview_co (UnityScopeProxyRemotePreviewData* _data_);
void unity_scope_service_preview (UnityScopeService* self, const gchar* uri, GAsyncReadyCallback _callback_, gpointer _user_data_);
void unity_scope_service_preview_finish (UnityScopeService* self, GAsyncResult* _res_, UnityPreviewReplyRaw* result, GError** error);
static void unity_scope_proxy_remote_preview_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void unity_scope_proxy_remote_set_view_type_data_free (gpointer _data);
void unity_scope_proxy_remote_set_view_type (UnityScopeProxyRemote* self, UnityViewType view_type, GAsyncReadyCallback _callback_, gpointer _user_data_);
void unity_scope_proxy_remote_set_view_type_finish (UnityScopeProxyRemote* self, GAsyncResult* _res_);
static gboolean unity_scope_proxy_remote_set_view_type_co (UnityScopeProxyRemoteSetViewTypeData* _data_);
void unity_scope_service_set_view_type (UnityScopeService* self, guint view_type, GAsyncReadyCallback _callback_, gpointer _user_data_);
void unity_scope_service_set_view_type_finish (UnityScopeService* self, GAsyncResult* _res_, GError** error);
static void unity_scope_proxy_remote_set_view_type_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void unity_scope_proxy_remote_real_set_active_sources_data_free (gpointer _data);
static void unity_scope_proxy_remote_real_set_active_sources (UnityScopeProxy* base, gchar** sources, int sources_length1, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gchar** _vala_array_dup6 (gchar** self, int length);
static gboolean unity_scope_proxy_remote_real_set_active_sources_co (UnityScopeProxyRemoteSetActiveSourcesData* _data_);
void unity_scope_service_set_active_sources (UnityScopeService* self, gchar** sources, int sources_length1, GAsyncReadyCallback _callback_, gpointer _user_data_);
void unity_scope_service_set_active_sources_finish (UnityScopeService* self, GAsyncResult* _res_, GError** error);
static void unity_scope_proxy_remote_set_active_sources_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
DeeSerializableModel* unity_scope_proxy_get_results_model (UnityScopeProxy* self);
void unity_scope_proxy_set_results_model (UnityScopeProxy* self, DeeSerializableModel* value);
DeeSerializableModel* unity_scope_proxy_get_global_results_model (UnityScopeProxy* self);
void unity_scope_proxy_set_global_results_model (UnityScopeProxy* self, DeeSerializableModel* value);
DeeSerializableModel* unity_scope_proxy_get_filters_model (UnityScopeProxy* self);
void unity_scope_proxy_set_filters_model (UnityScopeProxy* self, DeeSerializableModel* value);
UnityOptionsFilter* unity_scope_proxy_get_sources (UnityScopeProxy* self);
void unity_filter_update (UnityFilter* self, GVariant* properties);
static void unity_scope_proxy_remote_set_dbus_name (UnityScopeProxyRemote* self, const gchar* value);
static void unity_scope_proxy_remote_set_dbus_path (UnityScopeProxyRemote* self, const gchar* value);
static GObject * unity_scope_proxy_remote_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void _unity_scope_proxy_remote_on_scope_appeared_gbus_name_appeared_callback (GDBusConnection* connection, const gchar* name, const gchar* name_owner, gpointer self);
static void _unity_scope_proxy_remote_on_scope_vanished_gbus_name_vanished_callback (GDBusConnection* connection, const gchar* name, gpointer self);
static void unity_scope_proxy_remote_finalize (GObject* obj);
gboolean unity_scope_proxy_get_search_in_global (UnityScopeProxy* self);
UnityViewType unity_scope_proxy_get_view_type (UnityScopeProxy* self);
static void _vala_unity_scope_proxy_remote_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
void unity_scope_proxy_set_view_type (UnityScopeProxy* self, UnityViewType value);
static void _vala_unity_scope_proxy_remote_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


UnityScopeProxyRemote* unity_scope_proxy_remote_construct (GType object_type, const gchar* dbus_name_, const gchar* dbus_path_) {
	UnityScopeProxyRemote * self = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	g_return_val_if_fail (dbus_name_ != NULL, NULL);
	g_return_val_if_fail (dbus_path_ != NULL, NULL);
	_tmp0_ = dbus_name_;
	_tmp1_ = dbus_path_;
	self = (UnityScopeProxyRemote*) g_object_new (object_type, "dbus-name", _tmp0_, "dbus-path", _tmp1_, NULL);
	return self;
}


UnityScopeProxyRemote* unity_scope_proxy_remote_new (const gchar* dbus_name_, const gchar* dbus_path_) {
	return unity_scope_proxy_remote_construct (UNITY_TYPE_SCOPE_PROXY_REMOTE, dbus_name_, dbus_path_);
}


static void unity_scope_proxy_remote_connect_to_scope_data_free (gpointer _data) {
	UnityScopeProxyRemoteConnectToScopeData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (UnityScopeProxyRemoteConnectToScopeData, _data_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void unity_scope_proxy_remote_connect_to_scope (UnityScopeProxyRemote* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UnityScopeProxyRemoteConnectToScopeData* _data_;
	UnityScopeProxyRemote* _tmp0_;
	_data_ = g_slice_new0 (UnityScopeProxyRemoteConnectToScopeData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, unity_scope_proxy_remote_connect_to_scope);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, unity_scope_proxy_remote_connect_to_scope_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	unity_scope_proxy_remote_connect_to_scope_co (_data_);
}


static void unity_scope_proxy_remote_connect_to_scope_finish (UnityScopeProxyRemote* self, GAsyncResult* _res_) {
	UnityScopeProxyRemoteConnectToScopeData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void unity_scope_proxy_remote_connect_to_scope_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	UnityScopeProxyRemoteConnectToScopeData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	unity_scope_proxy_remote_connect_to_scope_co (_data_);
}


static void _unity_scope_proxy_remote_on_changed_unity_scope_service_changed (UnityScopeService* _sender, UnityScopeInfo* lens_info, gpointer self) {
	unity_scope_proxy_remote_on_changed (self, lens_info);
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


static gboolean unity_scope_proxy_remote_connect_to_scope_co (UnityScopeProxyRemoteConnectToScopeData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_tmp0_ = _data_->self->priv->_bus;
		_data_->_tmp1_ = _data_->self->priv->_dbus_name;
		_data_->_tmp2_ = _data_->self->priv->_dbus_path;
		_data_->_state_ = 1;
		g_async_initable_new_async (UNITY_TYPE_SCOPE_SERVICE_PROXY, 0, NULL, unity_scope_proxy_remote_connect_to_scope_ready, _data_, "g-flags", 0, "g-name", _data_->_tmp1_, "g-connection", _data_->_tmp0_, "g-object-path", _data_->_tmp2_, "g-interface-name", "com.canonical.Unity.Scope", NULL);
		return FALSE;
		_state_1:
		_data_->_tmp3_ = NULL;
		_data_->_tmp3_ = g_async_initable_new_finish (_data_->_source_object_, _data_->_res_, &_data_->_inner_error_);
		_data_->_tmp4_ = (UnityScopeService*) _data_->_tmp3_;
		if (_data_->_inner_error_ != NULL) {
			goto __catch25_g_error;
		}
		_g_object_unref0 (_data_->self->priv->_service);
		_data_->self->priv->_service = _data_->_tmp4_;
		_data_->_tmp5_ = _data_->self->priv->_service;
		g_signal_connect_object (_data_->_tmp5_, "changed", (GCallback) _unity_scope_proxy_remote_on_changed_unity_scope_service_changed, _data_->self, 0);
		_data_->_tmp6_ = _data_->self->priv->_service;
		_data_->_state_ = 2;
		unity_scope_service_info_request (_data_->_tmp6_, unity_scope_proxy_remote_connect_to_scope_ready, _data_);
		return FALSE;
		_state_2:
		unity_scope_service_info_request_finish (_data_->_tmp6_, _data_->_res_, &_data_->_inner_error_);
		if (_data_->_inner_error_ != NULL) {
			goto __catch25_g_error;
		}
	}
	goto __finally25;
	__catch25_g_error:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp7_ = _data_->self->priv->_dbus_path;
		_data_->_tmp8_ = NULL;
		_data_->_tmp8_ = string_to_string (_data_->_tmp7_);
		_data_->_tmp9_ = _data_->self->priv->_dbus_name;
		_data_->_tmp10_ = NULL;
		_data_->_tmp10_ = string_to_string (_data_->_tmp9_);
		_data_->_tmp11_ = _data_->e;
		_data_->_tmp12_ = _data_->_tmp11_->message;
		_data_->_tmp13_ = NULL;
		_data_->_tmp13_ = string_to_string (_data_->_tmp12_);
		_data_->_tmp14_ = NULL;
		_data_->_tmp14_ = g_strconcat ("Unable to connect to Scope (", _data_->_tmp8_, " @ ", _data_->_tmp10_, "): ", _data_->_tmp13_, NULL);
		_data_->_tmp15_ = _data_->_tmp14_;
		g_warning ("unity-scope-proxy-remote.vala:104: %s", _data_->_tmp15_);
		_g_free0 (_data_->_tmp15_);
		_g_error_free0 (_data_->e);
	}
	__finally25:
	if (_data_->_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void unity_scope_proxy_remote_on_scope_appeared (UnityScopeProxyRemote* self, GDBusConnection* conn, const gchar* name, const gchar* name_owner) {
	const gchar* _tmp0_;
	guint _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (conn != NULL);
	g_return_if_fail (name != NULL);
	g_return_if_fail (name_owner != NULL);
	_tmp0_ = self->priv->_dbus_name;
	unity_trace_log_object ((GObject*) self, "Scope appeared: %s", _tmp0_);
	_tmp1_ = self->priv->_reconnection_id;
	if (_tmp1_ != ((guint) 0)) {
		guint _tmp2_;
		_tmp2_ = self->priv->_reconnection_id;
		g_source_remove (_tmp2_);
	}
	unity_scope_proxy_remote_connect_to_scope (self, NULL, NULL);
}


static void unity_scope_proxy_remote_on_scope_vanished (UnityScopeProxyRemote* self, GDBusConnection* conn, const gchar* name) {
	const gchar* _tmp0_;
	UnityCheckOptionFilter* _tmp1_;
	UnityCheckOptionFilter* _tmp2_;
	DeeSharedModel* _tmp3_;
	DeeSharedModel* _tmp5_;
	DeeSharedModel* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (conn != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = self->priv->_dbus_name;
	unity_trace_log_object ((GObject*) self, "Scope vanished: %s", _tmp0_);
	self->priv->synchronized = FALSE;
	unity_scope_proxy_set_search_in_global ((UnityScopeProxy*) self, FALSE);
	_tmp1_ = unity_check_option_filter_new ("sources", "Sources", NULL, TRUE);
	_tmp2_ = _tmp1_;
	unity_scope_proxy_set_sources ((UnityScopeProxy*) self, (UnityOptionsFilter*) _tmp2_);
	_g_object_unref0 (_tmp2_);
	_tmp3_ = self->priv->_results_model;
	if (_tmp3_ != NULL) {
		DeeSharedModel* _tmp4_;
		_tmp4_ = self->priv->_results_model;
		dee_model_clear ((DeeModel*) _tmp4_);
	}
	_tmp5_ = self->priv->_global_results_model;
	if (_tmp5_ != NULL) {
		DeeSharedModel* _tmp6_;
		_tmp6_ = self->priv->_global_results_model;
		dee_model_clear ((DeeModel*) _tmp6_);
	}
	_tmp7_ = self->priv->_filters_model;
	if (_tmp7_ != NULL) {
		DeeSharedModel* _tmp8_;
		_tmp8_ = self->priv->_filters_model;
		dee_model_clear ((DeeModel*) _tmp8_);
	}
	unity_scope_proxy_remote_start_reconnection_timeout (self);
}


static gboolean __lambda0_ (UnityScopeProxyRemote* self) {
	gboolean result = FALSE;
	UnityScopeService* _tmp0_;
	_tmp0_ = self->priv->_service;
	if (_tmp0_ == NULL) {
		unity_scope_proxy_remote_connect_to_scope (self, NULL, NULL);
	}
	self->priv->_reconnection_id = (guint) 0;
	result = FALSE;
	return result;
}


static gboolean ___lambda0__gsource_func (gpointer self) {
	gboolean result;
	result = __lambda0_ (self);
	return result;
}


static void unity_scope_proxy_remote_start_reconnection_timeout (UnityScopeProxyRemote* self) {
	guint _tmp0_;
	guint _tmp2_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_reconnection_id;
	if (_tmp0_ != ((guint) 0)) {
		guint _tmp1_;
		_tmp1_ = self->priv->_reconnection_id;
		g_source_remove (_tmp1_);
	}
	_tmp2_ = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 1, ___lambda0__gsource_func, g_object_ref (self), g_object_unref);
	self->priv->_reconnection_id = _tmp2_;
}


static void unity_scope_proxy_remote_real_activate_data_free (gpointer _data) {
	UnityScopeProxyRemoteActivateData* _data_;
	_data_ = _data;
	_g_free0 (_data_->uri);
	unity_activation_reply_raw_destroy (&_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (UnityScopeProxyRemoteActivateData, _data_);
}


static void unity_scope_proxy_remote_real_activate (UnityScopeProxy* base, const gchar* uri, guint action_type, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UnityScopeProxyRemote * self;
	UnityScopeProxyRemoteActivateData* _data_;
	UnityScopeProxyRemote* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	guint _tmp3_;
	self = (UnityScopeProxyRemote*) base;
	_data_ = g_slice_new0 (UnityScopeProxyRemoteActivateData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, unity_scope_proxy_remote_real_activate);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, unity_scope_proxy_remote_real_activate_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = uri;
	_tmp2_ = g_strdup (_tmp1_);
	_data_->uri = _tmp2_;
	_tmp3_ = action_type;
	_data_->action_type = _tmp3_;
	unity_scope_proxy_remote_real_activate_co (_data_);
}


static void unity_scope_proxy_remote_real_activate_finish (UnityScopeProxy* base, GAsyncResult* _res_, UnityActivationReplyRaw* result) {
	UnityScopeProxyRemoteActivateData* _data_;
	UnityActivationReplyRaw _tmp0_ = {0};
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	unity_activation_reply_raw_copy (&_data_->result, &_tmp0_);
	*result = _tmp0_;
}


static void unity_scope_proxy_remote_activate_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	UnityScopeProxyRemoteActivateData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	unity_scope_proxy_remote_real_activate_co (_data_);
}


static gboolean unity_scope_proxy_remote_real_activate_co (UnityScopeProxyRemoteActivateData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->synchronized;
	if (_data_->_tmp0_) {
		{
			_data_->_tmp1_ = _data_->self->priv->_service;
			_data_->_tmp2_ = _data_->uri;
			_data_->_tmp3_ = _data_->action_type;
			memset (&_data_->_tmp4_, 0, sizeof (UnityActivationReplyRaw));
			_data_->_state_ = 1;
			unity_scope_service_activate (_data_->_tmp1_, _data_->_tmp2_, _data_->_tmp3_, unity_scope_proxy_remote_activate_ready, _data_);
			return FALSE;
			_state_1:
			unity_scope_service_activate_finish (_data_->_tmp1_, _data_->_res_, &_data_->_tmp4_, &_data_->_inner_error_);
			_data_->raw = _data_->_tmp4_;
			if (_data_->_inner_error_ != NULL) {
				goto __catch26_g_error;
			}
			_data_->result = _data_->raw;
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		goto __finally26;
		__catch26_g_error:
		{
			_data_->e = _data_->_inner_error_;
			_data_->_inner_error_ = NULL;
			_data_->_tmp5_ = _data_->self->priv->_dbus_path;
			_data_->_tmp6_ = NULL;
			_data_->_tmp6_ = string_to_string (_data_->_tmp5_);
			_data_->_tmp7_ = _data_->e;
			_data_->_tmp8_ = _data_->_tmp7_->message;
			_data_->_tmp9_ = NULL;
			_data_->_tmp9_ = string_to_string (_data_->_tmp8_);
			_data_->_tmp10_ = NULL;
			_data_->_tmp10_ = g_strconcat ("Unable to search scope (", _data_->_tmp6_, "): ", _data_->_tmp9_, NULL);
			_data_->_tmp11_ = _data_->_tmp10_;
			g_warning ("unity-scope-proxy-remote.vala:165: %s", _data_->_tmp11_);
			_g_free0 (_data_->_tmp11_);
			_g_error_free0 (_data_->e);
		}
		__finally26:
		if (_data_->_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	memset (&_data_->_tmp12_, 0, sizeof (UnityActivationReplyRaw));
	memset (&_data_->_tmp12_, 0, sizeof (UnityActivationReplyRaw));
	_data_->result = _data_->_tmp12_;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void unity_scope_proxy_remote_real_search_data_free (gpointer _data) {
	UnityScopeProxyRemoteSearchData* _data_;
	_data_ = _data;
	_g_free0 (_data_->search_string);
	_g_hash_table_unref0 (_data_->hints);
	_g_hash_table_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (UnityScopeProxyRemoteSearchData, _data_);
}


static gpointer _g_hash_table_ref0 (gpointer self) {
	return self ? g_hash_table_ref (self) : NULL;
}


static void unity_scope_proxy_remote_real_search (UnityScopeProxy* base, const gchar* search_string, GHashTable* hints, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UnityScopeProxyRemote * self;
	UnityScopeProxyRemoteSearchData* _data_;
	UnityScopeProxyRemote* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	GHashTable* _tmp3_;
	GHashTable* _tmp4_;
	self = (UnityScopeProxyRemote*) base;
	_data_ = g_slice_new0 (UnityScopeProxyRemoteSearchData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, unity_scope_proxy_remote_real_search);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, unity_scope_proxy_remote_real_search_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = search_string;
	_tmp2_ = g_strdup (_tmp1_);
	_data_->search_string = _tmp2_;
	_tmp3_ = hints;
	_tmp4_ = _g_hash_table_ref0 (_tmp3_);
	_data_->hints = _tmp4_;
	unity_scope_proxy_remote_real_search_co (_data_);
}


static GHashTable* unity_scope_proxy_remote_real_search_finish (UnityScopeProxy* base, GAsyncResult* _res_) {
	GHashTable* result;
	UnityScopeProxyRemoteSearchData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void unity_scope_proxy_remote_search_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	UnityScopeProxyRemoteSearchData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	unity_scope_proxy_remote_real_search_co (_data_);
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_variant_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_variant_unref (var), NULL));
}


static gboolean unity_scope_proxy_remote_real_search_co (UnityScopeProxyRemoteSearchData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->synchronized;
	if (_data_->_tmp0_) {
		{
			_data_->_tmp1_ = _data_->self->priv->_service;
			_data_->_tmp2_ = _data_->search_string;
			_data_->_tmp3_ = _data_->hints;
			_data_->_state_ = 1;
			unity_scope_service_search (_data_->_tmp1_, _data_->_tmp2_, _data_->_tmp3_, unity_scope_proxy_remote_search_ready, _data_);
			return FALSE;
			_state_1:
			_data_->_tmp4_ = NULL;
			_data_->_tmp4_ = unity_scope_service_search_finish (_data_->_tmp1_, _data_->_res_, &_data_->_inner_error_);
			_data_->ht = _data_->_tmp4_;
			if (_data_->_inner_error_ != NULL) {
				if (g_error_matches (_data_->_inner_error_, UNITY_SCOPE_ERROR, UNITY_SCOPE_ERROR_SEARCH_CANCELLED)) {
					goto __catch27_unity_scope_error_search_cancelled;
				}
				goto __catch27_g_error;
			}
			_data_->result = _data_->ht;
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		goto __finally27;
		__catch27_unity_scope_error_search_cancelled:
		{
			_data_->scope_error = _data_->_inner_error_;
			_data_->_inner_error_ = NULL;
			_g_error_free0 (_data_->scope_error);
		}
		goto __finally27;
		__catch27_g_error:
		{
			_data_->e = _data_->_inner_error_;
			_data_->_inner_error_ = NULL;
			_data_->_tmp5_ = _data_->self->priv->_dbus_path;
			_data_->_tmp6_ = NULL;
			_data_->_tmp6_ = string_to_string (_data_->_tmp5_);
			_data_->_tmp7_ = _data_->search_string;
			_data_->_tmp8_ = NULL;
			_data_->_tmp8_ = string_to_string (_data_->_tmp7_);
			_data_->_tmp9_ = _data_->e;
			_data_->_tmp10_ = _data_->_tmp9_->message;
			_data_->_tmp11_ = NULL;
			_data_->_tmp11_ = string_to_string (_data_->_tmp10_);
			_data_->_tmp12_ = NULL;
			_data_->_tmp12_ = g_strconcat ("Unable to search scope (", _data_->_tmp6_, " - '", _data_->_tmp8_, "'): ", _data_->_tmp11_, NULL);
			_data_->_tmp13_ = _data_->_tmp12_;
			g_warning ("unity-scope-proxy-remote.vala:182: %s", _data_->_tmp13_);
			_g_free0 (_data_->_tmp13_);
			_g_error_free0 (_data_->e);
		}
		__finally27:
		if (_data_->_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	_data_->_tmp14_ = g_str_hash;
	_data_->_tmp15_ = g_str_equal;
	_data_->_tmp16_ = g_hash_table_new_full (_data_->_tmp14_, _data_->_tmp15_, _g_free0_, _g_variant_unref0_);
	_data_->result = _data_->_tmp16_;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void unity_scope_proxy_remote_real_global_search_data_free (gpointer _data) {
	UnityScopeProxyRemoteGlobalSearchData* _data_;
	_data_ = _data;
	_g_free0 (_data_->search_string);
	_g_hash_table_unref0 (_data_->hints);
	_g_hash_table_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (UnityScopeProxyRemoteGlobalSearchData, _data_);
}


static void unity_scope_proxy_remote_real_global_search (UnityScopeProxy* base, const gchar* search_string, GHashTable* hints, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UnityScopeProxyRemote * self;
	UnityScopeProxyRemoteGlobalSearchData* _data_;
	UnityScopeProxyRemote* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	GHashTable* _tmp3_;
	GHashTable* _tmp4_;
	self = (UnityScopeProxyRemote*) base;
	_data_ = g_slice_new0 (UnityScopeProxyRemoteGlobalSearchData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, unity_scope_proxy_remote_real_global_search);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, unity_scope_proxy_remote_real_global_search_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = search_string;
	_tmp2_ = g_strdup (_tmp1_);
	_data_->search_string = _tmp2_;
	_tmp3_ = hints;
	_tmp4_ = _g_hash_table_ref0 (_tmp3_);
	_data_->hints = _tmp4_;
	unity_scope_proxy_remote_real_global_search_co (_data_);
}


static GHashTable* unity_scope_proxy_remote_real_global_search_finish (UnityScopeProxy* base, GAsyncResult* _res_) {
	GHashTable* result;
	UnityScopeProxyRemoteGlobalSearchData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void unity_scope_proxy_remote_global_search_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	UnityScopeProxyRemoteGlobalSearchData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	unity_scope_proxy_remote_real_global_search_co (_data_);
}


static gboolean unity_scope_proxy_remote_real_global_search_co (UnityScopeProxyRemoteGlobalSearchData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->synchronized;
	if (_data_->_tmp0_) {
		{
			_data_->_tmp1_ = _data_->self->priv->_service;
			_data_->_tmp2_ = _data_->search_string;
			_data_->_tmp3_ = _data_->hints;
			_data_->_state_ = 1;
			unity_scope_service_global_search (_data_->_tmp1_, _data_->_tmp2_, _data_->_tmp3_, unity_scope_proxy_remote_global_search_ready, _data_);
			return FALSE;
			_state_1:
			_data_->_tmp4_ = NULL;
			_data_->_tmp4_ = unity_scope_service_global_search_finish (_data_->_tmp1_, _data_->_res_, &_data_->_inner_error_);
			_data_->_result_ = _data_->_tmp4_;
			if (_data_->_inner_error_ != NULL) {
				if (g_error_matches (_data_->_inner_error_, UNITY_SCOPE_ERROR, UNITY_SCOPE_ERROR_SEARCH_CANCELLED)) {
					goto __catch28_unity_scope_error_search_cancelled;
				}
				goto __catch28_g_error;
			}
			_data_->result = _data_->_result_;
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		goto __finally28;
		__catch28_unity_scope_error_search_cancelled:
		{
			_data_->scope_error = _data_->_inner_error_;
			_data_->_inner_error_ = NULL;
			_g_error_free0 (_data_->scope_error);
		}
		goto __finally28;
		__catch28_g_error:
		{
			_data_->e = _data_->_inner_error_;
			_data_->_inner_error_ = NULL;
			_data_->_tmp5_ = _data_->self->priv->_dbus_path;
			_data_->_tmp6_ = NULL;
			_data_->_tmp6_ = string_to_string (_data_->_tmp5_);
			_data_->_tmp7_ = _data_->search_string;
			_data_->_tmp8_ = NULL;
			_data_->_tmp8_ = string_to_string (_data_->_tmp7_);
			_data_->_tmp9_ = _data_->e;
			_data_->_tmp10_ = _data_->_tmp9_->message;
			_data_->_tmp11_ = NULL;
			_data_->_tmp11_ = string_to_string (_data_->_tmp10_);
			_data_->_tmp12_ = NULL;
			_data_->_tmp12_ = g_strconcat ("Unable to global_search scope (", _data_->_tmp6_, " - '", _data_->_tmp8_, "'): ", _data_->_tmp11_, NULL);
			_data_->_tmp13_ = _data_->_tmp12_;
			g_warning ("unity-scope-proxy-remote.vala:200: %s", _data_->_tmp13_);
			_g_free0 (_data_->_tmp13_);
			_g_error_free0 (_data_->e);
		}
		__finally28:
		if (_data_->_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	_data_->_tmp14_ = g_str_hash;
	_data_->_tmp15_ = g_str_equal;
	_data_->_tmp16_ = g_hash_table_new_full (_data_->_tmp14_, _data_->_tmp15_, _g_free0_, _g_variant_unref0_);
	_data_->result = _data_->_tmp16_;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void unity_scope_proxy_remote_real_preview_data_free (gpointer _data) {
	UnityScopeProxyRemotePreviewData* _data_;
	_data_ = _data;
	_g_free0 (_data_->uri);
	unity_preview_reply_raw_destroy (&_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (UnityScopeProxyRemotePreviewData, _data_);
}


static void unity_scope_proxy_remote_real_preview (UnityScopeProxy* base, const gchar* uri, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UnityScopeProxyRemote * self;
	UnityScopeProxyRemotePreviewData* _data_;
	UnityScopeProxyRemote* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	self = (UnityScopeProxyRemote*) base;
	_data_ = g_slice_new0 (UnityScopeProxyRemotePreviewData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, unity_scope_proxy_remote_real_preview);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, unity_scope_proxy_remote_real_preview_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = uri;
	_tmp2_ = g_strdup (_tmp1_);
	_data_->uri = _tmp2_;
	unity_scope_proxy_remote_real_preview_co (_data_);
}


static void unity_scope_proxy_remote_real_preview_finish (UnityScopeProxy* base, GAsyncResult* _res_, UnityPreviewReplyRaw* result) {
	UnityScopeProxyRemotePreviewData* _data_;
	UnityPreviewReplyRaw _tmp0_ = {0};
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	unity_preview_reply_raw_copy (&_data_->result, &_tmp0_);
	*result = _tmp0_;
}


static void unity_scope_proxy_remote_preview_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	UnityScopeProxyRemotePreviewData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	unity_scope_proxy_remote_real_preview_co (_data_);
}


static gboolean unity_scope_proxy_remote_real_preview_co (UnityScopeProxyRemotePreviewData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->synchronized;
	if (_data_->_tmp0_) {
		{
			_data_->_tmp1_ = _data_->self->priv->_service;
			_data_->_tmp2_ = _data_->uri;
			memset (&_data_->_tmp3_, 0, sizeof (UnityPreviewReplyRaw));
			_data_->_state_ = 1;
			unity_scope_service_preview (_data_->_tmp1_, _data_->_tmp2_, unity_scope_proxy_remote_preview_ready, _data_);
			return FALSE;
			_state_1:
			unity_scope_service_preview_finish (_data_->_tmp1_, _data_->_res_, &_data_->_tmp3_, &_data_->_inner_error_);
			_data_->raw = _data_->_tmp3_;
			if (_data_->_inner_error_ != NULL) {
				goto __catch29_g_error;
			}
			_data_->result = _data_->raw;
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		goto __finally29;
		__catch29_g_error:
		{
			_data_->e = _data_->_inner_error_;
			_data_->_inner_error_ = NULL;
			_data_->_tmp4_ = _data_->self->priv->_dbus_path;
			_data_->_tmp5_ = NULL;
			_data_->_tmp5_ = string_to_string (_data_->_tmp4_);
			_data_->_tmp6_ = _data_->e;
			_data_->_tmp7_ = _data_->_tmp6_->message;
			_data_->_tmp8_ = NULL;
			_data_->_tmp8_ = string_to_string (_data_->_tmp7_);
			_data_->_tmp9_ = NULL;
			_data_->_tmp9_ = g_strconcat ("Unable to search scope (", _data_->_tmp5_, "): ", _data_->_tmp8_, NULL);
			_data_->_tmp10_ = _data_->_tmp9_;
			g_warning ("unity-scope-proxy-remote.vala:215: %s", _data_->_tmp10_);
			_g_free0 (_data_->_tmp10_);
			_g_error_free0 (_data_->e);
		}
		__finally29:
		if (_data_->_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	memset (&_data_->_tmp11_, 0, sizeof (UnityPreviewReplyRaw));
	memset (&_data_->_tmp11_, 0, sizeof (UnityPreviewReplyRaw));
	_data_->result = _data_->_tmp11_;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void unity_scope_proxy_remote_set_view_type_data_free (gpointer _data) {
	UnityScopeProxyRemoteSetViewTypeData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (UnityScopeProxyRemoteSetViewTypeData, _data_);
}


void unity_scope_proxy_remote_set_view_type (UnityScopeProxyRemote* self, UnityViewType view_type, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UnityScopeProxyRemoteSetViewTypeData* _data_;
	UnityScopeProxyRemote* _tmp0_;
	UnityViewType _tmp1_;
	_data_ = g_slice_new0 (UnityScopeProxyRemoteSetViewTypeData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, unity_scope_proxy_remote_set_view_type);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, unity_scope_proxy_remote_set_view_type_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = view_type;
	_data_->view_type = _tmp1_;
	unity_scope_proxy_remote_set_view_type_co (_data_);
}


void unity_scope_proxy_remote_set_view_type_finish (UnityScopeProxyRemote* self, GAsyncResult* _res_) {
	UnityScopeProxyRemoteSetViewTypeData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void unity_scope_proxy_remote_set_view_type_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	UnityScopeProxyRemoteSetViewTypeData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	unity_scope_proxy_remote_set_view_type_co (_data_);
}


static gboolean unity_scope_proxy_remote_set_view_type_co (UnityScopeProxyRemoteSetViewTypeData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->view_type;
	_data_->self->priv->_view_type = _data_->_tmp0_;
	_data_->_tmp1_ = _data_->self->priv->synchronized;
	if (_data_->_tmp1_) {
		{
			_data_->_tmp2_ = _data_->self->priv->_service;
			_data_->_tmp3_ = _data_->view_type;
			_data_->_state_ = 1;
			unity_scope_service_set_view_type (_data_->_tmp2_, (guint) _data_->_tmp3_, unity_scope_proxy_remote_set_view_type_ready, _data_);
			return FALSE;
			_state_1:
			unity_scope_service_set_view_type_finish (_data_->_tmp2_, _data_->_res_, &_data_->_inner_error_);
			if (_data_->_inner_error_ != NULL) {
				goto __catch30_g_error;
			}
		}
		goto __finally30;
		__catch30_g_error:
		{
			_data_->e = _data_->_inner_error_;
			_data_->_inner_error_ = NULL;
			_data_->_tmp4_ = _data_->self->priv->_dbus_path;
			_data_->_tmp5_ = NULL;
			_data_->_tmp5_ = string_to_string (_data_->_tmp4_);
			_data_->_tmp6_ = _data_->e;
			_data_->_tmp7_ = _data_->_tmp6_->message;
			_data_->_tmp8_ = NULL;
			_data_->_tmp8_ = string_to_string (_data_->_tmp7_);
			_data_->_tmp9_ = NULL;
			_data_->_tmp9_ = g_strconcat ("Unable to set_active (", _data_->_tmp5_, "): ", _data_->_tmp8_, NULL);
			_data_->_tmp10_ = _data_->_tmp9_;
			g_warning ("unity-scope-proxy-remote.vala:230: %s", _data_->_tmp10_);
			_g_free0 (_data_->_tmp10_);
			_g_error_free0 (_data_->e);
		}
		__finally30:
		if (_data_->_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void unity_scope_proxy_remote_real_set_active_sources_data_free (gpointer _data) {
	UnityScopeProxyRemoteSetActiveSourcesData* _data_;
	_data_ = _data;
	_data_->sources = (_vala_array_free (_data_->sources, _data_->sources_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (_data_->self);
	g_slice_free (UnityScopeProxyRemoteSetActiveSourcesData, _data_);
}


static gchar** _vala_array_dup6 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static void unity_scope_proxy_remote_real_set_active_sources (UnityScopeProxy* base, gchar** sources, int sources_length1, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UnityScopeProxyRemote * self;
	UnityScopeProxyRemoteSetActiveSourcesData* _data_;
	UnityScopeProxyRemote* _tmp0_;
	gchar** _tmp1_;
	gint _tmp1__length1;
	gchar** _tmp2_;
	gint _tmp2__length1;
	self = (UnityScopeProxyRemote*) base;
	_data_ = g_slice_new0 (UnityScopeProxyRemoteSetActiveSourcesData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, unity_scope_proxy_remote_real_set_active_sources);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, unity_scope_proxy_remote_real_set_active_sources_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = sources;
	_tmp1__length1 = sources_length1;
	_tmp2_ = (_tmp1_ != NULL) ? _vala_array_dup6 (_tmp1_, _tmp1__length1) : ((gpointer) _tmp1_);
	_tmp2__length1 = _tmp1__length1;
	_data_->sources = _tmp2_;
	_data_->sources_length1 = _tmp2__length1;
	unity_scope_proxy_remote_real_set_active_sources_co (_data_);
}


static void unity_scope_proxy_remote_real_set_active_sources_finish (UnityScopeProxy* base, GAsyncResult* _res_) {
	UnityScopeProxyRemoteSetActiveSourcesData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void unity_scope_proxy_remote_set_active_sources_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	UnityScopeProxyRemoteSetActiveSourcesData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	unity_scope_proxy_remote_real_set_active_sources_co (_data_);
}


static gboolean unity_scope_proxy_remote_real_set_active_sources_co (UnityScopeProxyRemoteSetActiveSourcesData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->synchronized;
	if (_data_->_tmp0_) {
		{
			_data_->_tmp1_ = _data_->self->priv->_service;
			_data_->_tmp2_ = _data_->sources;
			_data_->_tmp2__length1 = _data_->sources_length1;
			_data_->_state_ = 1;
			unity_scope_service_set_active_sources (_data_->_tmp1_, _data_->_tmp2_, _data_->_tmp2__length1, unity_scope_proxy_remote_set_active_sources_ready, _data_);
			return FALSE;
			_state_1:
			unity_scope_service_set_active_sources_finish (_data_->_tmp1_, _data_->_res_, &_data_->_inner_error_);
			if (_data_->_inner_error_ != NULL) {
				goto __catch31_g_error;
			}
		}
		goto __finally31;
		__catch31_g_error:
		{
			_data_->e = _data_->_inner_error_;
			_data_->_inner_error_ = NULL;
			_data_->_tmp3_ = _data_->self->priv->_dbus_path;
			_data_->_tmp4_ = NULL;
			_data_->_tmp4_ = string_to_string (_data_->_tmp3_);
			_data_->_tmp5_ = _data_->e;
			_data_->_tmp6_ = _data_->_tmp5_->message;
			_data_->_tmp7_ = NULL;
			_data_->_tmp7_ = string_to_string (_data_->_tmp6_);
			_data_->_tmp8_ = NULL;
			_data_->_tmp8_ = g_strconcat ("Unable to set_sources (", _data_->_tmp4_, "): ", _data_->_tmp7_, NULL);
			_data_->_tmp9_ = _data_->_tmp8_;
			g_warning ("unity-scope-proxy-remote.vala:242: %s", _data_->_tmp9_);
			_g_free0 (_data_->_tmp9_);
			_g_error_free0 (_data_->e);
		}
		__finally31:
		if (_data_->_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


void unity_scope_proxy_remote_on_changed (UnityScopeProxyRemote* self, UnityScopeInfo* scope_info) {
	const gchar* _tmp0_;
	UnityScopeInfo _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp10_;
	UnityScopeInfo _tmp11_;
	gboolean _tmp12_;
	gboolean _tmp13_ = FALSE;
	DeeSerializableModel* _tmp14_;
	DeeSerializableModel* _tmp15_;
	gboolean _tmp20_;
	gboolean _tmp27_ = FALSE;
	DeeSerializableModel* _tmp28_;
	DeeSerializableModel* _tmp29_;
	gboolean _tmp34_;
	gboolean _tmp41_ = FALSE;
	DeeSerializableModel* _tmp42_;
	DeeSerializableModel* _tmp43_;
	gboolean _tmp48_;
	UnityOptionsFilter* _tmp55_;
	UnityOptionsFilter* _tmp56_;
	UnityScopeInfo _tmp57_;
	GVariant* _tmp58_;
	gboolean _tmp59_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (scope_info != NULL);
	_tmp0_ = self->priv->_dbus_path;
	_tmp1_ = *scope_info;
	_tmp2_ = _tmp1_.dbus_path;
	if (g_strcmp0 (_tmp0_, _tmp2_) != 0) {
		const gchar* _tmp3_;
		const gchar* _tmp4_ = NULL;
		UnityScopeInfo _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		gchar* _tmp9_;
		_tmp3_ = self->priv->_dbus_path;
		_tmp4_ = string_to_string (_tmp3_);
		_tmp5_ = *scope_info;
		_tmp6_ = _tmp5_.dbus_path;
		_tmp7_ = string_to_string (_tmp6_);
		_tmp8_ = g_strconcat ("Unable to handle Scope changed signal: dbus_path mismatch. Expected ", _tmp4_, " got ", _tmp7_, NULL);
		_tmp9_ = _tmp8_;
		g_warning ("unity-scope-proxy-remote.vala:252: %s", _tmp9_);
		_g_free0 (_tmp9_);
		return;
	}
	_tmp10_ = self->priv->_dbus_path;
	unity_trace_log_object ((GObject*) self, "Processing changed signal for %s", _tmp10_);
	_tmp11_ = *scope_info;
	_tmp12_ = _tmp11_.search_in_global;
	unity_scope_proxy_set_search_in_global ((UnityScopeProxy*) self, _tmp12_);
	_tmp14_ = unity_scope_proxy_get_results_model ((UnityScopeProxy*) self);
	_tmp15_ = _tmp14_;
	if (_tmp15_ == NULL) {
		_tmp13_ = TRUE;
	} else {
		DeeSharedModel* _tmp16_;
		const gchar* _tmp17_ = NULL;
		UnityScopeInfo _tmp18_;
		const gchar* _tmp19_;
		_tmp16_ = self->priv->_results_model;
		_tmp17_ = dee_shared_model_get_swarm_name (_tmp16_);
		_tmp18_ = *scope_info;
		_tmp19_ = _tmp18_.results_model_name;
		_tmp13_ = g_strcmp0 (_tmp17_, _tmp19_) != 0;
	}
	_tmp20_ = _tmp13_;
	if (_tmp20_) {
		UnityScopeInfo _tmp21_;
		const gchar* _tmp22_;
		DeeSharedModel* _tmp23_;
		DeeSharedModel* _tmp24_;
		DeeSerializableModel* _tmp25_;
		DeeSerializableModel* _tmp26_;
		_tmp21_ = *scope_info;
		_tmp22_ = _tmp21_.results_model_name;
		_tmp23_ = (DeeSharedModel*) dee_shared_model_new (_tmp22_);
		_tmp24_ = _tmp23_;
		unity_scope_proxy_set_results_model ((UnityScopeProxy*) self, (DeeSerializableModel*) _tmp24_);
		_g_object_unref0 (_tmp24_);
		_tmp25_ = unity_scope_proxy_get_results_model ((UnityScopeProxy*) self);
		_tmp26_ = _tmp25_;
		dee_model_set_schema ((DeeModel*) _tmp26_, "s", "s", "u", "s", "s", "s", "s", NULL);
	}
	_tmp28_ = unity_scope_proxy_get_global_results_model ((UnityScopeProxy*) self);
	_tmp29_ = _tmp28_;
	if (_tmp29_ == NULL) {
		_tmp27_ = TRUE;
	} else {
		DeeSharedModel* _tmp30_;
		const gchar* _tmp31_ = NULL;
		UnityScopeInfo _tmp32_;
		const gchar* _tmp33_;
		_tmp30_ = self->priv->_global_results_model;
		_tmp31_ = dee_shared_model_get_swarm_name (_tmp30_);
		_tmp32_ = *scope_info;
		_tmp33_ = _tmp32_.global_results_model_name;
		_tmp27_ = g_strcmp0 (_tmp31_, _tmp33_) != 0;
	}
	_tmp34_ = _tmp27_;
	if (_tmp34_) {
		UnityScopeInfo _tmp35_;
		const gchar* _tmp36_;
		DeeSharedModel* _tmp37_;
		DeeSharedModel* _tmp38_;
		DeeSerializableModel* _tmp39_;
		DeeSerializableModel* _tmp40_;
		_tmp35_ = *scope_info;
		_tmp36_ = _tmp35_.global_results_model_name;
		_tmp37_ = (DeeSharedModel*) dee_shared_model_new (_tmp36_);
		_tmp38_ = _tmp37_;
		unity_scope_proxy_set_global_results_model ((UnityScopeProxy*) self, (DeeSerializableModel*) _tmp38_);
		_g_object_unref0 (_tmp38_);
		_tmp39_ = unity_scope_proxy_get_global_results_model ((UnityScopeProxy*) self);
		_tmp40_ = _tmp39_;
		dee_model_set_schema ((DeeModel*) _tmp40_, "s", "s", "u", "s", "s", "s", "s", NULL);
	}
	_tmp42_ = unity_scope_proxy_get_filters_model ((UnityScopeProxy*) self);
	_tmp43_ = _tmp42_;
	if (_tmp43_ == NULL) {
		_tmp41_ = TRUE;
	} else {
		DeeSharedModel* _tmp44_;
		const gchar* _tmp45_ = NULL;
		UnityScopeInfo _tmp46_;
		const gchar* _tmp47_;
		_tmp44_ = self->priv->_filters_model;
		_tmp45_ = dee_shared_model_get_swarm_name (_tmp44_);
		_tmp46_ = *scope_info;
		_tmp47_ = _tmp46_.filters_model_name;
		_tmp41_ = g_strcmp0 (_tmp45_, _tmp47_) != 0;
	}
	_tmp48_ = _tmp41_;
	if (_tmp48_) {
		UnityScopeInfo _tmp49_;
		const gchar* _tmp50_;
		DeeSharedModel* _tmp51_;
		DeeSharedModel* _tmp52_;
		DeeSerializableModel* _tmp53_;
		DeeSerializableModel* _tmp54_;
		_tmp49_ = *scope_info;
		_tmp50_ = _tmp49_.filters_model_name;
		_tmp51_ = (DeeSharedModel*) dee_shared_model_new (_tmp50_);
		_tmp52_ = _tmp51_;
		unity_scope_proxy_set_filters_model ((UnityScopeProxy*) self, (DeeSerializableModel*) _tmp52_);
		_g_object_unref0 (_tmp52_);
		_tmp53_ = unity_scope_proxy_get_filters_model ((UnityScopeProxy*) self);
		_tmp54_ = _tmp53_;
		dee_model_set_schema ((DeeModel*) _tmp54_, "s", "s", "s", "s", "a{sv}", "b", "b", "b", NULL);
	}
	_tmp55_ = unity_scope_proxy_get_sources ((UnityScopeProxy*) self);
	_tmp56_ = _tmp55_;
	_tmp57_ = *scope_info;
	_tmp58_ = _tmp57_.sources;
	unity_filter_update ((UnityFilter*) _tmp56_, _tmp58_);
	g_object_notify ((GObject*) self, "sources");
	_tmp59_ = self->priv->synchronized;
	if (!_tmp59_) {
		UnityViewType _tmp60_;
		self->priv->synchronized = TRUE;
		_tmp60_ = self->priv->_view_type;
		unity_scope_proxy_remote_set_view_type (self, _tmp60_, NULL, NULL);
	}
}


const gchar* unity_scope_proxy_remote_get_dbus_name (UnityScopeProxyRemote* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_dbus_name;
	result = _tmp0_;
	return result;
}


static void unity_scope_proxy_remote_set_dbus_name (UnityScopeProxyRemote* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_dbus_name);
	self->priv->_dbus_name = _tmp1_;
	g_object_notify ((GObject *) self, "dbus-name");
}


const gchar* unity_scope_proxy_remote_get_dbus_path (UnityScopeProxyRemote* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_dbus_path;
	result = _tmp0_;
	return result;
}


static void unity_scope_proxy_remote_set_dbus_path (UnityScopeProxyRemote* self, const gchar* value) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_dbus_path);
	self->priv->_dbus_path = _tmp1_;
	g_object_notify ((GObject *) self, "dbus-path");
}


static UnityOptionsFilter* unity_scope_proxy_remote_real_get_sources (UnityScopeProxy* base) {
	UnityOptionsFilter* result;
	UnityScopeProxyRemote* self;
	UnityOptionsFilter* _tmp0_;
	self = (UnityScopeProxyRemote*) base;
	_tmp0_ = self->priv->_sources;
	result = _tmp0_;
	return result;
}


static void unity_scope_proxy_remote_real_set_sources (UnityScopeProxy* base, UnityOptionsFilter* value) {
	UnityScopeProxyRemote* self;
	UnityOptionsFilter* _tmp0_;
	UnityOptionsFilter* _tmp1_;
	self = (UnityScopeProxyRemote*) base;
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_sources);
	self->priv->_sources = _tmp1_;
	g_object_notify ((GObject *) self, "sources");
}


static gboolean unity_scope_proxy_remote_real_get_search_in_global (UnityScopeProxy* base) {
	gboolean result;
	UnityScopeProxyRemote* self;
	gboolean _tmp0_;
	self = (UnityScopeProxyRemote*) base;
	_tmp0_ = self->priv->_search_in_global;
	result = _tmp0_;
	return result;
}


static void unity_scope_proxy_remote_real_set_search_in_global (UnityScopeProxy* base, gboolean value) {
	UnityScopeProxyRemote* self;
	gboolean _tmp0_;
	self = (UnityScopeProxyRemote*) base;
	_tmp0_ = value;
	self->priv->_search_in_global = _tmp0_;
	g_object_notify ((GObject *) self, "search-in-global");
}


static DeeSerializableModel* unity_scope_proxy_remote_real_get_results_model (UnityScopeProxy* base) {
	DeeSerializableModel* result;
	UnityScopeProxyRemote* self;
	DeeSharedModel* _tmp0_;
	self = (UnityScopeProxyRemote*) base;
	_tmp0_ = self->priv->_results_model;
	result = (DeeSerializableModel*) _tmp0_;
	return result;
}


static void unity_scope_proxy_remote_real_set_results_model (UnityScopeProxy* base, DeeSerializableModel* value) {
	UnityScopeProxyRemote* self;
	DeeSerializableModel* _tmp0_;
	DeeSharedModel* _tmp1_;
	self = (UnityScopeProxyRemote*) base;
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (DEE_IS_SHARED_MODEL (_tmp0_) ? ((DeeSharedModel*) _tmp0_) : NULL);
	_g_object_unref0 (self->priv->_results_model);
	self->priv->_results_model = _tmp1_;
	g_object_notify ((GObject *) self, "results-model");
}


static DeeSerializableModel* unity_scope_proxy_remote_real_get_global_results_model (UnityScopeProxy* base) {
	DeeSerializableModel* result;
	UnityScopeProxyRemote* self;
	DeeSharedModel* _tmp0_;
	self = (UnityScopeProxyRemote*) base;
	_tmp0_ = self->priv->_global_results_model;
	result = (DeeSerializableModel*) _tmp0_;
	return result;
}


static void unity_scope_proxy_remote_real_set_global_results_model (UnityScopeProxy* base, DeeSerializableModel* value) {
	UnityScopeProxyRemote* self;
	DeeSerializableModel* _tmp0_;
	DeeSharedModel* _tmp1_;
	self = (UnityScopeProxyRemote*) base;
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (DEE_IS_SHARED_MODEL (_tmp0_) ? ((DeeSharedModel*) _tmp0_) : NULL);
	_g_object_unref0 (self->priv->_global_results_model);
	self->priv->_global_results_model = _tmp1_;
	g_object_notify ((GObject *) self, "global-results-model");
}


static DeeSerializableModel* unity_scope_proxy_remote_real_get_filters_model (UnityScopeProxy* base) {
	DeeSerializableModel* result;
	UnityScopeProxyRemote* self;
	DeeSharedModel* _tmp0_;
	self = (UnityScopeProxyRemote*) base;
	_tmp0_ = self->priv->_filters_model;
	result = (DeeSerializableModel*) _tmp0_;
	return result;
}


static void unity_scope_proxy_remote_real_set_filters_model (UnityScopeProxy* base, DeeSerializableModel* value) {
	UnityScopeProxyRemote* self;
	DeeSerializableModel* _tmp0_;
	DeeSharedModel* _tmp1_;
	self = (UnityScopeProxyRemote*) base;
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (DEE_IS_SHARED_MODEL (_tmp0_) ? ((DeeSharedModel*) _tmp0_) : NULL);
	_g_object_unref0 (self->priv->_filters_model);
	self->priv->_filters_model = _tmp1_;
	g_object_notify ((GObject *) self, "filters-model");
}


static UnityViewType unity_scope_proxy_remote_real_get_view_type (UnityScopeProxy* base) {
	UnityViewType result;
	UnityScopeProxyRemote* self;
	UnityViewType _tmp0_;
	self = (UnityScopeProxyRemote*) base;
	_tmp0_ = self->priv->_view_type;
	result = _tmp0_;
	return result;
}


static void unity_scope_proxy_remote_real_set_view_type (UnityScopeProxy* base, UnityViewType value) {
	UnityScopeProxyRemote* self;
	UnityViewType _tmp0_;
	UnityViewType _tmp1_;
	self = (UnityScopeProxyRemote*) base;
	_tmp0_ = self->priv->_view_type;
	_tmp1_ = value;
	if (_tmp0_ != _tmp1_) {
		UnityViewType _tmp2_;
		_tmp2_ = value;
		unity_scope_proxy_remote_set_view_type (self, _tmp2_, NULL, NULL);
	}
	g_object_notify ((GObject *) self, "view-type");
}


static void _unity_scope_proxy_remote_on_scope_appeared_gbus_name_appeared_callback (GDBusConnection* connection, const gchar* name, const gchar* name_owner, gpointer self) {
	unity_scope_proxy_remote_on_scope_appeared (self, connection, name, name_owner);
}


static void _unity_scope_proxy_remote_on_scope_vanished_gbus_name_vanished_callback (GDBusConnection* connection, const gchar* name, gpointer self) {
	unity_scope_proxy_remote_on_scope_vanished (self, connection, name);
}


static GObject * unity_scope_proxy_remote_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	UnityScopeProxyRemote * self;
	UnityCheckOptionFilter* _tmp0_;
	UnityCheckOptionFilter* _tmp1_;
	GError * _inner_error_ = NULL;
	parent_class = G_OBJECT_CLASS (unity_scope_proxy_remote_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = UNITY_SCOPE_PROXY_REMOTE (obj);
	_tmp0_ = unity_check_option_filter_new ("sources", "Sources", NULL, TRUE);
	_tmp1_ = _tmp0_;
	unity_scope_proxy_set_sources ((UnityScopeProxy*) self, (UnityOptionsFilter*) _tmp1_);
	_g_object_unref0 (_tmp1_);
	{
		GDBusConnection* _tmp2_ = NULL;
		GDBusConnection* _tmp3_;
		GDBusConnection* _tmp4_;
		const gchar* _tmp5_;
		guint _tmp6_ = 0U;
		_tmp2_ = g_bus_get_sync (G_BUS_TYPE_SESSION, NULL, &_inner_error_);
		_tmp3_ = _tmp2_;
		if (_inner_error_ != NULL) {
			goto __catch32_g_error;
		}
		_g_object_unref0 (self->priv->_bus);
		self->priv->_bus = _tmp3_;
		_tmp4_ = self->priv->_bus;
		_tmp5_ = self->priv->_dbus_name;
		_tmp6_ = g_bus_watch_name_on_connection_with_closures (_tmp4_, _tmp5_, G_BUS_NAME_WATCHER_FLAGS_NONE, (GClosure*) ((_unity_scope_proxy_remote_on_scope_appeared_gbus_name_appeared_callback == NULL) ? NULL : g_cclosure_new ((GCallback) _unity_scope_proxy_remote_on_scope_appeared_gbus_name_appeared_callback, g_object_ref (self), g_object_unref)), (GClosure*) ((_unity_scope_proxy_remote_on_scope_vanished_gbus_name_vanished_callback == NULL) ? NULL : g_cclosure_new ((GCallback) _unity_scope_proxy_remote_on_scope_vanished_gbus_name_vanished_callback, g_object_ref (self), g_object_unref)));
		self->priv->_watcher = _tmp6_;
		unity_scope_proxy_remote_start_reconnection_timeout (self);
	}
	goto __finally32;
	__catch32_g_error:
	{
		GError* e = NULL;
		GError* _tmp7_;
		const gchar* _tmp8_;
		const gchar* _tmp9_ = NULL;
		gchar* _tmp10_ = NULL;
		gchar* _tmp11_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp7_ = e;
		_tmp8_ = _tmp7_->message;
		_tmp9_ = string_to_string (_tmp8_);
		_tmp10_ = g_strconcat ("Unable to connect to session bus: ", _tmp9_, NULL);
		_tmp11_ = _tmp10_;
		g_critical ("unity-scope-proxy-remote.vala:92: %s", _tmp11_);
		_g_free0 (_tmp11_);
		_g_error_free0 (e);
	}
	__finally32:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
	}
	return obj;
}


static void unity_scope_proxy_remote_class_init (UnityScopeProxyRemoteClass * klass) {
	unity_scope_proxy_remote_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (UnityScopeProxyRemotePrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_unity_scope_proxy_remote_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_unity_scope_proxy_remote_set_property;
	G_OBJECT_CLASS (klass)->constructor = unity_scope_proxy_remote_constructor;
	G_OBJECT_CLASS (klass)->finalize = unity_scope_proxy_remote_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_SCOPE_PROXY_REMOTE_DBUS_NAME, g_param_spec_string ("dbus-name", "dbus-name", "dbus-name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_SCOPE_PROXY_REMOTE_DBUS_PATH, g_param_spec_string ("dbus-path", "dbus-path", "dbus-path", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_SCOPE_PROXY_REMOTE_SOURCES, g_param_spec_object ("sources", "sources", "sources", UNITY_TYPE_OPTIONS_FILTER, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_SCOPE_PROXY_REMOTE_SEARCH_IN_GLOBAL, g_param_spec_boolean ("search-in-global", "search-in-global", "search-in-global", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_SCOPE_PROXY_REMOTE_RESULTS_MODEL, g_param_spec_object ("results-model", "results-model", "results-model", dee_serializable_model_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_SCOPE_PROXY_REMOTE_GLOBAL_RESULTS_MODEL, g_param_spec_object ("global-results-model", "global-results-model", "global-results-model", dee_serializable_model_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_SCOPE_PROXY_REMOTE_FILTERS_MODEL, g_param_spec_object ("filters-model", "filters-model", "filters-model", dee_serializable_model_get_type (), G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_SCOPE_PROXY_REMOTE_VIEW_TYPE, g_param_spec_enum ("view-type", "view-type", "view-type", UNITY_TYPE_VIEW_TYPE, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void unity_scope_proxy_remote_unity_scope_proxy_interface_init (UnityScopeProxyIface * iface) {
	unity_scope_proxy_remote_unity_scope_proxy_parent_iface = g_type_interface_peek_parent (iface);
	iface->activate = (void (*)(UnityScopeProxy*, const gchar*, guint, UnityActivationReplyRaw*)) unity_scope_proxy_remote_real_activate;
	iface->activate_finish = unity_scope_proxy_remote_real_activate_finish;
	iface->search = (GHashTable* (*)(UnityScopeProxy*, const gchar*, GHashTable*)) unity_scope_proxy_remote_real_search;
	iface->search_finish = unity_scope_proxy_remote_real_search_finish;
	iface->global_search = (GHashTable* (*)(UnityScopeProxy*, const gchar*, GHashTable*)) unity_scope_proxy_remote_real_global_search;
	iface->global_search_finish = unity_scope_proxy_remote_real_global_search_finish;
	iface->preview = (void (*)(UnityScopeProxy*, const gchar*, UnityPreviewReplyRaw*)) unity_scope_proxy_remote_real_preview;
	iface->preview_finish = unity_scope_proxy_remote_real_preview_finish;
	iface->set_active_sources = (void (*)(UnityScopeProxy*, gchar**, int)) unity_scope_proxy_remote_real_set_active_sources;
	iface->set_active_sources_finish = unity_scope_proxy_remote_real_set_active_sources_finish;
	iface->get_sources = unity_scope_proxy_remote_real_get_sources;
	iface->set_sources = unity_scope_proxy_remote_real_set_sources;
	iface->get_search_in_global = unity_scope_proxy_remote_real_get_search_in_global;
	iface->set_search_in_global = unity_scope_proxy_remote_real_set_search_in_global;
	iface->get_results_model = unity_scope_proxy_remote_real_get_results_model;
	iface->set_results_model = unity_scope_proxy_remote_real_set_results_model;
	iface->get_global_results_model = unity_scope_proxy_remote_real_get_global_results_model;
	iface->set_global_results_model = unity_scope_proxy_remote_real_set_global_results_model;
	iface->get_filters_model = unity_scope_proxy_remote_real_get_filters_model;
	iface->set_filters_model = unity_scope_proxy_remote_real_set_filters_model;
	iface->get_view_type = unity_scope_proxy_remote_real_get_view_type;
	iface->set_view_type = unity_scope_proxy_remote_real_set_view_type;
}


static void unity_scope_proxy_remote_instance_init (UnityScopeProxyRemote * self) {
	self->priv = UNITY_SCOPE_PROXY_REMOTE_GET_PRIVATE (self);
	self->priv->_reconnection_id = (guint) 0;
	self->priv->synchronized = FALSE;
}


static void unity_scope_proxy_remote_finalize (GObject* obj) {
	UnityScopeProxyRemote * self;
	self = UNITY_SCOPE_PROXY_REMOTE (obj);
	_g_free0 (self->priv->_dbus_name);
	_g_free0 (self->priv->_dbus_path);
	_g_object_unref0 (self->priv->_sources);
	_g_object_unref0 (self->priv->_bus);
	_g_object_unref0 (self->priv->_service);
	_g_object_unref0 (self->priv->_results_model);
	_g_object_unref0 (self->priv->_global_results_model);
	_g_object_unref0 (self->priv->_filters_model);
	G_OBJECT_CLASS (unity_scope_proxy_remote_parent_class)->finalize (obj);
}


GType unity_scope_proxy_remote_get_type (void) {
	static volatile gsize unity_scope_proxy_remote_type_id__volatile = 0;
	if (g_once_init_enter (&unity_scope_proxy_remote_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UnityScopeProxyRemoteClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unity_scope_proxy_remote_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnityScopeProxyRemote), 0, (GInstanceInitFunc) unity_scope_proxy_remote_instance_init, NULL };
		static const GInterfaceInfo unity_scope_proxy_info = { (GInterfaceInitFunc) unity_scope_proxy_remote_unity_scope_proxy_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType unity_scope_proxy_remote_type_id;
		unity_scope_proxy_remote_type_id = g_type_register_static (G_TYPE_OBJECT, "UnityScopeProxyRemote", &g_define_type_info, 0);
		g_type_add_interface_static (unity_scope_proxy_remote_type_id, UNITY_TYPE_SCOPE_PROXY, &unity_scope_proxy_info);
		g_once_init_leave (&unity_scope_proxy_remote_type_id__volatile, unity_scope_proxy_remote_type_id);
	}
	return unity_scope_proxy_remote_type_id__volatile;
}


static void _vala_unity_scope_proxy_remote_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	UnityScopeProxyRemote * self;
	self = UNITY_SCOPE_PROXY_REMOTE (object);
	switch (property_id) {
		case UNITY_SCOPE_PROXY_REMOTE_DBUS_NAME:
		g_value_set_string (value, unity_scope_proxy_remote_get_dbus_name (self));
		break;
		case UNITY_SCOPE_PROXY_REMOTE_DBUS_PATH:
		g_value_set_string (value, unity_scope_proxy_remote_get_dbus_path (self));
		break;
		case UNITY_SCOPE_PROXY_REMOTE_SOURCES:
		g_value_set_object (value, unity_scope_proxy_get_sources ((UnityScopeProxy*) self));
		break;
		case UNITY_SCOPE_PROXY_REMOTE_SEARCH_IN_GLOBAL:
		g_value_set_boolean (value, unity_scope_proxy_get_search_in_global ((UnityScopeProxy*) self));
		break;
		case UNITY_SCOPE_PROXY_REMOTE_RESULTS_MODEL:
		g_value_set_object (value, unity_scope_proxy_get_results_model ((UnityScopeProxy*) self));
		break;
		case UNITY_SCOPE_PROXY_REMOTE_GLOBAL_RESULTS_MODEL:
		g_value_set_object (value, unity_scope_proxy_get_global_results_model ((UnityScopeProxy*) self));
		break;
		case UNITY_SCOPE_PROXY_REMOTE_FILTERS_MODEL:
		g_value_set_object (value, unity_scope_proxy_get_filters_model ((UnityScopeProxy*) self));
		break;
		case UNITY_SCOPE_PROXY_REMOTE_VIEW_TYPE:
		g_value_set_enum (value, unity_scope_proxy_get_view_type ((UnityScopeProxy*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_unity_scope_proxy_remote_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	UnityScopeProxyRemote * self;
	self = UNITY_SCOPE_PROXY_REMOTE (object);
	switch (property_id) {
		case UNITY_SCOPE_PROXY_REMOTE_DBUS_NAME:
		unity_scope_proxy_remote_set_dbus_name (self, g_value_get_string (value));
		break;
		case UNITY_SCOPE_PROXY_REMOTE_DBUS_PATH:
		unity_scope_proxy_remote_set_dbus_path (self, g_value_get_string (value));
		break;
		case UNITY_SCOPE_PROXY_REMOTE_SOURCES:
		unity_scope_proxy_set_sources ((UnityScopeProxy*) self, g_value_get_object (value));
		break;
		case UNITY_SCOPE_PROXY_REMOTE_SEARCH_IN_GLOBAL:
		unity_scope_proxy_set_search_in_global ((UnityScopeProxy*) self, g_value_get_boolean (value));
		break;
		case UNITY_SCOPE_PROXY_REMOTE_RESULTS_MODEL:
		unity_scope_proxy_set_results_model ((UnityScopeProxy*) self, g_value_get_object (value));
		break;
		case UNITY_SCOPE_PROXY_REMOTE_GLOBAL_RESULTS_MODEL:
		unity_scope_proxy_set_global_results_model ((UnityScopeProxy*) self, g_value_get_object (value));
		break;
		case UNITY_SCOPE_PROXY_REMOTE_FILTERS_MODEL:
		unity_scope_proxy_set_filters_model ((UnityScopeProxy*) self, g_value_get_object (value));
		break;
		case UNITY_SCOPE_PROXY_REMOTE_VIEW_TYPE:
		unity_scope_proxy_set_view_type ((UnityScopeProxy*) self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



