/* unity-scope-private.c generated by valac 0.14.2, the Vala compiler
 * generated from unity-scope-private.vala, do not modify */

/*
 * Copyright (C) 2011 Canonical, Ltd.
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License
 * version 3.0 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3.0 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see
 * <http://www.gnu.org/licenses/>.
 *
 * Authored by Neil Jagdish Patel <neil.patel@canonical.com>
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <dee.h>
#include "unity.h"
#include <time.h>


#define UNITY_TYPE_SCOPE_SERVICE (unity_scope_service_get_type ())
#define UNITY_SCOPE_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_TYPE_SCOPE_SERVICE, UnityScopeService))
#define UNITY_IS_SCOPE_SERVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_TYPE_SCOPE_SERVICE))
#define UNITY_SCOPE_SERVICE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), UNITY_TYPE_SCOPE_SERVICE, UnityScopeServiceIface))

typedef struct _UnityScopeService UnityScopeService;
typedef struct _UnityScopeServiceIface UnityScopeServiceIface;

#define UNITY_TYPE_SCOPE_SERVICE_PROXY (unity_scope_service_proxy_get_type ())

#define UNITY_TYPE_ACTIVATION_REPLY_RAW (unity_activation_reply_raw_get_type ())
typedef struct _UnityActivationReplyRaw UnityActivationReplyRaw;

#define UNITY_TYPE_PREVIEW_REPLY_RAW (unity_preview_reply_raw_get_type ())
typedef struct _UnityPreviewReplyRaw UnityPreviewReplyRaw;

#define UNITY_TYPE_SCOPE_IMPL (unity_scope_impl_get_type ())
#define UNITY_SCOPE_IMPL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_TYPE_SCOPE_IMPL, UnityScopeImpl))
#define UNITY_SCOPE_IMPL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_TYPE_SCOPE_IMPL, UnityScopeImplClass))
#define UNITY_IS_SCOPE_IMPL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_TYPE_SCOPE_IMPL))
#define UNITY_IS_SCOPE_IMPL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_TYPE_SCOPE_IMPL))
#define UNITY_SCOPE_IMPL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_TYPE_SCOPE_IMPL, UnityScopeImplClass))

typedef struct _UnityScopeImpl UnityScopeImpl;
typedef struct _UnityScopeImplClass UnityScopeImplClass;
typedef struct _UnityScopeImplPrivate UnityScopeImplPrivate;

#define UNITY_TYPE_VIEW_TYPE (unity_view_type_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define UNITY_TYPE_SCOPE_INFO (unity_scope_info_get_type ())
typedef struct _UnityScopeInfo UnityScopeInfo;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))

#define UNITY_TYPE_FILTER_COLUMN (unity_filter_column_get_type ())
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _UnityScopeImplInfoRequestData UnityScopeImplInfoRequestData;
typedef struct _UnityScopeImplActivateData UnityScopeImplActivateData;
typedef struct _Block8Data Block8Data;
typedef struct _UnityScopeImplScheduleSearchChangedData UnityScopeImplScheduleSearchChangedData;
typedef struct _Block9Data Block9Data;
typedef struct _UnityScopeImplSearchInternalData UnityScopeImplSearchInternalData;
typedef struct _UnityScopeImplSearchData UnityScopeImplSearchData;
typedef struct _UnityScopeImplGlobalSearchData UnityScopeImplGlobalSearchData;
typedef struct _UnityScopeImplPreviewData UnityScopeImplPreviewData;
typedef struct _UnityScopeImplSetViewTypeData UnityScopeImplSetViewTypeData;
typedef struct _UnityScopeImplSetActiveSourcesData UnityScopeImplSetActiveSourcesData;

struct _UnityActivationReplyRaw {
	gchar* uri;
	guint handled;
	GHashTable* hints;
};

struct _UnityPreviewReplyRaw {
	gchar* uri;
	gchar* renderer_name;
	GHashTable* properties;
};

struct _UnityScopeServiceIface {
	GTypeInterface parent_iface;
	void (*info_request) (UnityScopeService* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*info_request_finish) (UnityScopeService* self, GAsyncResult* _res_, GError** error);
	void (*activate) (UnityScopeService* self, const gchar* uri, guint action_type, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*activate_finish) (UnityScopeService* self, GAsyncResult* _res_, UnityActivationReplyRaw* result, GError** error);
	void (*search) (UnityScopeService* self, const gchar* search_string, GHashTable* hints, GAsyncReadyCallback _callback_, gpointer _user_data_);
	GHashTable* (*search_finish) (UnityScopeService* self, GAsyncResult* _res_, GError** error);
	void (*global_search) (UnityScopeService* self, const gchar* search_string, GHashTable* hints, GAsyncReadyCallback _callback_, gpointer _user_data_);
	GHashTable* (*global_search_finish) (UnityScopeService* self, GAsyncResult* _res_, GError** error);
	void (*preview) (UnityScopeService* self, const gchar* uri, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*preview_finish) (UnityScopeService* self, GAsyncResult* _res_, UnityPreviewReplyRaw* result, GError** error);
	void (*set_view_type) (UnityScopeService* self, guint view_type, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*set_view_type_finish) (UnityScopeService* self, GAsyncResult* _res_, GError** error);
	void (*set_active_sources) (UnityScopeService* self, gchar** sources, int sources_length1, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*set_active_sources_finish) (UnityScopeService* self, GAsyncResult* _res_, GError** error);
};

struct _UnityScopeImpl {
	GObject parent_instance;
	UnityScopeImplPrivate * priv;
	DeeSerializableModel* _results_model;
	DeeSerializableModel* _global_results_model;
	DeeSerializableModel* _filters_model;
};

struct _UnityScopeImplClass {
	GObjectClass parent_class;
};

typedef enum  {
	UNITY_VIEW_TYPE_HIDDEN,
	UNITY_VIEW_TYPE_HOME_VIEW,
	UNITY_VIEW_TYPE_LENS_VIEW
} UnityViewType;

struct _UnityScopeImplPrivate {
	UnityScope* _owner;
	guint _dbus_id;
	guint _info_changed_id;
	guint _filters_changed_id;
	UnityViewType _view_type;
	GCancellable** cancellable_arr;
	gint cancellable_arr_length1;
	gint _cancellable_arr_size_;
	gchar** search_keys;
	gint search_keys_length1;
	gint _search_keys_size_;
};

struct _UnityScopeInfo {
	gchar* dbus_path;
	GVariant* sources;
	gboolean search_in_global;
	gchar* private_connection_name;
	gchar* results_model_name;
	gchar* global_results_model_name;
	gchar* filters_model_name;
	GHashTable* hints;
};

typedef enum  {
	UNITY_FILTER_COLUMN_ID = 0,
	UNITY_FILTER_COLUMN_NAME,
	UNITY_FILTER_COLUMN_ICON_HINT,
	UNITY_FILTER_COLUMN_RENDERER_NAME,
	UNITY_FILTER_COLUMN_RENDERER_STATE,
	UNITY_FILTER_COLUMN_VISIBLE,
	UNITY_FILTER_COLUMN_COLLAPSED,
	UNITY_FILTER_COLUMN_FILTERING
} UnityFilterColumn;

struct _UnityScopeImplInfoRequestData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	UnityScopeImpl* self;
};

struct _UnityScopeImplActivateData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	UnityScopeImpl* self;
	gchar* uri;
	guint action_type;
	UnityActivationReplyRaw result;
	UnityActivationReplyRaw reply;
	UnityScope* _tmp0_;
	const gchar* _tmp1_;
	UnityActivationResponse* _tmp2_;
	UnityActivationResponse* response;
	UnityActivationResponse* _tmp3_;
	UnityActivationResponse* _tmp4_;
	UnityActivationResponse* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	UnityActivationResponse* _tmp8_;
	UnityHandledType _tmp9_;
	UnityHandledType _tmp10_;
	UnityActivationResponse* _tmp11_;
	GHashTable* _tmp12_;
};

struct _Block8Data {
	int _ref_count_;
	UnityScopeImpl * self;
	UnitySearchType search_type;
	gpointer _async_data_;
};

struct _UnityScopeImplScheduleSearchChangedData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	UnityScopeImpl* self;
	UnityLensSearch* search;
	UnitySearchType search_type;
	gboolean wait_for_view;
	Block8Data* _data8_;
	UnitySearchType _tmp0_;
	UnitySearchType _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	UnitySearchType _tmp6_;
	UnityViewType _tmp7_;
	gboolean _tmp8_;
	gboolean _tmp9_;
	UnitySearchType _tmp10_;
	UnityViewType _tmp11_;
	gboolean _tmp12_;
	gboolean _tmp13_;
	gboolean _tmp14_;
	gboolean waiting_needed;
	GCancellable** _tmp15_;
	gint _tmp15__length1;
	UnitySearchType _tmp16_;
	GCancellable* _tmp17_;
	GCancellable** _tmp18_;
	gint _tmp18__length1;
	UnitySearchType _tmp19_;
	GCancellable* _tmp20_;
	GCancellable* _tmp21_;
	GCancellable* cancellable;
	GCancellable** _tmp22_;
	gint _tmp22__length1;
	UnitySearchType _tmp23_;
	GCancellable* _tmp24_;
	GCancellable* _tmp25_;
	GCancellable* _tmp26_;
	gboolean _tmp27_;
	gulong _tmp28_;
	gulong view_sig_id;
	gulong _tmp29_;
	GCancellable* _tmp30_;
	gboolean _tmp31_;
	UnityScope* _tmp32_;
	UnityLensSearch* _tmp33_;
	UnitySearchType _tmp34_;
	GCancellable* _tmp35_;
};

struct _Block9Data {
	int _ref_count_;
	UnityScopeImpl * self;
	GHashTable* _result_;
	UnityLensSearch* s;
	gulong sig_id;
	gpointer _async_data_;
};

struct _UnityScopeImplSearchInternalData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	UnityScopeImpl* self;
	gchar* search_string;
	GHashTable* hints;
	UnitySearchType search_type;
	GHashTable* result;
	Block9Data* _data9_;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	UnitySearchType _tmp3_;
	gboolean is_global_search;
	DeeSerializableModel* _tmp4_;
	gboolean _tmp5_;
	DeeSerializableModel* _tmp6_;
	DeeSerializableModel* _tmp7_;
	const gchar* _tmp8_;
	GHashTable* _tmp9_;
	DeeSerializableModel* _tmp10_;
	UnityLensSearch* _tmp11_;
	UnityLensSearch* _tmp12_;
	UnityLensSearch* _tmp13_;
	gulong _tmp14_;
	UnityLensSearch* last_search;
	gulong ls_sig_id;
	UnityLensSearch* _tmp15_;
	UnitySearchType _tmp16_;
	gchar* _tmp17_;
	gchar* search_key;
	gboolean _tmp18_;
	gboolean _tmp19_;
	const gchar* _tmp20_;
	const gchar* _tmp21_;
	gchar** _tmp22_;
	gint _tmp22__length1;
	UnitySearchType _tmp23_;
	const gchar* _tmp24_;
	gboolean _tmp25_;
	gboolean _tmp26_;
	const gchar* _tmp27_;
	UnityLensSearch* _tmp28_;
	UnityScope* _tmp29_;
	UnitySearchType _tmp30_;
	UnityLensSearch* _tmp31_;
	gboolean _tmp32_;
	gboolean _tmp33_;
	gboolean _tmp34_;
	UnityLensSearch* _tmp35_;
	UnitySearchType _tmp36_;
	gchar** _tmp37_;
	gint _tmp37__length1;
	UnitySearchType _tmp38_;
	const gchar* _tmp39_;
	gchar* _tmp40_;
	gchar* _tmp41_;
	UnityScope* _tmp42_;
	UnityLensSearch* _tmp43_;
	UnitySearchType _tmp44_;
	UnityScope* _tmp45_;
	UnitySearchType _tmp46_;
	UnityLensSearch* _tmp47_;
	UnityLensSearch* _tmp48_;
	gboolean _tmp49_;
	UnityLensSearch* _tmp50_;
	UnityLensSearch* _tmp51_;
	gboolean _tmp52_;
	gboolean _tmp53_;
	UnityLensSearch* _tmp54_;
	gulong _tmp55_;
	UnityViewType _tmp56_;
	gboolean _tmp57_;
	UnityViewType _tmp58_;
	UnityViewType current_view;
	UnityViewType _tmp59_;
	UnityViewType _tmp60_;
	UnityViewType _tmp61_;
	UnityViewType old_view;
	UnityViewType _tmp62_;
	UnityViewType _tmp63_;
	GHashTable* _tmp64_;
	GHashTable* _tmp65_;
	GCancellable** _tmp66_;
	gint _tmp66__length1;
	UnitySearchType _tmp67_;
	GCancellable* _tmp68_;
	GCancellable* _tmp69_;
	GCancellable* cancellable;
	GCancellable* _tmp70_;
	gulong _tmp71_;
	gulong canc_id;
	gulong _tmp72_;
	UnityLensSearch* _tmp73_;
	gulong _tmp74_;
	UnityLensSearch* _tmp75_;
	gulong _tmp76_;
	GCancellable* _tmp77_;
	gulong _tmp78_;
	GCancellable* _tmp79_;
	gboolean _tmp80_;
	const gchar* _tmp81_;
	GError* _tmp82_;
	GHashTable* _tmp83_;
	GHashTable* _tmp84_;
	GError * _inner_error_;
};

struct _UnityScopeImplSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	UnityScopeImpl* self;
	gchar* search_string;
	GHashTable* hints;
	GHashTable* result;
	GHashTable* _result_;
	const gchar* _tmp0_;
	GHashTable* _tmp1_;
	GHashTable* _tmp2_;
	GHashTable* _tmp3_;
	GError * _inner_error_;
};

struct _UnityScopeImplGlobalSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	UnityScopeImpl* self;
	gchar* search_string;
	GHashTable* hints;
	GHashTable* result;
	GHashTable* _result_;
	const gchar* _tmp0_;
	GHashTable* _tmp1_;
	GHashTable* _tmp2_;
	GHashTable* _tmp3_;
	GError * _inner_error_;
};

struct _UnityScopeImplPreviewData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	UnityScopeImpl* self;
	gchar* uri;
	UnityPreviewReplyRaw result;
	UnityPreviewReplyRaw reply;
	UnityScope* _tmp0_;
	const gchar* _tmp1_;
	UnityPreview* _tmp2_;
	UnityPreview* response;
	UnityPreview* _tmp3_;
	UnityNoPreview* _tmp4_;
	UnityPreview* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	UnityPreview* _tmp8_;
	gchar* _tmp9_;
	UnityPreview* _tmp10_;
	GHashTable* _tmp11_;
};

struct _UnityScopeImplSetViewTypeData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	UnityScopeImpl* self;
	guint view_type_id;
	guint _tmp0_;
	UnityViewType view_type;
	UnityViewType _tmp1_;
	gboolean _tmp2_;
	UnityViewType _tmp3_;
	gboolean _tmp4_;
	UnityViewType _tmp5_;
	UnityScope* _tmp6_;
	gboolean _tmp7_;
	gboolean _tmp8_;
	gboolean _tmp9_;
	UnityScope* _tmp10_;
	gboolean _tmp11_;
};

struct _UnityScopeImplSetActiveSourcesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	UnityScopeImpl* self;
	gchar** sources;
	gint sources_length1;
	UnityScope* _tmp0_;
	gchar** _tmp1_;
	gint _tmp1__length1;
};


static gpointer unity_scope_impl_parent_class = NULL;
static UnityScopeServiceIface* unity_scope_impl_unity_scope_service_parent_iface = NULL;

GType unity_scope_service_proxy_get_type (void) G_GNUC_CONST;
guint unity_scope_service_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType unity_activation_reply_raw_get_type (void) G_GNUC_CONST;
UnityActivationReplyRaw* unity_activation_reply_raw_dup (const UnityActivationReplyRaw* self);
void unity_activation_reply_raw_free (UnityActivationReplyRaw* self);
void unity_activation_reply_raw_copy (const UnityActivationReplyRaw* self, UnityActivationReplyRaw* dest);
void unity_activation_reply_raw_destroy (UnityActivationReplyRaw* self);
GType unity_preview_reply_raw_get_type (void) G_GNUC_CONST;
UnityPreviewReplyRaw* unity_preview_reply_raw_dup (const UnityPreviewReplyRaw* self);
void unity_preview_reply_raw_free (UnityPreviewReplyRaw* self);
void unity_preview_reply_raw_copy (const UnityPreviewReplyRaw* self, UnityPreviewReplyRaw* dest);
void unity_preview_reply_raw_destroy (UnityPreviewReplyRaw* self);
GType unity_scope_service_get_type (void) G_GNUC_CONST;
GType unity_scope_impl_get_type (void) G_GNUC_CONST;
GType unity_view_type_get_type (void) G_GNUC_CONST;
#define UNITY_SCOPE_IMPL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), UNITY_TYPE_SCOPE_IMPL, UnityScopeImplPrivate))
enum  {
	UNITY_SCOPE_IMPL_DUMMY_PROPERTY,
	UNITY_SCOPE_IMPL_VIEW_TYPE
};
UnityScopeImpl* unity_scope_impl_new (UnityScope* owner);
UnityScopeImpl* unity_scope_impl_construct (GType object_type, UnityScope* owner);
static void unity_scope_impl_queue_info_changed (UnityScopeImpl* self);
static void _unity_scope_impl_queue_info_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _unity_scope_impl_queue_info_changed_unity_filter_changed (UnityFilter* _sender, gpointer self);
static void unity_scope_impl_create_models (UnityScopeImpl* self);
static gchar* unity_scope_impl_create_dbus_name (UnityScopeImpl* self);
static void unity_scope_impl_on_filter_added (UnityScopeImpl* self, DeeModel* model, DeeModelIter* iter);
static void _unity_scope_impl_on_filter_added_dee_model_row_added (DeeModel* _sender, DeeModelIter* iter, gpointer self);
static void unity_scope_impl_on_filter_changed (UnityScopeImpl* self, DeeModel* model, DeeModelIter* iter);
static void _unity_scope_impl_on_filter_changed_dee_model_row_changed (DeeModel* _sender, DeeModelIter* iter, gpointer self);
static void unity_scope_impl_on_filter_removed (UnityScopeImpl* self, DeeModel* model, DeeModelIter* iter);
static void _unity_scope_impl_on_filter_removed_dee_model_row_removed (DeeModel* _sender, DeeModelIter* iter, gpointer self);
static void unity_scope_impl_create_shared_models (UnityScopeImpl* self, const gchar* dbus_name);
void unity_scope_impl_export (UnityScopeImpl* self, GError** error);
static gboolean unity_scope_impl_emit_info_changed (UnityScopeImpl* self);
static gboolean _unity_scope_impl_emit_info_changed_gsource_func (gpointer self);
static void unity_scope_impl_queue_filters_changed (UnityScopeImpl* self);
static gboolean unity_scope_impl_emit_filters_changed (UnityScopeImpl* self);
static gboolean _unity_scope_impl_emit_filters_changed_gsource_func (gpointer self);
static gchar* unity_scope_impl_get_model_name (UnityScopeImpl* self, DeeSerializableModel* model);
GType unity_scope_info_get_type (void) G_GNUC_CONST;
UnityScopeInfo* unity_scope_info_dup (const UnityScopeInfo* self);
void unity_scope_info_free (UnityScopeInfo* self);
void unity_scope_info_copy (const UnityScopeInfo* self, UnityScopeInfo* dest);
void unity_scope_info_destroy (UnityScopeInfo* self);
GHashTable* unity_filter_get_hints (UnityFilter* self);
static GVariant* _variant_new65 (GHashTable* value);
static void _g_free0_ (gpointer var);
static void _g_variant_unref0_ (gpointer var);
GType unity_filter_column_get_type (void) G_GNUC_CONST;
#define UNITY_LENS_SOURCES_FILTER_ID "unity-sources"
void unity_filter_set_filtering (UnityFilter* self, gboolean value);
UnityFilterRenderer unity_filter_renderer_for_name (const gchar* renderer_name);
void unity_filter_set_model_and_iter (UnityFilter* self, DeeModel* model, DeeModelIter* iter);
static void unity_scope_impl_real_info_request_data_free (gpointer _data);
static void unity_scope_impl_real_info_request (UnityScopeService* base, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean unity_scope_impl_real_info_request_co (UnityScopeImplInfoRequestData* _data_);
static void unity_scope_impl_real_activate_data_free (gpointer _data);
static void unity_scope_impl_real_activate (UnityScopeService* base, const gchar* uri, guint action_type, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean unity_scope_impl_real_activate_co (UnityScopeImplActivateData* _data_);
GHashTable* unity_activation_response_get_hints (UnityActivationResponse* self);
static void unity_scope_impl_schedule_search_changed_data_free (gpointer _data);
void unity_scope_impl_schedule_search_changed (UnityScopeImpl* self, UnityLensSearch* search, UnitySearchType search_type, gboolean wait_for_view, GAsyncReadyCallback _callback_, gpointer _user_data_);
void unity_scope_impl_schedule_search_changed_finish (UnityScopeImpl* self, GAsyncResult* _res_);
static gboolean unity_scope_impl_schedule_search_changed_co (UnityScopeImplScheduleSearchChangedData* _data_);
static Block8Data* block8_data_ref (Block8Data* _data8_);
static void block8_data_unref (Block8Data* _data8_);
UnityViewType unity_scope_impl_get_view_type (UnityScopeImpl* self);
static void ___lambda2_ (Block8Data* _data8_);
static void ____lambda2__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static gboolean _unity_scope_impl_schedule_search_changed_co_gsource_func (gpointer self);
void unity_scope_impl_update_search_key (UnityScopeImpl* self, UnityLensSearch* ls, UnitySearchType search_type);
static gchar* unity_scope_impl_get_search_key (UnityScopeImpl* self, UnityLensSearch* ls, UnitySearchType search_type);
void unity_scope_set_last_search (UnityScope* self, UnityLensSearch* search, UnitySearchType search_type);
void unity_scope_impl_invalidate_search (UnityScopeImpl* self, UnitySearchType search_type);
static void unity_scope_impl_search_internal_data_free (gpointer _data);
static void unity_scope_impl_search_internal (UnityScopeImpl* self, const gchar* search_string, GHashTable* hints, UnitySearchType search_type, GAsyncReadyCallback _callback_, gpointer _user_data_);
static GHashTable* unity_scope_impl_search_internal_finish (UnityScopeImpl* self, GAsyncResult* _res_, GError** error);
static gboolean unity_scope_impl_search_internal_co (UnityScopeImplSearchInternalData* _data_);
static Block9Data* block9_data_ref (Block9Data* _data9_);
static void block9_data_unref (Block9Data* _data9_);
static void __lambda3_ (Block9Data* _data9_, UnityLensSearch* lens_search);
GHashTable* unity_lens_search_get_reply_hints (UnityLensSearch* self);
static void ___lambda3__unity_lens_search_finished (UnityLensSearch* _sender, gpointer self);
UnityLensSearch* unity_scope_get_last_search (UnityScope* self, UnitySearchType search_type);
gboolean unity_lens_search_was_finished (UnityLensSearch* self);
static void ____lambda4_ (Block9Data* _data9_);
static void _____lambda4__unity_lens_search_finished (UnityLensSearch* _sender, gpointer self);
void unity_scope_service_set_view_type (UnityScopeService* self, guint view_type, GAsyncReadyCallback _callback_, gpointer _user_data_);
void unity_scope_service_set_view_type_finish (UnityScopeService* self, GAsyncResult* _res_, GError** error);
static void __lambda5_ (Block9Data* _data9_);
static gboolean _unity_scope_impl_search_internal_co_gsource_func (gpointer self);
static void ___lambda5__gfunc (gconstpointer data, gpointer self);
static void unity_scope_impl_real_search_data_free (gpointer _data);
static void unity_scope_impl_real_search (UnityScopeService* base, const gchar* search_string, GHashTable* hints, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean unity_scope_impl_real_search_co (UnityScopeImplSearchData* _data_);
static void unity_scope_impl_search_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void unity_scope_impl_real_global_search_data_free (gpointer _data);
static void unity_scope_impl_real_global_search (UnityScopeService* base, const gchar* search_string, GHashTable* hints, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean unity_scope_impl_real_global_search_co (UnityScopeImplGlobalSearchData* _data_);
static void unity_scope_impl_global_search_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void unity_scope_impl_real_preview_data_free (gpointer _data);
static void unity_scope_impl_real_preview (UnityScopeService* base, const gchar* uri, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean unity_scope_impl_real_preview_co (UnityScopeImplPreviewData* _data_);
gchar* unity_preview_get_renderer_name (UnityPreview* self);
GHashTable* unity_preview_get_properties (UnityPreview* self);
static void unity_scope_impl_real_set_view_type_data_free (gpointer _data);
static void unity_scope_impl_real_set_view_type (UnityScopeService* base, guint view_type_id, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean unity_scope_impl_real_set_view_type_co (UnityScopeImplSetViewTypeData* _data_);
void unity_scope_impl_set_view_type (UnityScopeImpl* self, UnityViewType value);
static void unity_scope_impl_real_set_active_sources_data_free (gpointer _data);
static void unity_scope_impl_real_set_active_sources (UnityScopeService* base, gchar** sources, int sources_length1, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gchar** _vala_array_dup4 (gchar** self, int length);
static gboolean unity_scope_impl_real_set_active_sources_co (UnityScopeImplSetActiveSourcesData* _data_);
void unity_scope_set_active_sources_internal (UnityScope* self, gchar** active_sources_, int active_sources__length1);
static void unity_scope_impl_finalize (GObject* obj);
static void _vala_unity_scope_impl_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_unity_scope_impl_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void _unity_scope_impl_queue_info_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	unity_scope_impl_queue_info_changed (self);
}


static void _unity_scope_impl_queue_info_changed_unity_filter_changed (UnityFilter* _sender, gpointer self) {
	unity_scope_impl_queue_info_changed (self);
}


UnityScopeImpl* unity_scope_impl_construct (GType object_type, UnityScope* owner) {
	UnityScopeImpl * self = NULL;
	UnityScope* _tmp0_;
	UnityScope* _tmp1_;
	UnityScope* _tmp2_;
	UnityScope* _tmp3_;
	UnityScope* _tmp4_;
	UnityOptionsFilter* _tmp5_;
	UnityOptionsFilter* _tmp6_;
	g_return_val_if_fail (owner != NULL, NULL);
	self = (UnityScopeImpl*) g_object_new (object_type, NULL);
	_tmp0_ = owner;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_owner);
	self->priv->_owner = _tmp1_;
	_tmp2_ = self->priv->_owner;
	g_signal_connect_object ((GObject*) _tmp2_, "notify::search-in-global", (GCallback) _unity_scope_impl_queue_info_changed_g_object_notify, self, 0);
	_tmp3_ = self->priv->_owner;
	g_signal_connect_object ((GObject*) _tmp3_, "notify::visible", (GCallback) _unity_scope_impl_queue_info_changed_g_object_notify, self, 0);
	_tmp4_ = self->priv->_owner;
	_tmp5_ = unity_scope_get_sources (_tmp4_);
	_tmp6_ = _tmp5_;
	g_signal_connect_object ((UnityFilter*) _tmp6_, "changed", (GCallback) _unity_scope_impl_queue_info_changed_unity_filter_changed, self, 0);
	unity_scope_impl_create_models (self);
	return self;
}


UnityScopeImpl* unity_scope_impl_new (UnityScope* owner) {
	return unity_scope_impl_construct (UNITY_TYPE_SCOPE_IMPL, owner);
}


static gchar* unity_scope_impl_create_dbus_name (UnityScopeImpl* self) {
	gchar* result = NULL;
	time_t _tmp0_;
	guint t;
	UnityScope* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* dbus_path;
	gchar* _tmp5_;
	gchar* dbus_name;
	const gchar* _tmp6_;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	const gchar* _tmp12_;
	gchar* _tmp13_ = NULL;
	gchar* _tmp14_;
	gchar* _tmp15_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = time (NULL);
	t = (guint) _tmp0_;
	_tmp1_ = self->priv->_owner;
	_tmp2_ = unity_scope_get_dbus_path (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup (_tmp3_);
	dbus_path = _tmp4_;
	_tmp5_ = g_strdup ("com.canonical.Unity.Scope");
	dbus_name = _tmp5_;
	_tmp6_ = dbus_name;
	_tmp7_ = g_path_get_basename (dbus_path);
	_tmp8_ = _tmp7_;
	_tmp9_ = g_strconcat (".", _tmp8_, NULL);
	_tmp10_ = _tmp9_;
	_tmp11_ = g_strconcat (_tmp6_, _tmp10_, NULL);
	_g_free0 (dbus_name);
	dbus_name = _tmp11_;
	_g_free0 (_tmp10_);
	_g_free0 (_tmp8_);
	_tmp12_ = dbus_name;
	_tmp13_ = g_strdup_printf (".T%u", t);
	_tmp14_ = _tmp13_;
	_tmp15_ = g_strconcat (_tmp12_, _tmp14_, NULL);
	_g_free0 (dbus_name);
	dbus_name = _tmp15_;
	_g_free0 (_tmp14_);
	result = dbus_name;
	_g_free0 (dbus_path);
	return result;
}


static void _unity_scope_impl_on_filter_added_dee_model_row_added (DeeModel* _sender, DeeModelIter* iter, gpointer self) {
	unity_scope_impl_on_filter_added (self, _sender, iter);
}


static void _unity_scope_impl_on_filter_changed_dee_model_row_changed (DeeModel* _sender, DeeModelIter* iter, gpointer self) {
	unity_scope_impl_on_filter_changed (self, _sender, iter);
}


static void _unity_scope_impl_on_filter_removed_dee_model_row_removed (DeeModel* _sender, DeeModelIter* iter, gpointer self) {
	unity_scope_impl_on_filter_removed (self, _sender, iter);
}


static void unity_scope_impl_create_models (UnityScopeImpl* self) {
	DeeSequenceModel* _tmp0_;
	DeeSerializableModel* _tmp1_;
	DeeSequenceModel* _tmp2_;
	DeeSerializableModel* _tmp3_;
	DeeSequenceModel* _tmp4_;
	DeeSerializableModel* _tmp5_;
	DeeSerializableModel* _tmp6_;
	DeeSerializableModel* _tmp7_;
	DeeSerializableModel* _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp0_ = (DeeSequenceModel*) dee_sequence_model_new ();
	_g_object_unref0 (self->_results_model);
	self->_results_model = (DeeSerializableModel*) _tmp0_;
	_tmp1_ = self->_results_model;
	dee_model_set_schema ((DeeModel*) _tmp1_, "s", "s", "u", "s", "s", "s", "s", NULL);
	_tmp2_ = (DeeSequenceModel*) dee_sequence_model_new ();
	_g_object_unref0 (self->_global_results_model);
	self->_global_results_model = (DeeSerializableModel*) _tmp2_;
	_tmp3_ = self->_global_results_model;
	dee_model_set_schema ((DeeModel*) _tmp3_, "s", "s", "u", "s", "s", "s", "s", NULL);
	_tmp4_ = (DeeSequenceModel*) dee_sequence_model_new ();
	_g_object_unref0 (self->_filters_model);
	self->_filters_model = (DeeSerializableModel*) _tmp4_;
	_tmp5_ = self->_filters_model;
	dee_model_set_schema ((DeeModel*) _tmp5_, "s", "s", "s", "s", "a{sv}", "b", "b", "b", NULL);
	_tmp6_ = self->_filters_model;
	g_signal_connect_object ((DeeModel*) _tmp6_, "row-added", (GCallback) _unity_scope_impl_on_filter_added_dee_model_row_added, self, 0);
	_tmp7_ = self->_filters_model;
	g_signal_connect_object ((DeeModel*) _tmp7_, "row-changed", (GCallback) _unity_scope_impl_on_filter_changed_dee_model_row_changed, self, 0);
	_tmp8_ = self->_filters_model;
	g_signal_connect_object ((DeeModel*) _tmp8_, "row-removed", (GCallback) _unity_scope_impl_on_filter_removed_dee_model_row_removed, self, 0);
}


static void unity_scope_impl_create_shared_models (UnityScopeImpl* self, const gchar* dbus_name) {
	DeeSerializableModel* _tmp0_;
	DeeSerializableModel* _tmp1_;
	DeeSerializableModel* backend;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	DeeSerializableModel* _tmp5_;
	DeeModel* _tmp6_;
	DeeSharedModel* _tmp7_;
	DeeSerializableModel* _tmp8_;
	DeeSerializableModel* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	DeeSerializableModel* _tmp13_;
	DeeModel* _tmp14_;
	DeeSharedModel* _tmp15_;
	DeeSerializableModel* _tmp16_;
	DeeSerializableModel* _tmp17_;
	DeeSerializableModel* _tmp18_;
	guint _tmp19_ = 0U;
	DeeSerializableModel* _tmp20_;
	guint _tmp21_ = 0U;
	DeeSerializableModel* _tmp22_;
	guint _tmp23_ = 0U;
	const gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* _tmp26_;
	DeeSerializableModel* _tmp27_;
	DeeModel* _tmp28_;
	DeeSharedModel* _tmp29_;
	DeeSerializableModel* _tmp30_;
	DeeSerializableModel* _tmp31_;
	DeeSerializableModel* _tmp32_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (dbus_name != NULL);
	_tmp0_ = self->_results_model;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	backend = _tmp1_;
	_tmp2_ = dbus_name;
	_tmp3_ = g_strconcat (_tmp2_, ".Results", NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = backend;
	_tmp6_ = _g_object_ref0 ((DeeModel*) _tmp5_);
	_tmp7_ = (DeeSharedModel*) dee_shared_model_new_with_back_end (_tmp4_, _tmp6_);
	_g_object_unref0 (self->_results_model);
	self->_results_model = (DeeSerializableModel*) _tmp7_;
	_g_free0 (_tmp4_);
	_tmp8_ = self->_global_results_model;
	_tmp9_ = _g_object_ref0 (_tmp8_);
	_g_object_unref0 (backend);
	backend = _tmp9_;
	_tmp10_ = dbus_name;
	_tmp11_ = g_strconcat (_tmp10_, ".GlobalResults", NULL);
	_tmp12_ = _tmp11_;
	_tmp13_ = backend;
	_tmp14_ = _g_object_ref0 ((DeeModel*) _tmp13_);
	_tmp15_ = (DeeSharedModel*) dee_shared_model_new_with_back_end (_tmp12_, _tmp14_);
	_g_object_unref0 (self->_global_results_model);
	self->_global_results_model = (DeeSerializableModel*) _tmp15_;
	_g_free0 (_tmp12_);
	_tmp16_ = self->_filters_model;
	_tmp17_ = _g_object_ref0 (_tmp16_);
	_g_object_unref0 (backend);
	backend = _tmp17_;
	_tmp18_ = backend;
	g_signal_parse_name ("row-added", dee_model_get_type (), &_tmp19_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((DeeModel*) _tmp18_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp19_, 0, NULL, (GCallback) _unity_scope_impl_on_filter_added_dee_model_row_added, self);
	_tmp20_ = backend;
	g_signal_parse_name ("row-changed", dee_model_get_type (), &_tmp21_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((DeeModel*) _tmp20_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp21_, 0, NULL, (GCallback) _unity_scope_impl_on_filter_changed_dee_model_row_changed, self);
	_tmp22_ = backend;
	g_signal_parse_name ("row-removed", dee_model_get_type (), &_tmp23_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((DeeModel*) _tmp22_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp23_, 0, NULL, (GCallback) _unity_scope_impl_on_filter_removed_dee_model_row_removed, self);
	_tmp24_ = dbus_name;
	_tmp25_ = g_strconcat (_tmp24_, ".Filters", NULL);
	_tmp26_ = _tmp25_;
	_tmp27_ = backend;
	_tmp28_ = _g_object_ref0 ((DeeModel*) _tmp27_);
	_tmp29_ = (DeeSharedModel*) dee_shared_model_new_with_back_end (_tmp26_, _tmp28_);
	_g_object_unref0 (self->_filters_model);
	self->_filters_model = (DeeSerializableModel*) _tmp29_;
	_g_free0 (_tmp26_);
	_tmp30_ = self->_filters_model;
	g_signal_connect_object ((DeeModel*) _tmp30_, "row-added", (GCallback) _unity_scope_impl_on_filter_added_dee_model_row_added, self, 0);
	_tmp31_ = self->_filters_model;
	g_signal_connect_object ((DeeModel*) _tmp31_, "row-changed", (GCallback) _unity_scope_impl_on_filter_changed_dee_model_row_changed, self, 0);
	_tmp32_ = self->_filters_model;
	g_signal_connect_object ((DeeModel*) _tmp32_, "row-removed", (GCallback) _unity_scope_impl_on_filter_removed_dee_model_row_removed, self, 0);
	_g_object_unref0 (backend);
}


void unity_scope_impl_export (UnityScopeImpl* self, GError** error) {
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	GDBusConnection* _tmp2_ = NULL;
	GDBusConnection* conn;
	GDBusConnection* _tmp3_;
	UnityScope* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	guint _tmp7_ = 0U;
	guint _tmp8_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = unity_scope_impl_create_dbus_name (self);
	_tmp1_ = _tmp0_;
	unity_scope_impl_create_shared_models (self, _tmp1_);
	_g_free0 (_tmp1_);
	_tmp2_ = g_bus_get_sync (G_BUS_TYPE_SESSION, NULL, &_inner_error_);
	conn = _tmp2_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_IO_ERROR) {
			g_propagate_error (error, _inner_error_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp3_ = conn;
	_tmp4_ = self->priv->_owner;
	_tmp5_ = unity_scope_get_dbus_path (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = unity_scope_service_register_object (UNITY_IS_SCOPE_SERVICE (self) ? ((UnityScopeService*) self) : NULL, _tmp3_, _tmp6_, &_inner_error_);
	_tmp8_ = _tmp7_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_IO_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (conn);
			return;
		} else {
			_g_object_unref0 (conn);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	self->priv->_dbus_id = _tmp8_;
	unity_scope_impl_queue_info_changed (self);
	_g_object_unref0 (conn);
}


static gboolean _unity_scope_impl_emit_info_changed_gsource_func (gpointer self) {
	gboolean result;
	result = unity_scope_impl_emit_info_changed (self);
	return result;
}


static void unity_scope_impl_queue_info_changed (UnityScopeImpl* self) {
	guint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_info_changed_id;
	if (_tmp0_ == ((guint) 0)) {
		guint _tmp1_ = 0U;
		_tmp1_ = g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _unity_scope_impl_emit_info_changed_gsource_func, g_object_ref (self), g_object_unref);
		self->priv->_info_changed_id = _tmp1_;
	}
}


static gboolean _unity_scope_impl_emit_filters_changed_gsource_func (gpointer self) {
	gboolean result;
	result = unity_scope_impl_emit_filters_changed (self);
	return result;
}


static void unity_scope_impl_queue_filters_changed (UnityScopeImpl* self) {
	guint _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_filters_changed_id;
	if (_tmp0_ == ((guint) 0)) {
		guint _tmp1_ = 0U;
		_tmp1_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 0, _unity_scope_impl_emit_filters_changed_gsource_func, g_object_ref (self), g_object_unref);
		self->priv->_filters_changed_id = _tmp1_;
	}
}


static gboolean unity_scope_impl_emit_filters_changed (UnityScopeImpl* self) {
	gboolean result = FALSE;
	UnityScope* _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_owner;
	g_signal_emit_by_name (_tmp0_, "filters-changed");
	self->priv->_filters_changed_id = (guint) 0;
	result = FALSE;
	return result;
}


static gchar* unity_scope_impl_get_model_name (UnityScopeImpl* self, DeeSerializableModel* model) {
	gchar* result = NULL;
	DeeSerializableModel* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (model != NULL, NULL);
	_tmp0_ = model;
	if (DEE_IS_SHARED_MODEL (_tmp0_)) {
		DeeSerializableModel* _tmp1_;
		DeeSharedModel* _tmp2_;
		DeeSharedModel* shared_model;
		DeeSharedModel* _tmp3_;
		const gchar* _tmp4_ = NULL;
		gchar* _tmp5_;
		_tmp1_ = model;
		_tmp2_ = _g_object_ref0 (DEE_IS_SHARED_MODEL (_tmp1_) ? ((DeeSharedModel*) _tmp1_) : NULL);
		shared_model = _tmp2_;
		_tmp3_ = shared_model;
		_tmp4_ = dee_shared_model_get_swarm_name (_tmp3_);
		_tmp5_ = g_strdup (_tmp4_);
		result = _tmp5_;
		_g_object_unref0 (shared_model);
		return result;
	} else {
		gchar* _tmp6_;
		_tmp6_ = g_strdup ("<local>");
		result = _tmp6_;
		return result;
	}
}


static GVariant* _variant_new65 (GHashTable* value) {
	GVariantBuilder _tmp8_;
	GHashTableIter _tmp9_;
	gpointer _tmp10_;
	gpointer _tmp11_;
	g_hash_table_iter_init (&_tmp9_, value);
	g_variant_builder_init (&_tmp8_, G_VARIANT_TYPE ("a{sv}"));
	while (g_hash_table_iter_next (&_tmp9_, &_tmp10_, &_tmp11_)) {
		gchar* _key;
		GVariant* _value;
		_key = (gchar*) _tmp10_;
		_value = (GVariant*) _tmp11_;
		g_variant_builder_add (&_tmp8_, "{?*}", g_variant_new_string (_key), g_variant_new_variant (_value));
	}
	return g_variant_ref_sink (g_variant_builder_end (&_tmp8_));
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_variant_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_variant_unref (var), NULL));
}


static gboolean unity_scope_impl_emit_info_changed (UnityScopeImpl* self) {
	gboolean result = FALSE;
	UnityScopeInfo info = {0};
	UnityScope* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	UnityScope* _tmp4_;
	UnityOptionsFilter* _tmp5_;
	UnityOptionsFilter* _tmp6_;
	GHashTable* _tmp7_ = NULL;
	GVariant* _tmp12_;
	UnityScope* _tmp13_;
	gboolean _tmp14_;
	gboolean _tmp15_;
	gchar* _tmp16_;
	DeeSerializableModel* _tmp17_;
	gchar* _tmp18_ = NULL;
	DeeSerializableModel* _tmp19_;
	gchar* _tmp20_ = NULL;
	DeeSerializableModel* _tmp21_;
	gchar* _tmp22_ = NULL;
	GHashFunc _tmp23_;
	GEqualFunc _tmp24_;
	GHashTable* _tmp25_;
	UnityScopeInfo _tmp26_;
	g_return_val_if_fail (self != NULL, FALSE);
	memset (&info, 0, sizeof (UnityScopeInfo));
	_tmp0_ = self->priv->_owner;
	_tmp1_ = unity_scope_get_dbus_path (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 (info.dbus_path);
	info.dbus_path = _tmp3_;
	_tmp4_ = self->priv->_owner;
	_tmp5_ = unity_scope_get_sources (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = unity_filter_get_hints ((UnityFilter*) _tmp6_);
	_tmp12_ = _variant_new65 (_tmp7_);
	_g_variant_unref0 (info.sources);
	info.sources = _tmp12_;
	_tmp13_ = self->priv->_owner;
	_tmp14_ = unity_scope_get_search_in_global (_tmp13_);
	_tmp15_ = _tmp14_;
	info.search_in_global = _tmp15_;
	_tmp16_ = g_strdup ("<not implemented>");
	_g_free0 (info.private_connection_name);
	info.private_connection_name = _tmp16_;
	_tmp17_ = self->_results_model;
	_tmp18_ = unity_scope_impl_get_model_name (self, _tmp17_);
	_g_free0 (info.results_model_name);
	info.results_model_name = _tmp18_;
	_tmp19_ = self->_global_results_model;
	_tmp20_ = unity_scope_impl_get_model_name (self, _tmp19_);
	_g_free0 (info.global_results_model_name);
	info.global_results_model_name = _tmp20_;
	_tmp21_ = self->_filters_model;
	_tmp22_ = unity_scope_impl_get_model_name (self, _tmp21_);
	_g_free0 (info.filters_model_name);
	info.filters_model_name = _tmp22_;
	_tmp23_ = g_str_hash;
	_tmp24_ = g_str_equal;
	_tmp25_ = g_hash_table_new_full (_tmp23_, _tmp24_, _g_free0_, _g_variant_unref0_);
	_g_hash_table_unref0 (info.hints);
	info.hints = _tmp25_;
	_tmp26_ = info;
	g_signal_emit_by_name ((UnityScopeService*) self, "changed", &_tmp26_);
	self->priv->_info_changed_id = (guint) 0;
	result = FALSE;
	unity_scope_info_destroy (&info);
	return result;
}


static void unity_scope_impl_on_filter_added (UnityScopeImpl* self, DeeModel* model, DeeModelIter* iter) {
	DeeModel* _tmp0_;
	DeeModelIter* _tmp1_;
	const gchar* _tmp2_ = NULL;
	DeeModel* _tmp9_;
	DeeModelIter* _tmp10_;
	const gchar* _tmp11_ = NULL;
	gchar* _tmp12_;
	gchar* icon_hint_s;
	GIcon* icon_hint;
	UnityFilter* filter;
	DeeModel* _tmp20_;
	DeeModelIter* _tmp21_;
	const gchar* _tmp22_ = NULL;
	UnityFilterRenderer _tmp23_ = 0;
	UnityFilterRenderer renderer;
	UnityFilterRenderer _tmp24_;
	UnityFilter* _tmp65_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (model != NULL);
	g_return_if_fail (iter != NULL);
	_tmp0_ = model;
	_tmp1_ = iter;
	_tmp2_ = dee_model_get_string (_tmp0_, _tmp1_, (guint) UNITY_FILTER_COLUMN_ID);
	if (g_strcmp0 (_tmp2_, UNITY_LENS_SOURCES_FILTER_ID) == 0) {
		UnityScope* _tmp3_;
		UnityOptionsFilter* _tmp4_;
		UnityOptionsFilter* _tmp5_;
		DeeModel* _tmp6_;
		DeeModelIter* _tmp7_;
		gboolean _tmp8_ = FALSE;
		_tmp3_ = self->priv->_owner;
		_tmp4_ = unity_scope_get_sources (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = model;
		_tmp7_ = iter;
		_tmp8_ = dee_model_get_bool (_tmp6_, _tmp7_, (guint) UNITY_FILTER_COLUMN_FILTERING);
		unity_filter_set_filtering ((UnityFilter*) _tmp5_, _tmp8_);
		return;
	}
	_tmp9_ = model;
	_tmp10_ = iter;
	_tmp11_ = dee_model_get_string (_tmp9_, _tmp10_, (guint) UNITY_FILTER_COLUMN_ICON_HINT);
	_tmp12_ = g_strdup (_tmp11_);
	icon_hint_s = _tmp12_;
	icon_hint = NULL;
	{
		const gchar* _tmp13_;
		_tmp13_ = icon_hint_s;
		if (g_strcmp0 (_tmp13_, "") != 0) {
			const gchar* _tmp14_;
			GIcon* _tmp15_ = NULL;
			GIcon* _tmp16_;
			_tmp14_ = icon_hint_s;
			_tmp15_ = g_icon_new_for_string (_tmp14_, &_inner_error_);
			_tmp16_ = _tmp15_;
			if (_inner_error_ != NULL) {
				goto __catch22_g_error;
			}
			_g_object_unref0 (icon_hint);
			icon_hint = _tmp16_;
		}
	}
	goto __finally22;
	__catch22_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp17_;
		GError* _tmp18_;
		const gchar* _tmp19_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp17_ = icon_hint_s;
		_tmp18_ = e;
		_tmp19_ = _tmp18_->message;
		g_warning ("unity-scope-private.vala:194: Error parsing GIcon data '%s': %s", _tmp17_, _tmp19_);
		_g_error_free0 (e);
	}
	__finally22:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (icon_hint);
		_g_free0 (icon_hint_s);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	filter = NULL;
	_tmp20_ = model;
	_tmp21_ = iter;
	_tmp22_ = dee_model_get_string (_tmp20_, _tmp21_, (guint) UNITY_FILTER_COLUMN_RENDERER_NAME);
	_tmp23_ = unity_filter_renderer_for_name (_tmp22_);
	renderer = _tmp23_;
	_tmp24_ = renderer;
	switch (_tmp24_) {
		case UNITY_FILTER_RENDERER_RATINGS:
		{
			DeeModel* _tmp25_;
			DeeModelIter* _tmp26_;
			const gchar* _tmp27_ = NULL;
			DeeModel* _tmp28_;
			DeeModelIter* _tmp29_;
			const gchar* _tmp30_ = NULL;
			GIcon* _tmp31_;
			UnityRatingsFilter* _tmp32_;
			_tmp25_ = model;
			_tmp26_ = iter;
			_tmp27_ = dee_model_get_string (_tmp25_, _tmp26_, (guint) UNITY_FILTER_COLUMN_ID);
			_tmp28_ = model;
			_tmp29_ = iter;
			_tmp30_ = dee_model_get_string (_tmp28_, _tmp29_, (guint) UNITY_FILTER_COLUMN_NAME);
			_tmp31_ = icon_hint;
			_tmp32_ = unity_ratings_filter_new (_tmp27_, _tmp30_, _tmp31_, FALSE);
			_g_object_unref0 (filter);
			filter = (UnityFilter*) _tmp32_;
			break;
		}
		case UNITY_FILTER_RENDERER_RADIO_OPTIONS:
		{
			DeeModel* _tmp33_;
			DeeModelIter* _tmp34_;
			const gchar* _tmp35_ = NULL;
			DeeModel* _tmp36_;
			DeeModelIter* _tmp37_;
			const gchar* _tmp38_ = NULL;
			GIcon* _tmp39_;
			UnityRadioOptionFilter* _tmp40_;
			_tmp33_ = model;
			_tmp34_ = iter;
			_tmp35_ = dee_model_get_string (_tmp33_, _tmp34_, (guint) UNITY_FILTER_COLUMN_ID);
			_tmp36_ = model;
			_tmp37_ = iter;
			_tmp38_ = dee_model_get_string (_tmp36_, _tmp37_, (guint) UNITY_FILTER_COLUMN_NAME);
			_tmp39_ = icon_hint;
			_tmp40_ = unity_radio_option_filter_new (_tmp35_, _tmp38_, _tmp39_, FALSE);
			_g_object_unref0 (filter);
			filter = (UnityFilter*) _tmp40_;
			break;
		}
		case UNITY_FILTER_RENDERER_CHECK_OPTIONS:
		{
			DeeModel* _tmp41_;
			DeeModelIter* _tmp42_;
			const gchar* _tmp43_ = NULL;
			DeeModel* _tmp44_;
			DeeModelIter* _tmp45_;
			const gchar* _tmp46_ = NULL;
			GIcon* _tmp47_;
			UnityCheckOptionFilter* _tmp48_;
			_tmp41_ = model;
			_tmp42_ = iter;
			_tmp43_ = dee_model_get_string (_tmp41_, _tmp42_, (guint) UNITY_FILTER_COLUMN_ID);
			_tmp44_ = model;
			_tmp45_ = iter;
			_tmp46_ = dee_model_get_string (_tmp44_, _tmp45_, (guint) UNITY_FILTER_COLUMN_NAME);
			_tmp47_ = icon_hint;
			_tmp48_ = unity_check_option_filter_new (_tmp43_, _tmp46_, _tmp47_, FALSE);
			_g_object_unref0 (filter);
			filter = (UnityFilter*) _tmp48_;
			break;
		}
		case UNITY_FILTER_RENDERER_CHECK_OPTIONS_COMPACT:
		{
			DeeModel* _tmp49_;
			DeeModelIter* _tmp50_;
			const gchar* _tmp51_ = NULL;
			DeeModel* _tmp52_;
			DeeModelIter* _tmp53_;
			const gchar* _tmp54_ = NULL;
			GIcon* _tmp55_;
			UnityCheckOptionFilterCompact* _tmp56_;
			_tmp49_ = model;
			_tmp50_ = iter;
			_tmp51_ = dee_model_get_string (_tmp49_, _tmp50_, (guint) UNITY_FILTER_COLUMN_ID);
			_tmp52_ = model;
			_tmp53_ = iter;
			_tmp54_ = dee_model_get_string (_tmp52_, _tmp53_, (guint) UNITY_FILTER_COLUMN_NAME);
			_tmp55_ = icon_hint;
			_tmp56_ = unity_check_option_filter_compact_new (_tmp51_, _tmp54_, _tmp55_, FALSE);
			_g_object_unref0 (filter);
			filter = (UnityFilter*) _tmp56_;
			break;
		}
		case UNITY_FILTER_RENDERER_MULTIRANGE:
		{
			DeeModel* _tmp57_;
			DeeModelIter* _tmp58_;
			const gchar* _tmp59_ = NULL;
			DeeModel* _tmp60_;
			DeeModelIter* _tmp61_;
			const gchar* _tmp62_ = NULL;
			GIcon* _tmp63_;
			UnityMultiRangeFilter* _tmp64_;
			_tmp57_ = model;
			_tmp58_ = iter;
			_tmp59_ = dee_model_get_string (_tmp57_, _tmp58_, (guint) UNITY_FILTER_COLUMN_ID);
			_tmp60_ = model;
			_tmp61_ = iter;
			_tmp62_ = dee_model_get_string (_tmp60_, _tmp61_, (guint) UNITY_FILTER_COLUMN_NAME);
			_tmp63_ = icon_hint;
			_tmp64_ = unity_multi_range_filter_new (_tmp59_, _tmp62_, _tmp63_, FALSE);
			_g_object_unref0 (filter);
			filter = (UnityFilter*) _tmp64_;
			break;
		}
		default:
		break;
	}
	_tmp65_ = filter;
	if (UNITY_IS_FILTER (_tmp65_)) {
		UnityFilter* _tmp66_;
		DeeModel* _tmp67_;
		DeeModelIter* _tmp68_;
		UnityScope* _tmp69_;
		UnityFilter* _tmp70_;
		UnityFilter* _tmp71_;
		_tmp66_ = filter;
		_tmp67_ = model;
		_tmp68_ = iter;
		unity_filter_set_model_and_iter (_tmp66_, _tmp67_, _tmp68_);
		_tmp69_ = self->priv->_owner;
		_tmp70_ = filter;
		_tmp71_ = _g_object_ref0 (_tmp70_);
		_tmp69_->_filters = g_list_append (_tmp69_->_filters, _tmp71_);
		unity_scope_impl_queue_filters_changed (self);
	}
	_g_object_unref0 (filter);
	_g_object_unref0 (icon_hint);
	_g_free0 (icon_hint_s);
}


static void unity_scope_impl_on_filter_changed (UnityScopeImpl* self, DeeModel* model, DeeModelIter* iter) {
	DeeModel* _tmp0_;
	DeeModelIter* _tmp1_;
	const gchar* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (model != NULL);
	g_return_if_fail (iter != NULL);
	_tmp0_ = model;
	_tmp1_ = iter;
	_tmp2_ = dee_model_get_string (_tmp0_, _tmp1_, (guint) UNITY_FILTER_COLUMN_ID);
	if (g_strcmp0 (_tmp2_, UNITY_LENS_SOURCES_FILTER_ID) == 0) {
		UnityScope* _tmp3_;
		UnityOptionsFilter* _tmp4_;
		UnityOptionsFilter* _tmp5_;
		DeeModel* _tmp6_;
		DeeModelIter* _tmp7_;
		gboolean _tmp8_ = FALSE;
		_tmp3_ = self->priv->_owner;
		_tmp4_ = unity_scope_get_sources (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = model;
		_tmp7_ = iter;
		_tmp8_ = dee_model_get_bool (_tmp6_, _tmp7_, (guint) UNITY_FILTER_COLUMN_FILTERING);
		unity_filter_set_filtering ((UnityFilter*) _tmp5_, _tmp8_);
		return;
	}
	unity_scope_impl_queue_filters_changed (self);
}


static void unity_scope_impl_on_filter_removed (UnityScopeImpl* self, DeeModel* model, DeeModelIter* iter) {
	gboolean dirty;
	UnityScope* _tmp0_;
	GList* _tmp1_;
	gboolean _tmp11_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (model != NULL);
	g_return_if_fail (iter != NULL);
	dirty = FALSE;
	_tmp0_ = self->priv->_owner;
	_tmp1_ = _tmp0_->_filters;
	{
		GList* filter_collection = NULL;
		GList* filter_it = NULL;
		filter_collection = _tmp1_;
		for (filter_it = filter_collection; filter_it != NULL; filter_it = filter_it->next) {
			UnityFilter* _tmp2_;
			UnityFilter* filter = NULL;
			_tmp2_ = _g_object_ref0 ((UnityFilter*) filter_it->data);
			filter = _tmp2_;
			{
				UnityFilter* _tmp3_;
				const gchar* _tmp4_;
				const gchar* _tmp5_;
				DeeModel* _tmp6_;
				DeeModelIter* _tmp7_;
				const gchar* _tmp8_ = NULL;
				_tmp3_ = filter;
				_tmp4_ = unity_filter_get_id (_tmp3_);
				_tmp5_ = _tmp4_;
				_tmp6_ = model;
				_tmp7_ = iter;
				_tmp8_ = dee_model_get_string (_tmp6_, _tmp7_, (guint) UNITY_FILTER_COLUMN_ID);
				if (g_strcmp0 (_tmp5_, _tmp8_) == 0) {
					UnityScope* _tmp9_;
					UnityFilter* _tmp10_;
					dirty = TRUE;
					_tmp9_ = self->priv->_owner;
					_tmp10_ = filter;
					_tmp9_->_filters = g_list_remove (_tmp9_->_filters, _tmp10_);
					_g_object_unref0 (filter);
					break;
				}
				_g_object_unref0 (filter);
			}
		}
	}
	_tmp11_ = dirty;
	if (_tmp11_) {
		unity_scope_impl_queue_filters_changed (self);
	}
}


static void unity_scope_impl_real_info_request_data_free (gpointer _data) {
	UnityScopeImplInfoRequestData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (UnityScopeImplInfoRequestData, _data_);
}


static void unity_scope_impl_real_info_request (UnityScopeService* base, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UnityScopeImpl * self;
	UnityScopeImplInfoRequestData* _data_;
	UnityScopeImpl* _tmp0_;
	self = (UnityScopeImpl*) base;
	_data_ = g_slice_new0 (UnityScopeImplInfoRequestData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, unity_scope_impl_real_info_request);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, unity_scope_impl_real_info_request_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	unity_scope_impl_real_info_request_co (_data_);
}


static void unity_scope_impl_real_info_request_finish (UnityScopeService* base, GAsyncResult* _res_, GError** error) {
	UnityScopeImplInfoRequestData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static gboolean unity_scope_impl_real_info_request_co (UnityScopeImplInfoRequestData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	unity_scope_impl_queue_info_changed (_data_->self);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void unity_scope_impl_real_activate_data_free (gpointer _data) {
	UnityScopeImplActivateData* _data_;
	_data_ = _data;
	_g_free0 (_data_->uri);
	unity_activation_reply_raw_destroy (&_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (UnityScopeImplActivateData, _data_);
}


static void unity_scope_impl_real_activate (UnityScopeService* base, const gchar* uri, guint action_type, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UnityScopeImpl * self;
	UnityScopeImplActivateData* _data_;
	UnityScopeImpl* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	guint _tmp3_;
	self = (UnityScopeImpl*) base;
	_data_ = g_slice_new0 (UnityScopeImplActivateData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, unity_scope_impl_real_activate);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, unity_scope_impl_real_activate_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = uri;
	_tmp2_ = g_strdup (_tmp1_);
	_data_->uri = _tmp2_;
	_tmp3_ = action_type;
	_data_->action_type = _tmp3_;
	unity_scope_impl_real_activate_co (_data_);
}


static void unity_scope_impl_real_activate_finish (UnityScopeService* base, GAsyncResult* _res_, UnityActivationReplyRaw* result, GError** error) {
	UnityScopeImplActivateData* _data_;
	UnityActivationReplyRaw _tmp0_ = {0};
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	unity_activation_reply_raw_copy (&_data_->result, &_tmp0_);
	*result = _tmp0_;
}


static gboolean unity_scope_impl_real_activate_co (UnityScopeImplActivateData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	memset (&_data_->reply, 0, sizeof (UnityActivationReplyRaw));
	_data_->_tmp0_ = _data_->self->priv->_owner;
	_data_->_tmp1_ = _data_->uri;
	_data_->_tmp2_ = NULL;
	g_signal_emit_by_name (_data_->_tmp0_, "activate-uri", _data_->_tmp1_, &_data_->_tmp2_);
	_data_->response = _data_->_tmp2_;
	_data_->_tmp3_ = _data_->response;
	if (_data_->_tmp3_ == NULL) {
		_data_->_tmp4_ = unity_activation_response_new (UNITY_HANDLED_TYPE_NOT_HANDLED, "");
		_data_->_tmp5_ = g_object_ref_sink (_data_->_tmp4_);
		_g_object_unref0 (_data_->response);
		_data_->response = _data_->_tmp5_;
	}
	_data_->_tmp6_ = _data_->uri;
	_data_->_tmp7_ = g_strdup (_data_->_tmp6_);
	_g_free0 (_data_->reply.uri);
	_data_->reply.uri = _data_->_tmp7_;
	_data_->_tmp8_ = _data_->response;
	_data_->_tmp9_ = unity_activation_response_get_handled (_data_->_tmp8_);
	_data_->_tmp10_ = _data_->_tmp9_;
	_data_->reply.handled = (guint) _data_->_tmp10_;
	_data_->_tmp11_ = _data_->response;
	_data_->_tmp12_ = NULL;
	_data_->_tmp12_ = unity_activation_response_get_hints (_data_->_tmp11_);
	_g_hash_table_unref0 (_data_->reply.hints);
	_data_->reply.hints = _data_->_tmp12_;
	_data_->result = _data_->reply;
	_g_object_unref0 (_data_->response);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	_g_object_unref0 (_data_->response);
	unity_activation_reply_raw_destroy (&_data_->reply);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void unity_scope_impl_schedule_search_changed_data_free (gpointer _data) {
	UnityScopeImplScheduleSearchChangedData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->search);
	_g_object_unref0 (_data_->self);
	g_slice_free (UnityScopeImplScheduleSearchChangedData, _data_);
}


void unity_scope_impl_schedule_search_changed (UnityScopeImpl* self, UnityLensSearch* search, UnitySearchType search_type, gboolean wait_for_view, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UnityScopeImplScheduleSearchChangedData* _data_;
	UnityScopeImpl* _tmp0_;
	UnityLensSearch* _tmp1_;
	UnityLensSearch* _tmp2_;
	UnitySearchType _tmp3_;
	gboolean _tmp4_;
	_data_ = g_slice_new0 (UnityScopeImplScheduleSearchChangedData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, unity_scope_impl_schedule_search_changed);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, unity_scope_impl_schedule_search_changed_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = search;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_data_->search = _tmp2_;
	_tmp3_ = search_type;
	_data_->search_type = _tmp3_;
	_tmp4_ = wait_for_view;
	_data_->wait_for_view = _tmp4_;
	unity_scope_impl_schedule_search_changed_co (_data_);
}


void unity_scope_impl_schedule_search_changed_finish (UnityScopeImpl* self, GAsyncResult* _res_) {
	UnityScopeImplScheduleSearchChangedData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static Block8Data* block8_data_ref (Block8Data* _data8_) {
	g_atomic_int_inc (&_data8_->_ref_count_);
	return _data8_;
}


static void block8_data_unref (Block8Data* _data8_) {
	if (g_atomic_int_dec_and_test (&_data8_->_ref_count_)) {
		_g_object_unref0 (_data8_->self);
		g_slice_free (Block8Data, _data8_);
	}
}


static void ___lambda2_ (Block8Data* _data8_) {
	UnityScopeImpl * self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	UnitySearchType _tmp2_;
	gboolean _tmp4_;
	gboolean _tmp9_;
	gboolean resume;
	gboolean _tmp10_;
	self = _data8_->self;
	_tmp2_ = _data8_->search_type;
	if (_tmp2_ == UNITY_SEARCH_TYPE_DEFAULT) {
		UnityViewType _tmp3_;
		_tmp3_ = self->priv->_view_type;
		_tmp1_ = _tmp3_ == UNITY_VIEW_TYPE_LENS_VIEW;
	} else {
		_tmp1_ = FALSE;
	}
	_tmp4_ = _tmp1_;
	if (_tmp4_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp5_ = FALSE;
		UnitySearchType _tmp6_;
		gboolean _tmp8_;
		_tmp6_ = _data8_->search_type;
		if (_tmp6_ == UNITY_SEARCH_TYPE_GLOBAL) {
			UnityViewType _tmp7_;
			_tmp7_ = self->priv->_view_type;
			_tmp5_ = _tmp7_ == UNITY_VIEW_TYPE_HOME_VIEW;
		} else {
			_tmp5_ = FALSE;
		}
		_tmp8_ = _tmp5_;
		_tmp0_ = _tmp8_;
	}
	_tmp9_ = _tmp0_;
	resume = _tmp9_;
	_tmp10_ = resume;
	if (_tmp10_) {
		unity_scope_impl_schedule_search_changed_co (_data8_->_async_data_);
	}
}


static void ____lambda2__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	___lambda2_ (self);
}


static gboolean _unity_scope_impl_schedule_search_changed_co_gsource_func (gpointer self) {
	gboolean result;
	result = unity_scope_impl_schedule_search_changed_co (self);
	return result;
}


static gboolean unity_scope_impl_schedule_search_changed_co (UnityScopeImplScheduleSearchChangedData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data8_ = g_slice_new0 (Block8Data);
	_data_->_data8_->_ref_count_ = 1;
	_data_->_data8_->self = g_object_ref (_data_->self);
	_data_->_tmp0_ = _data_->search_type;
	_data_->_data8_->search_type = _data_->_tmp0_;
	_data_->_data8_->_async_data_ = _data_;
	_data_->_tmp1_ = _data_->_data8_->search_type;
	if (_data_->_tmp1_ >= UNITY_SEARCH_TYPE_N_TYPES) {
		block8_data_unref (_data_->_data8_);
		_data_->_data8_ = NULL;
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp3_ = _data_->wait_for_view;
	if (_data_->_tmp3_) {
		_data_->_tmp6_ = _data_->_data8_->search_type;
		if (_data_->_tmp6_ == UNITY_SEARCH_TYPE_GLOBAL) {
			_data_->_tmp7_ = _data_->self->priv->_view_type;
			_data_->_tmp5_ = _data_->_tmp7_ != UNITY_VIEW_TYPE_HOME_VIEW;
		} else {
			_data_->_tmp5_ = FALSE;
		}
		_data_->_tmp8_ = _data_->_tmp5_;
		if (_data_->_tmp8_) {
			_data_->_tmp4_ = TRUE;
		} else {
			_data_->_tmp10_ = _data_->_data8_->search_type;
			if (_data_->_tmp10_ == UNITY_SEARCH_TYPE_DEFAULT) {
				_data_->_tmp11_ = _data_->self->priv->_view_type;
				_data_->_tmp9_ = _data_->_tmp11_ != UNITY_VIEW_TYPE_LENS_VIEW;
			} else {
				_data_->_tmp9_ = FALSE;
			}
			_data_->_tmp12_ = _data_->_tmp9_;
			_data_->_tmp4_ = _data_->_tmp12_;
		}
		_data_->_tmp13_ = _data_->_tmp4_;
		_data_->_tmp2_ = _data_->_tmp13_;
	} else {
		_data_->_tmp2_ = FALSE;
	}
	_data_->_tmp14_ = _data_->_tmp2_;
	_data_->waiting_needed = _data_->_tmp14_;
	_data_->_tmp15_ = _data_->self->priv->cancellable_arr;
	_data_->_tmp15__length1 = _data_->self->priv->cancellable_arr_length1;
	_data_->_tmp16_ = _data_->_data8_->search_type;
	_data_->_tmp17_ = _data_->_tmp15_[_data_->_tmp16_];
	if (_data_->_tmp17_ != NULL) {
		_data_->_tmp18_ = _data_->self->priv->cancellable_arr;
		_data_->_tmp18__length1 = _data_->self->priv->cancellable_arr_length1;
		_data_->_tmp19_ = _data_->_data8_->search_type;
		_data_->_tmp20_ = _data_->_tmp18_[_data_->_tmp19_];
		g_cancellable_cancel (_data_->_tmp20_);
	}
	_data_->_tmp21_ = g_cancellable_new ();
	_data_->cancellable = _data_->_tmp21_;
	_data_->_tmp22_ = _data_->self->priv->cancellable_arr;
	_data_->_tmp22__length1 = _data_->self->priv->cancellable_arr_length1;
	_data_->_tmp23_ = _data_->_data8_->search_type;
	_data_->_tmp24_ = _data_->cancellable;
	_data_->_tmp25_ = _g_object_ref0 (_data_->_tmp24_);
	_g_object_unref0 (_data_->_tmp22_[_data_->_tmp23_]);
	_data_->_tmp22_[_data_->_tmp23_] = _data_->_tmp25_;
	_data_->_tmp26_ = _data_->_tmp22_[_data_->_tmp23_];
	_data_->_tmp27_ = _data_->waiting_needed;
	if (_data_->_tmp27_) {
		_data_->_tmp28_ = 0UL;
		_data_->_tmp28_ = g_signal_connect_data ((GObject*) _data_->self, "notify::view-type", (GCallback) ____lambda2__g_object_notify, block8_data_ref (_data_->_data8_), (GClosureNotify) block8_data_unref, 0);
		_data_->view_sig_id = _data_->_tmp28_;
		_data_->_state_ = 1;
		return FALSE;
		_state_1:
		;
		_data_->_tmp29_ = _data_->view_sig_id;
		g_signal_handler_disconnect (_data_->self, _data_->_tmp29_);
	}
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _unity_scope_impl_schedule_search_changed_co_gsource_func, _data_, NULL);
	_data_->_state_ = 2;
	return FALSE;
	_state_2:
	;
	_data_->_tmp30_ = _data_->cancellable;
	_data_->_tmp31_ = FALSE;
	_data_->_tmp31_ = g_cancellable_is_cancelled (_data_->_tmp30_);
	if (_data_->_tmp31_) {
		_g_object_unref0 (_data_->cancellable);
		block8_data_unref (_data_->_data8_);
		_data_->_data8_ = NULL;
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp32_ = _data_->self->priv->_owner;
	_data_->_tmp33_ = _data_->search;
	_data_->_tmp34_ = _data_->_data8_->search_type;
	_data_->_tmp35_ = _data_->cancellable;
	g_signal_emit_by_name (_data_->_tmp32_, "search-changed", _data_->_tmp33_, _data_->_tmp34_, _data_->_tmp35_);
	_g_object_unref0 (_data_->cancellable);
	block8_data_unref (_data_->_data8_);
	_data_->_data8_ = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


void unity_scope_impl_update_search_key (UnityScopeImpl* self, UnityLensSearch* ls, UnitySearchType search_type) {
	UnitySearchType _tmp0_;
	UnityLensSearch* _tmp1_;
	UnitySearchType _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* search_key;
	gchar** _tmp4_;
	gint _tmp4__length1;
	UnitySearchType _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	UnityScope* _tmp8_;
	UnityLensSearch* _tmp9_;
	UnitySearchType _tmp10_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (ls != NULL);
	_tmp0_ = search_type;
	g_return_if_fail (_tmp0_ < UNITY_SEARCH_TYPE_N_TYPES);
	_tmp1_ = ls;
	_tmp2_ = search_type;
	_tmp3_ = unity_scope_impl_get_search_key (self, _tmp1_, _tmp2_);
	search_key = _tmp3_;
	_tmp4_ = self->priv->search_keys;
	_tmp4__length1 = self->priv->search_keys_length1;
	_tmp5_ = search_type;
	_tmp6_ = g_strdup (search_key);
	_g_free0 (_tmp4_[_tmp5_]);
	_tmp4_[_tmp5_] = _tmp6_;
	_tmp7_ = _tmp4_[_tmp5_];
	_tmp8_ = self->priv->_owner;
	_tmp9_ = ls;
	_tmp10_ = search_type;
	unity_scope_set_last_search (_tmp8_, _tmp9_, _tmp10_);
	_g_free0 (search_key);
}


static gchar* unity_scope_impl_get_search_key (UnityScopeImpl* self, UnityLensSearch* ls, UnitySearchType search_type) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	UnitySearchType _tmp1_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* search_key;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (ls != NULL, NULL);
	_tmp1_ = search_type;
	if (_tmp1_ == UNITY_SEARCH_TYPE_DEFAULT) {
		UnityScope* _tmp2_;
		UnityLensSearch* _tmp3_;
		gchar* _tmp4_ = NULL;
		_tmp2_ = self->priv->_owner;
		_tmp3_ = ls;
		g_signal_emit_by_name (_tmp2_, "generate-search-key::default", _tmp3_, &_tmp4_);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp4_;
	} else {
		UnityScope* _tmp5_;
		UnityLensSearch* _tmp6_;
		gchar* _tmp7_ = NULL;
		_tmp5_ = self->priv->_owner;
		_tmp6_ = ls;
		g_signal_emit_by_name (_tmp5_, "generate-search-key::global", _tmp6_, &_tmp7_);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp7_;
	}
	_tmp8_ = _tmp0_;
	_tmp9_ = g_strdup (_tmp8_);
	search_key = _tmp9_;
	result = search_key;
	_g_free0 (_tmp0_);
	return result;
}


void unity_scope_impl_invalidate_search (UnityScopeImpl* self, UnitySearchType search_type) {
	UnitySearchType _tmp0_;
	gchar** _tmp1_;
	gint _tmp1__length1;
	UnitySearchType _tmp2_;
	gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = search_type;
	g_return_if_fail (_tmp0_ < UNITY_SEARCH_TYPE_N_TYPES);
	_tmp1_ = self->priv->search_keys;
	_tmp1__length1 = self->priv->search_keys_length1;
	_tmp2_ = search_type;
	_g_free0 (_tmp1_[_tmp2_]);
	_tmp1_[_tmp2_] = NULL;
	_tmp3_ = _tmp1_[_tmp2_];
}


static void unity_scope_impl_search_internal_data_free (gpointer _data) {
	UnityScopeImplSearchInternalData* _data_;
	_data_ = _data;
	_g_free0 (_data_->search_string);
	_g_hash_table_unref0 (_data_->hints);
	_g_hash_table_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (UnityScopeImplSearchInternalData, _data_);
}


static gpointer _g_hash_table_ref0 (gpointer self) {
	return self ? g_hash_table_ref (self) : NULL;
}


static void unity_scope_impl_search_internal (UnityScopeImpl* self, const gchar* search_string, GHashTable* hints, UnitySearchType search_type, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UnityScopeImplSearchInternalData* _data_;
	UnityScopeImpl* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	GHashTable* _tmp3_;
	GHashTable* _tmp4_;
	UnitySearchType _tmp5_;
	_data_ = g_slice_new0 (UnityScopeImplSearchInternalData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, unity_scope_impl_search_internal);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, unity_scope_impl_search_internal_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = search_string;
	_tmp2_ = g_strdup (_tmp1_);
	_data_->search_string = _tmp2_;
	_tmp3_ = hints;
	_tmp4_ = _g_hash_table_ref0 (_tmp3_);
	_data_->hints = _tmp4_;
	_tmp5_ = search_type;
	_data_->search_type = _tmp5_;
	unity_scope_impl_search_internal_co (_data_);
}


static GHashTable* unity_scope_impl_search_internal_finish (UnityScopeImpl* self, GAsyncResult* _res_, GError** error) {
	GHashTable* result;
	UnityScopeImplSearchInternalData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static Block9Data* block9_data_ref (Block9Data* _data9_) {
	g_atomic_int_inc (&_data9_->_ref_count_);
	return _data9_;
}


static void block9_data_unref (Block9Data* _data9_) {
	if (g_atomic_int_dec_and_test (&_data9_->_ref_count_)) {
		_g_object_unref0 (_data9_->self);
		_g_object_unref0 (_data9_->s);
		_g_hash_table_unref0 (_data9_->_result_);
		g_slice_free (Block9Data, _data9_);
	}
}


static gpointer _g_variant_ref0 (gpointer self) {
	return self ? g_variant_ref (self) : NULL;
}


static void __lambda3_ (Block9Data* _data9_, UnityLensSearch* lens_search) {
	UnityScopeImpl * self;
	UnityLensSearch* _tmp0_;
	GHashTable* _tmp1_ = NULL;
	GHashTable* reply_hints;
	GHashTable* _tmp2_;
	GHashTable* _tmp12_;
	gchar* _tmp13_;
	UnityLensSearch* _tmp14_;
	DeeSerializableModel* _tmp15_;
	DeeSerializableModel* _tmp16_;
	guint64 _tmp17_ = 0ULL;
	GVariant* _tmp18_;
	GVariant* _tmp19_;
	self = _data9_->self;
	g_return_if_fail (lens_search != NULL);
	_tmp0_ = lens_search;
	_tmp1_ = unity_lens_search_get_reply_hints (_tmp0_);
	reply_hints = _tmp1_;
	_tmp2_ = reply_hints;
	if (_tmp2_ != NULL) {
		GHashTable* _tmp3_;
		GHashTableIter iter = {0};
		const gchar* key = NULL;
		GVariant* variant = NULL;
		_tmp3_ = reply_hints;
		g_hash_table_iter_init (&iter, _tmp3_);
		while (TRUE) {
			gconstpointer _tmp4_ = NULL;
			gconstpointer _tmp5_ = NULL;
			gboolean _tmp6_ = FALSE;
			GHashTable* _tmp7_;
			const gchar* _tmp8_;
			gchar* _tmp9_;
			GVariant* _tmp10_;
			GVariant* _tmp11_;
			_tmp6_ = g_hash_table_iter_next (&iter, &_tmp4_, &_tmp5_);
			key = _tmp4_;
			variant = _tmp5_;
			if (!_tmp6_) {
				break;
			}
			_tmp7_ = _data9_->_result_;
			_tmp8_ = key;
			_tmp9_ = g_strdup (_tmp8_);
			_tmp10_ = variant;
			_tmp11_ = _g_variant_ref0 (_tmp10_);
			g_hash_table_insert (_tmp7_, _tmp9_, _tmp11_);
		}
	}
	_tmp12_ = _data9_->_result_;
	_tmp13_ = g_strdup ("model-seqnum");
	_tmp14_ = lens_search;
	_tmp15_ = unity_lens_search_get_results_model (_tmp14_);
	_tmp16_ = _tmp15_;
	_tmp17_ = dee_serializable_model_get_seqnum (_tmp16_);
	_tmp18_ = g_variant_new_uint64 (_tmp17_);
	_tmp19_ = g_variant_ref_sink (_tmp18_);
	g_hash_table_insert (_tmp12_, _tmp13_, _tmp19_);
	unity_scope_impl_search_internal_co (_data9_->_async_data_);
	_g_hash_table_unref0 (reply_hints);
}


static void ___lambda3__unity_lens_search_finished (UnityLensSearch* _sender, gpointer self) {
	__lambda3_ (self, _sender);
}


static void ____lambda4_ (Block9Data* _data9_) {
	UnityScopeImpl * self;
	UnityLensSearch* _tmp0_;
	self = _data9_->self;
	_tmp0_ = _data9_->s;
	g_signal_emit_by_name (_tmp0_, "finished");
}


static void _____lambda4__unity_lens_search_finished (UnityLensSearch* _sender, gpointer self) {
	____lambda4_ (self);
}


static gboolean _unity_scope_impl_search_internal_co_gsource_func (gpointer self) {
	gboolean result;
	result = unity_scope_impl_search_internal_co (self);
	return result;
}


static void __lambda5_ (Block9Data* _data9_) {
	UnityScopeImpl * self;
	UnityLensSearch* _tmp0_;
	gulong _tmp1_;
	self = _data9_->self;
	_tmp0_ = _data9_->s;
	_tmp1_ = _data9_->sig_id;
	g_signal_handler_block (_tmp0_, _tmp1_);
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _unity_scope_impl_search_internal_co_gsource_func, _data9_->_async_data_, NULL);
}


static void ___lambda5__gfunc (gconstpointer data, gpointer self) {
	__lambda5_ (self);
}


static gboolean unity_scope_impl_search_internal_co (UnityScopeImplSearchInternalData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data9_ = g_slice_new0 (Block9Data);
	_data_->_data9_->_ref_count_ = 1;
	_data_->_data9_->self = g_object_ref (_data_->self);
	_data_->_data9_->_async_data_ = _data_;
	_data_->_tmp0_ = g_str_hash;
	_data_->_tmp1_ = g_str_equal;
	_data_->_tmp2_ = g_hash_table_new_full (_data_->_tmp0_, _data_->_tmp1_, _g_free0_, _g_variant_unref0_);
	_data_->_data9_->_result_ = _data_->_tmp2_;
	_data_->_tmp3_ = _data_->search_type;
	_data_->is_global_search = _data_->_tmp3_ == UNITY_SEARCH_TYPE_GLOBAL;
	_data_->_tmp5_ = _data_->is_global_search;
	if (_data_->_tmp5_) {
		_data_->_tmp6_ = _data_->self->_global_results_model;
		_data_->_tmp4_ = _data_->_tmp6_;
	} else {
		_data_->_tmp7_ = _data_->self->_results_model;
		_data_->_tmp4_ = _data_->_tmp7_;
	}
	_data_->_tmp8_ = _data_->search_string;
	_data_->_tmp9_ = _data_->hints;
	_data_->_tmp10_ = _data_->_tmp4_;
	_data_->_tmp11_ = unity_lens_search_new (_data_->_tmp8_, _data_->_tmp9_, _data_->_tmp10_);
	_data_->_tmp12_ = g_object_ref_sink (_data_->_tmp11_);
	_data_->_data9_->s = _data_->_tmp12_;
	_data_->_tmp13_ = _data_->_data9_->s;
	_data_->_tmp14_ = 0UL;
	_data_->_tmp14_ = g_signal_connect_data (_data_->_tmp13_, "finished", (GCallback) ___lambda3__unity_lens_search_finished, block9_data_ref (_data_->_data9_), (GClosureNotify) block9_data_unref, 0);
	_data_->_data9_->sig_id = _data_->_tmp14_;
	_data_->last_search = NULL;
	_data_->ls_sig_id = (gulong) 0;
	_data_->_tmp15_ = _data_->_data9_->s;
	_data_->_tmp16_ = _data_->search_type;
	_data_->_tmp17_ = NULL;
	_data_->_tmp17_ = unity_scope_impl_get_search_key (_data_->self, _data_->_tmp15_, _data_->_tmp16_);
	_data_->search_key = _data_->_tmp17_;
	_data_->_tmp20_ = _data_->search_key;
	if (_data_->_tmp20_ != NULL) {
		_data_->_tmp21_ = _data_->search_key;
		_data_->_tmp22_ = _data_->self->priv->search_keys;
		_data_->_tmp22__length1 = _data_->self->priv->search_keys_length1;
		_data_->_tmp23_ = _data_->search_type;
		_data_->_tmp24_ = _data_->_tmp22_[_data_->_tmp23_];
		_data_->_tmp19_ = g_strcmp0 (_data_->_tmp21_, _data_->_tmp24_) != 0;
	} else {
		_data_->_tmp19_ = FALSE;
	}
	_data_->_tmp25_ = _data_->_tmp19_;
	if (_data_->_tmp25_) {
		_data_->_tmp18_ = TRUE;
	} else {
		_data_->_tmp27_ = _data_->search_key;
		if (_data_->_tmp27_ == NULL) {
			_data_->_tmp28_ = _data_->_data9_->s;
			_data_->_tmp29_ = _data_->self->priv->_owner;
			_data_->_tmp30_ = _data_->search_type;
			_data_->_tmp31_ = NULL;
			_data_->_tmp31_ = unity_scope_get_last_search (_data_->_tmp29_, _data_->_tmp30_);
			_data_->_tmp32_ = FALSE;
			_data_->_tmp32_ = unity_lens_search_equals (_data_->_tmp28_, _data_->_tmp31_);
			_data_->_tmp26_ = !_data_->_tmp32_;
		} else {
			_data_->_tmp26_ = FALSE;
		}
		_data_->_tmp33_ = _data_->_tmp26_;
		_data_->_tmp18_ = _data_->_tmp33_;
	}
	_data_->_tmp34_ = _data_->_tmp18_;
	if (_data_->_tmp34_) {
		_data_->_tmp35_ = _data_->_data9_->s;
		_data_->_tmp36_ = _data_->search_type;
		unity_scope_impl_schedule_search_changed (_data_->self, _data_->_tmp35_, _data_->_tmp36_, FALSE, NULL, NULL);
		_data_->_tmp37_ = _data_->self->priv->search_keys;
		_data_->_tmp37__length1 = _data_->self->priv->search_keys_length1;
		_data_->_tmp38_ = _data_->search_type;
		_data_->_tmp39_ = _data_->search_key;
		_data_->_tmp40_ = g_strdup (_data_->_tmp39_);
		_g_free0 (_data_->_tmp37_[_data_->_tmp38_]);
		_data_->_tmp37_[_data_->_tmp38_] = _data_->_tmp40_;
		_data_->_tmp41_ = _data_->_tmp37_[_data_->_tmp38_];
		_data_->_tmp42_ = _data_->self->priv->_owner;
		_data_->_tmp43_ = _data_->_data9_->s;
		_data_->_tmp44_ = _data_->search_type;
		unity_scope_set_last_search (_data_->_tmp42_, _data_->_tmp43_, _data_->_tmp44_);
	} else {
		_data_->_tmp45_ = _data_->self->priv->_owner;
		_data_->_tmp46_ = _data_->search_type;
		_data_->_tmp47_ = NULL;
		_data_->_tmp47_ = unity_scope_get_last_search (_data_->_tmp45_, _data_->_tmp46_);
		_data_->_tmp48_ = _g_object_ref0 (_data_->_tmp47_);
		_g_object_unref0 (_data_->last_search);
		_data_->last_search = _data_->_tmp48_;
		_data_->_tmp50_ = _data_->last_search;
		if (_data_->_tmp50_ != NULL) {
			_data_->_tmp51_ = _data_->last_search;
			_data_->_tmp52_ = FALSE;
			_data_->_tmp52_ = unity_lens_search_was_finished (_data_->_tmp51_);
			_data_->_tmp49_ = !_data_->_tmp52_;
		} else {
			_data_->_tmp49_ = FALSE;
		}
		_data_->_tmp53_ = _data_->_tmp49_;
		if (_data_->_tmp53_) {
			_data_->_tmp54_ = _data_->last_search;
			_data_->_tmp55_ = 0UL;
			_data_->_tmp55_ = g_signal_connect_data (_data_->_tmp54_, "finished", (GCallback) _____lambda4__unity_lens_search_finished, block9_data_ref (_data_->_data9_), (GClosureNotify) block9_data_unref, 0);
			_data_->ls_sig_id = _data_->_tmp55_;
			_data_->_tmp57_ = _data_->is_global_search;
			if (_data_->_tmp57_) {
				_data_->_tmp56_ = UNITY_VIEW_TYPE_HOME_VIEW;
			} else {
				_data_->_tmp56_ = UNITY_VIEW_TYPE_LENS_VIEW;
			}
			_data_->_tmp58_ = _data_->_tmp56_;
			_data_->current_view = _data_->_tmp58_;
			_data_->_tmp59_ = _data_->self->priv->_view_type;
			_data_->_tmp60_ = _data_->current_view;
			if (_data_->_tmp59_ != _data_->_tmp60_) {
				_data_->_tmp61_ = _data_->self->priv->_view_type;
				_data_->old_view = _data_->_tmp61_;
				_data_->_tmp62_ = _data_->current_view;
				unity_scope_service_set_view_type ((UnityScopeService*) _data_->self, (guint) _data_->_tmp62_, NULL, NULL);
				_data_->_tmp63_ = _data_->old_view;
				unity_scope_service_set_view_type ((UnityScopeService*) _data_->self, (guint) _data_->_tmp63_, NULL, NULL);
			}
		} else {
			_data_->_tmp64_ = _data_->_data9_->_result_;
			_data_->_tmp65_ = _g_hash_table_ref0 (_data_->_tmp64_);
			_data_->result = _data_->_tmp65_;
			_g_free0 (_data_->search_key);
			_g_object_unref0 (_data_->last_search);
			block9_data_unref (_data_->_data9_);
			_data_->_data9_ = NULL;
			if (_data_->_state_ == 0) {
				g_simple_async_result_complete_in_idle (_data_->_async_result);
			} else {
				g_simple_async_result_complete (_data_->_async_result);
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
	}
	_data_->_tmp66_ = _data_->self->priv->cancellable_arr;
	_data_->_tmp66__length1 = _data_->self->priv->cancellable_arr_length1;
	_data_->_tmp67_ = _data_->search_type;
	_data_->_tmp68_ = _data_->_tmp66_[_data_->_tmp67_];
	_data_->_tmp69_ = _g_object_ref0 (_data_->_tmp68_);
	_data_->cancellable = _data_->_tmp69_;
	_data_->_tmp70_ = _data_->cancellable;
	_data_->_tmp71_ = 0UL;
	_data_->_tmp71_ = g_cancellable_connect (_data_->_tmp70_, (GCallback*) ___lambda5__gfunc, block9_data_ref (_data_->_data9_), block9_data_unref);
	_data_->canc_id = _data_->_tmp71_;
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	_data_->_tmp72_ = _data_->ls_sig_id;
	if (_data_->_tmp72_ != ((gulong) 0)) {
		_data_->_tmp73_ = _data_->last_search;
		_data_->_tmp74_ = _data_->ls_sig_id;
		g_signal_handler_disconnect (_data_->_tmp73_, _data_->_tmp74_);
	}
	_data_->_tmp75_ = _data_->_data9_->s;
	_data_->_tmp76_ = _data_->_data9_->sig_id;
	g_signal_handler_disconnect (_data_->_tmp75_, _data_->_tmp76_);
	_data_->_tmp77_ = _data_->cancellable;
	_data_->_tmp78_ = _data_->canc_id;
	g_cancellable_disconnect (_data_->_tmp77_, _data_->_tmp78_);
	_data_->_tmp79_ = _data_->cancellable;
	_data_->_tmp80_ = FALSE;
	_data_->_tmp80_ = g_cancellable_is_cancelled (_data_->_tmp79_);
	if (_data_->_tmp80_) {
		_data_->_tmp81_ = _data_->search_string;
		_data_->_tmp82_ = g_error_new (UNITY_SCOPE_ERROR, UNITY_SCOPE_ERROR_SEARCH_CANCELLED, "Search '%s' was cancelled", _data_->_tmp81_);
		_data_->_inner_error_ = _data_->_tmp82_;
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		_g_object_unref0 (_data_->cancellable);
		_g_free0 (_data_->search_key);
		_g_object_unref0 (_data_->last_search);
		block9_data_unref (_data_->_data9_);
		_data_->_data9_ = NULL;
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp83_ = _data_->_data9_->_result_;
	_data_->_tmp84_ = _g_hash_table_ref0 (_data_->_tmp83_);
	_data_->result = _data_->_tmp84_;
	_g_object_unref0 (_data_->cancellable);
	_g_free0 (_data_->search_key);
	_g_object_unref0 (_data_->last_search);
	block9_data_unref (_data_->_data9_);
	_data_->_data9_ = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	_g_object_unref0 (_data_->cancellable);
	_g_free0 (_data_->search_key);
	_g_object_unref0 (_data_->last_search);
	block9_data_unref (_data_->_data9_);
	_data_->_data9_ = NULL;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void unity_scope_impl_real_search_data_free (gpointer _data) {
	UnityScopeImplSearchData* _data_;
	_data_ = _data;
	_g_free0 (_data_->search_string);
	_g_hash_table_unref0 (_data_->hints);
	_g_hash_table_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (UnityScopeImplSearchData, _data_);
}


static void unity_scope_impl_real_search (UnityScopeService* base, const gchar* search_string, GHashTable* hints, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UnityScopeImpl * self;
	UnityScopeImplSearchData* _data_;
	UnityScopeImpl* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	GHashTable* _tmp3_;
	GHashTable* _tmp4_;
	self = (UnityScopeImpl*) base;
	_data_ = g_slice_new0 (UnityScopeImplSearchData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, unity_scope_impl_real_search);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, unity_scope_impl_real_search_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = search_string;
	_tmp2_ = g_strdup (_tmp1_);
	_data_->search_string = _tmp2_;
	_tmp3_ = hints;
	_tmp4_ = _g_hash_table_ref0 (_tmp3_);
	_data_->hints = _tmp4_;
	unity_scope_impl_real_search_co (_data_);
}


static GHashTable* unity_scope_impl_real_search_finish (UnityScopeService* base, GAsyncResult* _res_, GError** error) {
	GHashTable* result;
	UnityScopeImplSearchData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void unity_scope_impl_search_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	UnityScopeImplSearchData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	unity_scope_impl_real_search_co (_data_);
}


static gboolean unity_scope_impl_real_search_co (UnityScopeImplSearchData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->search_string;
	_data_->_tmp1_ = _data_->hints;
	_data_->_state_ = 1;
	unity_scope_impl_search_internal (_data_->self, _data_->_tmp0_, _data_->_tmp1_, UNITY_SEARCH_TYPE_DEFAULT, unity_scope_impl_search_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = unity_scope_impl_search_internal_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
	_data_->_tmp3_ = _data_->_tmp2_;
	if (_data_->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		_g_hash_table_unref0 (_data_->_result_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_g_hash_table_unref0 (_data_->_result_);
	_data_->_result_ = _data_->_tmp3_;
	_data_->result = _data_->_result_;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	_g_hash_table_unref0 (_data_->_result_);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void unity_scope_impl_real_global_search_data_free (gpointer _data) {
	UnityScopeImplGlobalSearchData* _data_;
	_data_ = _data;
	_g_free0 (_data_->search_string);
	_g_hash_table_unref0 (_data_->hints);
	_g_hash_table_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (UnityScopeImplGlobalSearchData, _data_);
}


static void unity_scope_impl_real_global_search (UnityScopeService* base, const gchar* search_string, GHashTable* hints, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UnityScopeImpl * self;
	UnityScopeImplGlobalSearchData* _data_;
	UnityScopeImpl* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	GHashTable* _tmp3_;
	GHashTable* _tmp4_;
	self = (UnityScopeImpl*) base;
	_data_ = g_slice_new0 (UnityScopeImplGlobalSearchData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, unity_scope_impl_real_global_search);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, unity_scope_impl_real_global_search_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = search_string;
	_tmp2_ = g_strdup (_tmp1_);
	_data_->search_string = _tmp2_;
	_tmp3_ = hints;
	_tmp4_ = _g_hash_table_ref0 (_tmp3_);
	_data_->hints = _tmp4_;
	unity_scope_impl_real_global_search_co (_data_);
}


static GHashTable* unity_scope_impl_real_global_search_finish (UnityScopeService* base, GAsyncResult* _res_, GError** error) {
	GHashTable* result;
	UnityScopeImplGlobalSearchData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void unity_scope_impl_global_search_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	UnityScopeImplGlobalSearchData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	unity_scope_impl_real_global_search_co (_data_);
}


static gboolean unity_scope_impl_real_global_search_co (UnityScopeImplGlobalSearchData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->search_string;
	_data_->_tmp1_ = _data_->hints;
	_data_->_state_ = 1;
	unity_scope_impl_search_internal (_data_->self, _data_->_tmp0_, _data_->_tmp1_, UNITY_SEARCH_TYPE_GLOBAL, unity_scope_impl_global_search_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp2_ = NULL;
	_data_->_tmp2_ = unity_scope_impl_search_internal_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
	_data_->_tmp3_ = _data_->_tmp2_;
	if (_data_->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		_g_hash_table_unref0 (_data_->_result_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_g_hash_table_unref0 (_data_->_result_);
	_data_->_result_ = _data_->_tmp3_;
	_data_->result = _data_->_result_;
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	_g_hash_table_unref0 (_data_->_result_);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void unity_scope_impl_real_preview_data_free (gpointer _data) {
	UnityScopeImplPreviewData* _data_;
	_data_ = _data;
	_g_free0 (_data_->uri);
	unity_preview_reply_raw_destroy (&_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (UnityScopeImplPreviewData, _data_);
}


static void unity_scope_impl_real_preview (UnityScopeService* base, const gchar* uri, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UnityScopeImpl * self;
	UnityScopeImplPreviewData* _data_;
	UnityScopeImpl* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	self = (UnityScopeImpl*) base;
	_data_ = g_slice_new0 (UnityScopeImplPreviewData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, unity_scope_impl_real_preview);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, unity_scope_impl_real_preview_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = uri;
	_tmp2_ = g_strdup (_tmp1_);
	_data_->uri = _tmp2_;
	unity_scope_impl_real_preview_co (_data_);
}


static void unity_scope_impl_real_preview_finish (UnityScopeService* base, GAsyncResult* _res_, UnityPreviewReplyRaw* result, GError** error) {
	UnityScopeImplPreviewData* _data_;
	UnityPreviewReplyRaw _tmp0_ = {0};
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	unity_preview_reply_raw_copy (&_data_->result, &_tmp0_);
	*result = _tmp0_;
}


static gboolean unity_scope_impl_real_preview_co (UnityScopeImplPreviewData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	memset (&_data_->reply, 0, sizeof (UnityPreviewReplyRaw));
	_data_->_tmp0_ = _data_->self->priv->_owner;
	_data_->_tmp1_ = _data_->uri;
	_data_->_tmp2_ = NULL;
	g_signal_emit_by_name (_data_->_tmp0_, "preview-uri", _data_->_tmp1_, &_data_->_tmp2_);
	_data_->response = _data_->_tmp2_;
	_data_->_tmp3_ = _data_->response;
	if (_data_->_tmp3_ == NULL) {
		_data_->_tmp4_ = unity_no_preview_new ();
		_data_->_tmp5_ = (UnityPreview*) g_object_ref_sink (_data_->_tmp4_);
		_g_object_unref0 (_data_->response);
		_data_->response = _data_->_tmp5_;
	}
	_data_->_tmp6_ = _data_->uri;
	_data_->_tmp7_ = g_strdup (_data_->_tmp6_);
	_g_free0 (_data_->reply.uri);
	_data_->reply.uri = _data_->_tmp7_;
	_data_->_tmp8_ = _data_->response;
	_data_->_tmp9_ = NULL;
	_data_->_tmp9_ = unity_preview_get_renderer_name (_data_->_tmp8_);
	_g_free0 (_data_->reply.renderer_name);
	_data_->reply.renderer_name = _data_->_tmp9_;
	_data_->_tmp10_ = _data_->response;
	_data_->_tmp11_ = NULL;
	_data_->_tmp11_ = unity_preview_get_properties (_data_->_tmp10_);
	_g_hash_table_unref0 (_data_->reply.properties);
	_data_->reply.properties = _data_->_tmp11_;
	_data_->result = _data_->reply;
	_g_object_unref0 (_data_->response);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	_g_object_unref0 (_data_->response);
	unity_preview_reply_raw_destroy (&_data_->reply);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void unity_scope_impl_real_set_view_type_data_free (gpointer _data) {
	UnityScopeImplSetViewTypeData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (UnityScopeImplSetViewTypeData, _data_);
}


static void unity_scope_impl_real_set_view_type (UnityScopeService* base, guint view_type_id, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UnityScopeImpl * self;
	UnityScopeImplSetViewTypeData* _data_;
	UnityScopeImpl* _tmp0_;
	guint _tmp1_;
	self = (UnityScopeImpl*) base;
	_data_ = g_slice_new0 (UnityScopeImplSetViewTypeData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, unity_scope_impl_real_set_view_type);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, unity_scope_impl_real_set_view_type_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = view_type_id;
	_data_->view_type_id = _tmp1_;
	unity_scope_impl_real_set_view_type_co (_data_);
}


static void unity_scope_impl_real_set_view_type_finish (UnityScopeService* base, GAsyncResult* _res_, GError** error) {
	UnityScopeImplSetViewTypeData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static gboolean unity_scope_impl_real_set_view_type_co (UnityScopeImplSetViewTypeData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->view_type_id;
	_data_->view_type = (UnityViewType) _data_->_tmp0_;
	_data_->_tmp1_ = _data_->view_type;
	unity_scope_impl_set_view_type (_data_->self, _data_->_tmp1_);
	_data_->_tmp3_ = _data_->view_type;
	if (_data_->_tmp3_ == UNITY_VIEW_TYPE_LENS_VIEW) {
		_data_->_tmp2_ = TRUE;
	} else {
		_data_->_tmp5_ = _data_->view_type;
		if (_data_->_tmp5_ == UNITY_VIEW_TYPE_HOME_VIEW) {
			_data_->_tmp6_ = _data_->self->priv->_owner;
			_data_->_tmp7_ = unity_scope_get_search_in_global (_data_->_tmp6_);
			_data_->_tmp8_ = _data_->_tmp7_;
			_data_->_tmp4_ = _data_->_tmp8_;
		} else {
			_data_->_tmp4_ = FALSE;
		}
		_data_->_tmp9_ = _data_->_tmp4_;
		_data_->_tmp2_ = _data_->_tmp9_;
	}
	_data_->_tmp10_ = _data_->self->priv->_owner;
	_data_->_tmp11_ = _data_->_tmp2_;
	unity_scope_set_active (_data_->_tmp10_, _data_->_tmp11_);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void unity_scope_impl_real_set_active_sources_data_free (gpointer _data) {
	UnityScopeImplSetActiveSourcesData* _data_;
	_data_ = _data;
	_data_->sources = (_vala_array_free (_data_->sources, _data_->sources_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (_data_->self);
	g_slice_free (UnityScopeImplSetActiveSourcesData, _data_);
}


static gchar** _vala_array_dup4 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static void unity_scope_impl_real_set_active_sources (UnityScopeService* base, gchar** sources, int sources_length1, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	UnityScopeImpl * self;
	UnityScopeImplSetActiveSourcesData* _data_;
	UnityScopeImpl* _tmp0_;
	gchar** _tmp1_;
	gint _tmp1__length1;
	gchar** _tmp2_;
	gint _tmp2__length1;
	self = (UnityScopeImpl*) base;
	_data_ = g_slice_new0 (UnityScopeImplSetActiveSourcesData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, unity_scope_impl_real_set_active_sources);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, unity_scope_impl_real_set_active_sources_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = sources;
	_tmp1__length1 = sources_length1;
	_tmp2_ = (_tmp1_ != NULL) ? _vala_array_dup4 (_tmp1_, _tmp1__length1) : ((gpointer) _tmp1_);
	_tmp2__length1 = _tmp1__length1;
	_data_->sources = _tmp2_;
	_data_->sources_length1 = _tmp2__length1;
	unity_scope_impl_real_set_active_sources_co (_data_);
}


static void unity_scope_impl_real_set_active_sources_finish (UnityScopeService* base, GAsyncResult* _res_, GError** error) {
	UnityScopeImplSetActiveSourcesData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static gboolean unity_scope_impl_real_set_active_sources_co (UnityScopeImplSetActiveSourcesData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->_owner;
	_data_->_tmp1_ = _data_->sources;
	_data_->_tmp1__length1 = _data_->sources_length1;
	unity_scope_set_active_sources_internal (_data_->_tmp0_, _data_->_tmp1_, _data_->_tmp1__length1);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


UnityViewType unity_scope_impl_get_view_type (UnityScopeImpl* self) {
	UnityViewType result;
	UnityViewType _tmp0_;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_view_type;
	result = _tmp0_;
	return result;
}


void unity_scope_impl_set_view_type (UnityScopeImpl* self, UnityViewType value) {
	UnityViewType _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_view_type = _tmp0_;
	g_object_notify ((GObject *) self, "view-type");
}


static void unity_scope_impl_class_init (UnityScopeImplClass * klass) {
	unity_scope_impl_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (UnityScopeImplPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_unity_scope_impl_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_unity_scope_impl_set_property;
	G_OBJECT_CLASS (klass)->finalize = unity_scope_impl_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNITY_SCOPE_IMPL_VIEW_TYPE, g_param_spec_enum ("view-type", "view-type", "view-type", UNITY_TYPE_VIEW_TYPE, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void unity_scope_impl_unity_scope_service_interface_init (UnityScopeServiceIface * iface) {
	unity_scope_impl_unity_scope_service_parent_iface = g_type_interface_peek_parent (iface);
	iface->info_request = (void (*)(UnityScopeService*, GError**)) unity_scope_impl_real_info_request;
	iface->info_request_finish = unity_scope_impl_real_info_request_finish;
	iface->activate = (void (*)(UnityScopeService*, const gchar*, guint, UnityActivationReplyRaw*, GError**)) unity_scope_impl_real_activate;
	iface->activate_finish = unity_scope_impl_real_activate_finish;
	iface->search = (GHashTable* (*)(UnityScopeService*, const gchar*, GHashTable*, GError**)) unity_scope_impl_real_search;
	iface->search_finish = unity_scope_impl_real_search_finish;
	iface->global_search = (GHashTable* (*)(UnityScopeService*, const gchar*, GHashTable*, GError**)) unity_scope_impl_real_global_search;
	iface->global_search_finish = unity_scope_impl_real_global_search_finish;
	iface->preview = (void (*)(UnityScopeService*, const gchar*, UnityPreviewReplyRaw*, GError**)) unity_scope_impl_real_preview;
	iface->preview_finish = unity_scope_impl_real_preview_finish;
	iface->set_view_type = (void (*)(UnityScopeService*, guint, GError**)) unity_scope_impl_real_set_view_type;
	iface->set_view_type_finish = unity_scope_impl_real_set_view_type_finish;
	iface->set_active_sources = (void (*)(UnityScopeService*, gchar**, int, GError**)) unity_scope_impl_real_set_active_sources;
	iface->set_active_sources_finish = unity_scope_impl_real_set_active_sources_finish;
}


static void unity_scope_impl_instance_init (UnityScopeImpl * self) {
	GCancellable** _tmp0_ = NULL;
	gchar** _tmp1_ = NULL;
	self->priv = UNITY_SCOPE_IMPL_GET_PRIVATE (self);
	_tmp0_ = g_new0 (GCancellable*, UNITY_SEARCH_TYPE_N_TYPES + 1);
	self->priv->cancellable_arr = _tmp0_;
	self->priv->cancellable_arr_length1 = UNITY_SEARCH_TYPE_N_TYPES;
	self->priv->_cancellable_arr_size_ = self->priv->cancellable_arr_length1;
	_tmp1_ = g_new0 (gchar*, UNITY_SEARCH_TYPE_N_TYPES + 1);
	self->priv->search_keys = _tmp1_;
	self->priv->search_keys_length1 = UNITY_SEARCH_TYPE_N_TYPES;
	self->priv->_search_keys_size_ = self->priv->search_keys_length1;
}


static void unity_scope_impl_finalize (GObject* obj) {
	UnityScopeImpl * self;
	self = UNITY_SCOPE_IMPL (obj);
	_g_object_unref0 (self->priv->_owner);
	_g_object_unref0 (self->_results_model);
	_g_object_unref0 (self->_global_results_model);
	_g_object_unref0 (self->_filters_model);
	self->priv->cancellable_arr = (_vala_array_free (self->priv->cancellable_arr, self->priv->cancellable_arr_length1, (GDestroyNotify) g_object_unref), NULL);
	self->priv->search_keys = (_vala_array_free (self->priv->search_keys, self->priv->search_keys_length1, (GDestroyNotify) g_free), NULL);
	G_OBJECT_CLASS (unity_scope_impl_parent_class)->finalize (obj);
}


GType unity_scope_impl_get_type (void) {
	static volatile gsize unity_scope_impl_type_id__volatile = 0;
	if (g_once_init_enter (&unity_scope_impl_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (UnityScopeImplClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) unity_scope_impl_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UnityScopeImpl), 0, (GInstanceInitFunc) unity_scope_impl_instance_init, NULL };
		static const GInterfaceInfo unity_scope_service_info = { (GInterfaceInitFunc) unity_scope_impl_unity_scope_service_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType unity_scope_impl_type_id;
		unity_scope_impl_type_id = g_type_register_static (G_TYPE_OBJECT, "UnityScopeImpl", &g_define_type_info, 0);
		g_type_add_interface_static (unity_scope_impl_type_id, UNITY_TYPE_SCOPE_SERVICE, &unity_scope_service_info);
		g_once_init_leave (&unity_scope_impl_type_id__volatile, unity_scope_impl_type_id);
	}
	return unity_scope_impl_type_id__volatile;
}


static void _vala_unity_scope_impl_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	UnityScopeImpl * self;
	self = UNITY_SCOPE_IMPL (object);
	switch (property_id) {
		case UNITY_SCOPE_IMPL_VIEW_TYPE:
		g_value_set_enum (value, unity_scope_impl_get_view_type (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_unity_scope_impl_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	UnityScopeImpl * self;
	self = UNITY_SCOPE_IMPL (object);
	switch (property_id) {
		case UNITY_SCOPE_IMPL_VIEW_TYPE:
		unity_scope_impl_set_view_type (self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



