/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * uwa-test.h
 * Copyright (C) Canonical LTD 2011
 * 
 * Author: Robert Carr <racarr@canonical.com>
 * 
unity-webapps is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * unity-webapps is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.";
 */

#ifndef __UWA_TEST_H
#define __UWA_TEST_H

#include <glib.h>

typedef struct _UwaTest UwaTest;

UwaTest *uwa_test_new(const gchar *name, gboolean do_not_trace, gboolean echo);
void test_free (UwaTest *test);

gboolean uwa_test_prepare_environment (UwaTest *test);
gboolean uwa_test_run (UwaTest *test);

gboolean uwa_test_passed (UwaTest *test, gboolean print_next);

#endif
