/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * unity-webapps-context-daemon.h
 * Copyright (C) Canonical LTD 2011
 * 
 * Author: Robert Carr <racarr@canonical.com>
 * 
unity-webapps is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * unity-webapps is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.";
 */

#ifndef __UNITY_WEBAPPS_CONTEXT_DAEMON_H
#define __UNITY_WEBAPPS_CONTEXT_DAEMON_H

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>

typedef struct _UnityWebappsContextDaemon UnityWebappsContextDaemon;

#include "unity-webapps-notification-context.h"
#include "unity-webapps-indicator-context.h"
#include "unity-webapps-music-player-context.h"
#include "unity-webapps-launcher-context.h"

struct _UnityWebappsContextDaemon {
	GHashTable *interest_vanished_ids;
	GHashTable *name_interest_counts;
	guint interests;
	
	gchar **dnd_mimes;
	gchar *desktop_file_name;
	gchar *icon_file_name;
	
	gchar *icon_theme_dir;
	
	UnityWebappsNotificationContext *notification_context;
	UnityWebappsIndicatorContext *indicator_context;
	UnityWebappsMusicPlayerContext *music_player_context;
	UnityWebappsLauncherContext *launcher_context;
};

UnityWebappsContextDaemon *unity_webapps_context_daemon_new();
void unity_webapps_context_daemon_free (UnityWebappsContextDaemon *daemon);

void unity_webapps_context_daemon_emit_raise (GDBusConnection *connection, gint interest_id, const gchar * const *files);

gint unity_webapps_context_daemon_get_most_recent_interest ();
void unity_webapps_context_daemon_set_most_recent_interest (gint id);

void unity_webapps_context_daemon_raise_interest (gint interest_id);
void unity_webapps_context_daemon_raise_most_recent();


 
#endif
