/*
 * Copyright (C) 2009 Gnome Shell
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU  General Public License
 * version 2.0 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License version 2.0 for more details.
 *
 * You should have received a copy of the GNU  General Public
 * License along with this library. If not, see
 * <http://www.gnu.org/licenses/>.
 *
 * Taken from the Gnome Shell Project (src/shell-tray-manager.[h|c])
 */

#ifndef __UNITY_TRAY_MANAGER_H__
#define __UNITY_TRAY_MANAGER_H__

#include <clutter/clutter.h>

G_BEGIN_DECLS

#define UNITY_TYPE_TRAY_MANAGER			(unity_tray_manager_get_type ())
#define UNITY_TRAY_MANAGER(obj)			(G_TYPE_CHECK_INSTANCE_CAST ((obj), UNITY_TYPE_TRAY_MANAGER, UnityTrayManager))
#define UNITY_TRAY_MANAGER_CLASS(klass)		(G_TYPE_CHECK_CLASS_CAST ((klass), UNITY_TYPE_TRAY_MANAGER, UnityTrayManagerClass))
#define UNITY_IS_TRAY_MANAGER(obj)		(G_TYPE_CHECK_INSTANCE_TYPE ((obj), UNITY_TYPE_TRAY_MANAGER))
#define UNITY_IS_TRAY_MANAGER_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE ((klass), UNITY_TYPE_TRAY_MANAGER))
#define UNITY_TRAY_MANAGER_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS ((obj), UNITY_TYPE_TRAY_MANAGER, UnityTrayManagerClass))
	
typedef struct _UnityTrayManager        UnityTrayManager;
typedef struct _UnityTrayManagerPrivate UnityTrayManagerPrivate;
typedef struct _UnityTrayManagerClass   UnityTrayManagerClass;

struct _UnityTrayManager
{
  GObject parent_instance;

  UnityTrayManagerPrivate *priv;
};

struct _UnityTrayManagerClass
{
  GObjectClass parent_class;

  void (* tray_icon_added)   (UnityTrayManager *manager,
			      ClutterActor     *icon); 
  void (* tray_icon_removed) (UnityTrayManager *manager,
			      ClutterActor     *icon);

};

GType             unity_tray_manager_get_type     (void);

UnityTrayManager *unity_tray_manager_new          (void);
void              unity_tray_manager_manage_stage (UnityTrayManager *manager,
                                                   ClutterStage     *stage);

G_END_DECLS

#endif /* __UNITY_TRAY_MANAGER_H__ */
