/*
 * Copyright (C) 2009 Gnome Shell
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU  General Public License
 * version 2.0 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License version 2.0 for more details.
 *
 * You should have received a copy of the GNU  General Public
 * License along with this library. If not, see
 * <http://www.gnu.org/licenses/>.
 *
 * Taken from the Gnome Shell Project (src/)
 */


#ifndef __SHELL_EMBEDDED_WINDOW_H__
#define __SHELL_EMBEDDED_WINDOW_H__

#include <gtk/gtk.h>

#define SHELL_TYPE_EMBEDDED_WINDOW                 (shell_embedded_window_get_type ())
#define SHELL_EMBEDDED_WINDOW(obj)                 (G_TYPE_CHECK_INSTANCE_CAST ((obj), SHELL_TYPE_EMBEDDED_WINDOW, ShellEmbeddedWindow))
#define SHELL_EMBEDDED_WINDOW_CLASS(klass)         (G_TYPE_CHECK_CLASS_CAST ((klass), SHELL_TYPE_EMBEDDED_WINDOW, ShellEmbeddedWindowClass))
#define SHELL_IS_EMBEDDED_WINDOW(obj)              (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SHELL_TYPE_EMBEDDED_WINDOW))
#define SHELL_IS_EMBEDDED_WINDOW_CLASS(klass)      (G_TYPE_CHECK_CLASS_TYPE ((klass), SHELL_TYPE_EMBEDDED_WINDOW))
#define SHELL_EMBEDDED_WINDOW_GET_CLASS(obj)       (G_TYPE_INSTANCE_GET_CLASS ((obj), SHELL_TYPE_EMBEDDED_WINDOW, ShellEmbeddedWindowClass))

typedef struct _ShellEmbeddedWindow        ShellEmbeddedWindow;
typedef struct _ShellEmbeddedWindowClass   ShellEmbeddedWindowClass;

typedef struct _ShellEmbeddedWindowPrivate ShellEmbeddedWindowPrivate;

struct _ShellEmbeddedWindow
{
  GtkWindow parent;

  ShellEmbeddedWindowPrivate *priv;
};

struct _ShellEmbeddedWindowClass
{
  GtkWindowClass parent_class;
};

GType shell_embedded_window_get_type (void) G_GNUC_CONST;
GtkWidget *shell_embedded_window_new (void);

#endif /* __SHELL_EMBEDDED_WINDOW_H__ */
