/*
 * Copyright (C) 2010 Canonical, Ltd.
 *
 * Authors:
 *  Olivier Tilloy <olivier.tilloy@canonical.com>
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; version 3.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/>.
 */

#ifndef QT_BAMF_VIEW_H
#define QT_BAMF_VIEW_H

#include <QtCore/QObject>

#include "bamf-list.h"

class OrgAyatanaBamfViewInterface;

class __attribute__ ((visibility ("default"))) BamfView: public QObject
{
    Q_OBJECT

    Q_PROPERTY(bool active READ active NOTIFY ActiveChanged)
    Q_PROPERTY(QString path READ path)
    Q_PROPERTY(bool running READ running NOTIFY RunningChanged)
    Q_PROPERTY(bool urgent READ urgent NOTIFY UrgentChanged)
    Q_PROPERTY(bool user_visible READ user_visible NOTIFY UserVisibleChanged)
    Q_PROPERTY(QString name READ name)
    Q_PROPERTY(QString icon READ icon)
    Q_PROPERTY(QString view_type READ view_type)

friend class BamfFactory;

protected:
    BamfView(QString path);
    ~BamfView();

private:
    BamfView(BamfView const&);
    void operator=(BamfView const&);

public:
    // getters
    bool active() const;
    const QString path() const;
    bool running() const;
    bool urgent() const;
    bool user_visible() const;
    const QString name() const;
    const QString icon() const;
    const QString view_type() const;

    Q_INVOKABLE BamfViewList *children() const;

Q_SIGNALS:
    void ActiveChanged(bool new_state);
    void Closed();
    void ChildAdded(BamfView *child);
    void ChildRemoved(BamfView *child);
    void RunningChanged(bool new_state);
    void UrgentChanged(bool new_state);
    void UserVisibleChanged(bool new_state);

private:
    OrgAyatanaBamfViewInterface *m_proxy;

private Q_SLOTS:
    void OnViewClosed();
    void OnChildAdded(const QString &path);
    void OnChildRemoved(const QString &path);
};

#endif

