/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.util.junit;

import java.awt.Point;
import java.util.ArrayList;
import java.util.Collection;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.util.ObjectUtilities;

public class ObjectUtilitiesTests
extends TestCase {
    static /* synthetic */ Class class$org$jfree$util$junit$ObjectUtilitiesTests;

    public ObjectUtilitiesTests(String name) {
        super(name);
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public static Test suite() {
        return new TestSuite(class$org$jfree$util$junit$ObjectUtilitiesTests != null ? class$org$jfree$util$junit$ObjectUtilitiesTests : (class$org$jfree$util$junit$ObjectUtilitiesTests = ObjectUtilitiesTests.class$("org.jfree.util.junit.ObjectUtilitiesTests")));
    }

    public void testCloneObject() throws CloneNotSupportedException {
        Object clone;
        boolean pass = false;
        Object obj = "Hello World";
        try {
            clone = ObjectUtilities.clone(obj);
            pass = false;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            pass = true;
        }
        Assert.assertTrue((boolean)pass);
        pass = false;
        obj = new Integer(123);
        try {
            clone = ObjectUtilities.clone(obj);
            pass = false;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            pass = true;
        }
        Assert.assertTrue((boolean)pass);
        obj = new Point(1, 2);
        clone = ObjectUtilities.clone(obj);
        Assert.assertEquals((Object)obj, (Object)clone);
        obj = null;
        try {
            clone = ObjectUtilities.clone(obj);
            pass = false;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            pass = true;
        }
        Assert.assertTrue((boolean)pass);
    }

    public void testDeepClone() {
        ArrayList<Object> c1 = new ArrayList<Object>();
        Collection c2 = null;
        try {
            c2 = ObjectUtilities.deepClone(c1);
            Assert.assertTrue((boolean)c2.isEmpty());
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            Assert.assertTrue((boolean)false);
        }
        c1 = new ArrayList();
        c1.add(new Point(1, 2));
        c1.add(new Point(3, 4));
        try {
            c2 = ObjectUtilities.deepClone(c1);
            Assert.assertEquals((int)2, (int)c2.size());
            Assert.assertTrue((boolean)c2.contains(new Point(1, 2)));
            Assert.assertTrue((boolean)c2.contains(new Point(3, 4)));
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            Assert.assertTrue((boolean)false);
        }
        c1 = new ArrayList();
        c1.add(new Point(1, 2));
        c1.add(null);
        c1.add(new Point(3, 4));
        try {
            c2 = ObjectUtilities.deepClone(c1);
            Assert.assertEquals((int)3, (int)c2.size());
            Assert.assertTrue((boolean)c2.contains(new Point(1, 2)));
            Assert.assertTrue((boolean)c2.contains(new Point(3, 4)));
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            Assert.assertTrue((boolean)false);
        }
        c1.clear();
        c1.add("S1");
        c1.add("S2");
        try {
            c2 = ObjectUtilities.deepClone(c1);
            Assert.assertTrue((boolean)false);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            Assert.assertTrue((boolean)true);
        }
        try {
            c2 = ObjectUtilities.deepClone(null);
            Assert.assertTrue((boolean)false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Assert.assertTrue((boolean)true);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            Assert.assertTrue((boolean)false);
        }
    }
}

