/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.ui.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.ui.Size2D;

public class Size2DTests
extends TestCase {
    static /* synthetic */ Class class$org$jfree$ui$junit$Size2DTests;

    public Size2DTests(String name) {
        super(name);
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    public static Test suite() {
        return new TestSuite(class$org$jfree$ui$junit$Size2DTests != null ? class$org$jfree$ui$junit$Size2DTests : (class$org$jfree$ui$junit$Size2DTests = Size2DTests.class$("org.jfree.ui.junit.Size2DTests")));
    }

    public void testCloning() {
        Size2D s1 = new Size2D(1.0, 2.0);
        Size2D s2 = null;
        try {
            s2 = (Size2D)s1.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            System.err.println("Failed to clone.");
        }
        Assert.assertTrue((s1 != s2 ? 1 : 0) != 0);
        Assert.assertTrue((s1.getClass() == s2.getClass() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)s1.equals(s2));
    }

    public void testEquals() {
        Size2D s1 = new Size2D(1.0, 2.0);
        Size2D s2 = new Size2D(1.0, 2.0);
        Assert.assertTrue((boolean)s1.equals(s2));
        Assert.assertTrue((boolean)s2.equals(s1));
        s1 = new Size2D(2.0, 2.0);
        Assert.assertFalse((boolean)s1.equals(s2));
        s2 = new Size2D(2.0, 2.0);
        Assert.assertTrue((boolean)s1.equals(s2));
        s1 = new Size2D(2.0, 3.0);
        Assert.assertFalse((boolean)s1.equals(s2));
        s2 = new Size2D(2.0, 3.0);
        Assert.assertTrue((boolean)s1.equals(s2));
    }

    public void testSerialization() {
        Size2D s1 = new Size2D(3.0, 4.0);
        Size2D s2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(s1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            s2 = (Size2D)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        Assert.assertTrue((boolean)s1.equals(s2));
    }
}

