//-*-c++-*-
/***************************************************************************
 *   Copyright (C) 2003 by Fred Schaettgen                                 *
 *   kdebluetooth@schaettgen.de                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#ifndef _btsdp_H_
#define _btsdp_H_

#include <kio/slavebase.h>
#include <libkbluetooth/deviceaddress.h>
#include <libkbluetooth/namerequest.h>
#include <libkbluetooth/sdpattribute.h>
#include <vector>

class QCString;

typedef QMap<QString,QString> QStrMap;

class SdpProtocol : public KIO::SlaveBase
{
    struct InquiryInfo
    {
        KBluetooth::DeviceAddress address;
        int deviceClass;
    };
    struct DevInfo
    {
        QString realName;
        QString uniqueName;
        QString mimeType;
        KBluetooth::DeviceAddress address;
    };
    typedef std::vector<DevInfo> DevInfoVec;
    DevInfoVec deviceList;

    typedef std::vector<KBluetooth::SDP::uuid_t> UUIDVec;
    struct ServiceHandlerInfo
    {
        QString mimeType;
        UUIDVec uuids;
    };
    typedef std::vector<ServiceHandlerInfo> HandlerInfoVec;
    HandlerInfoVec handlerList;

    bool serviceListUp2Date;
    KBluetooth::NameRequest nameRequester;

    //KBluetooth::SDP::InfoFactory sdpInfoFactory;
public:
    SdpProtocol(const QCString &pool_socket, const QCString &app_socket);
    virtual ~SdpProtocol();
    //virtual void mimetype(const KURL& url);
    virtual void stat(const KURL &url);
    virtual void listDir(const KURL &url);
    virtual void setHost(const QString & host, int port,
                         const QString &user, const QString &pass);
    virtual void get(const KURL &url);

private:
    //bool inquiry(std::vector<InquiryInfo> &addrList);
    bool findDeviceByName(DevInfo &info, QString devStr);
    bool findDeviceByAddress(DevInfo &info, KBluetooth::DeviceAddress addr,
        int deviceClass = -1);
    bool doListInvalid(const KURL &url);
    bool doListServices(const KURL &url, QString btaddr, const QString& browseGroup);
    void initHandlerList();
    void findMimeTypesForUUIDList(
        std::vector<QString> &mimeTypes,
        const UUIDVec& uuids);
    QString getCachedName(KBluetooth::DeviceAddress addr);

    bool createFileEntry(KIO::UDSEntry &entry, QString title,
                         QString mimetype = QString::null,
                         QString url=QString::null);
    bool createDirEntry(KIO::UDSEntry &entry,
                        const QString &title,
                        const QString &url = QString::null,
                        const QString &mimeType = "inode/directory");
    void addAtom(KIO::UDSEntry &entry, KIO::UDSAtomTypes type,
                 QString s);
    void addAtom(KIO::UDSEntry &entry, KIO::UDSAtomTypes type,
                 long s);
    void saveMru(QString hostname, KBluetooth::DeviceAddress addr);
};

#endif
