/***************************************************************************
 *   Copyright (C) 2003 by Mattia Merzi                                    *
 *   ottobit@ferrara.linux.it                                              *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#ifndef DEVICESWINDOW_H
#define DEVICESWINDOW_H

#include <qvariant.h>
#include <qwidget.h>
#include <qnamespace.h>
#include <qmessagebox.h>
#include <qpixmap.h>

#include <BluezConnector.h>
#include <DeviceClassDialog.h>

#define COMBO_ENABLED 1
#define COMBO_DISABLED 2
#define COMBO_UNKNOWN 0

class QVBoxLayout;
class QHBoxLayout;
class QGridLayout;
class QComboBox;
class QLabel;
class QLineEdit;
class QTextEdit;
class QListBox;
class QListBoxItem;
class QPushButton;
class QButtonGroup;

/*
 * This is the main khciconfig window.
 */
class DevicesWindow : public QWidget
{
    Q_OBJECT

public:
    DevicesWindow( QWidget* parent = 0, const char* name = 0, WFlags fl = 0 );
    ~DevicesWindow();

    QLabel* label_local_installed_devices;
    QListBox* localdevices;
    int localdevices_current_device;
    QLabel* label_authentication_2;
    QLabel* label_inquiry_scan;
    QLabel* label_page_scan;
    QLabel* label_authentication;
    QComboBox* combo_status;
    int combo_status_old_value;
    QLabel* label_status;
    QLineEdit* lineedit_bdaddress;
    QLineEdit* lineedit_name;
    QComboBox* combo_inquiry_scan_enabled;
    QComboBox* combo_page_scan_enabled;
    QComboBox* combo_encryption_enabled;
    QComboBox* combo_authentication_enabled;
    QLabel* label_bdaddress;
    QLabel* label_name;
    QPushButton* pushbutton_update;
    QPushButton* pushbutton_reset;
    QPushButton* pushbutton_show_details;
    QPushButton* pushbutton_device_class;
    //    QTextEdit* lineedit_info;
    QButtonGroup* buttongroup_devices;
    void setEnabled(bool enabled);
    QButtonGroup* buttongroup_details;
    void closeEvent(QCloseEvent*);

    int getUserIsRoot() const
    {
        return user_is_root;
    }
    void setUserIsRoot(int _usr)
    {
        user_is_root = _usr;
    };

    static void permissionAlert()
    {
        QMessageBox::information(NULL,"Sorry !",
                                 "This operation requires root permission",
                                 "Ok!");
    }

public slots:
    //    virtual void localdevices_clicked();
    virtual void localdevices_selectionChanged( QListBoxItem * );
    virtual void pushbutton_update_clicked();
    virtual void pushbutton_reset_clicked();
    virtual void combo_status_activated( int );
    virtual void pushbutton_show_details_clicked();
    virtual void combo_inquiry_or_page_scan_activated( int );
    virtual void combo_inquiry_scan_activated( int );
    virtual void combo_page_scan_activated( int );
    virtual void combo_authentication_activated( int );
    virtual void combo_encryption_activated( int );
    virtual void lineedit_name_lost_focus();
    virtual void lineedit_name_return_pressed();
    virtual void pushbutton_show_device_class_window();

protected:
    QGridLayout* device_specs_layout;

protected slots:
    virtual void languageChange();

private:
    void windowContentUpdate();
    int flagsToCombo(int _flag);
    int comboToFlags(int _flag);
    void setFormValues(BluezConnector::KBTDevice* dev);
    void cleanWindowContent();
    void devNameFromLineEdit();
    int user_is_root;
    QPixmap* getPixmap(QString* _label);
    QPixmap QPixmap_USB;
    QPixmap QPixmap_VHCI;
    QPixmap QPixmap_PCCARD;
    QPixmap QPixmap_PCI;
    QPixmap QPixmap_UNKNOWN;
};

#endif // DEVICESWINDOW_H
