//-*-c++-*-
/***************************************************************************
 *   Copyright (C) 2003 by Fred Schaettgen                                 *
 *   kbluetoothd@schaettgen.de                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#include "dcopcall.h"
#include <kdebug.h>


DCOPCall::DCOPCall(DCOPClient* client, QString app, QString obj)
{
    this->client = client;
    this->app = app;
    this->obj = obj;
    this->argStream = new QDataStream(argArray, IO_WriteOnly);
    this->retStream = new QDataStream(retArray, IO_WriteOnly);
}

DCOPCall::~DCOPCall()
{
    if (argStream) delete this->argStream;
    if (retStream) delete this->retStream;
}

QString DCOPCall::call(QString func) {
    delete retStream;
    retArray = QByteArray();
    retStream = new QDataStream(retArray, IO_ReadOnly);

    QCString replyType;
    if (client->call(app.ascii(), obj.ascii(),
        func.ascii(), argArray, replyType, retArray))
    {
        delete argStream;
        argArray = QByteArray();
        argStream = new QDataStream(argArray, IO_WriteOnly);

        return replyType;
    }
    else {
        delete argStream;
        argArray = QByteArray();
        argStream = new QDataStream(argArray, IO_WriteOnly);

        kdWarning() << QString("DCOPCall::call() failed for function %1").arg(func) << endl;
        return QString::null;
    }
}

QDataStream& DCOPCall::args() {
    return *argStream;
}

QDataStream& DCOPCall::ret() {
    return *retStream;
}


