
from elisa.core.tests.test_media_provider import TestMediaProvider
from elisa.core.media_uri import MediaUri
from twisted.internet import defer
import os, platform

# TODO:
# - test http:// file:// smb:// ...
# - finish provider methods test

class TestVfsMedia(TestMediaProvider):
    component_class = 'gnomevfs_media:GnomevfsMedia'
    component_path = '..'

    skip = "blah"
    
    def __init__(self, methodName='runTest'):
        TestMediaProvider.__init__(self, methodName)
        if platform.system() == 'Windows':
            self.skip = "test not supported under windows"
##         else:
##             from elisa.plugins.media_gnomevfs_media import GnomevfsMedia
##             self.component_class = GnomevfsMedia
            

    def get_valid_uris(self):
        return [MediaUri("http://kernel.org/"),
                MediaUri("smb:///"),
                MediaUri("file:///")]

    def tearDown(self):
        self.component.clean()
        TestMediaProvider.tearDown(self)

    def test_directory1(self):

        def got_answer(answer, right_value):
            self.assertEquals(answer, right_value)

        uri = MediaUri(u'ftp://ftp.informatik.rwth-aachen.de/')
        dfr = self.component.is_directory(uri)
        dfr.addCallback(got_answer, True)

        uri = MediaUri(u'ftp://ftp.informatik.rwth-aachen.de/README')
        dfr2 = self.component.is_directory(uri)
        dfr2.addCallback(got_answer, False)

        return defer.DeferredList([dfr, dfr2])

    test_directory1.skip = "unreliable (at times) FTP"

    def test_has_children(self):

        def got_answer(answer, right_value):
            self.assertEquals(answer, right_value)

        uri = MediaUri(u'ftp://ftp.informatik.rwth-aachen.de/')
        dfr = self.component.is_directory(uri)
        dfr.addCallback(got_answer, True)

        uri = MediaUri(u'ftp://ftp.informatik.rwth-aachen.de/README')
        dfr2 = self.component.is_directory(uri)
        dfr2.addCallback(got_answer, False)

        return defer.DeferredList([dfr, dfr2])

    test_has_children.skip = "unreliable (at times) FTP"
