/*
 * This file is part of the TYPO3 CMS project.
 *
 * It is free software; you can redistribute it and/or modify it under
 * the terms of the GNU General Public License, either version 2
 * of the License, or any later version.
 *
 * For the full copyright and license information, please read the
 * LICENSE.txt file that was distributed with this source code.
 *
 * The TYPO3 project - inspiring people to share!
 */
Ext.namespace('TYPO3.Components.PageTree');

/**
 * @class TYPO3.Components.PageTree.FilteringTree
 *
 * Filtering Tree
 *
 * @namespace TYPO3.Components.PageTree
 * @extends TYPO3.Components.PageTree.Tree
 */
TYPO3.Components.PageTree.FilteringTree = Ext.extend(TYPO3.Components.PageTree.Tree, {
  /**
   * Search word
   *
   * @type {String}
   */
  searchWord: '',

  /**
   * Tree loader implementation for the filtering tree
   *
   * @return {void}
   */
  addTreeLoader: function() {
    this.loader = new Ext.tree.TreeLoader({
      directFn: this.treeDataProvider.getFilteredTree,
      paramOrder: 'nodeId,attributes,searchWord',
      nodeParameter: 'nodeId',
      baseAttrs: {
        uiProvider: this.uiProvider
      },

      listeners: {
        beforeload: function(treeLoader, node) {
          if (!node.ownerTree.searchWord || node.ownerTree.searchWord === '') {
            return false;
          }

          treeLoader.baseParams.nodeId = node.id;
          treeLoader.baseParams.searchWord = node.ownerTree.searchWord;
          treeLoader.baseParams.attributes = node.attributes.nodeData;
        }
      }
    });
  }
});

// XTYPE Registration
Ext.reg('TYPO3.Components.PageTree.FilteringTree', TYPO3.Components.PageTree.FilteringTree);
