/* Any copyright is dedicated to the Public Domain.
   http://creativecommons.org/publicdomain/zero/1.0/ */

"use strict";

const NETWORK_RUNTIME_HOST = "localhost:6080";
const NETWORK_RUNTIME_APP_NAME = "TestNetworkApp";
const WORKER_NAME = "testserviceworker";

// Test that navigating from:
// - a remote runtime page that contains a service worker
// to:
// - this icecat
// does not crash. See Bug 1519088.
add_task(async function () {
  const mocks = new Mocks();

  const { document, tab, window } = await openAboutDebugging({
    enableWorkerUpdates: true,
  });
  await selectThisIceCatPage(document, window.AboutDebugging.store);

  info("Prepare Network client mock");
  const networkClient = mocks.createNetworkRuntime(NETWORK_RUNTIME_HOST, {
    name: NETWORK_RUNTIME_APP_NAME,
  });

  info("Connect and select the network runtime");
  await connectToRuntime(NETWORK_RUNTIME_HOST, document);
  await selectRuntime(NETWORK_RUNTIME_HOST, NETWORK_RUNTIME_APP_NAME, document);

  info(`Add a service worker to the network client`);
  const workers = {
    otherWorkers: [],
    serviceWorkers: [
      {
        name: WORKER_NAME,
        workerDescriptorFront: { actorID: WORKER_NAME },
      },
    ],
    sharedWorkers: [],
  };
  networkClient.listWorkers = () => workers;
  networkClient._eventEmitter.emit("workersUpdated");

  info("Wait until the service worker is displayed");
  await waitUntil(() => findDebugTargetByText(WORKER_NAME, document));

  info("Go to This IceCat again");
  const thisIceCatString = getThisIceCatString(window);
  const thisIceCatSidebarItem = findSidebarItemByText(
    thisIceCatString,
    document
  );
  const thisIceCatLink =
    thisIceCatSidebarItem.querySelector(".qa-sidebar-link");
  info("Click on the ThisIceCat item in the sidebar");
  const requestsSuccess = waitForRequestsSuccess(window.AboutDebugging.store);
  thisIceCatLink.click();

  info("Wait for all target requests to complete");
  await requestsSuccess;

  info("Check that the runtime info is rendered for This IceCat");
  const thisIceCatRuntimeInfo = document.querySelector(".qa-runtime-name");
  ok(
    thisIceCatRuntimeInfo,
    "Runtime info for this-icecat runtime is displayed"
  );

  const text = thisIceCatRuntimeInfo.textContent;
  ok(
    text.includes("IceCat") && text.includes("63.0"),
    "this-icecat runtime info shows the correct values"
  );

  await removeTab(tab);
});
