# This Source Code Form is subject to the terms of the Mozilla Public
# License, v. 2.0. If a copy of the MPL was not distributed with this
# file, You can obtain one at http://mozilla.org/MPL/2.0/.

toolbar-button-icecat-view-2 =
  .label = { -icecatview-brand-name }
  .tooltiptext = View recent browsing across windows and devices

menu-tools-icecat-view =
  .label = { -icecatview-brand-name }
  .accesskey = F

icecatview-page-title = { -icecatview-brand-name }

icecatview-page-heading =
  .heading = { -icecatview-brand-name }

icecatview-page-label =
  .label = { -icecatview-brand-name }

icecatview-close-button =
  .title = Close
  .aria-label = Close

icecatview-empty-state-icon =
  .alt = Attention:

# Used instead of the localized relative time when a timestamp is within a minute or so of now
icecatview-just-now-timestamp = Just now

# This is a headline for an area in the product where users can resume and re-open tabs they have previously viewed on other devices.
icecatview-tabpickup-header = Tab pickup
icecatview-tabpickup-description = Open pages from other devices.

# Variables:
#  $percentValue (Number): the percentage value for setup completion
icecatview-tabpickup-progress-label = { $percentValue }% complete

icecatview-tabpickup-step-signin-header = Switch seamlessly between devices
icecatview-tabpickup-step-signin-description = To grab your phone tabs here, first sign in or create an account.
icecatview-tabpickup-step-signin-primarybutton = Continue

icecatview-syncedtabs-signin-header = Grab tabs from anywhere
icecatview-syncedtabs-signin-description = To see your tabs from wherever you use { -brand-product-name }, sign in to your account. If you don’t have an account, we’ll take you through the steps to sign up.
icecatview-syncedtabs-signin-primarybutton = Sign in or sign up

icecatview-tabpickup-adddevice-header = Sync { -brand-product-name } on your phone or tablet
icecatview-tabpickup-adddevice-description = Download { -brand-product-name } for mobile and sign in there.
icecatview-tabpickup-adddevice-learn-how = Learn how
icecatview-tabpickup-adddevice-primarybutton = Get { -brand-product-name } for mobile

icecatview-syncedtabs-adddevice-header = Sign in to { -brand-product-name } on your other devices
icecatview-syncedtabs-adddevice-description = To see your tabs from wherever you use { -brand-product-name }, sign in on all your devices. Learn how to <a data-l10n-name="url">connect additional devices</a>.
icecatview-syncedtabs-adddevice-primarybutton = Try { -brand-product-name } for mobile

icecatview-tabpickup-synctabs-header = Turn on tab syncing
icecatview-tabpickup-synctabs-description = Allow { -brand-short-name } to share tabs between devices.
icecatview-tabpickup-synctabs-learn-how = Learn how
icecatview-tabpickup-synctabs-primarybutton = Sync open tabs

icecatview-syncedtabs-synctabs-header = Update your sync settings
icecatview-syncedtabs-synctabs-description = To see tabs from other devices, you need to sync your open tabs.
icecatview-syncedtabs-synctabs-checkbox = Allow open tabs to sync

icecatview-syncedtabs-loading-header = Sync in progress
icecatview-syncedtabs-loading-description = When it’s done, you’ll see any tabs you have open on other devices. Check back soon.

icecatview-tabpickup-fxa-admin-disabled-header = Your organization has disabled sync
icecatview-tabpickup-fxa-disabled-by-policy-description = { -brand-short-name } is not able to sync tabs between devices because your organization has disabled syncing.

icecatview-tabpickup-network-offline-header = Check your internet connection
icecatview-tabpickup-network-offline-description = If you’re using a firewall or proxy, check that { -brand-short-name } has permission to access the web.
icecatview-tabpickup-network-offline-primarybutton = Try again

icecatview-tabpickup-sync-error-header = We’re having trouble syncing
icecatview-tabpickup-generic-sync-error-description = { -brand-short-name } can’t reach the syncing service right now. Try again in a few moments.
icecatview-tabpickup-sync-error-primarybutton = Try again

icecatview-tabpickup-sync-disconnected-header = Turn on syncing to continue
icecatview-tabpickup-sync-disconnected-description = To grab your tabs, you’ll need to allow syncing in { -brand-short-name }.
icecatview-tabpickup-sync-disconnected-primarybutton = Turn on sync in settings

icecatview-tabpickup-password-locked-header = Enter your Primary Password to view tabs
icecatview-tabpickup-password-locked-description = To grab your tabs, you’ll need to enter the Primary Password for { -brand-short-name }.
icecatview-tabpickup-password-locked-link = Learn more
icecatview-tabpickup-password-locked-primarybutton = Enter Primary Password
icecatview-syncedtab-password-locked-link = <a data-l10n-name="syncedtab-password-locked-link">Learn more</a>

icecatview-tabpickup-signed-out-header = Sign in to reconnect
icecatview-tabpickup-signed-out-description2 = To reconnect and grab your tabs, sign in to your account.
icecatview-tabpickup-signed-out-primarybutton = Sign in

icecatview-tabpickup-syncing = Sit tight while your tabs sync. It’ll be just a moment.

icecatview-mobile-promo-header = Grab tabs from your phone or tablet
icecatview-mobile-promo-description = To view your latest mobile tabs, sign in to { -brand-product-name } on iOS or Android.
icecatview-mobile-promo-primarybutton = Get { -brand-product-name } for mobile

icecatview-mobile-confirmation-header = 🎉 Good to go!
icecatview-mobile-confirmation-description = Now you can grab your { -brand-product-name } tabs from your tablet or phone.

icecatview-closed-tabs-placeholder-header = No recently closed tabs
icecatview-closed-tabs-placeholder-body2 = When you close a tab, you can fetch it from here.

# Variables:
#   $tabTitle (string) - Title of tab being dismissed
icecatview-closed-tabs-dismiss-tab =
  .title = Dismiss { $tabTitle }

# refers to the last tab that was used
icecatview-pickup-tabs-badge = Last active

# Variables:
#   $targetURI (string) - URL that will be opened in the new tab
icecatview-tabs-list-tab-button =
  .title = Open { $targetURI } in a new tab

icecatview-try-colorways-button = Try colorways
icecatview-change-colorway-button = Change colorway

# Variables:
#  $intensity (String): Colorway intensity
#  $collection (String): Colorway Collection name
icecatview-colorway-description = { $intensity } · { $collection }

icecatview-synced-tabs-placeholder-header = Nothing to see yet
icecatview-synced-tabs-placeholder-body = The next time you open a page in { -brand-product-name } on another device, grab it here like magic.

icecatview-collapse-button-show =
  .title = Show list

icecatview-collapse-button-hide =
  .title = Hide list

icecatview-overview-nav = Recent browsing
  .title = Recent browsing
icecatview-overview-header = Recent browsing
  .title = Recent browsing

## History in this context refers to browser history

icecatview-history-nav = History
  .title = History
icecatview-history-header = History
icecatview-history-context-delete = Delete from History
    .accesskey = D

## Open Tabs in this context refers to all open tabs in the browser

icecatview-opentabs-nav = Open tabs
  .title = Open tabs
icecatview-opentabs-header = Open tabs

## Recently closed tabs in this context refers to recently closed tabs from all windows

icecatview-recently-closed-nav = Recently closed tabs
  .title = Recently closed tabs
icecatview-recently-closed-header = Recently closed tabs

## Tabs from other devices refers in this context refers to synced tabs from other devices

icecatview-synced-tabs-nav = Tabs from other devices
  .title = Tabs from other devices
icecatview-synced-tabs-header = Tabs from other devices

##

# Used for a link in collapsible cards, in the ’Recent browsing’ page of IceCat View
icecatview-view-all-link = View all

# Variables:
#   $winID (Number) - The index of the owner window for this set of tabs
icecatview-opentabs-window-header =
  .title = Window { $winID }

# Variables:
#   $winID (Number) - The index of the owner window (which is currently focused) for this set of tabs
icecatview-opentabs-current-window-header =
  .title = Window { $winID } (Current)

icecatview-opentabs-focus-tab =
  .title = Switch to this tab

icecatview-show-more = Show more
icecatview-show-less = Show less
icecatview-show-all = Show all

icecatview-search-text-box-clear-button =
  .title = Clear

# Placeholder for the input field to search in recent browsing ("search" is a verb).
icecatview-search-text-box-recentbrowsing =
  .placeholder = Search

# Placeholder for the input field to search in history ("search" is a verb).
icecatview-search-text-box-history =
  .placeholder = Search history

# Placeholder for the input field to search in recently closed tabs ("search" is a verb).
icecatview-search-text-box-recentlyclosed =
  .placeholder = Search recently closed tabs

# Placeholder for the input field to search in tabs from other devices ("search" is a verb).
icecatview-search-text-box-syncedtabs =
  .placeholder = Search synced tabs

# Placeholder for the input field to search in open tabs ("search" is a verb).
icecatview-search-text-box-opentabs =
  .placeholder = Search open tabs

# "Search" is a noun (as in "Results of the search for")
# Variables:
#   $query (String) - The search query used for searching through browser history.
icecatview-search-results-header = Search results for “{ $query }”

# Variables:
#   $count (Number) - The number of visits matching the search query.
icecatview-search-results-count = { $count ->
  [one] { $count } site
 *[other] { $count } sites
}

# Message displayed when a search is performed and no matching results were found.
# Variables:
#   $query (String) - The search query.
icecatview-search-results-empty = No results for “{ $query }”

icecatview-sort-history-by-date-label = Sort by date
icecatview-sort-history-by-site-label = Sort by site
icecatview-sort-open-tabs-by-recency-label = Sort by recent activity
icecatview-sort-open-tabs-by-order-label = Sort by tab order

# Variables:
#   $url (string) - URL that will be opened in the new tab
icecatview-opentabs-tab-row =
  .title = Switch to { $url }

## Variables:
##   $date (string) - Date to be formatted based on locale

icecatview-history-date-today = Today - { DATETIME($date, dateStyle: "full") }
icecatview-history-date-yesterday = Yesterday - { DATETIME($date, dateStyle: "full") }
icecatview-history-date-this-month = { DATETIME($date, dateStyle: "full") }
icecatview-history-date-prev-month = { DATETIME($date, month: "long", year: "numeric") }

# When history is sorted by site, this heading is used in place of a domain, in
# order to group sites that do not come from an outside host.
# For example, this would be the heading for all file:/// URLs in history.
icecatview-history-site-localhost = (local files)

##

icecatview-show-all-history = Show all history

icecatview-view-more-browsing-history = View more browsing history

## Message displayed in IceCat View when the user has no history data

icecatview-history-empty-header = Get back to where you’ve been
icecatview-history-empty-description = As you browse, the pages you visit will be listed here.
icecatview-history-empty-description-two = Protecting your privacy is at the heart of what we do. It’s why you can control the activity { -brand-short-name } remembers, in your <a data-l10n-name="history-settings-url">history settings</a>.

##

# Button text for choosing a browser within the ’Import history from another browser’ banner
icecatview-choose-browser-button = Choose browser
  .title = Choose browser

## Message displayed in IceCat View when the user has chosen to never remember History

icecatview-dont-remember-history-empty-header = Nothing to show
icecatview-dont-remember-history-empty-description = Protecting your privacy is at the heart of what we do. It’s why you can control the activity { -brand-short-name } remembers.
icecatview-dont-remember-history-empty-description-two = Based on your current settings, { -brand-short-name } doesn’t remember your activity as you browse. To change that, <a data-l10n-name="history-settings-url-two">change your history settings to remember your history</a>.

##

# This label is read by screen readers when focusing the close button for the "Import history from another browser" banner in IceCat View
icecatview-import-history-close-button =
  .aria-label = Close
  .title = Close

## Text displayed in a dismissable banner to import bookmarks/history from another browser

icecatview-import-history-header = Import history from another browser
icecatview-import-history-description = Make { -brand-short-name } your go-to browser. Import browsing history, bookmarks, and more.

## Message displayed in IceCat View when the user has no recently closed tabs data

icecatview-recentlyclosed-empty-header = Closed a tab too soon?
icecatview-recentlyclosed-empty-description = Here you’ll find the tabs you recently closed, so you can reopen any of them quickly.
icecatview-recentlyclosed-empty-description-two = To find tabs from longer ago, view your <a data-l10n-name="history-url">browsing history</a>.

## This message is displayed below the name of another connected device when it doesn't have any open tabs.

icecatview-syncedtabs-device-notabs = No tabs open on this device

icecatview-syncedtabs-connect-another-device = Connect another device

icecatview-pinned-tabs =
  .title = Pinned Tabs

icecatview-tabs =
  .title = Tabs

## These tooltips will be displayed when hovering over a pinned tab on the Open Tabs page
## Variables:
##  $tabTitle (string) - Title of pinned tab that will be opened when selected

icecatview-opentabs-pinned-tab =
  .title = Switch to { $tabTitle }

# This tooltip will be shown for a pinned tab whose URL is currently bookmarked.
icecatview-opentabs-bookmarked-pinned-tab =
  .title = Switch to (Bookmarked) { $tabTitle }

## These tooltips will be displayed when hovering over an unpinned Open Tab
## Variables:
##   $url (string) - URL of tab that will be opened when selected

# This tooltip will be shown for an unpinned tab whose URL is currently bookmarked.
icecatview-opentabs-bookmarked-tab =
  .title = (Bookmarked) { $url }
