// Makes all tables on the page with a cell with a pivot class pivotable
function webdeveloper_makeTablesPivotable()
{
    var tableCellList   = webdeveloper_evaluateXPath(document, "//td[@class='pivot']");
    var tableCellLength = tableCellList.length;

    // Loop through the table cells
    for(var i = 0; i < tableCellLength; i++)
    {
        tableCellList[i].addEventListener("click", webdeveloper_pivotTable, false);
    }
}

// Pivots a table
function webdeveloper_pivotTable(event)
{
    // If the event is set
    if(event)
    {
        var hide      = true;
        var pivotRow  = event.target.parentNode;
        var tableCell = null;
        var tableRow  = pivotRow;

        // If the pivot row class attribute is set to collapsed
        if(pivotRow.getAttribute("class") == "collapsed")
        {
            hide = false;

            pivotRow.setAttribute("class", "expanded");
        }
        else
        {
            pivotRow.setAttribute("class", "collapsed");
        }

        // Loop through the table rows
        while((tableRow = tableRow.nextSibling) != null)
        {
            tableCell = tableRow.firstChild;

            // If the table cell is set and has a class attribute set to indent
            if(tableCell && tableCell.hasAttribute("class") && tableCell.getAttribute("class") == "indent")
            {
                // If the table row has a class attribute that contains shaded
                if(tableRow.hasAttribute("class") && tableRow.getAttribute("class").indexOf("shaded") != -1)
                {
                    // If hiding the row
                    if(hide)
                    {
                        tableRow.setAttribute("class", "hidden shaded");
                    }
                    else
                    {
                        tableRow.setAttribute("class", "shaded");
                    }
                }
                else
                {
                    // If hiding the row
                    if(hide)
                    {
                        tableRow.setAttribute("class", "hidden");
                    }
                    else
                    {
                        tableRow.removeAttribute("class");
                    }
                }
            }
            else
            {
                break;
            }
        }
    }
}

webdeveloper_makeTablesPivotable();
