/* UndoRedoAction.java
 * =========================================================================
 * This file is part of the SWIRL Library - http://swirl-lib.sourceforge.net
 * 
 * Copyright (C) 2005-2008 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 * 
 */

package be.ugent.caagt.swirl.undoredo;

import java.util.ResourceBundle;
import javax.swing.Icon;
import be.ugent.caagt.swirl.actions.SimpleAction;

/**
 * Common super class for {@link UndoAction} and {@link RedoAction}
 */
public abstract class UndoRedoAction extends SimpleAction implements UndoListener {

    //
    protected final UndoManager manager;
    
    //
    private String disabledCaption;
    
    //
    private boolean disabledCaptionSet;

    /**
     * Create an action of this type with the given parameters
     */
    protected UndoRedoAction (UndoManager manager, ResourceBundle bundle, String key, 
		       Icon icon, Icon mediumIcon, Icon mediumDisabledIcon) {
        super(bundle, key, icon, mediumIcon, mediumDisabledIcon);
        this.manager = manager;
        this.disabledCaptionSet = false;
        manager.addUndoListener (this);
        setEnabled (false); // not overridable (PMD)
    }
    
    //
    UndoRedoAction (UndoManager manager) {
        this.manager = manager;
        this.disabledCaptionSet = false;
        manager.addUndoListener (this);
        super.setEnabled (false);
    }
    
    /**
     * Enables/disables the action and changes the caption accordingly.
     */
    @Override
    public void setEnabled (boolean newValue) {
        super.setEnabled (newValue);
        String caption = disabledCaption;
        if (newValue) {
            String newCaption = getCaption();
            if (newCaption != null)
                caption = newCaption;
        }
        putValue (NAME, caption);
    }

    /**
     * Overridden to set the disabled caption
     * from the first caption set.
     * @param key
     * @param newValue
     */
    @Override
    public void putValue(String key, Object newValue) {
        if (! disabledCaptionSet && key.equals(NAME)) {
            this.disabledCaption = (String)newValue;
            this.disabledCaptionSet = true;
        }
        super.putValue(key, newValue);
    }
    
    /**
     * Obtain the correct caption from the manager.
     */
    protected abstract String getCaption ();    
    
}
