/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 1997-2008 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common
 * Development and Distribution License("CDDL") (collectively, the
 * "License"). You may not use this file except in compliance with the
 * License. You can obtain a copy of the License at
 * http://www.netbeans.org/cddl-gplv2.html
 * or nbbuild/licenses/CDDL-GPL-2-CP. See the License for the
 * specific language governing permissions and limitations under the
 * License.  When distributing the software, include this License Header
 * Notice in each file and include the License file at
 * nbbuild/licenses/CDDL-GPL-2-CP.  Sun designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Sun in the GPL Version 2 section of the License file that
 * accompanied this code. If applicable, add the following below the
 * License Header, with the fields enclosed by brackets [] replaced by
 * your own identifying information:
 * "Portions Copyrighted [year] [name of copyright owner]"
 *
 * Contributor(s):
 *
 * The Original Software is NetBeans. The Initial Developer of the Original
 * Software is Sun Microsystems, Inc. Portions Copyright 1997-2008 Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * If you wish your version of this file to be governed by only the CDDL
 * or only the GPL Version 2, indicate your decision by adding
 * "[Contributor] elects to include this software in this distribution
 * under the [CDDL or GPL Version 2] license." If you do not indicate a
 * single choice of license, a recipient has the option to distribute
 * your version of this file under either the CDDL, the GPL Version 2 or
 * to extend the choice of license to its licensees as provided above.
 * However, if you add GPL Version 2 code and therefore, elected the GPL
 * Version 2 license, then the option applies only if the new code is
 * made subject to such option by the copyright holder.
 */
package org.netbeans.core.ui.options.filetypes;

import java.util.ArrayList;
import java.util.Collections;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.core.ui.options.filetypes.FileAssociationsModel.MimeItem;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.NbBundle;

/** Options panel with extensions and associated MIME types.
 *
 * @author Jiri Skrivanek
 */
final class FileAssociationsPanel extends javax.swing.JPanel {

    private final FileAssociationsOptionsPanelController controller;
    private final String chooseExtensionItem;
    private NewExtensionPanel newExtensionPanel;
    private FileAssociationsModel model;
    private DocumentListener patternListener;
    
    FileAssociationsPanel(FileAssociationsOptionsPanelController controller) {
        this.controller = controller;
        initComponents();
        chooseExtensionItem = NbBundle.getMessage(FileAssociationsPanel.class, "FileAssociationsPanel.cbExtension.choose"); // NOI18N
        patternListener = new PatternDocumentListener();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        lblExtension = new javax.swing.JLabel();
        cbExtension = new javax.swing.JComboBox();
        btnNew = new javax.swing.JButton();
        btnRemove = new javax.swing.JButton();
        lblType = new javax.swing.JLabel();
        cbType = new javax.swing.JComboBox();
        btnDefault = new javax.swing.JButton();
        lblAssociatedAlso = new javax.swing.JLabel();
        lblAssociatedAlsoExt = new javax.swing.JLabel();
        sepFileAssociations = new javax.swing.JSeparator();
        lblFileAssociations = new javax.swing.JLabel();
        lblFilesIgnored = new javax.swing.JLabel();
        setFilesIgnored = new javax.swing.JSeparator();
        lblPattern = new javax.swing.JLabel();
        btnDefaultIgnored = new javax.swing.JButton();
        jScrollPane1 = new javax.swing.JScrollPane();
        txtPattern = new javax.swing.JTextArea();
        txtPatternError = new javax.swing.JLabel();

        lblExtension.setLabelFor(cbExtension);
        org.openide.awt.Mnemonics.setLocalizedText(lblExtension, org.openide.util.NbBundle.getMessage(FileAssociationsPanel.class, "FileAssociationsPanel.lblExtension.text")); // NOI18N

        cbExtension.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                cbExtensionActionPerformed(evt);
            }
        });

        org.openide.awt.Mnemonics.setLocalizedText(btnNew, org.openide.util.NbBundle.getMessage(FileAssociationsPanel.class, "FileAssociationsPanel.btnNew.text")); // NOI18N
        btnNew.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnNewActionPerformed(evt);
            }
        });

        org.openide.awt.Mnemonics.setLocalizedText(btnRemove, org.openide.util.NbBundle.getMessage(FileAssociationsPanel.class, "FileAssociationsPanel.btnRemove.text")); // NOI18N
        btnRemove.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnRemoveActionPerformed(evt);
            }
        });

        lblType.setLabelFor(cbType);
        org.openide.awt.Mnemonics.setLocalizedText(lblType, org.openide.util.NbBundle.getMessage(FileAssociationsPanel.class, "FileAssociationsPanel.lblType.text")); // NOI18N

        cbType.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                cbTypeActionPerformed(evt);
            }
        });

        org.openide.awt.Mnemonics.setLocalizedText(btnDefault, org.openide.util.NbBundle.getMessage(FileAssociationsPanel.class, "FileAssociationsPanel.btnDefault.text")); // NOI18N
        btnDefault.setToolTipText(org.openide.util.NbBundle.getMessage(FileAssociationsPanel.class, "FileAssociationsPanel.btnDefault.tooltip")); // NOI18N
        btnDefault.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnDefaultActionPerformed(evt);
            }
        });

        lblAssociatedAlso.setLabelFor(lblAssociatedAlsoExt);
        org.openide.awt.Mnemonics.setLocalizedText(lblAssociatedAlso, org.openide.util.NbBundle.getMessage(FileAssociationsPanel.class, "FileAssociationsPanel.lblAssociatedAlso.text")); // NOI18N
        lblAssociatedAlso.setEnabled(false);

        lblAssociatedAlsoExt.setEnabled(false);
        lblAssociatedAlsoExt.setPreferredSize(new java.awt.Dimension(200, 14));

        org.openide.awt.Mnemonics.setLocalizedText(lblFileAssociations, org.openide.util.NbBundle.getMessage(FileAssociationsPanel.class, "FileAssociationsPanel.lblFileAssociations.text")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(lblFilesIgnored, org.openide.util.NbBundle.getMessage(FileAssociationsPanel.class, "FileAssociationsPanel.lblFilesIgnored.text")); // NOI18N

        lblPattern.setLabelFor(txtPattern);
        org.openide.awt.Mnemonics.setLocalizedText(lblPattern, org.openide.util.NbBundle.getMessage(FileAssociationsPanel.class, "FileAssociationsPanel.lblPattern.text")); // NOI18N
        lblPattern.setToolTipText(org.openide.util.NbBundle.getMessage(FileAssociationsPanel.class, "FileAssociationsPanel.lblPattern.tooltip")); // NOI18N

        org.openide.awt.Mnemonics.setLocalizedText(btnDefaultIgnored, org.openide.util.NbBundle.getMessage(FileAssociationsPanel.class, "FileAssociationsPanel.btnDefaultIgnored.text")); // NOI18N
        btnDefaultIgnored.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnDefaultIgnoredActionPerformed(evt);
            }
        });

        jScrollPane1.setHorizontalScrollBarPolicy(javax.swing.ScrollPaneConstants.HORIZONTAL_SCROLLBAR_NEVER);
        jScrollPane1.setVerticalScrollBarPolicy(javax.swing.ScrollPaneConstants.VERTICAL_SCROLLBAR_NEVER);

        txtPattern.setLineWrap(true);
        jScrollPane1.setViewportView(txtPattern);
        txtPattern.getAccessibleContext().setAccessibleParent(this);

        txtPatternError.setForeground(java.awt.Color.red);
        txtPatternError.setVerticalAlignment(javax.swing.SwingConstants.TOP);
        txtPatternError.setFocusable(false);

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(layout.createSequentialGroup()
                        .add(lblFileAssociations)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(sepFileAssociations, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 461, Short.MAX_VALUE))
                    .add(layout.createSequentialGroup()
                        .add(10, 10, 10)
                        .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(lblExtension)
                            .add(lblType))
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(layout.createSequentialGroup()
                                .add(lblAssociatedAlso)
                                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                                .add(lblAssociatedAlsoExt, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 281, Short.MAX_VALUE))
                            .add(layout.createSequentialGroup()
                                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                                    .add(layout.createSequentialGroup()
                                        .add(cbExtension, 0, 236, Short.MAX_VALUE)
                                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED))
                                    .add(cbType, 0, 236, Short.MAX_VALUE))
                                .add(10, 10, 10)
                                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                                    .add(layout.createSequentialGroup()
                                        .add(btnNew)
                                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                                        .add(btnRemove))
                                    .add(btnDefault)))))
                    .add(layout.createSequentialGroup()
                        .add(lblFilesIgnored)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(setFilesIgnored, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 423, Short.MAX_VALUE))
                    .add(layout.createSequentialGroup()
                        .add(10, 10, 10)
                        .add(lblPattern)
                        .add(41, 41, 41)
                        .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(txtPatternError, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 387, Short.MAX_VALUE)
                            .add(layout.createSequentialGroup()
                                .add(jScrollPane1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 310, Short.MAX_VALUE)
                                .addPreferredGap(org.jdesktop.layout.LayoutStyle.UNRELATED)
                                .add(btnDefaultIgnored)))))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.CENTER)
                    .add(sepFileAssociations, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(lblFileAssociations))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(btnNew)
                    .add(cbExtension, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(btnRemove)
                    .add(lblExtension))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(cbType, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(btnDefault)
                    .add(lblType))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(lblAssociatedAlso)
                    .add(lblAssociatedAlsoExt, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .add(23, 23, 23)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.CENTER)
                    .add(setFilesIgnored, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(lblFilesIgnored))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(lblPattern)
                    .add(btnDefaultIgnored)
                    .add(jScrollPane1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 45, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(txtPatternError, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 123, Short.MAX_VALUE)
                .add(16, 16, 16))
        );

        lblExtension.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(FileAssociationsPanel.class, "FileAssociationsPanel.lblExtension.AN")); // NOI18N
        lblExtension.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(FileAssociationsPanel.class, "FileAssociationsPanel.lblExtension.AD")); // NOI18N
        btnNew.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(FileAssociationsPanel.class, "FileAssociationsPanel.btnNew.AN")); // NOI18N
        btnNew.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(FileAssociationsPanel.class, "FileAssociationsPanel.btnNew.AD")); // NOI18N
        btnRemove.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(FileAssociationsPanel.class, "FileAssociationsPanel.btnRemove.AN")); // NOI18N
        btnRemove.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(FileAssociationsPanel.class, "FileAssociationsPanel.btnRemove.AD")); // NOI18N
        lblType.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(FileAssociationsPanel.class, "FileAssociationsPanel.lblType.AN")); // NOI18N
        lblType.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(FileAssociationsPanel.class, "FileAssociationsPanel.lblType.AD")); // NOI18N
        btnDefault.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(FileAssociationsPanel.class, "FileAssociationsPanel.btnDefault.AN")); // NOI18N
        btnDefault.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(FileAssociationsPanel.class, "FileAssociationsPanel.btnDefault.AD")); // NOI18N
        lblAssociatedAlso.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(FileAssociationsPanel.class, "FileAssociationsPanel.lblAssociatedAlso.AN")); // NOI18N
        lblAssociatedAlso.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(FileAssociationsPanel.class, "FileAssociationsPanel.lblAssociatedAlso.AD")); // NOI18N
        lblPattern.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(FileAssociationsPanel.class, "FileAssociationsPanel.lblPattern.AN")); // NOI18N
        lblPattern.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(FileAssociationsPanel.class, "FileAssociationsPanel.lblPattern.AD")); // NOI18N
        btnDefaultIgnored.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(FileAssociationsPanel.class, "FileAssociationsPanel.btnDefaultIgnored.AN")); // NOI18N
        btnDefaultIgnored.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(FileAssociationsPanel.class, "FileAssociationsPanel.btnDefaultIgnored.AD")); // NOI18N
        txtPatternError.getAccessibleContext().setAccessibleName(org.openide.util.NbBundle.getMessage(FileAssociationsPanel.class, "FileAssociationsPanel.txtPatternError.AN")); // NOI18N
        txtPatternError.getAccessibleContext().setAccessibleDescription(org.openide.util.NbBundle.getMessage(FileAssociationsPanel.class, "FileAssociationsPanel.txtPatternError.AD")); // NOI18N
    }// </editor-fold>//GEN-END:initComponents

    private void cbExtensionActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cbExtensionActionPerformed
        if(cbExtension.getSelectedItem() == null || chooseExtensionItem.equals(cbExtension.getSelectedItem().toString())) {
            return;
        } 
        String newExtension = cbExtension.getSelectedItem().toString();
        if(cbExtension.getItemAt(0).equals(chooseExtensionItem)) {
            // remove initial hint item
            cbExtension.removeItem(chooseExtensionItem);
            cbType.setEnabled(true);
        }
        cbType.setSelectedItem(model.getMimeItem(newExtension));
        btnRemove.setEnabled(model.canBeRemoved(newExtension));
    }//GEN-LAST:event_cbExtensionActionPerformed

    private void cbTypeActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_cbTypeActionPerformed
        if(cbType.getSelectedItem() == null || chooseExtensionItem.equals(cbExtension.getSelectedItem().toString())) {
            return;
        }
        String extension = cbExtension.getSelectedItem().toString();
        String newMimeType = ((MimeItem)cbType.getSelectedItem()).getMimeType();
        if(model.setMimeType(extension, newMimeType)) {
            controller.changed();
        }
        btnDefault.setEnabled(model.canBeRestored(extension));
        lblAssociatedAlsoExt.setText(model.getAssociatedAlso(extension, newMimeType));
    }//GEN-LAST:event_cbTypeActionPerformed

    private void btnDefaultActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnDefaultActionPerformed
        String extension = cbExtension.getSelectedItem().toString();
        model.setDefault(extension);
        btnDefault.setEnabled(false);
        cbType.setSelectedItem(model.getMimeItem(extension));
        controller.changed();
    }//GEN-LAST:event_btnDefaultActionPerformed

private void btnNewActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnNewActionPerformed
    if (newExtensionPanel == null) {
        newExtensionPanel = new NewExtensionPanel();
    }
    newExtensionPanel.setModel(model);
    DialogDescriptor dd = new DialogDescriptor(newExtensionPanel, NbBundle.getMessage(NewExtensionPanel.class, "NewExtensionPanel.title")); // NOI18N
    newExtensionPanel.addExtensionListener(dd); 
    
    DialogDisplayer.getDefault().createDialog(dd).setVisible(true);
    if (DialogDescriptor.OK_OPTION.equals (dd.getValue())) {
        // add new extension to combo box and re-create
        ArrayList<String> newItems = new ArrayList<String>();
        for (int i = 0; i < cbExtension.getItemCount(); i++) {
            newItems.add(cbExtension.getItemAt(i).toString());
        }
        if(newItems.remove(chooseExtensionItem)) {
            // initial hint removed, so enable file types combo box
            cbType.setEnabled(true);
        }
        newItems.add(newExtensionPanel.getExtension());
        Collections.sort(newItems, String.CASE_INSENSITIVE_ORDER);
        cbExtension.removeAllItems();
        for (String item : newItems) {
            cbExtension.addItem(item);
        }
        cbExtension.setSelectedItem(newExtensionPanel.getExtension());
    }    
}//GEN-LAST:event_btnNewActionPerformed

private void btnRemoveActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnRemoveActionPerformed
    String extension = cbExtension.getSelectedItem().toString();
    model.remove(extension);
    int selectedIndex = cbExtension.getSelectedIndex();
    cbExtension.removeItem(extension);
    if (cbExtension.getItemCount() > 0) {
        cbExtension.setSelectedIndex(Math.max(0, --selectedIndex));
    }
    controller.changed();
}//GEN-LAST:event_btnRemoveActionPerformed

private void btnDefaultIgnoredActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnDefaultIgnoredActionPerformed
    txtPattern.setText(IgnoredFilesPreferences.DEFAULT_IGNORED_FILES);
}//GEN-LAST:event_btnDefaultIgnoredActionPerformed

    void load() {
        cbExtension.removeAllItems();
        cbType.removeAllItems();
        cbType.setEnabled(false);
        btnDefault.setEnabled(false);
        btnRemove.setEnabled(false);
        lblAssociatedAlsoExt.setText(null);
        
        model = new FileAssociationsModel();
        // populate extension combo box
        cbExtension.addItem(chooseExtensionItem);
        for (String extension : model.getExtensions()) {
            cbExtension.addItem(extension);
        }
        // pupulate MIME type combo box
        for (MimeItem mimePair : model.getMimeItems()) {
            cbType.addItem(mimePair);
        }

        // load ignored files pattern
        txtPattern.getDocument().removeDocumentListener(patternListener);
        txtPattern.setText(IgnoredFilesPreferences.getIgnoredFiles());
        txtPattern.getDocument().addDocumentListener(patternListener);
        btnDefaultIgnored.setEnabled(!IgnoredFilesPreferences.DEFAULT_IGNORED_FILES.equals(txtPattern.getText()));
    }
    
    void store() {
        // store file associations
        model.store();
        // store ignored files pattern
        IgnoredFilesPreferences.setIgnoredFiles(txtPattern.getText());
    }

    boolean valid() {
        // Check validity only for ignored files pattern because file associations
        // cannot get into invalid state.
        return IgnoredFilesPreferences.isValid(txtPattern.getText());
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton btnDefault;
    private javax.swing.JButton btnDefaultIgnored;
    private javax.swing.JButton btnNew;
    private javax.swing.JButton btnRemove;
    private javax.swing.JComboBox cbExtension;
    private javax.swing.JComboBox cbType;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JLabel lblAssociatedAlso;
    private javax.swing.JLabel lblAssociatedAlsoExt;
    private javax.swing.JLabel lblExtension;
    private javax.swing.JLabel lblFileAssociations;
    private javax.swing.JLabel lblFilesIgnored;
    private javax.swing.JLabel lblPattern;
    private javax.swing.JLabel lblType;
    private javax.swing.JSeparator sepFileAssociations;
    private javax.swing.JSeparator setFilesIgnored;
    private javax.swing.JTextArea txtPattern;
    private javax.swing.JLabel txtPatternError;
    // End of variables declaration//GEN-END:variables


    private class PatternDocumentListener implements DocumentListener {

        public void insertUpdate(DocumentEvent e) {
            patternChanged();
        }

        public void removeUpdate(DocumentEvent e) {
            patternChanged();
        }

        public void changedUpdate(DocumentEvent e) {}

        /** Notify controller that property was changed and update status of components
         * handling ignored files pattern. */
        private void patternChanged() {
            controller.changed();
            btnDefaultIgnored.setEnabled(!IgnoredFilesPreferences.DEFAULT_IGNORED_FILES.equals(txtPattern.getText()));
            if(IgnoredFilesPreferences.getSyntaxError() != null) {
                txtPatternError.setText("<html><pre>" + IgnoredFilesPreferences.getSyntaxError() + "</pre></html>");  //NOI18N
            } else {
                txtPatternError.setText(null);
            }
        }
    }
}
