/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.Comparator;
import java.util.List;
import java.util.RandomAccess;

public class Arrays {
    private static final int INSERTIONSORT_THRESHOLD = 7;

    private Arrays() {
    }

    public static void sort(long[] lArray) {
        Arrays.sort1(lArray, 0, lArray.length);
    }

    public static void sort(long[] lArray, int n, int n2) {
        Arrays.rangeCheck(lArray.length, n, n2);
        Arrays.sort1(lArray, n, n2 - n);
    }

    public static void sort(int[] nArray) {
        Arrays.sort1(nArray, 0, nArray.length);
    }

    public static void sort(int[] nArray, int n, int n2) {
        Arrays.rangeCheck(nArray.length, n, n2);
        Arrays.sort1(nArray, n, n2 - n);
    }

    public static void sort(short[] sArray) {
        Arrays.sort1(sArray, 0, sArray.length);
    }

    public static void sort(short[] sArray, int n, int n2) {
        Arrays.rangeCheck(sArray.length, n, n2);
        Arrays.sort1(sArray, n, n2 - n);
    }

    public static void sort(char[] cArray) {
        Arrays.sort1(cArray, 0, cArray.length);
    }

    public static void sort(char[] cArray, int n, int n2) {
        Arrays.rangeCheck(cArray.length, n, n2);
        Arrays.sort1(cArray, n, n2 - n);
    }

    public static void sort(byte[] byArray) {
        Arrays.sort1(byArray, 0, byArray.length);
    }

    public static void sort(byte[] byArray, int n, int n2) {
        Arrays.rangeCheck(byArray.length, n, n2);
        Arrays.sort1(byArray, n, n2 - n);
    }

    public static void sort(double[] dArray) {
        Arrays.sort2(dArray, 0, dArray.length);
    }

    public static void sort(double[] dArray, int n, int n2) {
        Arrays.rangeCheck(dArray.length, n, n2);
        Arrays.sort2(dArray, n, n2);
    }

    public static void sort(float[] fArray) {
        Arrays.sort2(fArray, 0, fArray.length);
    }

    public static void sort(float[] fArray, int n, int n2) {
        Arrays.rangeCheck(fArray.length, n, n2);
        Arrays.sort2(fArray, n, n2);
    }

    private static void sort2(double[] dArray, int n, int n2) {
        long l = Double.doubleToLongBits(-0.0);
        int n3 = 0;
        int n4 = n;
        int n5 = n2;
        while (n4 < n5) {
            if (dArray[n4] != dArray[n4]) {
                double d = dArray[n4];
                dArray[n4] = dArray[--n5];
                dArray[n5] = d;
                continue;
            }
            if (dArray[n4] == 0.0 && Double.doubleToLongBits(dArray[n4]) == l) {
                dArray[n4] = 0.0;
                ++n3;
            }
            ++n4;
        }
        Arrays.sort1(dArray, n, n5 - n);
        if (n3 != 0) {
            int n6 = Arrays.binarySearch(dArray, 0.0, n, n5 - 1);
            while (--n6 >= 0 && dArray[n6] == 0.0) {
            }
            for (int i = 0; i < n3; ++i) {
                dArray[++n6] = -0.0;
            }
        }
    }

    private static void sort2(float[] fArray, int n, int n2) {
        int n3 = Float.floatToIntBits(-0.0f);
        int n4 = 0;
        int n5 = n;
        int n6 = n2;
        while (n5 < n6) {
            if (fArray[n5] != fArray[n5]) {
                float f = fArray[n5];
                fArray[n5] = fArray[--n6];
                fArray[n6] = f;
                continue;
            }
            if (fArray[n5] == 0.0f && Float.floatToIntBits(fArray[n5]) == n3) {
                fArray[n5] = 0.0f;
                ++n4;
            }
            ++n5;
        }
        Arrays.sort1(fArray, n, n6 - n);
        if (n4 != 0) {
            int n7 = Arrays.binarySearch(fArray, 0.0f, n, n6 - 1);
            while (--n7 >= 0 && fArray[n7] == 0.0f) {
            }
            for (int i = 0; i < n4; ++i) {
                fArray[++n7] = -0.0f;
            }
        }
    }

    private static void sort1(long[] lArray, int n, int n2) {
        int n3;
        int n4;
        if (n2 < 7) {
            for (int i = n; i < n2 + n; ++i) {
                for (int j = i; j > n && lArray[j - 1] > lArray[j]; --j) {
                    Arrays.swap(lArray, j, j - 1);
                }
            }
            return;
        }
        int n5 = n + (n2 >> 1);
        if (n2 > 7) {
            int n6 = n;
            int n7 = n + n2 - 1;
            if (n2 > 40) {
                n4 = n2 / 8;
                n6 = Arrays.med3(lArray, n6, n6 + n4, n6 + 2 * n4);
                n5 = Arrays.med3(lArray, n5 - n4, n5, n5 + n4);
                n7 = Arrays.med3(lArray, n7 - 2 * n4, n7 - n4, n7);
            }
            n5 = Arrays.med3(lArray, n6, n5, n7);
        }
        long l = lArray[n5];
        int n8 = n4 = n;
        int n9 = n3 = n + n2 - 1;
        while (true) {
            if (n8 <= n3 && lArray[n8] <= l) {
                if (lArray[n8] == l) {
                    Arrays.swap(lArray, n4++, n8);
                }
                ++n8;
                continue;
            }
            while (n3 >= n8 && lArray[n3] >= l) {
                if (lArray[n3] == l) {
                    Arrays.swap(lArray, n3, n9--);
                }
                --n3;
            }
            if (n8 > n3) break;
            Arrays.swap(lArray, n8++, n3--);
        }
        int n10 = n + n2;
        int n11 = Math.min(n4 - n, n8 - n4);
        Arrays.vecswap(lArray, n, n8 - n11, n11);
        n11 = Math.min(n9 - n3, n10 - n9 - 1);
        Arrays.vecswap(lArray, n8, n10 - n11, n11);
        n11 = n8 - n4;
        if (n11 > 1) {
            Arrays.sort1(lArray, n, n11);
        }
        if ((n11 = n9 - n3) > 1) {
            Arrays.sort1(lArray, n10 - n11, n11);
        }
    }

    private static void swap(long[] lArray, int n, int n2) {
        long l = lArray[n];
        lArray[n] = lArray[n2];
        lArray[n2] = l;
    }

    private static void vecswap(long[] lArray, int n, int n2, int n3) {
        int n4 = 0;
        while (n4 < n3) {
            Arrays.swap(lArray, n, n2);
            ++n4;
            ++n;
            ++n2;
        }
    }

    private static int med3(long[] lArray, int n, int n2, int n3) {
        return lArray[n] < lArray[n2] ? (lArray[n2] < lArray[n3] ? n2 : (lArray[n] < lArray[n3] ? n3 : n)) : (lArray[n2] > lArray[n3] ? n2 : (lArray[n] > lArray[n3] ? n3 : n));
    }

    private static void sort1(int[] nArray, int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        if (n2 < 7) {
            for (int i = n; i < n2 + n; ++i) {
                for (int j = i; j > n && nArray[j - 1] > nArray[j]; --j) {
                    Arrays.swap(nArray, j, j - 1);
                }
            }
            return;
        }
        int n7 = n + (n2 >> 1);
        if (n2 > 7) {
            n6 = n;
            n5 = n + n2 - 1;
            if (n2 > 40) {
                n4 = n2 / 8;
                n6 = Arrays.med3(nArray, n6, n6 + n4, n6 + 2 * n4);
                n7 = Arrays.med3(nArray, n7 - n4, n7, n7 + n4);
                n5 = Arrays.med3(nArray, n5 - 2 * n4, n5 - n4, n5);
            }
            n7 = Arrays.med3(nArray, n6, n7, n5);
        }
        n6 = nArray[n7];
        n4 = n5 = n;
        int n8 = n3 = n + n2 - 1;
        while (true) {
            if (n4 <= n3 && nArray[n4] <= n6) {
                if (nArray[n4] == n6) {
                    Arrays.swap(nArray, n5++, n4);
                }
                ++n4;
                continue;
            }
            while (n3 >= n4 && nArray[n3] >= n6) {
                if (nArray[n3] == n6) {
                    Arrays.swap(nArray, n3, n8--);
                }
                --n3;
            }
            if (n4 > n3) break;
            Arrays.swap(nArray, n4++, n3--);
        }
        int n9 = n + n2;
        int n10 = Math.min(n5 - n, n4 - n5);
        Arrays.vecswap(nArray, n, n4 - n10, n10);
        n10 = Math.min(n8 - n3, n9 - n8 - 1);
        Arrays.vecswap(nArray, n4, n9 - n10, n10);
        n10 = n4 - n5;
        if (n10 > 1) {
            Arrays.sort1(nArray, n, n10);
        }
        if ((n10 = n8 - n3) > 1) {
            Arrays.sort1(nArray, n9 - n10, n10);
        }
    }

    private static void swap(int[] nArray, int n, int n2) {
        int n3 = nArray[n];
        nArray[n] = nArray[n2];
        nArray[n2] = n3;
    }

    private static void vecswap(int[] nArray, int n, int n2, int n3) {
        int n4 = 0;
        while (n4 < n3) {
            Arrays.swap(nArray, n, n2);
            ++n4;
            ++n;
            ++n2;
        }
    }

    private static int med3(int[] nArray, int n, int n2, int n3) {
        return nArray[n] < nArray[n2] ? (nArray[n2] < nArray[n3] ? n2 : (nArray[n] < nArray[n3] ? n3 : n)) : (nArray[n2] > nArray[n3] ? n2 : (nArray[n] > nArray[n3] ? n3 : n));
    }

    private static void sort1(short[] sArray, int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        if (n2 < 7) {
            for (int i = n; i < n2 + n; ++i) {
                for (int j = i; j > n && sArray[j - 1] > sArray[j]; --j) {
                    Arrays.swap(sArray, j, j - 1);
                }
            }
            return;
        }
        int n7 = n + (n2 >> 1);
        if (n2 > 7) {
            n6 = n;
            n5 = n + n2 - 1;
            if (n2 > 40) {
                n4 = n2 / 8;
                n6 = Arrays.med3(sArray, n6, n6 + n4, n6 + 2 * n4);
                n7 = Arrays.med3(sArray, n7 - n4, n7, n7 + n4);
                n5 = Arrays.med3(sArray, n5 - 2 * n4, n5 - n4, n5);
            }
            n7 = Arrays.med3(sArray, n6, n7, n5);
        }
        n6 = sArray[n7];
        n4 = n5 = n;
        int n8 = n3 = n + n2 - 1;
        while (true) {
            if (n4 <= n3 && sArray[n4] <= n6) {
                if (sArray[n4] == n6) {
                    Arrays.swap(sArray, n5++, n4);
                }
                ++n4;
                continue;
            }
            while (n3 >= n4 && sArray[n3] >= n6) {
                if (sArray[n3] == n6) {
                    Arrays.swap(sArray, n3, n8--);
                }
                --n3;
            }
            if (n4 > n3) break;
            Arrays.swap(sArray, n4++, n3--);
        }
        int n9 = n + n2;
        int n10 = Math.min(n5 - n, n4 - n5);
        Arrays.vecswap(sArray, n, n4 - n10, n10);
        n10 = Math.min(n8 - n3, n9 - n8 - 1);
        Arrays.vecswap(sArray, n4, n9 - n10, n10);
        n10 = n4 - n5;
        if (n10 > 1) {
            Arrays.sort1(sArray, n, n10);
        }
        if ((n10 = n8 - n3) > 1) {
            Arrays.sort1(sArray, n9 - n10, n10);
        }
    }

    private static void swap(short[] sArray, int n, int n2) {
        short s = sArray[n];
        sArray[n] = sArray[n2];
        sArray[n2] = s;
    }

    private static void vecswap(short[] sArray, int n, int n2, int n3) {
        int n4 = 0;
        while (n4 < n3) {
            Arrays.swap(sArray, n, n2);
            ++n4;
            ++n;
            ++n2;
        }
    }

    private static int med3(short[] sArray, int n, int n2, int n3) {
        return sArray[n] < sArray[n2] ? (sArray[n2] < sArray[n3] ? n2 : (sArray[n] < sArray[n3] ? n3 : n)) : (sArray[n2] > sArray[n3] ? n2 : (sArray[n] > sArray[n3] ? n3 : n));
    }

    private static void sort1(char[] cArray, int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        if (n2 < 7) {
            for (int i = n; i < n2 + n; ++i) {
                for (int j = i; j > n && cArray[j - 1] > cArray[j]; --j) {
                    Arrays.swap(cArray, j, j - 1);
                }
            }
            return;
        }
        int n7 = n + (n2 >> 1);
        if (n2 > 7) {
            n6 = n;
            n5 = n + n2 - 1;
            if (n2 > 40) {
                n4 = n2 / 8;
                n6 = Arrays.med3(cArray, n6, n6 + n4, n6 + 2 * n4);
                n7 = Arrays.med3(cArray, n7 - n4, n7, n7 + n4);
                n5 = Arrays.med3(cArray, n5 - 2 * n4, n5 - n4, n5);
            }
            n7 = Arrays.med3(cArray, n6, n7, n5);
        }
        n6 = cArray[n7];
        n4 = n5 = n;
        int n8 = n3 = n + n2 - 1;
        while (true) {
            if (n4 <= n3 && cArray[n4] <= n6) {
                if (cArray[n4] == n6) {
                    Arrays.swap(cArray, n5++, n4);
                }
                ++n4;
                continue;
            }
            while (n3 >= n4 && cArray[n3] >= n6) {
                if (cArray[n3] == n6) {
                    Arrays.swap(cArray, n3, n8--);
                }
                --n3;
            }
            if (n4 > n3) break;
            Arrays.swap(cArray, n4++, n3--);
        }
        int n9 = n + n2;
        int n10 = Math.min(n5 - n, n4 - n5);
        Arrays.vecswap(cArray, n, n4 - n10, n10);
        n10 = Math.min(n8 - n3, n9 - n8 - 1);
        Arrays.vecswap(cArray, n4, n9 - n10, n10);
        n10 = n4 - n5;
        if (n10 > 1) {
            Arrays.sort1(cArray, n, n10);
        }
        if ((n10 = n8 - n3) > 1) {
            Arrays.sort1(cArray, n9 - n10, n10);
        }
    }

    private static void swap(char[] cArray, int n, int n2) {
        char c = cArray[n];
        cArray[n] = cArray[n2];
        cArray[n2] = c;
    }

    private static void vecswap(char[] cArray, int n, int n2, int n3) {
        int n4 = 0;
        while (n4 < n3) {
            Arrays.swap(cArray, n, n2);
            ++n4;
            ++n;
            ++n2;
        }
    }

    private static int med3(char[] cArray, int n, int n2, int n3) {
        return cArray[n] < cArray[n2] ? (cArray[n2] < cArray[n3] ? n2 : (cArray[n] < cArray[n3] ? n3 : n)) : (cArray[n2] > cArray[n3] ? n2 : (cArray[n] > cArray[n3] ? n3 : n));
    }

    private static void sort1(byte[] byArray, int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        if (n2 < 7) {
            for (int i = n; i < n2 + n; ++i) {
                for (int j = i; j > n && byArray[j - 1] > byArray[j]; --j) {
                    Arrays.swap(byArray, j, j - 1);
                }
            }
            return;
        }
        int n7 = n + (n2 >> 1);
        if (n2 > 7) {
            n6 = n;
            n5 = n + n2 - 1;
            if (n2 > 40) {
                n4 = n2 / 8;
                n6 = Arrays.med3(byArray, n6, n6 + n4, n6 + 2 * n4);
                n7 = Arrays.med3(byArray, n7 - n4, n7, n7 + n4);
                n5 = Arrays.med3(byArray, n5 - 2 * n4, n5 - n4, n5);
            }
            n7 = Arrays.med3(byArray, n6, n7, n5);
        }
        n6 = byArray[n7];
        n4 = n5 = n;
        int n8 = n3 = n + n2 - 1;
        while (true) {
            if (n4 <= n3 && byArray[n4] <= n6) {
                if (byArray[n4] == n6) {
                    Arrays.swap(byArray, n5++, n4);
                }
                ++n4;
                continue;
            }
            while (n3 >= n4 && byArray[n3] >= n6) {
                if (byArray[n3] == n6) {
                    Arrays.swap(byArray, n3, n8--);
                }
                --n3;
            }
            if (n4 > n3) break;
            Arrays.swap(byArray, n4++, n3--);
        }
        int n9 = n + n2;
        int n10 = Math.min(n5 - n, n4 - n5);
        Arrays.vecswap(byArray, n, n4 - n10, n10);
        n10 = Math.min(n8 - n3, n9 - n8 - 1);
        Arrays.vecswap(byArray, n4, n9 - n10, n10);
        n10 = n4 - n5;
        if (n10 > 1) {
            Arrays.sort1(byArray, n, n10);
        }
        if ((n10 = n8 - n3) > 1) {
            Arrays.sort1(byArray, n9 - n10, n10);
        }
    }

    private static void swap(byte[] byArray, int n, int n2) {
        byte by = byArray[n];
        byArray[n] = byArray[n2];
        byArray[n2] = by;
    }

    private static void vecswap(byte[] byArray, int n, int n2, int n3) {
        int n4 = 0;
        while (n4 < n3) {
            Arrays.swap(byArray, n, n2);
            ++n4;
            ++n;
            ++n2;
        }
    }

    private static int med3(byte[] byArray, int n, int n2, int n3) {
        return byArray[n] < byArray[n2] ? (byArray[n2] < byArray[n3] ? n2 : (byArray[n] < byArray[n3] ? n3 : n)) : (byArray[n2] > byArray[n3] ? n2 : (byArray[n] > byArray[n3] ? n3 : n));
    }

    private static void sort1(double[] dArray, int n, int n2) {
        int n3;
        int n4;
        if (n2 < 7) {
            for (int i = n; i < n2 + n; ++i) {
                for (int j = i; j > n && dArray[j - 1] > dArray[j]; --j) {
                    Arrays.swap(dArray, j, j - 1);
                }
            }
            return;
        }
        int n5 = n + (n2 >> 1);
        if (n2 > 7) {
            int n6 = n;
            int n7 = n + n2 - 1;
            if (n2 > 40) {
                n4 = n2 / 8;
                n6 = Arrays.med3(dArray, n6, n6 + n4, n6 + 2 * n4);
                n5 = Arrays.med3(dArray, n5 - n4, n5, n5 + n4);
                n7 = Arrays.med3(dArray, n7 - 2 * n4, n7 - n4, n7);
            }
            n5 = Arrays.med3(dArray, n6, n5, n7);
        }
        double d = dArray[n5];
        int n8 = n4 = n;
        int n9 = n3 = n + n2 - 1;
        while (true) {
            if (n8 <= n3 && dArray[n8] <= d) {
                if (dArray[n8] == d) {
                    Arrays.swap(dArray, n4++, n8);
                }
                ++n8;
                continue;
            }
            while (n3 >= n8 && dArray[n3] >= d) {
                if (dArray[n3] == d) {
                    Arrays.swap(dArray, n3, n9--);
                }
                --n3;
            }
            if (n8 > n3) break;
            Arrays.swap(dArray, n8++, n3--);
        }
        int n10 = n + n2;
        int n11 = Math.min(n4 - n, n8 - n4);
        Arrays.vecswap(dArray, n, n8 - n11, n11);
        n11 = Math.min(n9 - n3, n10 - n9 - 1);
        Arrays.vecswap(dArray, n8, n10 - n11, n11);
        n11 = n8 - n4;
        if (n11 > 1) {
            Arrays.sort1(dArray, n, n11);
        }
        if ((n11 = n9 - n3) > 1) {
            Arrays.sort1(dArray, n10 - n11, n11);
        }
    }

    private static void swap(double[] dArray, int n, int n2) {
        double d = dArray[n];
        dArray[n] = dArray[n2];
        dArray[n2] = d;
    }

    private static void vecswap(double[] dArray, int n, int n2, int n3) {
        int n4 = 0;
        while (n4 < n3) {
            Arrays.swap(dArray, n, n2);
            ++n4;
            ++n;
            ++n2;
        }
    }

    private static int med3(double[] dArray, int n, int n2, int n3) {
        return dArray[n] < dArray[n2] ? (dArray[n2] < dArray[n3] ? n2 : (dArray[n] < dArray[n3] ? n3 : n)) : (dArray[n2] > dArray[n3] ? n2 : (dArray[n] > dArray[n3] ? n3 : n));
    }

    private static void sort1(float[] fArray, int n, int n2) {
        int n3;
        int n4;
        int n5;
        if (n2 < 7) {
            for (int i = n; i < n2 + n; ++i) {
                for (int j = i; j > n && fArray[j - 1] > fArray[j]; --j) {
                    Arrays.swap(fArray, j, j - 1);
                }
            }
            return;
        }
        int n6 = n + (n2 >> 1);
        if (n2 > 7) {
            int n7 = n;
            n5 = n + n2 - 1;
            if (n2 > 40) {
                n4 = n2 / 8;
                n7 = Arrays.med3(fArray, n7, n7 + n4, n7 + 2 * n4);
                n6 = Arrays.med3(fArray, n6 - n4, n6, n6 + n4);
                n5 = Arrays.med3(fArray, n5 - 2 * n4, n5 - n4, n5);
            }
            n6 = Arrays.med3(fArray, n7, n6, n5);
        }
        float f = fArray[n6];
        n4 = n5 = n;
        int n8 = n3 = n + n2 - 1;
        while (true) {
            if (n4 <= n3 && fArray[n4] <= f) {
                if (fArray[n4] == f) {
                    Arrays.swap(fArray, n5++, n4);
                }
                ++n4;
                continue;
            }
            while (n3 >= n4 && fArray[n3] >= f) {
                if (fArray[n3] == f) {
                    Arrays.swap(fArray, n3, n8--);
                }
                --n3;
            }
            if (n4 > n3) break;
            Arrays.swap(fArray, n4++, n3--);
        }
        int n9 = n + n2;
        int n10 = Math.min(n5 - n, n4 - n5);
        Arrays.vecswap(fArray, n, n4 - n10, n10);
        n10 = Math.min(n8 - n3, n9 - n8 - 1);
        Arrays.vecswap(fArray, n4, n9 - n10, n10);
        n10 = n4 - n5;
        if (n10 > 1) {
            Arrays.sort1(fArray, n, n10);
        }
        if ((n10 = n8 - n3) > 1) {
            Arrays.sort1(fArray, n9 - n10, n10);
        }
    }

    private static void swap(float[] fArray, int n, int n2) {
        float f = fArray[n];
        fArray[n] = fArray[n2];
        fArray[n2] = f;
    }

    private static void vecswap(float[] fArray, int n, int n2, int n3) {
        int n4 = 0;
        while (n4 < n3) {
            Arrays.swap(fArray, n, n2);
            ++n4;
            ++n;
            ++n2;
        }
    }

    private static int med3(float[] fArray, int n, int n2, int n3) {
        return fArray[n] < fArray[n2] ? (fArray[n2] < fArray[n3] ? n2 : (fArray[n] < fArray[n3] ? n3 : n)) : (fArray[n2] > fArray[n3] ? n2 : (fArray[n] > fArray[n3] ? n3 : n));
    }

    public static void sort(Object[] objectArray) {
        Object[] objectArray2 = (Object[])objectArray.clone();
        Arrays.mergeSort(objectArray2, objectArray, 0, objectArray.length, 0);
    }

    public static void sort(Object[] objectArray, int n, int n2) {
        Arrays.rangeCheck(objectArray.length, n, n2);
        Object[] objectArray2 = (Object[])Arrays.cloneSubarray(objectArray, n, n2);
        Arrays.mergeSort(objectArray2, objectArray, n, n2, -n);
    }

    private static Object cloneSubarray(Object[] objectArray, int n, int n2) {
        int n3 = n2 - n;
        Object object = Array.newInstance(objectArray.getClass().getComponentType(), n3);
        System.arraycopy(objectArray, n, object, 0, n3);
        return object;
    }

    private static void mergeSort(Object[] objectArray, Object[] objectArray2, int n, int n2, int n3) {
        int n4 = n2 - n;
        if (n4 < 7) {
            for (int i = n; i < n2; ++i) {
                for (int j = i; j > n && ((Comparable)objectArray2[j - 1]).compareTo((Comparable)objectArray2[j]) > 0; --j) {
                    Arrays.swap(objectArray2, j, j - 1);
                }
            }
            return;
        }
        int n5 = n;
        int n6 = n2;
        int n7 = (n += n3) + (n2 += n3) >> 1;
        Arrays.mergeSort(objectArray2, objectArray, n, n7, -n3);
        Arrays.mergeSort(objectArray2, objectArray, n7, n2, -n3);
        if (((Comparable)objectArray[n7 - 1]).compareTo((Comparable)objectArray[n7]) <= 0) {
            System.arraycopy(objectArray, n, objectArray2, n5, n4);
            return;
        }
        int n8 = n;
        int n9 = n7;
        for (int i = n5; i < n6; ++i) {
            objectArray2[i] = n9 >= n2 || n8 < n7 && ((Comparable)objectArray[n8]).compareTo(objectArray[n9]) <= 0 ? objectArray[n8++] : objectArray[n9++];
        }
    }

    private static void swap(Object[] objectArray, int n, int n2) {
        Object object = objectArray[n];
        objectArray[n] = objectArray[n2];
        objectArray[n2] = object;
    }

    public static void sort(Object[] objectArray, Comparator comparator) {
        Object[] objectArray2 = (Object[])objectArray.clone();
        if (comparator == null) {
            Arrays.mergeSort(objectArray2, objectArray, 0, objectArray.length, 0);
        } else {
            Arrays.mergeSort(objectArray2, objectArray, 0, objectArray.length, 0, comparator);
        }
    }

    public static void sort(Object[] objectArray, int n, int n2, Comparator comparator) {
        Arrays.rangeCheck(objectArray.length, n, n2);
        Object[] objectArray2 = (Object[])Arrays.cloneSubarray(objectArray, n, n2);
        if (comparator == null) {
            Arrays.mergeSort(objectArray2, objectArray, n, n2, -n);
        } else {
            Arrays.mergeSort(objectArray2, objectArray, n, n2, -n, comparator);
        }
    }

    private static void mergeSort(Object[] objectArray, Object[] objectArray2, int n, int n2, int n3, Comparator comparator) {
        int n4 = n2 - n;
        if (n4 < 7) {
            for (int i = n; i < n2; ++i) {
                for (int j = i; j > n && comparator.compare(objectArray2[j - 1], objectArray2[j]) > 0; --j) {
                    Arrays.swap(objectArray2, j, j - 1);
                }
            }
            return;
        }
        int n5 = n;
        int n6 = n2;
        int n7 = (n += n3) + (n2 += n3) >> 1;
        Arrays.mergeSort(objectArray2, objectArray, n, n7, -n3, comparator);
        Arrays.mergeSort(objectArray2, objectArray, n7, n2, -n3, comparator);
        if (comparator.compare(objectArray[n7 - 1], objectArray[n7]) <= 0) {
            System.arraycopy(objectArray, n, objectArray2, n5, n4);
            return;
        }
        int n8 = n;
        int n9 = n7;
        for (int i = n5; i < n6; ++i) {
            objectArray2[i] = n9 >= n2 || n8 < n7 && comparator.compare(objectArray[n8], objectArray[n9]) <= 0 ? objectArray[n8++] : objectArray[n9++];
        }
    }

    private static void rangeCheck(int n, int n2, int n3) {
        if (n2 > n3) {
            throw new IllegalArgumentException("fromIndex(" + n2 + ") > toIndex(" + n3 + ")");
        }
        if (n2 < 0) {
            throw new ArrayIndexOutOfBoundsException(n2);
        }
        if (n3 > n) {
            throw new ArrayIndexOutOfBoundsException(n3);
        }
    }

    public static int binarySearch(long[] lArray, long l) {
        int n = 0;
        int n2 = lArray.length - 1;
        while (n <= n2) {
            int n3 = n + n2 >> 1;
            long l2 = lArray[n3];
            if (l2 < l) {
                n = n3 + 1;
                continue;
            }
            if (l2 > l) {
                n2 = n3 - 1;
                continue;
            }
            return n3;
        }
        return -(n + 1);
    }

    public static int binarySearch(int[] nArray, int n) {
        int n2 = 0;
        int n3 = nArray.length - 1;
        while (n2 <= n3) {
            int n4 = n2 + n3 >> 1;
            int n5 = nArray[n4];
            if (n5 < n) {
                n2 = n4 + 1;
                continue;
            }
            if (n5 > n) {
                n3 = n4 - 1;
                continue;
            }
            return n4;
        }
        return -(n2 + 1);
    }

    public static int binarySearch(short[] sArray, short s) {
        int n = 0;
        int n2 = sArray.length - 1;
        while (n <= n2) {
            int n3 = n + n2 >> 1;
            short s2 = sArray[n3];
            if (s2 < s) {
                n = n3 + 1;
                continue;
            }
            if (s2 > s) {
                n2 = n3 - 1;
                continue;
            }
            return n3;
        }
        return -(n + 1);
    }

    public static int binarySearch(char[] cArray, char c) {
        int n = 0;
        int n2 = cArray.length - 1;
        while (n <= n2) {
            int n3 = n + n2 >> 1;
            char c2 = cArray[n3];
            if (c2 < c) {
                n = n3 + 1;
                continue;
            }
            if (c2 > c) {
                n2 = n3 - 1;
                continue;
            }
            return n3;
        }
        return -(n + 1);
    }

    public static int binarySearch(byte[] byArray, byte by) {
        int n = 0;
        int n2 = byArray.length - 1;
        while (n <= n2) {
            int n3 = n + n2 >> 1;
            byte by2 = byArray[n3];
            if (by2 < by) {
                n = n3 + 1;
                continue;
            }
            if (by2 > by) {
                n2 = n3 - 1;
                continue;
            }
            return n3;
        }
        return -(n + 1);
    }

    public static int binarySearch(double[] dArray, double d) {
        return Arrays.binarySearch(dArray, d, 0, dArray.length - 1);
    }

    private static int binarySearch(double[] dArray, double d, int n, int n2) {
        while (n <= n2) {
            int n3;
            int n4 = n + n2 >> 1;
            double d2 = dArray[n4];
            if (d2 < d) {
                n3 = -1;
            } else if (d2 > d) {
                n3 = 1;
            } else {
                long l;
                long l2 = Double.doubleToLongBits(d2);
                int n5 = l2 == (l = Double.doubleToLongBits(d)) ? 0 : (n3 = l2 < l ? -1 : 1);
            }
            if (n3 < 0) {
                n = n4 + 1;
                continue;
            }
            if (n3 > 0) {
                n2 = n4 - 1;
                continue;
            }
            return n4;
        }
        return -(n + 1);
    }

    public static int binarySearch(float[] fArray, float f) {
        return Arrays.binarySearch(fArray, f, 0, fArray.length - 1);
    }

    private static int binarySearch(float[] fArray, float f, int n, int n2) {
        while (n <= n2) {
            int n3;
            int n4 = n + n2 >> 1;
            float f2 = fArray[n4];
            if (f2 < f) {
                n3 = -1;
            } else if (f2 > f) {
                n3 = 1;
            } else {
                int n5;
                int n6 = Float.floatToIntBits(f2);
                int n7 = n6 == (n5 = Float.floatToIntBits(f)) ? 0 : (n3 = n6 < n5 ? -1 : 1);
            }
            if (n3 < 0) {
                n = n4 + 1;
                continue;
            }
            if (n3 > 0) {
                n2 = n4 - 1;
                continue;
            }
            return n4;
        }
        return -(n + 1);
    }

    public static int binarySearch(Object[] objectArray, Object object) {
        int n = 0;
        int n2 = objectArray.length - 1;
        while (n <= n2) {
            int n3 = n + n2 >> 1;
            Object object2 = objectArray[n3];
            int n4 = ((Comparable)object2).compareTo(object);
            if (n4 < 0) {
                n = n3 + 1;
                continue;
            }
            if (n4 > 0) {
                n2 = n3 - 1;
                continue;
            }
            return n3;
        }
        return -(n + 1);
    }

    public static int binarySearch(Object[] objectArray, Object object, Comparator comparator) {
        if (comparator == null) {
            return Arrays.binarySearch(objectArray, object);
        }
        int n = 0;
        int n2 = objectArray.length - 1;
        while (n <= n2) {
            int n3 = n + n2 >> 1;
            Object object2 = objectArray[n3];
            int n4 = comparator.compare(object2, object);
            if (n4 < 0) {
                n = n3 + 1;
                continue;
            }
            if (n4 > 0) {
                n2 = n3 - 1;
                continue;
            }
            return n3;
        }
        return -(n + 1);
    }

    public static boolean equals(long[] lArray, long[] lArray2) {
        if (lArray == lArray2) {
            return true;
        }
        if (lArray == null || lArray2 == null) {
            return false;
        }
        int n = lArray.length;
        if (lArray2.length != n) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (lArray[i] == lArray2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(int[] nArray, int[] nArray2) {
        if (nArray == nArray2) {
            return true;
        }
        if (nArray == null || nArray2 == null) {
            return false;
        }
        int n = nArray.length;
        if (nArray2.length != n) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (nArray[i] == nArray2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(short[] sArray, short[] sArray2) {
        if (sArray == sArray2) {
            return true;
        }
        if (sArray == null || sArray2 == null) {
            return false;
        }
        int n = sArray.length;
        if (sArray2.length != n) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (sArray[i] == sArray2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(char[] cArray, char[] cArray2) {
        if (cArray == cArray2) {
            return true;
        }
        if (cArray == null || cArray2 == null) {
            return false;
        }
        int n = cArray.length;
        if (cArray2.length != n) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (cArray[i] == cArray2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(byte[] byArray, byte[] byArray2) {
        if (byArray == byArray2) {
            return true;
        }
        if (byArray == null || byArray2 == null) {
            return false;
        }
        int n = byArray.length;
        if (byArray2.length != n) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(boolean[] blArray, boolean[] blArray2) {
        if (blArray == blArray2) {
            return true;
        }
        if (blArray == null || blArray2 == null) {
            return false;
        }
        int n = blArray.length;
        if (blArray2.length != n) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (blArray[i] == blArray2[i]) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(double[] dArray, double[] dArray2) {
        if (dArray == dArray2) {
            return true;
        }
        if (dArray == null || dArray2 == null) {
            return false;
        }
        int n = dArray.length;
        if (dArray2.length != n) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (Double.doubleToLongBits(dArray[i]) == Double.doubleToLongBits(dArray2[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(float[] fArray, float[] fArray2) {
        if (fArray == fArray2) {
            return true;
        }
        if (fArray == null || fArray2 == null) {
            return false;
        }
        int n = fArray.length;
        if (fArray2.length != n) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (Float.floatToIntBits(fArray[i]) == Float.floatToIntBits(fArray2[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(Object[] objectArray, Object[] objectArray2) {
        if (objectArray == objectArray2) {
            return true;
        }
        if (objectArray == null || objectArray2 == null) {
            return false;
        }
        int n = objectArray.length;
        if (objectArray2.length != n) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            Object object = objectArray[i];
            Object object2 = objectArray2[i];
            if (object != null ? object.equals(object2) : object2 == null) continue;
            return false;
        }
        return true;
    }

    public static void fill(long[] lArray, long l) {
        Arrays.fill(lArray, 0, lArray.length, l);
    }

    public static void fill(long[] lArray, int n, int n2, long l) {
        Arrays.rangeCheck(lArray.length, n, n2);
        for (int i = n; i < n2; ++i) {
            lArray[i] = l;
        }
    }

    public static void fill(int[] nArray, int n) {
        Arrays.fill(nArray, 0, nArray.length, n);
    }

    public static void fill(int[] nArray, int n, int n2, int n3) {
        Arrays.rangeCheck(nArray.length, n, n2);
        for (int i = n; i < n2; ++i) {
            nArray[i] = n3;
        }
    }

    public static void fill(short[] sArray, short s) {
        Arrays.fill(sArray, 0, sArray.length, s);
    }

    public static void fill(short[] sArray, int n, int n2, short s) {
        Arrays.rangeCheck(sArray.length, n, n2);
        for (int i = n; i < n2; ++i) {
            sArray[i] = s;
        }
    }

    public static void fill(char[] cArray, char c) {
        Arrays.fill(cArray, 0, cArray.length, c);
    }

    public static void fill(char[] cArray, int n, int n2, char c) {
        Arrays.rangeCheck(cArray.length, n, n2);
        for (int i = n; i < n2; ++i) {
            cArray[i] = c;
        }
    }

    public static void fill(byte[] byArray, byte by) {
        Arrays.fill(byArray, 0, byArray.length, by);
    }

    public static void fill(byte[] byArray, int n, int n2, byte by) {
        Arrays.rangeCheck(byArray.length, n, n2);
        for (int i = n; i < n2; ++i) {
            byArray[i] = by;
        }
    }

    public static void fill(boolean[] blArray, boolean bl) {
        Arrays.fill(blArray, 0, blArray.length, bl);
    }

    public static void fill(boolean[] blArray, int n, int n2, boolean bl) {
        Arrays.rangeCheck(blArray.length, n, n2);
        for (int i = n; i < n2; ++i) {
            blArray[i] = bl;
        }
    }

    public static void fill(double[] dArray, double d) {
        Arrays.fill(dArray, 0, dArray.length, d);
    }

    public static void fill(double[] dArray, int n, int n2, double d) {
        Arrays.rangeCheck(dArray.length, n, n2);
        for (int i = n; i < n2; ++i) {
            dArray[i] = d;
        }
    }

    public static void fill(float[] fArray, float f) {
        Arrays.fill(fArray, 0, fArray.length, f);
    }

    public static void fill(float[] fArray, int n, int n2, float f) {
        Arrays.rangeCheck(fArray.length, n, n2);
        for (int i = n; i < n2; ++i) {
            fArray[i] = f;
        }
    }

    public static void fill(Object[] objectArray, Object object) {
        Arrays.fill(objectArray, 0, objectArray.length, object);
    }

    public static void fill(Object[] objectArray, int n, int n2, Object object) {
        Arrays.rangeCheck(objectArray.length, n, n2);
        for (int i = n; i < n2; ++i) {
            objectArray[i] = object;
        }
    }

    public static List asList(Object[] objectArray) {
        return new ArrayList(objectArray);
    }

    private static class ArrayList
    extends AbstractList
    implements RandomAccess,
    Serializable {
        private static final long serialVersionUID = -2764017481108945198L;
        private Object[] a;

        ArrayList(Object[] objectArray) {
            if (objectArray == null) {
                throw new NullPointerException();
            }
            this.a = objectArray;
        }

        public int size() {
            return this.a.length;
        }

        public Object[] toArray() {
            return (Object[])this.a.clone();
        }

        public Object get(int n) {
            return this.a[n];
        }

        public Object set(int n, Object object) {
            Object object2 = this.a[n];
            this.a[n] = object;
            return object2;
        }

        public int indexOf(Object object) {
            if (object == null) {
                for (int i = 0; i < this.a.length; ++i) {
                    if (this.a[i] != null) continue;
                    return i;
                }
            } else {
                for (int i = 0; i < this.a.length; ++i) {
                    if (!object.equals(this.a[i])) continue;
                    return i;
                }
            }
            return -1;
        }

        public boolean contains(Object object) {
            return this.indexOf(object) != -1;
        }
    }
}

